/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.premigration.dbinspector.checks;

import com.oracle.premigration.commons.enums.LockdownProfile;
import com.oracle.premigration.commons.enums.MigrationMethod;
import com.oracle.premigration.commons.enums.TargetCloud;
import com.oracle.premigration.dbinspector.Check;
import com.oracle.premigration.dbinspector.CheckResult;
import com.oracle.premigration.dbinspector.DatabaseObject;
import com.oracle.premigration.dbinspector.ExecutionContext;
import com.oracle.premigration.dbinspector.FilterableCheck;
import com.oracle.premigration.helpers.SqlUtils;
import com.oracle.premigration.reports.CheckFiltrationMetadata;
import java.util.Arrays;

public class gg_not_unique
extends FilterableCheck {
    public gg_not_unique() {
        this.getLockdownProfiles().addAll(Arrays.asList(LockdownProfile.PAAS_ATPD, LockdownProfile.ADW_ADWD, LockdownProfile.OLTP_ATPS, LockdownProfile.DWCS_ADWS, LockdownProfile.ADB_UNSUPPORTED, LockdownProfile.NONE, LockdownProfile.NOT_AUTONOMOUS));
        this.getTargetCloud().addAll(Arrays.asList(TargetCloud.ADWD, TargetCloud.ADWS, TargetCloud.ATPD, TargetCloud.ATPS, TargetCloud.DEFAULT));
        this.getMigrationMethods().add(MigrationMethod.GOLDENGATE);
        this.setScope(Check.Scope.SCHEMA);
        this.setDeclarativeResult(CheckResult.BLOCKER);
    }

    @Override
    public void initFiltrationMetadata() {
        this.setFiltrationMetadata(CheckFiltrationMetadata.builder().schemaOwnerColumn("OWNER").objectNameColumn("TABLE_NAME").objectTypeFixed("TABLE").build());
    }

    @Override
    public void prepare(ExecutionContext exeCtx) {
        String whereClause = SqlUtils.createWhereClauseForOwnerColumn(exeCtx);
        String sqlQuery = "SELECT OWNER, TABLE_NAME, BAD_COLUMN  FROM SYS.DBA_GOLDENGATE_NOT_UNIQUE " + whereClause + " AND BAD_COLUMN = 'Y'  ORDER BY 1, 2";
        this.setSqlQuery(sqlQuery);
        boolean hasGGNotUnique = exeCtx.hasDatabaseObject(DatabaseObject.builder().schema("SYS").table("DBA_GOLDENGATE_NOT_UNIQUE").build());
        if (!hasGGNotUnique) {
            this.skipCheck(this.lang.txt("CHECK_SKIPPED_BECAUSE_OBJECT_MISSING", this.getName(), "DBA_GOLDENGATE_NOT_UNIQUE", "TABLE"), CheckResult.WARNING);
        }
    }
}

