/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.generator.SchemaGenerator;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.newscriptrunner.ScriptExecutor;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryXMLSupport;
import oracle.dbtools.raptor.scriptrunner.commands.liquibase.LbCommand;

public class QueryUtils {
    static QueryXMLSupport s_xml = null;
    static final String SET_BOOL_DDL = "declare \n FUNCTION ifelse (bool_in IN varchar2) \n   RETURN boolean \n IS \n BEGIN \n   IF bool_in = 'OFF' \n   THEN \n     RETURN false; \n  ELSE \n     RETURN true; \n  END IF;\n  END; \n begin \n dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,ifelse(:VALUE)); \n end;\n";
    public static final String COLLATION_CLAUSE = "COLLATION_CLAUSE";
    static final String SET_STRING_DDL = "begin dbms_metadata.set_transform_param(dbms_metadata.session_transform,:OPTION,:VALUE); end;";
    static String path1;
    static String path2;
    static String path3;
    static String path4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean doesObjectExist(Connection conn, String oName, String oType, String oOwner) {
        String objectExistsQuery = QueryUtils.getXMLQueries().getQuery("objectExistsQuery", conn).getSql();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            int count = 0;
            stmt = conn.prepareStatement(objectExistsQuery);
            stmt.setString(1, oName);
            if (SchemaGenerator.typeNameTransform.containsKey(oType)) {
                stmt.setString(2, SchemaGenerator.typeNameTransform.get(oType));
            } else {
                stmt.setString(2, oType);
            }
            stmt.setString(3, oOwner);
            rs = stmt.executeQuery();
            while (rs.next()) {
                count = rs.getInt(1);
            }
            if (count > 0) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static String getSchedulerObjectType(String name, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        HashMap<String, String> binds = new HashMap<String, String>();
        binds.put("OBJECT_NAME", name);
        return dbUtil.executeReturnOneCol("select object_type from all_objects where object_name = :OBJECT_NAME and rownum = 1", binds);
    }

    public static String getUser(Connection conn) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        HashMap binds = new HashMap();
        return dbUtil.executeReturnOneCol("select user from dual", binds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getXmlFromActionsLog(Connection conn, AbstractOracleStatement statement, Database database) throws SQLException, IOException {
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql().replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        stmt = conn.prepareStatement(actionLogSxmlQuery);
        stmt.setString(1, statement.getId());
        stmt.setString(2, statement.getAuthor());
        stmt.setString(3, statement.getFile());
        rs = stmt.executeQuery();
        while (rs.next()) {
            Clob sxml = rs.getClob(1);
            if (sxml == null) {
                String string = null;
                return string;
            }
            sb.append(LiquibaseStringUtils.clobToString(sxml));
        }
        String string = sb.toString();
        return string;
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(LbCommand.class.getClassLoader(), "oracle/dbtools/raptor/scriptrunner/commands/liquibase/cmQueries.xml"));
        }
        return s_xml;
    }

    public static String runSqlReturnResult(String sql, Connection conn) throws DatabaseException {
        try {
            return QueryUtils.runSqlReturnResult(sql, conn, false);
        }
        catch (DatabaseException e) {
            LbUtils.log((Exception)((Object)e));
            throw e;
        }
    }

    public static String runSqlReturnResult(String sql, Connection conn, boolean scan) throws DatabaseException {
        try {
            String encoding = ScriptRunnerContext.getOutputEncoding();
            ScriptExecutor runner = new ScriptExecutor(sql, conn);
            ScriptRunnerContext ctx = new ScriptRunnerContext();
            ctx.putProperty("script.runner.using.systemout", (Object)true);
            ctx.setSubstitutionOn(scan);
            ctx.setScanOn(scan);
            ctx.setSqlError(4);
            ctx.putProperty("sqlplus.error.logging", (Object)true);
            ctx.putProperty("script.runner.exit_int_whenever", (Object)2);
            ctx.putProperty("script.runner.exit_int_whenever.wassqlcode", (Object)true);
            ctx.setBaseConnection(conn);
            ctx.setCurrentConnection(conn);
            runner.setScriptRunnerContext(ctx);
            runner.setDirectory(LbUtils.getContext().prependCD(""));
            ByteArrayOutputStream BaS = new ByteArrayOutputStream();
            BufferedOutputStream BoS = new BufferedOutputStream(BaS);
            runner.setOut(BoS);
            runner.run();
            BoS.flush();
            if (Boolean.parseBoolean(runner.getScriptRunnerContext().getProperty("sqldev.error").toString()) && runner.getScriptRunnerContext().getProperty("sqldev.last.err.sqlcode") != null) {
                if ((Integer)runner.getScriptRunnerContext().getProperty("sqldev.last.err.sqlcode") == 2275) {
                    return "Referential constraint already exists skipping";
                }
                if ((Integer)runner.getScriptRunnerContext().getProperty("sqldev.last.err.sqlcode") == 2443) {
                    return "Referential constraint already dropped skipping";
                }
                if (BaS.toString().length() > 0) {
                    throw new DatabaseException(BaS.toString(encoding).trim());
                }
                throw new DatabaseException((String)runner.getScriptRunnerContext().getProperty("sqldev.last.err.message.forsqlcode"));
            }
            BaS.close();
            BoS.close();
            String type = (String)ctx.getProperty("sqldev.last.err.type");
            if (type != null) {
                if ("TYPE".equals(type) && BaS.toString().contains("PLS-00201:")) {
                    return "Type dependency missing, continuing";
                }
                if ("TYPE".equals(type) && BaS.toString().contains("PLS-00905:")) {
                    return "Type dependency invalid, continuing";
                }
                if ("TYPE BODY".equals(type) && BaS.toString().contains("PLS-00201:") && !BaS.toString().contains("PLS-00304:")) {
                    return "Type body dependency missing, continuing";
                }
                if ("PACKAGE".equals(type) && BaS.toString().contains("PLS-00201:")) {
                    return "Package dependency missing, continuing";
                }
                throw new DatabaseException(BaS.toString(encoding).trim());
            }
            String result = LiquibaseStringUtils.stripCR(BaS.toString(encoding));
            if (result == null || "".equals(result)) {
                return "Statement executed successfully";
            }
            return result;
        }
        catch (UnsupportedEncodingException e) {
            LbUtils.log(e);
            throw new DatabaseException((Throwable)e);
        }
        catch (IOException e) {
            throw new DatabaseException((Throwable)e);
        }
    }

    public static void setDDLParameter(Connection conn, String key, String value) throws SQLException {
        String sql = null;
        HashMap<String, String> binds = new HashMap<String, String>();
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        sql = COLLATION_CLAUSE.equals(key) ? SET_STRING_DDL : SET_BOOL_DDL;
        binds.put("OPTION", key);
        binds.put("VALUE", value);
        dbUtil.execute(sql, binds);
        LbUtils.log(sql);
        LbUtils.log(LbUtils.mapToString(binds));
        SQLException e = dbUtil.getLastException();
        if (e != null) {
            LbUtils.log(e);
            throw e;
        }
    }

    public static int updateTable(String sql, Database database) {
        DBUtil dbUtil = DBUtil.getInstance((Connection)((JdbcConnection)database.getConnection()).getUnderlyingConnection());
        return dbUtil.executeUpdate(sql, new HashMap());
    }
}

