/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.util;

import java.sql.Connection;
import java.text.MessageFormat;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.TreeMap;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;

public class ApexUtils {
    private static ArrayList<String> doNotDisplayParms = new ArrayList<String>(){
        private static final long serialVersionUID = 1L;
        {
            this.add("ddl");
            this.add("filename");
            this.add("isSqlCl");
            this.add("object-name");
            this.add("object-type");
            this.add("ddl");
            this.add("sql");
        }
    };

    public static String genApexController(LinkedList<APEXExport.RowDetails> files, Connection conn) {
        StringBuilder sb = new StringBuilder();
        sb.append(ApexUtils.genControllerHeader());
        String user = QueryUtils.getUser(conn);
        for (APEXExport.RowDetails detail : files) {
            sb.append(ApexUtils.genControllerSetup(detail.getWorkName(), detail.getAppId(), user, detail.getFileName(), detail.getOverrideSchema(), detail.getOverrideAlias(), detail.getOverrideWorkspace(), detail.getOverrideAppId()));
        }
        sb.append(ApexUtils.genControllerFooter());
        return sb.toString();
    }

    private static String genControllerFooter() {
        return "</databaseChangeLog> \n";
    }

    public static String commentParamSettings(String parms, Position pos) {
        StringBuilder sb = new StringBuilder();
        HashMap Params = LbUtils.getContext().getParameterInstance().getParameters(parms);
        TreeMap sortedMap = new TreeMap();
        if (Params != null) {
            sortedMap = new TreeMap(Params);
        }
        if (pos == Position.TOP || pos == Position.SINGLE) {
            sb.append("<!--\n");
            sb.append("############ " + ApexUtils.pad(ZonedDateTime.now(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("uuuu.MM.dd.HH.mm.ss")), 10) + " #################################\n");
        }
        sb.append("############ " + ApexUtils.pad(parms, 10) + " ########################################\n");
        for (String key : sortedMap.keySet()) {
            if (doNotDisplayParms.contains(key)) continue;
            sb.append(MessageFormat.format("{0} : {1}\n", ApexUtils.pad(key, 30), sortedMap.get(key)));
        }
        if (pos == Position.BOTTOM || pos == Position.SINGLE) {
            sb.append("############ " + ApexUtils.pad("End Parameters", 10) + " #######################################\n");
            sb.append("-->");
        }
        return sb.toString();
    }

    private static String pad(String word, int newLength) {
        while (((String)word).length() < newLength) {
            word = (String)word + " ";
        }
        return word;
    }

    private static String genControllerHeader() {
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n" + ApexUtils.commentParamSettings("lb.parameters", Position.SINGLE) + "\n<databaseChangeLog \n        xmlns=\"http://www.liquibase.org/xml/ns/dbchangelog\" \n        xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" \n        xmlns:n0=\"http://www.oracle.com/xml/ns/dbchangelog-ext\" \n        xsi:schemaLocation=\"http://www.liquibase.org/xml/ns/dbchangelog \n        http://www.liquibase.org/xml/ns/dbchangelog/dbchangelog-latest.xsd\">\n";
    }

    protected static String genControllerSetup(String workspace, String appId, String user, String filename, String schema, String alias, String override_workspace, String override_appid) {
        StringBuilder setup = new StringBuilder();
        String context = LbUtils.getParameter("contexts");
        String label = LbUtils.getParameter("labels");
        boolean fail = LbUtils.getBoolenParameter("fail-on-error");
        boolean runalways = LbUtils.getBoolenParameter("runalways");
        setup.append("<changeSet id=\"INSTALL_" + appId + "\" author=\"" + user + "\"  %FAILONERROR% %CONTEXTS% %LABELS% %RUNALWAYS% >\n");
        setup.append("    <n0:runApexScript objectName=\"install\" objectType=\"SCRIPT\" ownerName=\"" + user + "\" sourceType=\"STRING\" >\n");
        setup.append("        <n0:source><![CDATA[\n");
        setup.append("declare \n\n");
        setup.append("  -- sqlcl version      = " + ApexMessages.getString((String)"SQLclVersion.VERSION") + " \n");
        setup.append("  -- override_schema    = ${lb.apex.schema} \n");
        setup.append("  -- override_alias     = ${lb.apex.alias} \n");
        setup.append("  -- override_workspace = ${lb.apex.workspace} \n");
        setup.append("  -- override_app_id    = ${lb.apex.appId} \n\n");
        setup.append("  l_app_id apex_applications.application_id%type := q'[" + appId + "]';  \n");
        setup.append("  l_workspace apex_workspaces.workspace%type := q'[" + workspace + "]'; \n\n");
        setup.append("  l_override_workspace apex_workspaces.workspace%type := q'[${lb.apex.workspace}]'; \n");
        setup.append("  l_override_schema apex_workspace_schemas.schema%type := q'[${lb.apex.schema}]';  \n");
        setup.append("  l_override_alias apex_applications.alias%type := q'[${lb.apex.alias}]';  \n");
        setup.append("  l_override_app_id apex_applications.application_id%type := q'[${lb.apex.appId}]';  \n");
        setup.append("  l_generate_offset boolean := false;\n");
        setup.append("begin  \n");
        setup.append("  apex_application_install.clear_all(); \n");
        setup.append("  -- set workspace \n ");
        setup.append("  if (l_override_workspace is not null and l_override_workspace != l_workspace) then \n");
        setup.append("      apex_application_install.set_workspace(l_override_workspace);  \n");
        setup.append("  else \n");
        setup.append("      apex_application_install.set_workspace(l_workspace); \n");
        setup.append("  end if; \n");
        setup.append("     commit;  \n");
        setup.append("  -- set app id \n");
        setup.append("  if (l_override_app_id is not null and l_override_app_id != l_app_id) then \n");
        setup.append("      apex_application_install.set_application_id(l_override_app_id);  \n");
        setup.append("      l_generate_offset := true;\n");
        setup.append("  else  \n");
        setup.append("      apex_application_install.set_application_id(l_app_id); \n");
        setup.append("  end if; \n");
        setup.append("  -- ensure supporting objects get installed\n");
        setup.append("   apex_application_install.set_auto_install_sup_obj(p_auto_install_sup_obj => true); \n");
        setup.append("  -- set schema if not same \n");
        setup.append("  if (l_override_schema is not null) then \n");
        setup.append("      apex_application_install.set_schema(l_override_schema);  \n");
        setup.append("  end if; \n");
        setup.append("  -- set alias \n");
        setup.append("  if (l_override_alias is not null ) then \n");
        setup.append("      apex_application_install.set_application_alias(l_override_alias); \n");
        setup.append("      l_generate_offset := true;\n");
        setup.append("  end if;         \n");
        setup.append("  -- generate offset if necessary\n");
        setup.append("  if (l_generate_offset)  then\n");
        setup.append("     apex_application_install.generate_offset();\n");
        setup.append("  end if;\n");
        setup.append("end;  \n");
        setup.append("/\n");
        String cleanFileName = filename;
        if (filename.contains(LbUtils.getContext().prependCD(""))) {
            cleanFileName = filename.replace(LbUtils.getContext().prependCD(""), "");
        }
        setup.append("@@" + cleanFileName + "\n");
        setup.append("        ]]></n0:source>\n");
        setup.append("    </n0:runApexScript>\n");
        setup.append("</changeSet>\n");
        String change = setup.toString();
        change = fail ? LiquibaseStringUtils.replaceVal("%FAILONERROR%", "failOnError=\"true\"", change) : LiquibaseStringUtils.replaceVal("%FAILONERROR%", null, change);
        change = context != null && !context.isEmpty() ? LiquibaseStringUtils.replaceVal("%CONTEXTS%", "context=\"" + context + "\"", change) : LiquibaseStringUtils.replaceVal("%CONTEXTS%", null, change);
        change = label != null && !label.isEmpty() ? LiquibaseStringUtils.replaceVal("%LABELS%", "labels=\"" + label + "\"", change) : LiquibaseStringUtils.replaceVal("%LABELS%", null, change);
        change = runalways ? LiquibaseStringUtils.replaceVal("%RUNALWAYS%", "runAlways=\"true\"", change) : LiquibaseStringUtils.replaceVal("%RUNALWAYS%", null, change);
        return change;
    }

    public static enum Position {
        TOP,
        BOTTOM,
        SINGLE;

    }
}

