/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.raptor.liquibase.actionlogging;

import java.io.IOException;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Base64;
import java.util.List;
import liquibase.Scope;
import liquibase.change.Change;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.ext.ora.change.CreateInternalSxmlChange;
import liquibase.ext.ora.change.RunInternalScriptChange;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.ext.ora.statement.RollbackOraclePlSqlStatement;
import liquibase.ext.ora.statement.RollbackOracleSxmlStatement;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.ext.ora.statement.RunOrdsScriptStatement;
import liquibase.statement.SqlStatement;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.liquibase.util.DbmsMetaUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.LiquibaseStringUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;

public class ActionLogTableManager {
    public String delLogRecordComment = "delete from %USER_NAME%.%DATABASECHANGELOG%_ACTIONS where id =";
    public String addLogRecordComment = "-- Logging Oracle Liquibase extension actions to";
    public String LogActionSuccessMessage = "Action logged sucessfully.";
    private String LogTriggerSource = "--create log table trigger\nCREATE OR REPLACE TRIGGER %USER_NAME%.%DATABASECHANGELOG%_ACTIONS_TRG BEFORE\r\n    INSERT ON %USER_NAME%.%DATABASECHANGELOG%_ACTIONS\r\n    FOR EACH ROW\r\nDECLARE\r\n    new_seq  NUMBER;\r\nBEGIN\r\n    SELECT\r\n        nvl(MAX(sequence + 1), 0)\r\n    INTO new_seq\r\n    FROM\r\n        %USER_NAME%.%DATABASECHANGELOG%_ACTIONS\r\n    WHERE\r\n            id = :new.id\r\n        AND author = :new.author\r\n        AND filename = :new.filename;\r\n\r\n    :new.sequence := new_seq;\r\nEND;\n/\n-- end trigger\n";
    private String LogViewsource = " <VIEW xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\n   <SCHEMA>%USER_NAME%</SCHEMA>\n   <NAME>%DATABASECHANGELOG%_DETAILS</NAME>\n   <COL_LIST>\n      <COL_LIST_ITEM>\n         <NAME>DEPLOYMENT_ID</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>ID</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>AUTHOR</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>FILENAME</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>SQL</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>SXML</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>DATEEXECUTED</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>EXECTYPE</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>MD5SUM</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>DESCRIPTION</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>COMMENTS</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>LIQUIBASE</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>CONTEXTS</NAME>\n      </COL_LIST_ITEM>\n      <COL_LIST_ITEM>\n         <NAME>LABELS</NAME>\n      </COL_LIST_ITEM>\n   </COL_LIST>\n   <SUBQUERY>SELECT  da.deployment_id,    da.id,    da.author,    da.filename,  da.sql,     da.sxml,    d.dateexecuted,    d.exectype,    d.md5sum,  d.description,    d.comments,    d.liquibase,    d.contexts,    d.labels \nFROM %USER_NAME%.%DATABASECHANGELOG% d  LEFT JOIN %USER_NAME%.%DATABASECHANGELOG%_ACTIONS da ON d.id = da.id AND d.author = da.author AND d.filename = da.filename ORDER BY   1,7</SUBQUERY>\n</VIEW>";
    private String MergeSqlv1 = "MERGE INTO %USER_NAME%.%DATABASECHANGELOG%_ACTIONS tt USING %USER_NAME%.%DATABASECHANGELOG% st ON ( tt.id = st.id )\r\nWHEN MATCHED THEN UPDATE SET tt.author = st.author,tt.filename = st.filename where tt.author is null or tt.filename is null;";
    private String MergeSqlv2a = "update %USER_NAME%.%DATABASECHANGELOG%_ACTIONS SET status = 'SKIPPED' where sql is null or DBMS_LOB.SUBSTR(sql,9) = '--skipped';";
    private String MergeSqlv2b = "update %USER_NAME%.%DATABASECHANGELOG%_ACTIONS SET status = 'RAN' where sql is not null and  DBMS_LOB.SUBSTR(sql,9) != '--skipped';";
    private String LogTableSource = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?><TABLE xmlns=\"http://xmlns.oracle.com/ku\" version=\"1.0\">\r\n <SCHEMA>%USER_NAME%</SCHEMA>\r\n   <NAME>%DATABASECHANGELOG%_ACTIONS</NAME>\r\n   <RELATIONAL_TABLE>\r\n      <COL_LIST>\r\n         <COL_LIST_ITEM>\r\n            <NAME>ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SEQUENCE</NAME>\r\n            <DATATYPE>NUMBER</DATATYPE>\r\n            <NOT_NULL/>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SQL</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>SXML</NAME>\r\n            <DATATYPE>CLOB</DATATYPE>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>AUTHOR</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>FILENAME</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>255</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>DEPLOYMENT_ID</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>10</LENGTH>\r\n         </COL_LIST_ITEM>\r\n         <COL_LIST_ITEM>\r\n            <NAME>STATUS</NAME>\r\n            <DATATYPE>VARCHAR2</DATATYPE>\r\n            <LENGTH>20</LENGTH>\r\n         </COL_LIST_ITEM>\r\n      </COL_LIST>\r\n      %PHYSICAL_PROPERTIES%   </RELATIONAL_TABLE>\r\n</TABLE>";
    private final String props_no_ts = "      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n";
    private String props_ts = " <PHYSICAL_PROPERTIES>\n         <HEAP_TABLE>\n            <SEGMENT_ATTRIBUTES>\n               <SEGMENT_CREATION_DEFERRED></SEGMENT_CREATION_DEFERRED>\n               <PCTFREE>10</PCTFREE>\n               <PCTUSED>40</PCTUSED>\n               <INITRANS>1</INITRANS>\n               <MAXTRANS>255</MAXTRANS>\n               <TABLESPACE>%TABLESPACE%</TABLESPACE>\n               <LOGGING>Y</LOGGING>\n            </SEGMENT_ATTRIBUTES>\n            <COMPRESS>N</COMPRESS>\n         </HEAP_TABLE>\n      </PHYSICAL_PROPERTIES>\n";
    private String PkSql = "ALTER TABLE %USER_NAME%.%DATABASECHANGELOG%_ACTIONS ADD CONSTRAINT %DATABASECHANGELOG%_ACTIONS_PK PRIMARY KEY (id,author,filename,sequence);";
    private final CreateInternalSxmlChange CreateorUpdateLogTableChange = new CreateInternalSxmlChange();
    private final RunInternalScriptChange CreateorUpdateLogTableTriggerChange = new RunInternalScriptChange();
    private final RunInternalScriptChange UpdateLogDataChange = new RunInternalScriptChange();
    private final RunInternalScriptChange CreatePkChange = new RunInternalScriptChange();
    private final CreateInternalSxmlChange CreateorUpdateLogViewChange = new CreateInternalSxmlChange();
    private Database database = null;

    public ActionLogTableManager(Database database) {
        String schema = LbUtils.getParameter("liquibase-schema-name") != null && !"".equals(LbUtils.getParameter("liquibase-schema-name")) ? LbUtils.getParameter("liquibase-schema-name") : database.getDefaultSchemaName();
        this.database = database;
        this.delLogRecordComment = this.delLogRecordComment.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.delLogRecordComment = this.delLogRecordComment.replaceAll("%USER_NAME%", schema);
        this.addLogRecordComment = this.addLogRecordComment.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.addLogRecordComment = this.addLogRecordComment.replaceAll("%USER_NAME%", schema);
        this.LogTriggerSource = this.LogTriggerSource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogTriggerSource = this.LogTriggerSource.replaceAll("%USER_NAME%", schema);
        this.LogViewsource = this.LogViewsource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogViewsource = this.LogViewsource.replaceAll("%USER_NAME%", schema);
        this.MergeSqlv1 = this.MergeSqlv1.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.MergeSqlv1 = this.MergeSqlv1.replaceAll("%USER_NAME%", schema);
        this.MergeSqlv2a = this.MergeSqlv2a.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.MergeSqlv2a = this.MergeSqlv2a.replaceAll("%USER_NAME%", schema);
        this.MergeSqlv2b = this.MergeSqlv2b.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.MergeSqlv2b = this.MergeSqlv2b.replaceAll("%USER_NAME%", schema);
        this.LogTableSource = this.LogTableSource.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.LogTableSource = this.LogTableSource.replaceAll("%USER_NAME%", schema);
        this.PkSql = this.PkSql.replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        this.PkSql = this.PkSql.replaceAll("%USER_NAME%", schema);
        String baseName = "%DATABASECHANGELOG%".replaceAll("%DATABASECHANGELOG%", database.getDatabaseChangeLogTableName());
        if (LbUtils.getParameter("liquibase-tablespace-name") != null && !"".equals(LbUtils.getParameter("liquibase-tablespace-name"))) {
            this.props_ts = this.props_ts.replaceAll("%TABLESPACE%", LbUtils.getParameter("liquibase-tablespace-name"));
            this.LogTableSource = this.LogTableSource.replaceAll("%PHYSICAL_PROPERTIES%", this.props_ts);
        } else {
            this.LogTableSource = this.LogTableSource.replaceAll("%PHYSICAL_PROPERTIES%", "      <PHYSICAL_PROPERTIES>\r\n         <HEAP_TABLE/>\r\n      </PHYSICAL_PROPERTIES>\r\n");
        }
        this.CreateorUpdateLogTableChange.setSource(this.LogTableSource);
        this.CreateorUpdateLogTableChange.setOwnerName(schema);
        this.CreateorUpdateLogTableChange.setObjectType("TABLE");
        this.CreateorUpdateLogTableChange.setObjectName(baseName + "_ACTIONS");
        this.CreateorUpdateLogTableTriggerChange.setSource(this.LogTriggerSource);
        this.CreateorUpdateLogTableTriggerChange.setOwnerName(schema);
        this.CreateorUpdateLogTableTriggerChange.setSourceType("STRING");
        this.CreateorUpdateLogTableTriggerChange.setObjectName(baseName + "_TRG");
        this.CreateorUpdateLogViewChange.setSource(this.LogViewsource);
        this.CreateorUpdateLogViewChange.setOwnerName(schema);
        this.CreateorUpdateLogViewChange.setObjectType("VIEW");
        this.CreateorUpdateLogViewChange.setObjectName(baseName + "_DETAILS");
        this.CreatePkChange.setSource(this.PkSql);
        this.CreatePkChange.setOwnerName(schema);
        this.CreatePkChange.setSourceType("STRING");
        this.CreatePkChange.setObjectName(baseName + "_PK");
        try {
            this.createUpdateLogTable();
        }
        catch (DatabaseException e) {
            LbUtils.log((Exception)((Object)e));
        }
    }

    public void createUpdateLogTable() throws DatabaseException {
        String schema = LbUtils.getParameter("liquibase-schema-name") != null && !"".equals(LbUtils.getParameter("liquibase-schema-name")) ? LbUtils.getParameter("liquibase-schema-name") : this.database.getDefaultSchemaName();
        Connection con = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
        try {
            DBUtil dbUtil = DBUtil.getInstance((Connection)con);
            int cols = 0;
            try {
                Object sql = "select count(*) from all_tab_columns where table_name='%DATABASECHANGELOG%_ACTIONS' and owner = '" + schema + "'";
                sql = ((String)sql).replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName());
                cols = Integer.parseInt(dbUtil.executeReturnOneCol((String)sql));
            }
            catch (Exception sql) {
                // empty catch block
            }
            if (cols == 8) {
                return;
            }
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            exec.execute((Change)this.CreateorUpdateLogTableChange);
            if (cols > 0) {
                this.UpdateLogDataChange.setSource(this.MergeSqlv1);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
                this.UpdateLogDataChange.setSource(this.MergeSqlv2a);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
                this.UpdateLogDataChange.setSource(this.MergeSqlv2b);
                this.UpdateLogDataChange.setSourceType("STRING");
                exec.execute((Change)this.UpdateLogDataChange);
            }
            exec.execute((Change)this.CreatePkChange);
            exec.execute((Change)this.CreateorUpdateLogTableTriggerChange);
            exec.execute((Change)this.CreateorUpdateLogViewChange);
        }
        catch (DatabaseException e) {
            LbUtils.log((Exception)((Object)e));
            throw e;
        }
    }

    private String genActionLoggingSql(String id, String author, String filename, String actions, String sxml) throws DatabaseException {
        try {
            String schema = LbUtils.getParameter("liquibase-schema-name") != null && !"".equals(LbUtils.getParameter("liquibase-schema-name")) ? LbUtils.getParameter("liquibase-schema-name") : this.database.getDefaultSchemaName();
            StringBuilder sb = new StringBuilder();
            Executor exec = ((ExecutorService)Scope.getCurrentScope().getSingleton(ExecutorService.class)).getExecutor("jdbc", this.database);
            String rawAction = "";
            String rawSxml = "";
            if (actions != null) {
                rawAction = new String(Base64.getEncoder().encode(actions.getBytes()));
            }
            if (sxml != null) {
                rawSxml = new String(Base64.getEncoder().encode(sxml.getBytes()));
            }
            sb.append(this.addLogRecordComment);
            sb.append("\n DECLARE ");
            sb.append("\n id varchar2(2000) := '" + id + "';");
            sb.append("\n status varchar2(2000) := 'PREPARING';");
            sb.append("\n rawAction clob;");
            sb.append("\n rawSxml clob;");
            sb.append("\n myrow varchar2(2000);");
            sb.append("\n action clob := '';");
            sb.append("\n sxml clob := '';");
            sb.append("\n dep varchar2(2000) := '" + ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.database).getDeploymentId() + "';");
            sb.append("\n author varchar2(2000) := '" + author + "';");
            sb.append("\n filename varchar2(2000) := '" + filename + "';");
            sb.append("\n insertlog varchar2(2000) := 'insert into %USER_NAME%.%DATABASECHANGELOG%_ACTIONS (id,author,filename,sql,sxml,deployment_id,status) values (:id,:author,:filename,:action,:sxml,:dep,:status) returning rowid into :out';");
            sb.append("\n updateaction varchar2(2000) := 'update %USER_NAME%.%DATABASECHANGELOG%_ACTIONS set sql = sql ||:action where rowid = :myrow ';");
            sb.append("\n updatesxml varchar2(2000) := 'update %USER_NAME%.%DATABASECHANGELOG%_ACTIONS set sxml = sxml ||:sxml where rowid = :myrow ';");
            sb.append("\n begin ");
            if (actions == null) {
                sb.append("\n action := '';");
            } else if (rawAction.length() < 32000 && rawSxml.length() < 32000) {
                if (rawAction.length() > 0) {
                    sb.append("\naction := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawAction + "}')));");
                }
                if (rawSxml.length() > 0) {
                    sb.append("\nsxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(q'{" + rawSxml + "}')));");
                }
                sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep,status returning into myrow;");
            } else {
                List<String> actionchunks = LiquibaseStringUtils.splitString(rawAction, 32000);
                List<String> sxmlchunks = LiquibaseStringUtils.splitString(rawSxml, 32000);
                boolean first = true;
                for (String piece : actionchunks) {
                    sb.append("\n rawAction := '" + piece + "';");
                    sb.append("\n action := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawAction)));");
                    if (first) {
                        sb.append("\n execute immediate insertlog using id,author,filename,action,sxml,dep,status returning into myrow;");
                        first = false;
                        continue;
                    }
                    sb.append("\n execute immediate updateaction using action,myrow;");
                }
                for (String piece : sxmlchunks) {
                    sb.append("\n rawSxml := '" + piece + "';");
                    sb.append("\n sxml := utl_raw.cast_to_varchar2(utl_encode.base64_decode(utl_raw.cast_to_raw(rawSxml)));");
                    sb.append("\n execute immediate updatesxml using sxml,myrow;\n");
                }
            }
            sb.append("\nend;");
            if (exec instanceof LoggingExecutor) {
                sb.append("\n/        --\n");
            }
            String ret = sb.toString().replaceAll("%USER_NAME%", schema);
            return ret.replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName());
        }
        catch (Exception e) {
            LbUtils.log(e);
            throw e;
        }
    }

    private String genRollbackActionLogging(String id, String author, String filename) {
        String schema = LbUtils.getParameter("liquibase-schema-name") != null && !"".equals(LbUtils.getParameter("liquibase-schema-name")) ? LbUtils.getParameter("liquibase-schema-name") : this.database.getDefaultSchemaName();
        StringBuilder sb = new StringBuilder();
        sb.append("delete from " + schema + this.database.getDatabaseChangeLogTableName() + "_ACTIONS");
        sb.append(" where id = '" + id + "' and filename = '" + filename);
        sb.append("' and author ='" + author + "' and sequence = (select Max(sequence) from ");
        sb.append(schema + this.database.getDatabaseChangeLogTableName() + "_ACTIONS where id = '");
        sb.append(id + "' and filename = '" + filename + "' and author ='" + author + "')");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActionFromActionLog(String changeId, String author, String filename) throws SQLException, IOException, DatabaseException {
        Connection conn = ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection();
        String actionLogSxmlQuery = QueryUtils.getXMLQueries().getQuery("actionLogSxmlQuery", conn).getSql();
        actionLogSxmlQuery = actionLogSxmlQuery.replaceAll("%DATABASECHANGELOG%", this.database.getDatabaseChangeLogTableName());
        StringBuilder sb = new StringBuilder();
        PreparedStatement stmt = null;
        ResultSet rs = null;
        this.createUpdateLogTable();
        stmt = conn.prepareStatement(actionLogSxmlQuery);
        stmt.setString(1, changeId);
        stmt.setString(2, author);
        stmt.setString(3, filename);
        rs = stmt.executeQuery();
        while (rs.next()) {
            Clob sxml = rs.getClob(1);
            if (sxml == null) {
                String string = null;
                return string;
            }
            sb.append(LiquibaseStringUtils.clobToString(sxml));
        }
        String string = sb.toString();
        return string;
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exception) {}
            if (stmt != null) {
                try {
                    stmt.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    public String getActionLogSql(SqlStatement statement, String sqltorun) throws DatabaseException {
        StringBuilder sb = new StringBuilder();
        if (!(statement instanceof AbstractOracleStatement)) {
            return null;
        }
        if (statement instanceof RollbackOraclePlSqlStatement || statement instanceof RollbackOracleSxmlStatement) {
            AbstractOracleStatement st = (AbstractOracleStatement)statement;
            sb.append(this.genRollbackActionLogging(st.getId(), st.getAuthor(), st.getFile()));
        } else {
            AbstractOracleStatement st = (AbstractOracleStatement)statement;
            if ((statement instanceof RunOracleScriptStatement || statement instanceof RunApexScriptStatement || statement instanceof RunOrdsScriptStatement) && sqltorun.length() > 32768) {
                sqltorun = "Not capturing long script";
            }
            sb.append(this.genActionLoggingSql(st.getId(), st.getAuthor(), st.getFile(), sqltorun, DbmsMetaUtils.getObjectFromDb(((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), st.getObjectType(), st.getObjectName())));
        }
        return sb.toString();
    }
}

