/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.ora.generator;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import liquibase.database.Database;
import liquibase.database.core.OracleDatabase;
import liquibase.ext.ora.generator.AbstractCommonPlSqlGenerator;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.ext.ora.statement.RunInternalScriptStatement;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.structure.DatabaseObject;
import oracle.dbtools.raptor.liquibase.util.LbUtils;

public class RunInternalScriptGenerator
extends AbstractCommonPlSqlGenerator<AbstractCommonPlSqlStatement> {
    public static String getSqlString(AbstractCommonPlSqlStatement statement) throws Exception {
        StringBuilder sql = new StringBuilder();
        if ("STRING".equals(statement.getSourceType().toUpperCase())) {
            if (statement instanceof RunApexScriptStatement) {
                String schema = LbUtils.getParameter("override-app-schema");
                String alias = LbUtils.getParameter("override-app-alias");
                String workspace = LbUtils.getParameter("override-app-workspace");
                String app_id = LbUtils.getParameter("override-app-id");
                String source = statement.getSource();
                LbUtils.log("pre substitution");
                LbUtils.log(source);
                source = app_id != null ? source.replace("${lb.apex.appId}", app_id) : source.replace("${lb.apex.appId}", "");
                source = schema != null ? source.replace("${lb.apex.schema}", schema) : source.replace("${lb.apex.schema}", "");
                source = alias != null ? source.replace("${lb.apex.alias}", alias) : source.replace("${lb.apex.alias}", "");
                source = workspace != null ? source.replace("${lb.apex.workspace}", workspace) : source.replace("${lb.apex.workspace}", "");
                sql.append(source);
            } else {
                sql.append(statement.getSource());
            }
        } else if ("FILE".equals(statement.getSourceType().toUpperCase())) {
            String content = "";
            Path cwd = null;
            Path file = null;
            Path path = null;
            try {
                if ("true".equals(statement.getRelativeToChangelogFile().toLowerCase())) {
                    cwd = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toAbsolutePath();
                    file = cwd.resolve(statement.getFile().trim());
                    statement.setFile(file.toString().trim());
                    path = cwd.resolve(file.getParent()).resolve(statement.getSource().trim());
                    statement.setSource(path.toString().trim());
                    if (Files.notExists(path, new LinkOption[0])) {
                        throw new FileNotFoundException(path.toString());
                    }
                } else {
                    cwd = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toRealPath(new LinkOption[0]);
                    path = cwd.resolve(statement.getSource());
                }
                content = new String(Files.readAllBytes(path));
            }
            catch (Exception e) {
                LbUtils.log(e);
                throw e;
            }
            sql.append(content);
        } else if ("URL".equals(statement.getSourceType().toUpperCase())) {
            URL url = null;
            URI uri = null;
            URL fileURL = null;
            try {
                String inputLine;
                url = new URL(statement.getSource());
                uri = new URI(url.getProtocol(), url.getUserInfo(), url.getHost(), url.getPort(), url.getPath(), url.getQuery(), url.getRef());
                fileURL = uri.toURL();
                BufferedReader in = new BufferedReader(new InputStreamReader(fileURL.openStream()));
                while ((inputLine = in.readLine()) != null) {
                    sql.append(inputLine);
                }
                in.close();
            }
            catch (Exception e) {
                LbUtils.log(e);
                return null;
            }
        }
        String outSql = sql.toString();
        if (outSql.endsWith("/\n") || outSql.endsWith("/")) {
            outSql = outSql.replaceAll("/\n$", "");
            outSql = outSql.replaceAll("/$", "");
        }
        return outSql;
    }

    @Override
    public AbstractCommonPlSqlGenerator.ACTIONS createOrDrop() {
        return null;
    }

    @Override
    public Sql[] generateSql(AbstractCommonPlSqlStatement statement, Database database, SqlGeneratorChain chain) {
        try {
            return new Sql[]{new UnparsedSql(RunInternalScriptGenerator.getSqlString(statement), new DatabaseObject[0])};
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean supports(AbstractCommonPlSqlStatement statement, Database database) {
        return database instanceof OracleDatabase && statement instanceof RunInternalScriptStatement;
    }
}

