/*
 * Decompiled with CFR 0.152.
 */
package liquibase.executor.jvm;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import liquibase.database.jvm.JdbcConnection;
import liquibase.exception.DatabaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.ext.ora.statement.AbstractCommonPlSqlStatement;
import liquibase.ext.ora.statement.AbstractOracleStatement;
import liquibase.ext.ora.statement.CreateInternalSxmlStatement;
import liquibase.ext.ora.statement.DropCommentStatement;
import liquibase.ext.ora.statement.DropInternalSxmlStatement;
import liquibase.ext.ora.statement.LogOracleActionStatement;
import liquibase.ext.ora.statement.LogOracleSyncStatement;
import liquibase.ext.ora.statement.RollbackOraclePlSqlStatement;
import liquibase.ext.ora.statement.RollbackOracleSxmlStatement;
import liquibase.ext.ora.statement.RunApexScriptStatement;
import liquibase.ext.ora.statement.RunInternalScriptStatement;
import liquibase.ext.ora.statement.RunOracleScriptStatement;
import liquibase.ext.ora.statement.RunOrdsScriptStatement;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.statement.SqlStatement;
import oracle.dbtools.raptor.liquibase.actionlogging.ActionLogTableManager;
import oracle.dbtools.raptor.liquibase.util.LbFileUtils;
import oracle.dbtools.raptor.liquibase.util.LbUtils;
import oracle.dbtools.raptor.liquibase.util.QueryUtils;

public class SqlClExecutor
extends JdbcExecutor {
    final String sqlcl_skip_rb = "YES".equals(System.getenv("sqlcl_skip_rb")) ? "YES" : "";

    public void execute(SqlStatement stmt, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        ArrayList<Exception> errors = new ArrayList<Exception>();
        if (stmt instanceof AbstractOracleStatement) {
            LbUtils.log("Executing with the 'SqlCl-jdbc' executor");
            String[] sqls = this.applyVisitors(stmt, sqlVisitors);
            if (sqls == null) {
                LbUtils.report("No SQL to execute object not changed.");
                return;
            }
            for (String sSql : sqls) {
                if (sSql == null) {
                    LbUtils.report("No SQL to execute object not changed.");
                    continue;
                }
                LbUtils.log(sSql);
                String sql = sSql.replaceAll("\\n\\s*\\n", "\n");
                try {
                    if (stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof CreateInternalSxmlStatement || stmt instanceof RunInternalScriptStatement || stmt instanceof DropInternalSxmlStatement || stmt instanceof RollbackOraclePlSqlStatement || stmt instanceof RollbackOracleSxmlStatement) {
                        QueryUtils.runSqlReturnResult(sql, ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), false);
                        continue;
                    }
                    if (stmt instanceof DropCommentStatement) {
                        String result = QueryUtils.runSqlReturnResult(sql, ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), false);
                        LbUtils.report(result.replaceAll("created", "dropped"));
                        continue;
                    }
                    Path cwd = null;
                    boolean scan = true;
                    if (stmt instanceof RunApexScriptStatement || stmt instanceof RunOrdsScriptStatement || stmt instanceof RunOracleScriptStatement) {
                        if (stmt instanceof RunApexScriptStatement) {
                            scan = false;
                        }
                        cwd = Paths.get(LbUtils.getContext().prependCD(""), new String[0]).toAbsolutePath();
                        if ("true".equals(((AbstractOracleStatement)stmt).getRelativeToChangelogFile().toLowerCase())) {
                            String path = "STRING".equals(((AbstractOracleStatement)stmt).getSourceType()) || "URL".equals(((AbstractOracleStatement)stmt).getSourceType()) ? Paths.get(((AbstractOracleStatement)stmt).getFile(), new String[0]).getParent().toString() : Paths.get(((AbstractOracleStatement)stmt).getSource(), new String[0]).getParent().toString();
                            LbUtils.log("cd to " + path);
                            LbFileUtils.setCWD(path, LbUtils.getContext());
                        }
                    }
                    LbUtils.report(QueryUtils.runSqlReturnResult(sql, ((JdbcConnection)this.database.getConnection()).getUnderlyingConnection(), scan));
                    if (!(stmt instanceof RunApexScriptStatement) && !(stmt instanceof RunOrdsScriptStatement) && (!(stmt instanceof RunOracleScriptStatement) || !"true".equals(((AbstractOracleStatement)stmt).getRelativeToChangelogFile().toLowerCase()))) continue;
                    LbUtils.log("cd to " + cwd);
                    LbFileUtils.setCWD(cwd.toString(), LbUtils.getContext());
                }
                catch (Exception e) {
                    LbUtils.report(e);
                    if (stmt instanceof AbstractOracleStatement) {
                        LbUtils.addError(((AbstractOracleStatement)stmt).getFile(), LbUtils.exceptionToString(e));
                    }
                    errors.add(e);
                }
            }
            if (("NO".equals(this.sqlcl_skip_rb) || "".equals(this.sqlcl_skip_rb)) && errors.size() > 0) {
                if (stmt instanceof RunOracleScriptStatement || stmt instanceof RunApexScriptStatement || stmt instanceof RunOrdsScriptStatement) {
                    LbUtils.report("Unable to rollback Scripts automatically, taking no action.");
                    throw new DatabaseException("Unable to rollback Scripts automatically, taking no action.");
                }
                if (stmt instanceof LogOracleActionStatement || stmt instanceof LogOracleSyncStatement || stmt instanceof CreateInternalSxmlStatement || stmt instanceof RunInternalScriptStatement || stmt instanceof DropInternalSxmlStatement) {
                    LbUtils.log("Error occured running internal sql.");
                    LbUtils.log(((AbstractOracleStatement)stmt).getSource());
                    throw new DatabaseException("Error occured running internal sql.");
                }
                if (!(stmt instanceof RollbackOracleSxmlStatement) && !(stmt instanceof RollbackOraclePlSqlStatement)) {
                    LbUtils.report("Rolling back changeset.\n", true);
                    AbstractOracleStatement rec = (AbstractOracleStatement)stmt;
                    ActionLogTableManager tm = new ActionLogTableManager(this.database);
                    try {
                        String origObject = tm.getActionFromActionLog(rec.getId(), rec.getAuthor(), rec.getFile());
                        rec.setSource(origObject);
                    }
                    catch (Exception e) {
                        if (stmt instanceof AbstractOracleStatement) {
                            LbUtils.addError(((AbstractOracleStatement)stmt).getFile(), LbUtils.exceptionToString(e));
                        }
                        errors.add(e);
                        throw new DatabaseException("Rollback failed");
                    }
                    if (stmt instanceof AbstractCommonPlSqlStatement) {
                        this.execute((SqlStatement)new RollbackOraclePlSqlStatement(rec), null);
                    } else {
                        this.execute((SqlStatement)new RollbackOracleSxmlStatement(rec), null);
                    }
                    LbUtils.report("Rollback completed successfully.\n", true);
                    if (errors.get(0) instanceof DatabaseException) {
                        throw (DatabaseException)((Object)errors.get(0));
                    }
                    throw new DatabaseException((Throwable)errors.get(0));
                }
            } else if ("YES".equals(this.sqlcl_skip_rb) && errors.size() > 0) {
                LbUtils.report("Rollback skipped because of env variable");
                throw new DatabaseException("Rollback skipped");
            }
        } else {
            super.execute(stmt, sqlVisitors);
        }
    }

    public String getName() {
        return "jdbc";
    }

    public int getPriority() {
        return 99999999;
    }
}

