/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagHelper;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;

public class GITRevertCommitCustomizer
extends VCSOptionsCustomizerAdapter {
    private GITRevertCommitPanel _panel;
    private GITBranchTagHelper _helper = new GITBranchTagHelper();
    private GITBranchTagValidator _validator = new GITBranchTagValidator();
    public static final String COMMIT_REVERT_MOD = "git-commit-revert";

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITRevertCommitPanel();
        }
        return this._panel;
    }

    public void setOptions(Map<?, ?> map) {
        GITRevertCommitPanel panel = (GITRevertCommitPanel)this.getComponent();
        this._helper.setOptions(map, panel.getBranch());
    }

    public Map<?, ?> getOptions() {
        GITRevertCommitPanel panel = (GITRevertCommitPanel)this.getComponent();
        Map<String, Object> options = this._helper.getOptions(panel.getBranch());
        options.put(COMMIT_REVERT_MOD, panel.isCommitRevert());
        return options;
    }

    public void validateOptions() throws VCSException {
        URL root;
        String tag;
        Map<?, ?> opts = this.getOptions();
        String branch = (String)opts.get("Git-use-branch");
        VCSException exception = this._validator.validateBranchAndTag(branch, tag = (String)opts.get("Git-use-tag"), root = (URL)opts.get("Git-local-root"), Resource.get("REVERT_COMMIT_ERROR_TITLE"), GITUtil.getBranches(root));
        if (exception != null) {
            throw exception;
        }
    }

    private class GITRevertCommitPanel
    extends JPanel {
        private GITBranchRevisionPanel _brrevPanel = new GITBranchRevisionPanel();
        private JCheckBox _chCommitMod = new JCheckBox();

        private GITRevertCommitPanel() {
            this.init();
            this.initLayout();
        }

        private void init() {
            ResourceUtils.resButton((AbstractButton)this._chCommitMod, (String)Resource.get("REVERTCOMMIT_COMMIT_MOD"));
            this._chCommitMod.setSelected(true);
        }

        private void initLayout() {
            this.setLayout(new GridBagLayout());
            this.add((Component)this._brrevPanel, new GridBagConstraints(0, 0, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this._chCommitMod, new GridBagConstraints(0, 2, 2, 2, 1.0, 0.0, 17, 2, new Insets(5, 0, 5, 0), 0, 0));
        }

        private GITBranchRevisionPanel getBranch() {
            return this._brrevPanel;
        }

        private boolean isCommitRevert() {
            return this._chCommitMod.isSelected();
        }
    }
}

