/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.net.URL;
import java.util.Map;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizerAdapter;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagHelper;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;
import org.netbeans.libs.git.GitBranch;

public class GITMergeCustomizer
extends VCSOptionsCustomizerAdapter {
    private Map<String, GitBranch> _branches;
    private GITBranchRevisionPanel _panel;
    private final GITBranchTagValidator _validator = new GITBranchTagValidator();
    private final GITBranchTagHelper _helper = new GITBranchTagHelper();
    private String _errorTitle;

    public GITMergeCustomizer(String errorTitle) {
        this._errorTitle = errorTitle;
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITBranchRevisionPanel();
        }
        return this._panel;
    }

    public Map getOptions() {
        GITBranchRevisionPanel ui = (GITBranchRevisionPanel)this.getComponent();
        return this._helper.getOptions(ui);
    }

    public void setOptions(Map map) {
        GITBranchRevisionPanel ui = (GITBranchRevisionPanel)this.getComponent();
        this._helper.setOptions(map, ui);
    }

    public void validateOptions() throws VCSException {
        URL root;
        String tag;
        Map opts = this.getOptions();
        String branch = (String)opts.get("Git-use-branch");
        VCSException exception = this._validator.validateBranchAndTag(branch, tag = (String)opts.get("Git-use-tag"), root = (URL)opts.get("Git-local-root"), this._errorTitle, this.getBranches(root));
        if (exception != null) {
            throw exception;
        }
    }

    private Map<String, GitBranch> getBranches(URL root) {
        if (this._branches == null) {
            this._branches = GITUtil.getBranches(root);
        }
        return this._branches;
    }
}

