/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.ui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.controls.FileField;
import oracle.jdeveloper.vcs.generic.CommandState;
import oracle.jdeveloper.vcs.spi.VCSException;
import oracle.jdeveloper.vcs.spi.VCSOptionsCustomizer;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.res.Resource;
import oracle.jdevimpl.vcs.git.ui.GITBranchRevisionPanel;
import oracle.jdevimpl.vcs.git.ui.GITBranchTagValidator;
import oracle.jdevimpl.vcs.xspi.VCSBugCommandState;
import oracle.jdevimpl.vcs.xspi.VCSBugTrackingManager;
import org.netbeans.libs.git.GitBranch;

public class GITExportCommitted
implements VCSOptionsCustomizer {
    public static final String EXPORT_FILE = "ExportFile";
    public static final String BRANCH = "Branch";
    public static final String TAG = "Tag";
    public static final String COMMIT_ID = "CommitId";
    public static final String ROOT_URL = "RootURL";
    public static final String PATCH_LOCATION_ENABLE = "PatchLocation";
    private final GITBranchTagValidator _validator = new GITBranchTagValidator();
    private Map<String, GitBranch> _branches;
    private GITExportCommittedPanel _panel;
    private CommandState _commandState;

    public GITExportCommitted(CommandState commandState) {
        this._commandState = commandState;
    }

    public Component getComponent() {
        if (this._panel == null) {
            this._panel = new GITExportCommittedPanel();
        }
        return this._panel;
    }

    public void setOptions(Map<?, ?> options) {
        GITExportCommittedPanel panel = (GITExportCommittedPanel)this.getComponent();
        if (options.containsKey(PATCH_LOCATION_ENABLE)) {
            panel.enablePatchLocation((Boolean)options.get(PATCH_LOCATION_ENABLE));
        } else {
            panel.setExportFile((URL)options.get(EXPORT_FILE));
            panel.setRootURL((URL)options.get(ROOT_URL));
            panel.setBranch((String)options.get(BRANCH));
            panel.setCommitId((String)options.get(COMMIT_ID));
            panel.setTag((String)options.get(TAG));
        }
    }

    public Map<?, ?> getOptions() {
        GITExportCommittedPanel panel = (GITExportCommittedPanel)this.getComponent();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(EXPORT_FILE, panel.getExportFile());
        map.put(BRANCH, panel.getBranch());
        map.put(TAG, panel.getTag());
        map.put(COMMIT_ID, panel.getCommitId());
        map.put(ROOT_URL, panel.getRootUrl());
        map.put(PATCH_LOCATION_ENABLE, panel.isEnabledPatchLocation());
        return map;
    }

    public void validateOptions() throws VCSException {
        Map<?, ?> opts = this.getOptions();
        URL url = (URL)opts.get(EXPORT_FILE);
        String branch = (String)opts.get(BRANCH);
        String tag = (String)opts.get(TAG);
        URL root = (URL)opts.get(ROOT_URL);
        Boolean enabled = (Boolean)opts.get(PATCH_LOCATION_ENABLE);
        if (url == null && enabled.booleanValue()) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.get("ERROR_EXPORT_FILE"));
        }
        if (URLFileSystem.exists((URL)url) && enabled.booleanValue()) {
            throw new VCSException(Resource.get("EXPORT_FILE_EXIST_TITLE"), Resource.format("EXPORT_FILE_EXIST", URLFileSystem.getPlatformPathName((URL)url)));
        }
        VCSException exception = this._validator.validateBranchAndTag(branch, tag, root, Resource.get("EXPORT_FILE_EXIST_TITLE"), this.getBranches(root));
        if (exception != null) {
            throw exception;
        }
        try {
            VCSBugTrackingManager.getInstance().validatePatch(((VCSBugCommandState)this._commandState).getBugContext());
        }
        catch (Exception e) {
            throw new VCSException(Resource.get("EXPORT_ERROR_TITLE"), e.getLocalizedMessage());
        }
    }

    public Component getInitialFocusComponent() {
        return ((GITExportCommittedPanel)this.getComponent()).getInitialFocusComponent();
    }

    private Map<String, GitBranch> getBranches(URL root) {
        if (this._branches == null) {
            this._branches = GITUtil.getBranches(root);
        }
        return this._branches;
    }

    private static class GITExportCommittedPanel
    extends JPanel {
        private JLabel _lblFile = new JLabel();
        private FileField _fldDest = new FileField();
        private JButton _browse = new JButton();
        private GITBranchRevisionPanel _brrevPanel = new GITBranchRevisionPanel();

        GITExportCommittedPanel() {
            this.initComponents();
            this.layoutComponenents();
            this.listeners();
        }

        Component getInitialFocusComponent() {
            return this._fldDest;
        }

        void enablePatchLocation(boolean enabled) {
            this._lblFile.setEnabled(enabled);
            this._fldDest.setEnabled(enabled);
            this._browse.setEnabled(enabled);
        }

        boolean isEnabledPatchLocation() {
            return this._fldDest.isEnabled();
        }

        private void initComponents() {
            ResourceUtils.resLabel((JLabel)this._lblFile, (Component)this._fldDest, (String)Resource.get("EXPORT_COMM_FILE"));
            ResourceUtils.resButton((AbstractButton)this._browse, (String)Resource.get("EXPORT_COMM_BROWSE"));
        }

        private void layoutComponenents() {
            Insets isn = new Insets(5, 0, 5, 0);
            this.setLayout(new GridBagLayout());
            this.add((Component)this._brrevPanel, new GridBagConstraints(0, 0, 3, 4, 1.0, 0.0, 17, 1, isn, 0, 0));
            this._brrevPanel.addLayoutRow(this._lblFile, (Component)this._fldDest, this._browse);
        }

        private void listeners() {
            this._browse.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    URL current = URLFactory.newDirURL((String)_fldDest.getText());
                    URLChooser chooser = DialogUtil.newURLChooser((URL)current);
                    chooser.setSelectionMode(0);
                    if (chooser.showOpenDialog((Component)this) == 0) {
                        _fldDest.setText(URLFileSystem.getPlatformPathName((URL)chooser.getSelectedURL()));
                    }
                }
            });
        }

        private void setExportFile(URL url) {
            this._fldDest.setText(URLFileSystem.getPlatformPathName((URL)url));
        }

        private URL getExportFile() {
            if (this._fldDest.isEnabled()) {
                return URLFactory.newURL((String)this._fldDest.getText());
            }
            return null;
        }

        private void setBranch(String branch) {
            this._brrevPanel.setSelectedBranch(branch);
        }

        private String getBranch() {
            return this._brrevPanel.getSelectedBranch();
        }

        private String getTag() {
            return this._brrevPanel.getSelectedTag();
        }

        private void setTag(String tag) {
            this._brrevPanel.setSelectedTag(tag);
        }

        private String getCommitId() {
            return this._brrevPanel.getSelectedRevision();
        }

        private void setCommitId(String id) {
            if (id != null) {
                this._brrevPanel.setSelectedRevision(id);
            }
        }

        private void setRootURL(URL url) {
            this._brrevPanel.setRepositoryRoot(url);
        }

        private URL getRootUrl() {
            return this._brrevPanel.getRepositoryRoot();
        }
    }
}

