/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.prefs;

import oracle.ideri.util.Product;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.PropertyStorage;

public class GITVersionToolsPrefs
extends HashStructureAdapter {
    private static final String DATA_KEY = "oracle.jdeveloper.vcs.git.GITVersionToolsPrefs";
    private static final String PENDING_CHANGES_DIALOG_USAGE = "pendingChangesDialogUsage";
    private static final int DEFAULT_PENDING_CHANGES_DIALOG_USAGE = 0;
    private static final String SAVE_PASSWD_PASSPHRASE = "gitSavePassPassphrase";
    private static final Boolean SAVE_PASS_PHRASE = Boolean.TRUE;

    private GITVersionToolsPrefs(HashStructure hash) {
        super(hash);
    }

    public static GITVersionToolsPrefs getInstance(PropertyStorage prefs) {
        return new GITVersionToolsPrefs(GITVersionToolsPrefs.findOrCreate((PropertyStorage)prefs, (String)DATA_KEY));
    }

    public int getPendingChangesDialogUsage() {
        return this._hash.getInt(PENDING_CHANGES_DIALOG_USAGE, 0);
    }

    public void setPendingChangesDialogUsage(int pendingChangesDialogUsage) {
        this._hash.putInt(PENDING_CHANGES_DIALOG_USAGE, pendingChangesDialogUsage);
    }

    public boolean getSavePassPhrase() {
        if (Product.isRaptor()) {
            return false;
        }
        return this._hash.getBoolean(SAVE_PASSWD_PASSPHRASE, SAVE_PASS_PHRASE.booleanValue());
    }

    void setSavePassPhrase(Boolean save) {
        this._hash.putBoolean(SAVE_PASSWD_PASSPHRASE, save.booleanValue());
    }
}

