/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav.cmd;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.compare.CompareContributor;
import oracle.jdeveloper.compare.InputStreamTextContributor;
import oracle.jdeveloper.compare.StreamDecoder;
import oracle.jdeveloper.vcs.commithistory.CommitNode;
import oracle.jdeveloper.vcs.spi.VCSCommand;
import oracle.jdevimpl.compare.CompareIdeViewer;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.GITRevision;
import oracle.jdevimpl.vcs.git.GITUtil;
import oracle.jdevimpl.vcs.git.commithistory.GITCommitVersionCompare;
import oracle.jdevimpl.vcs.git.nav.GITStashFileNode;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITNavCompareWorking
extends VCSCommand {
    public static String COMMAND_ID = "oracle.jdeveloper.git.nav-compareworking";

    public GITNavCompareWorking() {
        super(Ide.findOrCreateCmdID((String)COMMAND_ID));
    }

    protected int doitImpl() throws Exception {
        Node node = this.getContext().getNode();
        InputStream is = null;
        if (node instanceof GITStashFileNode) {
            GITStashFileNode stNode = (GITStashFileNode)node;
            URL root = GITNavURLFileSystemHelper.fromNavigatorURL(stNode.getURL());
            GitClient client = null;
            GITRevision rev = (GITRevision)stNode.getData();
            URL fileUrl = stNode.getFile().toURI().toURL();
            try {
                String type = GITUtil.getSuffixAsType(fileUrl);
                String charsetName = StreamDecoder.getDefaultEncoding((URL)fileUrl);
                String title = GITUtil.shortCommitId(rev.getRevision());
                GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("catFile");
                client = GITClientAdaptor.getClient(root);
                ByteArrayOutputStream commitOS = new ByteArrayOutputStream();
                client.catFile(stNode.getFile(), rev.getRevision(), (OutputStream)commitOS, (ProgressMonitor)monitor);
                InputStreamTextContributor cmtContrib = new InputStreamTextContributor((InputStream)new ByteArrayInputStream(commitOS.toByteArray()), charsetName, title, title, type);
                is = stNode.getFile().exists() ? new FileInputStream(stNode.getFile()) : new ByteArrayInputStream("".getBytes());
                title = stNode.getFile().getName();
                InputStreamTextContributor wkContrib = new InputStreamTextContributor(is, charsetName, title, title, type);
                CompareIdeViewer.getCompareIdeViewer().show((CompareContributor)cmtContrib, (CompareContributor)wkContrib, (Element)new CommitNode(fileUrl));
            }
            catch (GitException ex) {
                GITProfile.getQualifiedLogger(GITCommitVersionCompare.class.getName()).warning(ex.getMessage());
                throw new GITProcessException(Resource.format("ERROR_STASH_COMPARE_WK", URLFileSystem.getPlatformPathName((URL)fileUrl)), (Exception)((Object)ex));
            }
            finally {
                if (client != null) {
                    client.release();
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
            return 0;
        }
        return 1;
    }
}

