/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.nav;

import java.net.URL;
import javax.swing.Icon;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.ImageIconCache;
import oracle.jdevimpl.vcs.git.GITNavURLFileSystemHelper;
import oracle.jdevimpl.vcs.git.nav.GITRemote;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitBranch;

public class GITBranchNode
extends Node
implements GITRemote {
    private GitBranch _info;
    private URL _toolUrl;

    GITBranchNode(GitBranch branch, URL url) {
        this._info = branch;
        this._toolUrl = url;
        this.setURL(GITNavURLFileSystemHelper.toNavigatorURL(url));
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public String getShortLabel() {
        return this._info.getName();
    }

    public Icon getIcon() {
        if (this._info.isActive()) {
            return ImageIconCache.get((URL)Resource.getBundle().getClass().getResource(Resource.get("BRANCH_ACTIVE_ICON")));
        }
        return OracleIcons.getIcon((String)"branch.png");
    }

    boolean isLocal() {
        return !this._info.isRemote();
    }

    public GitBranch getBranch() {
        return this._info;
    }

    public String getToolTipText() {
        return URLFileSystem.toDisplayString((URL)this._toolUrl);
    }

    @Override
    public boolean canDelete() {
        return !this._info.isActive();
    }

    @Override
    public boolean canRefresh() {
        return false;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GITBranchNode)) {
            return false;
        }
        return this.equalsImpl((Node)obj);
    }
}

