/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git.imp;

import java.awt.Component;
import java.net.URL;
import java.util.Collection;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.TraversableContext;
import oracle.ide.wizard.FinishPanel;
import oracle.jdevimpl.vcs.git.res.Resource;

public class SummaryPanel
extends FinishPanel {
    private boolean _initialized = false;
    private JTree _tree;
    private DefaultMutableTreeNode _destinationNode;
    private DefaultMutableTreeNode _sourceNode;
    private DefaultMutableTreeNode _filtersNode;

    public void onEntry(TraversableContext ctx) {
        super.onEntry(ctx);
        this.initialize();
        this.populateSummary(ctx);
        DefaultTreeModel treeModel = (DefaultTreeModel)this._tree.getModel();
        treeModel.reload((TreeNode)treeModel.getRoot());
        this.expandSummaryTree();
    }

    private synchronized void initialize() {
        if (this._initialized) {
            return;
        }
        this.setFinishText(Resource.get("IMPORT_UI_SUMMARY_TITLE"));
        this._tree = this.createSummaryTree(Resource.get("IMPORT_UI_SUMMARY_DESC"));
        this._tree.setShowsRootHandles(true);
        this._tree.setCellRenderer(new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                this.setBackgroundNonSelectionColor(tree.getBackground());
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                this.setIcon(null);
                return this;
            }
        });
        this._destinationNode = new DefaultMutableTreeNode(Resource.get("IMPORT_WIZARD_DESTINATION"));
        this._sourceNode = new DefaultMutableTreeNode(Resource.get("IMPORT_WIZARD_SOURCE"));
        this._filtersNode = new DefaultMutableTreeNode(Resource.get("IMPORT_WIZARD_FILTERS"));
        this._initialized = true;
    }

    private void populateSummary(TraversableContext ctx) {
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this._tree.getModel().getRoot();
        this._destinationNode.removeAllChildren();
        this._destinationNode.add(new DefaultMutableTreeNode(Resource.format("IMPORT_UI_SUMMARY_REPOS_URL", URLFileSystem.getPlatformPathName((URL)((URL)ctx.get("dest_url"))))));
        root.add(this._destinationNode);
        this._sourceNode.removeAllChildren();
        this._sourceNode.add(new DefaultMutableTreeNode(Resource.format("IMPORT_UI_SUMMARY_SOURCE_URL", URLFileSystem.getPlatformPathName((URL)((URL)ctx.get("source_url"))))));
        root.add(this._sourceNode);
        this._filtersNode.removeAllChildren();
        Collection filters = (Collection)ctx.get("filters");
        if (filters != null && !filters.isEmpty()) {
            this._filtersNode.add(new DefaultMutableTreeNode(Resource.format("IMPORT_UI_SUMMARY_FILTERS", String.valueOf(filters.size()))));
        } else {
            this._filtersNode.add(new DefaultMutableTreeNode(Resource.get("IMPORT_UI_SUMMARY_NO_FILTERS")));
        }
        root.add(this._filtersNode);
    }
}

