/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.File;
import java.net.URL;
import java.util.logging.Level;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.jdeveloper.history.HistoryEntrySelector;
import oracle.jdeveloper.vcs.generic.VCSProfile;
import oracle.jdeveloper.vcs.spi.VCSStatus;
import oracle.jdeveloper.vcs.spi.VCSStatusFilter;
import oracle.jdevimpl.vcs.git.GITAbstractCompareOperation;
import oracle.jdevimpl.vcs.git.GITClientAdaptor;
import oracle.jdevimpl.vcs.git.GITCommandProgressMonitor;
import oracle.jdevimpl.vcs.git.GITProcessException;
import oracle.jdevimpl.vcs.git.GITProfile;
import oracle.jdevimpl.vcs.git.res.Resource;
import org.netbeans.libs.git.GitClient;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.SearchCriteria;
import org.netbeans.libs.git.progress.ProgressMonitor;

public class GITOperationComparePrevious
extends GITAbstractCompareOperation {
    public GITOperationComparePrevious() {
        super("oracle.jdeveloper.git.compareprevious");
    }

    protected Object getContextRevision(VCSProfile profile, Locatable locatable) throws Exception {
        VCSStatusFilter pending = profile.getStatusFilter("filters.status.historied-pending");
        VCSStatus stat = (VCSStatus)profile.getPolicyStatusCache().get(locatable.getURL());
        GitRevisionInfo[] rev = this.getRevision(locatable.getURL());
        Node node = NodeFactory.find((URL)locatable.getURL());
        if ((node != null && node.isDirty() || pending.accept(stat)) && rev.length > 0) {
            return rev[0].getRevision();
        }
        if (rev.length > 1) {
            return rev[1].getRevision();
        }
        return rev[0].getRevision();
    }

    protected HistoryEntrySelector getHistoryEntrySelector(VCSProfile profile, Locatable source, Object revision) throws Exception {
        return revision != null ? new HistoryEntrySelector((String)revision) : null;
    }

    private GitRevisionInfo[] getRevision(URL url) throws GITProcessException {
        GitRevisionInfo[] rev;
        GitClient client = null;
        try {
            client = GITClientAdaptor.getClient(url);
            GITCommandProgressMonitor monitor = new GITCommandProgressMonitor("log");
            SearchCriteria cr = new SearchCriteria();
            File[] files = new File[]{new File(url.getPath())};
            cr.setFiles(files);
            cr.setLimit(2);
            rev = client.log(cr, (ProgressMonitor)monitor);
        }
        catch (GitException ge) {
            GITProfile.getQualifiedLogger(GITOperationComparePrevious.class.getName()).log(Level.SEVERE, ge.getMessage());
            throw new GITProcessException(Resource.get("PROCESS_EXCEPTION_COMPARE_PREV_ERROR"));
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return rev;
    }
}

