/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.vcs.git;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.UnknownServiceException;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystemHelper;
import oracle.jdevimpl.vcs.git.GITVersionURL;

public class GITNavURLFileSystemHelper
extends URLFileSystemHelper {
    public static final String GIT_NAV_PROTOCOL = "ide.scm.git.nav";
    public static final String FILE_PROTOCOL = "file";

    public static boolean isNavigatorURL(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().equals(GIT_NAV_PROTOCOL);
    }

    public static URL toNavigatorURL(URL url) {
        if (!url.getProtocol().equals(GIT_NAV_PROTOCOL)) {
            return URLFactory.newURL((String)GIT_NAV_PROTOCOL, (String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)url.getQuery(), (String)url.getRef());
        }
        return url;
    }

    public static URL fromNavigatorURL(URL url) {
        if (url != null && url.getProtocol().equals(GIT_NAV_PROTOCOL)) {
            return URLFactory.newURL((String)FILE_PROTOCOL, (String)url.getUserInfo(), (String)url.getHost(), (int)url.getPort(), (String)url.getPath(), (String)url.getQuery(), (String)url.getRef());
        }
        return url;
    }

    public String getPlatformPathName(URL url) {
        return new GITVersionURL(url).getPath();
    }

    public String toDisplayString(URL url) {
        GITVersionURL versionUrl = new GITVersionURL(url);
        return versionUrl.getPath() + ": " + versionUrl.getVersion();
    }

    public boolean canWrite(URL url) {
        return false;
    }

    public boolean isReadOnly(URL url) {
        return true;
    }

    public boolean exists(URL url) {
        return false;
    }

    public InputStream openInputStream(URL url) throws IOException {
        throw new UnknownServiceException("Failed to open " + url.toString());
    }
}

