/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2.layouts;

import java.awt.Dimension;
import java.text.MessageFormat;
import javax.swing.JLabel;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.ideimpl.palette2.layouts.IconLayout;

public class IconLayoutWithBottomLabels
extends IconLayout {
    private static final String SIMPLE_FMT = "{0}";
    private static final String NAME_ONLY_FMT = "<html><center>{0}</center></html>";
    private static final String NAME_AND_PAGE_FMT = "<html><center>{0}<br>({1})</center></html>";
    private static final Dimension BASE_SIZE = new Dimension(72, 40);

    @Override
    public void configurePaletteItemUI(PaletteItemUI itemUI) {
        JLabel label;
        String text;
        String name = itemUI.getItemName();
        String pageName = itemUI.getPageName();
        String formatText = SIMPLE_FMT;
        if (name.split("\\s").length > 1) {
            formatText = NAME_ONLY_FMT;
        }
        if (pageName != null && pageName.length() > 0) {
            formatText = NAME_AND_PAGE_FMT;
        }
        if (!(text = MessageFormat.format(formatText, name, pageName)).equals((label = itemUI.getGUI()).getText())) {
            label.setText(text);
        }
        if (0 != label.getHorizontalTextPosition()) {
            label.setHorizontalTextPosition(0);
        }
        if (3 != label.getVerticalTextPosition()) {
            label.setVerticalTextPosition(3);
        }
        if (0 != label.getHorizontalAlignment()) {
            label.setHorizontalAlignment(0);
        }
        if (1 != label.getVerticalAlignment()) {
            label.setVerticalAlignment(1);
        }
        label.setPreferredSize(BASE_SIZE);
    }
}

