/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.palette2;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PopupMenu;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.palette2.PaletteItem;
import oracle.ide.palette2.PaletteManager;
import oracle.ide.palette2.PaletteSection;
import oracle.ide.palette2.PaletteWindow;
import oracle.ide.palette2.layouts.PaletteLayout;
import oracle.ideimpl.palette2.PaletteControllerUI;
import oracle.ideimpl.palette2.PaletteGroupUI;
import oracle.ideimpl.palette2.PaletteItemUI;
import oracle.javatools.ui.themes.Painter;
import oracle.javatools.ui.themes.ThemeProperties;
import oracle.javatools.ui.themes.Themes;
import oracle.javatools.util.Disposable;

public class PaletteSectionUI
implements Disposable {
    private PaletteSection paletteSection;
    private PaletteGroupUI paletteGroupUI;
    private JPanel midPanel;
    private String showState;
    private SectionSeparator sectionSeparator = null;
    private List<PaletteItemUI> itemUI = new ArrayList<PaletteItemUI>();
    private Boolean canUseLargeIcons;

    public PaletteSectionUI(JPanel midPanel, String showState, PaletteSection section, PaletteGroupUI groupUI) {
        this.paletteSection = section;
        this.paletteGroupUI = groupUI;
        this.midPanel = midPanel;
        this.setShowState(showState);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
    }

    protected void jbInit() throws Exception {
        String name;
        PaletteSection section = this.getPaletteSection();
        String string = name = null != section ? section.getName() : null;
        if (name != null && name.length() > 0) {
            this.sectionSeparator = new SectionSeparator(name, this, this.showState);
            this.getContainer().add(this.sectionSeparator);
        }
        this.initItems();
    }

    protected JPanel getContainer() {
        return this.midPanel;
    }

    protected void initItems() {
        PaletteSection section = this.getPaletteSection();
        if (null == section) {
            return;
        }
        Collection<PaletteItem> paletteItems = section.getItems();
        this.itemUI.clear();
        for (PaletteItem paletteItem : paletteItems) {
            this.addPaletteItem(paletteItem, null, null);
        }
    }

    protected void addPaletteItem(PaletteItem paletteItem, String pageName, String groupName) {
        PaletteItemUI item = new PaletteItemUI(paletteItem, this, this.showState, pageName, groupName);
        this.itemUI.add(item);
        this.midPanel.add(item);
    }

    public PaletteGroupUI getPaletteGroupUI() {
        return this.paletteGroupUI;
    }

    public PaletteSection getPaletteSection() {
        return this.paletteSection;
    }

    public void setShowState(String showState) {
        this.showState = showState;
        for (PaletteItemUI item : this.itemUI) {
            item.setShowState(showState);
        }
    }

    public void showAsUnselected() {
        for (PaletteItemUI item : this.itemUI) {
            item.showAsUnselected();
        }
    }

    public PaletteItemUI getItemWithFocus() {
        for (PaletteItemUI item : this.itemUI) {
            if (!item.hasFocus()) continue;
            return item;
        }
        return null;
    }

    public List<PaletteItemUI> getPaletteItems() {
        return this.itemUI;
    }

    public Component getSeparator() {
        return this.sectionSeparator;
    }

    public void setUseLargeIcons(boolean useLargeIcons) {
        boolean useLargeIcon = useLargeIcons;
        if (useLargeIcons) {
            useLargeIcon = this.canUseLargeIcons();
        }
        for (PaletteItemUI item : this.getPaletteItems()) {
            item.setUseLargeIcon(useLargeIcon);
        }
        this.midPanel.repaint();
    }

    public boolean getUseLargeIcons() {
        boolean useLargeIcons;
        PaletteWindow window = PaletteManager.getPaletteManager().getPaletteWindow();
        boolean bl = useLargeIcons = null != window ? window.getUseLargeIcons() : true;
        if (!useLargeIcons) {
            return false;
        }
        return this.canUseLargeIcons();
    }

    private boolean canUseLargeIcons() {
        if (null != this.canUseLargeIcons) {
            return this.canUseLargeIcons;
        }
        PaletteSection section = this.getPaletteSection();
        if (null == section) {
            return false;
        }
        for (PaletteItem item : section.getItems()) {
            if (null != item.getLargeIcon()) continue;
            this.canUseLargeIcons = Boolean.FALSE;
            return this.canUseLargeIcons;
        }
        this.canUseLargeIcons = Boolean.TRUE;
        return this.canUseLargeIcons;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + ": " + (null != this.getPaletteSection() ? this.getPaletteSection().getName() : "<null>");
    }

    public void dispose() {
        this.midPanel.removeAll();
        for (PaletteItemUI itemUI : this.itemUI) {
            itemUI.dispose();
        }
        this.itemUI.clear();
    }

    class SectionSeparator
    extends JLabel
    implements MouseListener {
        private static final float HEIGHT_FACTOR = 1.2f;
        private static final float WIDTH_FACTOR = 1.5f;
        private static final int OFFSET = 5;
        private static final String SEPARATOR = "palettesectionseparator";
        private static final String ENABLED = "enabled";
        private PaletteSectionUI sectionUI;
        private PaletteControllerUI paletteController;
        private boolean _tryPopupInMousePressed;
        private String showState;
        private Border defaultBorder;

        public SectionSeparator() {
            this.paletteController = PaletteControllerUI.getInstance();
            this._tryPopupInMousePressed = false;
            this.putClientProperty(PaletteLayout.PALETTE_SECTION_UI_KEY, PaletteSectionUI.this);
        }

        public SectionSeparator(String text, PaletteSectionUI sectionUI, String showState) {
            super(text);
            this.paletteController = PaletteControllerUI.getInstance();
            this._tryPopupInMousePressed = false;
            this.putClientProperty(PaletteLayout.PALETTE_SECTION_UI_KEY, PaletteSectionUI.this);
            this.sectionUI = sectionUI;
            this.showState = showState;
            this.setVerticalTextPosition(1);
            this.setHorizontalAlignment(2);
            this.addMouseListener(this);
            this.setFocusable(false);
        }

        public PaletteSectionUI getSectionUI() {
            return this.sectionUI;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        public void setShowState(String showState) {
            this.showState = showState;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            Dimension d = this.getSize();
            int y = d.height / 2;
            Color lineColor = this.getLineColor();
            g.setColor(lineColor);
            g.drawLine(1, y, d.width - 1, y);
            String text = this.getText();
            if (text.length() == 0) {
                return;
            }
            g.setFont(this.getFont());
            FontMetrics fm = g.getFontMetrics();
            y = (d.height + fm.getAscent()) / 2;
            int w = fm.stringWidth(text);
            if (Themes.isThemed()) {
                Painter painter = Themes.getActiveTheme().getStateProperties(SEPARATOR, "default").getPainter("bg");
                painter.paint(g, 0, 0, w + 10, d.height);
            } else {
                g.setColor(this.getBackground());
                g.fillRect(0, 0, w + 10, d.height);
            }
            g.setColor(this.getForeground());
            g.drawString(text, 5, y);
        }

        private void tryPopup(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.paletteController.tryPopup(e);
            }
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            PaletteItemUI pI = this.paletteController.getSelectedItemUI();
            if (pI != null) {
                this.paletteController.setSelectedWindowUI((PaletteItemUI)null);
            } else {
                PaletteSectionUI pS = this.paletteController.getSelectedSectionUI();
                if (pS != null && pS != this.sectionUI) {
                    this.paletteController.setSelectedWindowUI((PaletteSectionUI)null);
                }
            }
            boolean bl = this._tryPopupInMousePressed = e.isPopupTrigger();
            if (this._tryPopupInMousePressed) {
                this.paletteController.unSelectSelectedItem(true);
                this.paletteController.setSelectedWindowUI(this.sectionUI);
                this.tryPopup(e);
            }
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            if (!this._tryPopupInMousePressed) {
                if (e.isPopupTrigger()) {
                    this.paletteController.setSelectedWindowUI(this.sectionUI);
                    this.tryPopup(e);
                } else {
                    this.paletteController.setSelectedWindowUI(this.sectionUI);
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public synchronized void add(PopupMenu popup) {
            super.add(popup);
        }

        @Override
        public Color getBackground() {
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties(SEPARATOR, ENABLED);
                return properties.getColor("background");
            }
            return super.getBackground();
        }

        @Override
        public Color getForeground() {
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties(SEPARATOR, ENABLED);
                return properties.getColor("foreground");
            }
            return super.getForeground();
        }

        private Color getLineColor() {
            if (Themes.isThemed()) {
                ThemeProperties properties = Themes.getActiveTheme().getStateProperties(SEPARATOR, "line");
                return properties.getColor("foreground");
            }
            return this.getForeground();
        }
    }
}

