/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.util.ArrayList;
import oracle.spatial.geometry.Chain;
import oracle.spatial.geometry.JPoint2DD;
import oracle.spatial.geometry.SkipListData;

final class PSSegment {
    private static final boolean DEBUG = false;
    SkipListData node;
    SegType type;
    JPoint2DD farLeft;
    JPoint2DD left;
    JPoint2DD right;
    JPoint2DD farRight;
    JPoint2DD center;
    double radius;
    boolean CUW;
    MonotoneUpdater updater;
    final int polyId;
    final int downDiff;
    int insidedness;
    Chain c;
    ArrayList<Chain> holes;

    PSSegment(int n, int n2) {
        this.polyId = n;
        this.downDiff = n2;
        this.type = SegType.DUMMY;
    }

    PSSegment(int n, int n2, MonotoneUpdater monotoneUpdater) {
        this.polyId = n;
        this.downDiff = n2;
        this.updater = monotoneUpdater;
        if (!monotoneUpdater.nextSegment(this)) {
            throw new IllegalArgumentException();
        }
    }

    void setLinearValues(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        this.type = SegType.LINEAR;
        this.farLeft = jPoint2DD;
        this.left = jPoint2DD;
        this.right = jPoint2DD2;
        this.farRight = jPoint2DD2;
    }

    void setArcValues(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, JPoint2DD jPoint2DD3, double d, boolean bl) {
        this.type = SegType.ARC;
        this.farLeft = jPoint2DD;
        this.left = jPoint2DD;
        this.right = jPoint2DD2;
        this.farRight = jPoint2DD2;
        this.center = jPoint2DD3;
        this.radius = d;
        this.CUW = bl;
    }

    void swap(PSSegment pSSegment) {
        SkipListData skipListData = this.node;
        this.node = pSSegment.node;
        pSSegment.node = skipListData;
        pSSegment.node.payload = pSSegment;
        this.node.payload = this;
    }

    PSSegment next() {
        if (this.node.forward[0] == null) {
            return null;
        }
        return this.node.forward[0].payload;
    }

    PSSegment prev() {
        if (this.node.back == null) {
            return null;
        }
        return this.node.back.payload;
    }

    public static final int compare(JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2) {
        if (jPoint2DD.x < jPoint2DD2.x) {
            return -1;
        }
        if (jPoint2DD.x > jPoint2DD2.x) {
            return 1;
        }
        if (jPoint2DD.y < jPoint2DD2.y) {
            return -1;
        }
        if (jPoint2DD.y > jPoint2DD2.y) {
            return 1;
        }
        return 0;
    }

    public int compareTo(PSSegment pSSegment) {
        double d;
        double d2 = Math.max(this.left.x, pSSegment.left.x);
        if (d2 > (d = Math.min(this.right.x, pSSegment.right.x))) {
            d = d2 = (d2 + d) / 2.0;
        } else if (this.type == SegType.ARC && pSSegment.type == SegType.ARC && this.center.equals(pSSegment.center) && this.radius == pSSegment.radius && this.CUW == pSSegment.CUW) {
            return 0;
        }
        int n = Double.compare(this.yAt(d2, 0.0), pSSegment.yAt(d2, 0.0));
        if (n != 0) {
            return n;
        }
        double d3 = (d2 + d) / 2.0;
        n = Double.compare(this.yAt(d3, 0.5), pSSegment.yAt(d3, 0.5));
        if (n != 0) {
            return n;
        }
        n = Double.compare(this.yAt(d, 1.0), pSSegment.yAt(d, 1.0));
        if (n != 0) {
            return n;
        }
        return 0;
    }

    public int compareTo(PSSegment pSSegment, JPoint2DD jPoint2DD) {
        double d;
        double d2 = Math.max(this.left.getX(), pSSegment.left.getX());
        if (d2 > (d = Math.min(this.right.getX(), pSSegment.right.getX()))) {
            d = d2 = (d2 + d) / 2.0;
        } else if (this.type == SegType.ARC && pSSegment.type == SegType.ARC && this.center.equals(pSSegment.center) && this.radius == pSSegment.radius && this.CUW == pSSegment.CUW) {
            return 0;
        }
        double d3 = d2;
        int n = Double.compare(this.yAt(d2, 0.0), pSSegment.yAt(d2, 0.0));
        boolean bl = this.left.x == this.right.x && this.left.y != this.right.y || pSSegment.left.x == pSSegment.right.x && pSSegment.left.y != pSSegment.right.y;
        if (d2 >= d && !bl) {
            return n;
        }
        double d4 = d;
        int n2 = Double.compare(this.yAt(d, 1.0), pSSegment.yAt(d, 1.0));
        int n3 = 0;
        double d5 = Double.NaN;
        if (n * n2 >= 0 && (this.type == SegType.ARC || pSSegment.type == SegType.ARC)) {
            d5 = PSSegment.arcTestLocation(this, pSSegment, d2, d);
            if (d5 > d2 && d5 < d) {
                n3 = Double.compare(this.yAt(d5, 0.5), pSSegment.yAt(d5, 0.5));
            }
            if (n3 == 0) {
                d5 = (d2 + d) / 2.0;
                n3 = Double.compare(this.yAt(d5, 0.5), pSSegment.yAt(d5, 0.5));
            }
        }
        if (n == 0) {
            n = n3;
            d3 = d5;
            if (n == 0) {
                n = n2;
                d3 = d4;
            }
        } else if (n2 == 0) {
            n2 = n3;
            d4 = d5;
        }
        if (n * n3 < 0) {
            n2 = n3;
            d4 = d5;
        }
        if (n * n2 >= 0) {
            return n;
        }
        if (jPoint2DD == null) {
            return 2 * n;
        }
        double d6 = 0.0;
        double d7 = 1.0;
        double d8 = 0.5;
        double d9 = (1.0 - d8) * d3 + d8 * d4;
        double d10 = d4;
        while (d8 > d6 && d8 < d7) {
            int n4 = Double.compare(this.yAt(d9, d8), pSSegment.yAt(d9, d8));
            if (n4 == -n) {
                d7 = d8;
                d10 = d9;
            } else {
                d6 = d8;
            }
            d8 = (d6 + d7) / 2.0;
            d9 = (1.0 - d8) * d3 + d8 * d4;
        }
        jPoint2DD.x = d10;
        jPoint2DD.y = (this.yAt(d10, d8) + pSSegment.yAt(d10, d8)) / 2.0;
        if (jPoint2DD.x - d2 < d - jPoint2DD.x) {
            return 2 * n2;
        }
        return 2 * n;
    }

    final boolean validateYside(double d) {
        if (d == this.center.y) {
            return true;
        }
        return d > this.center.y ^ this.CUW;
    }

    static double arcTestLocation(PSSegment pSSegment, PSSegment pSSegment2, double d, double d2) {
        double d3;
        double d4;
        double d5;
        PSSegment pSSegment3 = pSSegment;
        PSSegment pSSegment4 = pSSegment2;
        if (pSSegment3.type != SegType.ARC) {
            pSSegment3 = pSSegment2;
            pSSegment4 = pSSegment;
        }
        if (pSSegment4.type == SegType.ARC) {
            d5 = pSSegment4.center.x - pSSegment3.center.x;
            d4 = pSSegment4.center.y - pSSegment3.center.y;
        } else {
            d5 = pSSegment4.farRight.y - pSSegment4.farLeft.y;
            d4 = -(pSSegment4.farRight.x - pSSegment4.farLeft.x);
        }
        if (d5 == 0.0 && d4 == 0.0) {
            return d;
        }
        double d6 = Math.sqrt(d5 * d5 + d4 * d4);
        d5 /= d6;
        d4 /= d6;
        double d7 = d;
        if (d4 <= 0.0 && pSSegment3.CUW || d4 >= 0.0 && !pSSegment3.CUW) {
            d7 = pSSegment3.center.x + d5 * pSSegment3.radius;
            d3 = pSSegment3.center.y + d4 * pSSegment3.radius;
            if (d7 > d && d7 < d2) {
                return d7;
            }
        }
        if (-d4 <= 0.0 && pSSegment3.CUW || -d4 >= 0.0 && !pSSegment3.CUW) {
            d7 = pSSegment3.center.x - d5 * pSSegment3.radius;
            d3 = pSSegment3.center.y - d4 * pSSegment3.radius;
            if (d7 > d && d7 < d2) {
                return d7;
            }
        }
        if (pSSegment4.type == SegType.ARC) {
            if (d4 <= 0.0 && pSSegment4.CUW || d4 >= 0.0 && !pSSegment4.CUW) {
                d7 = pSSegment4.center.x + d5 * pSSegment4.radius;
                d3 = pSSegment4.center.y + d4 * pSSegment4.radius;
                if (d7 > d && d7 < d2) {
                    return d7;
                }
            }
            if (-d4 <= 0.0 && pSSegment4.CUW || -d4 >= 0.0 && !pSSegment4.CUW) {
                d7 = pSSegment4.center.x - d5 * pSSegment4.radius;
                d3 = pSSegment4.center.y - d4 * pSSegment4.radius;
                if (d7 > d && d7 < d2) {
                    return d7;
                }
            }
        }
        return d7;
    }

    public double yAt(double d, double d2) {
        if (this.type == SegType.LINEAR) {
            if (this.left.x == this.right.x) {
                double d3 = d2;
                return d3 * (this.right.y - this.left.y) + this.left.y;
            }
            if (d <= this.left.x) {
                return this.left.y;
            }
            if (d >= this.right.x) {
                return this.right.y;
            }
            double d4 = (d - this.farLeft.x) / (this.farRight.x - this.farLeft.x);
            return d4 * (this.farRight.y - this.farLeft.y) + this.farLeft.y;
        }
        if (d <= this.left.x) {
            return this.left.y;
        }
        if (d >= this.right.x) {
            return this.right.y;
        }
        if (d <= this.center.x - this.radius || d >= this.center.x + this.radius) {
            return this.center.y;
        }
        double d5 = Math.sqrt(this.radius * this.radius - (d - this.center.x) * (d - this.center.x));
        if (this.CUW) {
            return this.center.y - d5;
        }
        return this.center.y + d5;
    }

    public String IdString() {
        return this.polyId + (this.downDiff > 0 ? "^" : "V") + "  " + (Object)((Object)this.type);
    }

    public String toString() {
        return this.IdString() + ": (" + this.left + ")..(" + this.right + ")" + (this.type == SegType.ARC ? "[" + this.center + ", " + this.radius + "] " + (this.CUW ? "CUW" : "CDN") : "") + " =>" + this.c;
    }

    static interface MonotoneUpdater {
        public boolean nextSegment(PSSegment var1);
    }

    static enum SegType {
        ARC,
        LINEAR,
        DUMMY;

    }
}

