/*
 * Decompiled with CFR 0.152.
 */
package oracle.spatial.geometry;

import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Struct;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.jdbc.OracleArray;
import oracle.jdbc.OracleConnection;
import oracle.spatial.geometry.BufGeom;
import oracle.spatial.geometry.Buffer;
import oracle.spatial.geometry.Chain;
import oracle.spatial.geometry.DataException;
import oracle.spatial.geometry.ElementExtractor;
import oracle.spatial.geometry.J3D_Geometry;
import oracle.spatial.geometry.JPoint2DD;
import oracle.spatial.geometry.PSSegment;
import oracle.spatial.geometry.SdoPickler;
import oracle.spatial.util.SDODoubleGeneralPath;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.Datum;
import oracle.sql.NUMBER;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class JGeometry
implements Cloneable,
Serializable {
    static final long serialVersionUID = -4792272186565640701L;
    public static final int GTYPE_POINT = 1;
    public static final int GTYPE_CURVE = 2;
    public static final int GTYPE_POLYGON = 3;
    public static final int GTYPE_COLLECTION = 4;
    public static final int GTYPE_MULTIPOINT = 5;
    public static final int GTYPE_MULTICURVE = 6;
    public static final int GTYPE_MULTIPOLYGON = 7;
    protected static final int ETYPE_UNKNOWN = 0;
    protected static final int ETYPE_POINT = 1;
    protected static final int ETYPE_CURVE = 2;
    protected static final int ETYPE_RING = 3;
    protected static final int ETYPE_COMPOUNDCURVE = 4;
    protected static final int ETYPE_COMPOUNDRING = 5;
    protected static final int EITPR_UNKNOWN = 0;
    protected static final int EITPR_LINEAR = 1;
    protected static final int EITPR_ARC = 2;
    protected static final int EITPR_NURBSCURVE = 3;
    protected static final int EITPR_RECTANGLE = 3;
    protected static final int EITPR_GEODETICMBR = 3;
    protected static final int EITPR_CIRCLE = 4;
    protected static final int ETOPO_NA = 0;
    protected static final int ETOPO_UNKNOWN = 0;
    protected static final int ETOPO_EXTERIOR = 1;
    protected static final int ETOPO_INTERIOR = 2;
    protected static StructDescriptor geomDesc = null;
    protected static StructDescriptor pointDesc = null;
    protected static ArrayDescriptor elemInfoDesc = null;
    protected static ArrayDescriptor ordinatesDesc = null;
    protected static String geomDescStr = null;
    protected static String pointDescStr = null;
    protected static String elemInfoDescStr = null;
    protected static String ordinatesDescStr = null;
    protected int gtype = 0;
    protected int linfo = 0;
    protected int srid = 0;
    protected double x = Double.NaN;
    protected double y = Double.NaN;
    protected double z = Double.NaN;
    protected int[] elemInfo = null;
    protected double[] ordinates = null;
    protected double[] mbr = null;
    protected int dim = 2;
    protected LT_transform lttpH;
    protected Gc_trans gtransH;
    private static final double TORAD = Math.PI / 180;
    private static final double TODEGREE = 57.29577951308232;
    private static final double EARTHRAD = 6371007.0;
    private static final int NURBS_NUM_OF_POINTS_TO_EVAL = 200;
    private static final boolean DEBUG_BUFFER = false;
    private static final double SMALLEST_ARC_ANGLE = Math.PI / 90;
    private static final double MERCATOR_mdFE = 0.0;
    private static final double MERCATOR_mdFN = 0.0;
    private static final double MERCATOR_a = 6378137.0;
    private static final double MERCATOR_k0 = 1.0;
    private static final double MERCATOR_lon0 = 0.0;
    private static final double MERCATOR_f3785 = 0.0;
    private static final double MERCATOR_f54004 = 0.0033528106647474805;
    private static final double MERCATOR_e3785 = Math.sqrt(0.0);
    private static final double MERCATOR_e54004 = Math.sqrt(0.0066943799901413165);
    private static final double MERCATOR_B = Math.exp(1.0);

    private boolean lltogXYZ(double[] dArray, Gc_trans gc_trans) {
        dArray[0] = dArray[0] * gc_trans.unitfactor;
        dArray[1] = dArray[1] * gc_trans.unitfactor;
        double d = Math.cos(dArray[1]);
        double d2 = Math.sin(dArray[1]);
        double d3 = Math.cos(dArray[0]);
        double d4 = Math.sin(dArray[0]);
        double d5 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d2 * d2);
        dArray[0] = d * d3 * (d5 + dArray[2]);
        dArray[1] = d * d4 * (d5 + dArray[2]);
        dArray[2] = d2 * ((1.0 - gc_trans.esq) * d5 + dArray[2]);
        return true;
    }

    private boolean gXYZtoll(double[] dArray, Gc_trans gc_trans) {
        double d;
        double d2;
        double d3 = dArray[0] * dArray[0] + dArray[1] * dArray[1];
        double d4 = (1.0 + gc_trans.esq) * dArray[2];
        double d5 = d4 / Math.sqrt(d3 + d4 * d4);
        while (Math.abs((d5 = (d4 = dArray[2] + (d2 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * (d = d5) * d)) * gc_trans.esq * d) / Math.sqrt(d3 + d4 * d4)) - d) > 1.0E-15) {
        }
        d2 = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d5 * d5);
        d4 = dArray[2] + d2 * gc_trans.esq * d5;
        dArray[0] = Math.atan2(dArray[1], dArray[0]);
        dArray[1] = Math.asin(d5);
        dArray[2] = Math.sqrt(d3 + d4 * d4) - d2;
        return true;
    }

    private boolean gxyzgmcenter(double[] dArray, double[] dArray2, Gc_trans gc_trans) {
        for (int i = 0; i < 3; ++i) {
            dArray[i] = (dArray2[i] + dArray2[i + 3]) / 2.0;
        }
        double d = gc_trans.radius / Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        for (int i = 0; i < 3; ++i) {
            dArray[i] = dArray[i] * d;
        }
        return this.gXYZtoll(dArray, gc_trans);
    }

    private boolean ltxform(double[] dArray, LT_transform lT_transform) {
        double d = dArray[0] - lT_transform.xc;
        double d2 = dArray[1] - lT_transform.yc;
        double d3 = dArray[2] - lT_transform.zc;
        dArray[0] = lT_transform.xrow[0] * d + lT_transform.xrow[1] * d2 + lT_transform.xrow[2] * d3;
        dArray[1] = lT_transform.yrow[0] * d + lT_transform.yrow[1] * d2 + lT_transform.yrow[2] * d3;
        dArray[2] = 0.0;
        return true;
    }

    private boolean iltxform(double[] dArray, LT_transform lT_transform, Gc_trans gc_trans) {
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = 0.0;
        d3 = Math.sqrt(gc_trans.radius * gc_trans.radius - d * d - d2 * d2) - gc_trans.radius;
        dArray[0] = lT_transform.xrow[0] * d + lT_transform.yrow[0] * d2 + lT_transform.zrow[0] * d3 + lT_transform.xc;
        dArray[1] = lT_transform.xrow[1] * d + lT_transform.yrow[1] * d2 + lT_transform.zrow[1] * d3 + lT_transform.yc;
        dArray[2] = lT_transform.xrow[2] * d + lT_transform.yrow[2] * d2 + lT_transform.zrow[2] * d3 + lT_transform.zc;
        return true;
    }

    protected JGeometry(int n, int n2) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        this.dim = n / 1000 > 0 ? n / 1000 : 2;
        this.srid = n2 <= 0 ? 0 : n2;
    }

    public JGeometry(int n, int n2, double d, double d2, double d3, int[] nArray, double[] dArray) {
        this(n, n2);
        this.x = d;
        this.y = d2;
        this.z = d3;
        if (nArray == null || dArray == null) {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        } else if (JGeometry.etype0_exists(nArray) && !JGeometry.ordOffset0_exists(nArray)) {
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            JGeometry.remove_etype0(nArray, dArray, arrayList, arrayList2);
            int[] nArray2 = new int[arrayList.size()];
            double[] dArray2 = new double[arrayList2.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                nArray2[n3] = (Integer)arrayList.get(n3);
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                dArray2[n3] = (Double)arrayList2.get(n3);
            }
            this.elemInfo = nArray2;
            this.ordinates = dArray2;
        } else {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        }
    }

    public JGeometry(int n, int n2, int[] nArray, double[] dArray) {
        this(n, n2);
        if (nArray == null || dArray == null) {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        } else if (JGeometry.etype0_exists(nArray) && !JGeometry.ordOffset0_exists(nArray)) {
            int n3;
            ArrayList arrayList = new ArrayList();
            ArrayList arrayList2 = new ArrayList();
            JGeometry.remove_etype0(nArray, dArray, arrayList, arrayList2);
            int[] nArray2 = new int[arrayList.size()];
            double[] dArray2 = new double[arrayList2.size()];
            for (n3 = 0; n3 < arrayList.size(); ++n3) {
                nArray2[n3] = (Integer)arrayList.get(n3);
            }
            for (n3 = 0; n3 < arrayList2.size(); ++n3) {
                dArray2[n3] = (Double)arrayList2.get(n3);
            }
            this.elemInfo = nArray2;
            this.ordinates = dArray2;
        } else {
            this.elemInfo = nArray;
            this.ordinates = dArray;
        }
    }

    public JGeometry(double d, double d2, int n) {
        this(1, n);
        this.x = d;
        this.y = d2;
    }

    public JGeometry(double d, double d2, double d3, int n) {
        this(3001, n);
        this.x = d;
        this.y = d2;
        this.z = d3;
    }

    public JGeometry(double d, double d2, double d3, double d4, int n) {
        this(3, n);
        this.elemInfo = new int[3];
        this.elemInfo[0] = 1;
        this.elemInfo[1] = 1003;
        this.elemInfo[2] = 3;
        this.ordinates = new double[4];
        this.ordinates[0] = d;
        this.ordinates[1] = d2;
        this.ordinates[2] = d3;
        this.ordinates[3] = d4;
    }

    public Object clone() {
        try {
            JGeometry jGeometry = (JGeometry)super.clone();
            if (this.elemInfo != null) {
                jGeometry.elemInfo = new int[this.elemInfo.length];
                System.arraycopy(this.elemInfo, 0, jGeometry.elemInfo, 0, this.elemInfo.length);
            }
            if (this.ordinates != null) {
                jGeometry.ordinates = new double[this.ordinates.length];
                System.arraycopy(this.ordinates, 0, jGeometry.ordinates, 0, this.ordinates.length);
            }
            if (this.mbr != null) {
                jGeometry.mbr = new double[this.mbr.length];
                System.arraycopy(this.mbr, 0, jGeometry.mbr, 0, this.mbr.length);
            }
            return jGeometry;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public static JGeometry createPoint(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(1, n2);
        jGeometry.dim = dArray.length;
        jGeometry.x = dArray[0];
        jGeometry.y = dArray[1];
        if (n == 3) {
            jGeometry.z = dArray[2];
        }
        return jGeometry;
    }

    public static JGeometry createLRSPoint(double[] dArray, int n, int n2) {
        try {
            if (n == 2 && dArray.length == 3) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(3301, n2, nArray, dArray);
                return jGeometry;
            }
            if (n == 3 && dArray.length == 4) {
                int[] nArray = new int[]{1, 1, 1};
                JGeometry jGeometry = new JGeometry(4401, n2, nArray, dArray);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Point type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createCircle(double d, double d2, double d3, int n) {
        return JGeometry.createCircle(d + d3 * Math.cos(0.7853981633974483), d2 + d3 * Math.sin(0.7853981633974483), d + d3 * Math.cos(2.356194490192345), d2 + d3 * Math.sin(2.356194490192345), d + d3 * Math.cos(4.71238898038469), d2 + d3 * Math.sin(4.71238898038469), n);
    }

    public static JGeometry createCircle(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        if (JGeometry.orientation(d, d2, d3, d4, d5, d6) == 0.0) {
            return null;
        }
        JGeometry jGeometry = new JGeometry(3, n);
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 4;
        jGeometry.ordinates = new double[6];
        jGeometry.ordinates[0] = d;
        jGeometry.ordinates[1] = d2;
        jGeometry.ordinates[2] = d3;
        jGeometry.ordinates[3] = d4;
        jGeometry.ordinates[4] = d5;
        jGeometry.ordinates[5] = d6;
        return jGeometry;
    }

    public static JGeometry createArc2d(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 2;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLinearLineString(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createNURBScurve(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(2, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 2;
        jGeometry.elemInfo[2] = 3;
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearLineString(double[] dArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 3, n2);
                jGeometry.setType(3302);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearLineString(dArray, 4, n2);
                jGeometry.setType(4402);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Line type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLinearMultiLineString(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createLinearLineString((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(6, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        int n4 = 1;
        jGeometry.elemInfo = new int[n3 * 3];
        for (int i = 0; i < n3; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n4;
            jGeometry.elemInfo[i * 3 + 1] = 2;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n4 += ((double[])objectArray[i]).length;
        }
        double[] dArray = new double[n4 - 1];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearMultiLineString(Object[] objectArray, int n, int n2) {
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 3, n2);
                jGeometry.setType(3306);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearMultiLineString(objectArray, 4, n2);
                jGeometry.setType(4406);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS MultiLine type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createMultiPoint(Object[] objectArray, int n, int n2) {
        if (objectArray.length == 1) {
            return JGeometry.createPoint((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(5, n2);
        jGeometry.dim = n;
        int n3 = objectArray.length;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1;
        jGeometry.elemInfo[2] = n3;
        double[] dArray = new double[n3 * n];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            double[] dArray2 = (double[])objectArray[i];
            System.arraycopy(dArray2, 0, dArray, n4, n);
            n4 += n;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(double[] dArray, int n, int n2) {
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = JGeometry.closeCoords(dArray, n);
        return jGeometry;
    }

    private static JGeometry createLinearPolygonInternalLRS(double[] dArray, int n, int n2, boolean bl) {
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        jGeometry.elemInfo = new int[3];
        jGeometry.elemInfo[0] = 1;
        jGeometry.elemInfo[1] = 1003;
        jGeometry.elemInfo[2] = 1;
        jGeometry.ordinates = JGeometry.closeCoordsInternalLRS(dArray, n, bl);
        return jGeometry;
    }

    public static JGeometry createLinearPolygon(Object[] objectArray, int n, int n2) {
        int n3;
        if (objectArray.length == 1) {
            return JGeometry.createLinearPolygon((double[])objectArray[0], n, n2);
        }
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        int n4 = objectArray.length;
        Object[] objectArray2 = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray2[n3] = JGeometry.closeCoords((double[])objectArray[n3], n);
        }
        n3 = 1;
        jGeometry.elemInfo = new int[n4 * 3];
        for (int i = 0; i < n4; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n3;
            jGeometry.elemInfo[i * 3 + 1] = i == 0 ? 1003 : 2003;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n3 += ((double[])objectArray2[i]).length;
        }
        double[] dArray = new double[n3 - 1];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double[] dArray2 = (double[])objectArray2[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    private static JGeometry createLinearPolygonInternalLRS(Object[] objectArray, int n, int n2, boolean bl) {
        int n3;
        if (objectArray.length == 1) {
            return JGeometry.createLinearPolygonInternalLRS((double[])objectArray[0], n, n2, bl);
        }
        JGeometry jGeometry = new JGeometry(3, n2);
        jGeometry.dim = n;
        int n4 = objectArray.length;
        Object[] objectArray2 = new Object[n4];
        for (n3 = 0; n3 < n4; ++n3) {
            objectArray2[n3] = JGeometry.closeCoordsInternalLRS((double[])objectArray[n3], n, bl);
        }
        n3 = 1;
        jGeometry.elemInfo = new int[n4 * 3];
        for (int i = 0; i < n4; ++i) {
            jGeometry.elemInfo[i * 3 + 0] = n3;
            jGeometry.elemInfo[i * 3 + 1] = i == 0 ? 1003 : 2003;
            jGeometry.elemInfo[i * 3 + 2] = 1;
            n3 += ((double[])objectArray2[i]).length;
        }
        double[] dArray = new double[n3 - 1];
        int n5 = 0;
        for (int i = 0; i < n4; ++i) {
            double[] dArray2 = (double[])objectArray2[i];
            System.arraycopy(dArray2, 0, dArray, n5, dArray2.length);
            n5 += dArray2.length;
        }
        jGeometry.ordinates = dArray;
        return jGeometry;
    }

    public static JGeometry createLRSLinearPolygon(double[] dArray, int n, int n2) {
        boolean bl = true;
        try {
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygonInternalLRS(dArray, 3, n2, bl);
                jGeometry.setType(3303);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygonInternalLRS(dArray, 4, n2, bl);
                jGeometry.setType(4403);
                if (JGeometry.monoMeasure(jGeometry.ordinates, n + 1) != 0) {
                    return jGeometry;
                }
                System.out.println("Inconsistent LRS Measure Values");
                return null;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static JGeometry createLRSLinearPolygon(Object[] objectArray, int n, int n2) {
        boolean bl = true;
        try {
            if (objectArray instanceof double[][]) {
                for (int i = 0; i < objectArray.length; ++i) {
                    double[] dArray = ((double[][])objectArray)[i];
                    if (JGeometry.monoMeasure(dArray, n + 1) != 0) continue;
                    System.out.println("Inconsistent LRS Measure Values");
                    return null;
                }
            }
            if (n == 2) {
                JGeometry jGeometry = JGeometry.createLinearPolygonInternalLRS(objectArray, 3, n2, bl);
                jGeometry.setType(3303);
                return jGeometry;
            }
            if (n == 3) {
                JGeometry jGeometry = JGeometry.createLinearPolygonInternalLRS(objectArray, 4, n2, bl);
                jGeometry.setType(4403);
                return jGeometry;
            }
            throw new RuntimeException("Unsupported LRS Polygon type");
        }
        catch (Exception exception) {
            System.out.println("Error: " + exception);
            return null;
        }
    }

    public static int monoMeasure(double[] dArray, int n) {
        int n2;
        double d = Double.NaN;
        int n3 = 0;
        int n4 = 0;
        double d2 = Double.NaN;
        for (n2 = n - 1; n2 < dArray.length; n2 += n) {
            d = dArray[n2];
            if (Double.isNaN(d)) continue;
            n3 = n2;
            break;
        }
        n4 = dArray[n3] == dArray[dArray.length - 1] && dArray[n3 - (n - 2)] == dArray[dArray.length - (n - 1)] && dArray[n3 - (n - 1)] == dArray[dArray.length - n] ? dArray.length - n : dArray.length;
        if (Double.isNaN(d)) {
            return 1;
        }
        int n5 = 0;
        double d3 = d;
        for (n2 = n3 + n; n2 < n4; n2 += n) {
            d2 = dArray[n2];
            if (Double.isNaN(d2)) continue;
            double d4 = d2 - d3;
            if (n5 == 0) {
                n5 = d4 > 0.0 ? 1 : (d4 < 0.0 ? -1 : 0);
            } else if (d4 * (double)n5 < 0.0) {
                return 0;
            }
            d3 = d2;
        }
        if (n5 == 0) {
            return 1;
        }
        return n5;
    }

    public int getType() {
        return this.gtype;
    }

    public void setType(int n) {
        this.gtype = n % 100;
        this.linfo = n % 1000 / 100;
        if (n / 1000 > 0) {
            this.dim = n / 1000;
        }
    }

    public int getLRMDimension() {
        return this.linfo;
    }

    public void setLRMDimension(int n) {
        this.linfo = n;
    }

    public int getSRID() {
        return this.srid;
    }

    public void setSRID(int n) {
        this.srid = n;
    }

    public Point2D getLabelPoint() {
        if (Double.isNaN(this.x) || Double.isNaN(this.y)) {
            return null;
        }
        return new Point2D.Double(this.x, this.y);
    }

    public double[] getLabelPointXYZ() {
        return new double[]{this.x, this.y, this.z};
    }

    public double[] getPoint() {
        if (this.gtype != 1) {
            return null;
        }
        double[] dArray = new double[this.dim];
        if ((Double.isNaN(this.x) || Double.isNaN(this.y)) && (this.elemInfo == null || this.elemInfo.length == 0)) {
            return null;
        }
        if (this.elemInfo == null && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        if (this.elemInfo.length == 3) {
            for (int i = 0; i < this.dim; ++i) {
                dArray[i] = this.ordinates[i];
            }
            return dArray;
        }
        if (this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0) {
            dArray[0] = this.ordinates[0];
            dArray[1] = this.ordinates[1];
            if (this.dim > 2) {
                dArray[2] = this.ordinates[2];
            }
            return dArray;
        }
        double[] dArray2 = this.getMBR();
        if (dArray2 == null) {
            return null;
        }
        dArray[0] = dArray2[0];
        dArray[1] = dArray2[1];
        return dArray;
    }

    public Point2D getJavaPoint() {
        if (this.gtype != 1) {
            return null;
        }
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            return new Point2D.Double(this.x, this.y);
        }
        if (this.elemInfo.length == 3) {
            return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
        }
        if (this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0) {
            return new Point2D.Double(this.ordinates[0], this.ordinates[1]);
        }
        double[] dArray = this.getMBR();
        if (dArray != null) {
            return new Point2D.Double(dArray[0], dArray[1]);
        }
        return null;
    }

    public Point2D[] getJavaPoints() {
        int n;
        int n2 = this.elemInfo[1] % 10;
        int n3 = this.elemInfo[2];
        if (this.isOrientedMultiPoint()) {
            n3 = this.elemInfo.length / 6;
        } else if (this.isMultiPoint()) {
            n3 = 0;
            for (n = 0; n < this.elemInfo.length; n += 3) {
                n3 += this.elemInfo[n + 2];
            }
        }
        n = n3;
        if (this.gtype != 5 || n2 != 1) {
            return null;
        }
        Point2D[] point2DArray = new Point2D[n];
        int n4 = 0;
        if (this.isOrientedMultiPoint()) {
            n4 = this.getOrientMultiPointOffset();
        }
        for (int i = 0; i < n; ++i) {
            point2DArray[i] = new Point2D.Double(this.ordinates[i * (this.dim + n4)], this.ordinates[i * (this.dim + n4) + 1]);
        }
        return point2DArray;
    }

    public final boolean isPoint() {
        return this.gtype == 1;
    }

    public final boolean isOrientedPoint() {
        if (this.elemInfo == null || this.ordinates == null) {
            return false;
        }
        return this.isPoint() && this.elemInfo.length == 6 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0;
    }

    public final boolean isMultiPoint() {
        return this.gtype == 5;
    }

    public final boolean isOrientedMultiPoint() {
        if (this.elemInfo == null || this.ordinates == null) {
            return false;
        }
        return this.isMultiPoint() && this.elemInfo.length > 3 && this.elemInfo[4] == 1 && this.elemInfo[5] == 0;
    }

    public final boolean isRectangle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 3 && this.elemInfo.length == 3;
    }

    public final boolean isCircle() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 4 && this.elemInfo.length == 3;
    }

    public final boolean isGeodeticMBR() {
        if (this.elemInfo == null) {
            return false;
        }
        return this.gtype == 3 && this.elemInfo[1] % 100 == 3 && this.elemInfo[2] == 5 && this.elemInfo.length == 3;
    }

    public final boolean isLRSGeometry() {
        return this.dim <= 2 || this.linfo == 0 ? false : (this.dim == 3 ? this.linfo == 3 : (this.dim == 4 ? this.linfo == 3 || this.linfo == 4 : false));
    }

    public final boolean hasCircularArcs() {
        if (this.elemInfo != null) {
            for (int i = 1; i < this.elemInfo.length; i += 3) {
                int n = this.elemInfo[i];
                int n2 = this.elemInfo[i + 1];
                if ((n2 != 2 || n != 2 && n != 2003 && n != 3 && n != 1003) && n != 4 && n != 5 && n != 2005 && n != 1005) continue;
                return true;
            }
        }
        return false;
    }

    public int getDimensions() {
        return this.dim;
    }

    public double[] getOrdinatesArray() {
        return this.ordinates;
    }

    public int[] getElemInfo() {
        return this.elemInfo;
    }

    public final int getNumPoints() {
        if (this.gtype == 1) {
            return 1;
        }
        if (this.isOrientedMultiPoint()) {
            int n = this.getOrientMultiPointOffset();
            return this.ordinates.length / (this.dim + n);
        }
        return this.ordinates.length / this.dim;
    }

    public double[] getFirstPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[i];
        }
        return dArray;
    }

    public double[] getLastPoint() {
        double[] dArray = new double[this.dim];
        if (this.gtype == 1 && !Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            dArray[0] = this.x;
            dArray[1] = this.y;
            if (this.dim > 2) {
                dArray[2] = this.z;
            }
            return dArray;
        }
        if (this.isOrientedPoint()) {
            for (int i = 0; i < this.dim; ++i) {
                dArray[i] = this.ordinates[i];
            }
            return dArray;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        int n2 = this.ordinates.length - this.dim - n;
        for (int i = 0; i < this.dim; ++i) {
            dArray[i] = this.ordinates[n2 + i];
        }
        return dArray;
    }

    public double[] getMBR() {
        if (this.mbr != null) {
            return this.mbr;
        }
        if (this.getDimensions() == 3 && this.linfo == 0) {
            int n;
            this.mbr = new double[6];
            if (this.isOptimizedPoint()) {
                this.mbr[0] = this.x;
                this.mbr[1] = this.y;
                this.mbr[2] = this.z;
                this.mbr[3] = this.x;
                this.mbr[4] = this.y;
                this.mbr[5] = this.z;
                return this.mbr;
            }
            if (this.isPoint() && this.elemInfo.length == 3 || this.isOrientedPoint()) {
                this.mbr[0] = this.ordinates[0];
                this.mbr[1] = this.ordinates[1];
                this.mbr[2] = this.ordinates[2];
                this.mbr[3] = this.ordinates[0];
                this.mbr[4] = this.ordinates[1];
                this.mbr[5] = this.ordinates[2];
                return this.mbr;
            }
            this.mbr[0] = Double.POSITIVE_INFINITY;
            this.mbr[1] = Double.POSITIVE_INFINITY;
            this.mbr[2] = Double.POSITIVE_INFINITY;
            this.mbr[3] = Double.NEGATIVE_INFINITY;
            this.mbr[4] = Double.NEGATIVE_INFINITY;
            this.mbr[5] = Double.NEGATIVE_INFINITY;
            if (this.isOrientedMultiPoint()) {
                int n2 = this.ordinates.length / (2 * this.dim);
                int n3 = this.getOrientMultiPointOffset();
                for (int i = 0; i < n2; ++i) {
                    JGeometry.expandMBR(this.mbr, this.ordinates[i * (this.dim + n3)], this.ordinates[i * (this.dim + n3) + 1], this.ordinates[i * (this.dim + n3) + 2]);
                }
                return this.mbr;
            }
            int[] nArray = new int[this.elemInfo.length];
            double[] dArray = new double[this.ordinates.length];
            for (n = 0; n < this.ordinates.length; ++n) {
                dArray[n] = this.ordinates[n];
            }
            for (n = 0; n < this.elemInfo.length; ++n) {
                nArray[n] = this.elemInfo[n];
            }
            J3D_Geometry j3D_Geometry = new J3D_Geometry(this.gtype, this.srid, nArray, dArray);
            double[][] dArray2 = new double[3][2];
            dArray2 = J3D_Geometry.getMBH(j3D_Geometry);
            for (int i = 0; i < 3; ++i) {
                this.mbr[i] = dArray2[i][0];
                this.mbr[i + 3] = dArray2[i][1];
            }
            return this.mbr;
        }
        this.mbr = new double[4];
        if (this.isOptimizedPoint()) {
            this.mbr[0] = this.x;
            this.mbr[1] = this.y;
            this.mbr[2] = this.x;
            this.mbr[3] = this.y;
            return this.mbr;
        }
        if (this.isPoint() && this.elemInfo.length == 3 || this.isOrientedPoint()) {
            this.mbr[0] = this.ordinates[0];
            this.mbr[1] = this.ordinates[1];
            this.mbr[2] = this.ordinates[0];
            this.mbr[3] = this.ordinates[1];
            return this.mbr;
        }
        if (this.isRectangle() || this.isGeodeticMBR()) {
            this.mbr[0] = Math.min(this.ordinates[0], this.ordinates[2]);
            this.mbr[1] = Math.min(this.ordinates[1], this.ordinates[3]);
            this.mbr[2] = Math.max(this.ordinates[0], this.ordinates[2]);
            this.mbr[3] = Math.max(this.ordinates[1], this.ordinates[3]);
            return this.mbr;
        }
        this.mbr[0] = Double.POSITIVE_INFINITY;
        this.mbr[1] = Double.POSITIVE_INFINITY;
        this.mbr[2] = Double.NEGATIVE_INFINITY;
        this.mbr[3] = Double.NEGATIVE_INFINITY;
        if (this.isMultiPoint() && this.elemInfo.length == 3) {
            int n = this.elemInfo[2];
            for (int i = 0; i < n; ++i) {
                JGeometry.expandMBR(this.mbr, this.ordinates[i * this.dim], this.ordinates[i * this.dim + 1]);
            }
            return this.mbr;
        }
        if (this.isOrientedMultiPoint()) {
            int n = this.ordinates.length / (2 * this.dim);
            int n4 = this.getOrientMultiPointOffset();
            for (int i = 0; i < n; ++i) {
                JGeometry.expandMBR(this.mbr, this.ordinates[i * (this.dim + n4)], this.ordinates[i * (this.dim + n4) + 1]);
            }
            return this.mbr;
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block6: while (elementIterator.next()) {
            int n = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                double[] dArray;
                if (elementIterator.eitpr == 2) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim || i >= elementIterator.nCoord - 1) continue block6;
                    dArray = JGeometry.computeArcMBR(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    this.expandMBR(this.mbr, dArray, 2);
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr == 4) {
                    if (n + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block6;
                    dArray = JGeometry.computeArc(this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1], this.ordinates[n + (i + 1) * this.dim], this.ordinates[n + (i + 1) * this.dim + 1], this.ordinates[n + (i + 2) * this.dim], this.ordinates[n + (i + 2) * this.dim + 1]);
                    double[] dArray3 = new double[]{dArray[0] - dArray[2], dArray[1] - dArray[2], dArray[0] + dArray[2], dArray[1] + dArray[2]};
                    this.expandMBR(this.mbr, dArray3, 2);
                    i += 2;
                    continue;
                }
                JGeometry.expandMBR(this.mbr, this.ordinates[n + i * this.dim], this.ordinates[n + i * this.dim + 1]);
            }
        }
        return this.mbr;
    }

    public Object[] getOrdinatesOfElements() {
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        while (elementIterator.next()) {
            int n2 = elementIterator.ord_offset;
            double[] dArray = new double[elementIterator.nCoord * this.dim];
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                for (int j = 0; j < this.dim; ++j) {
                    dArray[i * this.dim + j] = this.ordinates[n2 + i * (this.dim + n) + j];
                }
            }
            arrayList.add(dArray);
        }
        return arrayList.toArray();
    }

    protected double[] getOrdinatesOfElement(int n, int n2) {
        double[] dArray = new double[n2 - n];
        int n3 = 0;
        for (int i = n; i < n2; ++i) {
            dArray[n3] = this.ordinates[i];
            ++n3;
        }
        return dArray;
    }

    protected int[] getElemInfoOfElement(int n, int n2) {
        int[] nArray = new int[n2 - n];
        int n3 = 0;
        int n4 = this.elemInfo[n] - 1;
        for (int i = n; i < n2; i += 3) {
            nArray[n3] = this.elemInfo[i] - n4;
            nArray[n3 + 1] = this.elemInfo[i + 1];
            nArray[n3 + 2] = this.elemInfo[i + 2];
            n3 += 3;
        }
        return nArray;
    }

    protected JGeometry makeElementGeometry(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[n3 - n2];
        nArray = this.getElemInfoOfElement(n2, n3);
        double[] dArray = new double[n5 - n4];
        dArray = this.getOrdinatesOfElement(n4, n5);
        JGeometry jGeometry = new JGeometry(n, this.srid, nArray, dArray);
        return jGeometry;
    }

    public JGeometry getElementAt(int n) {
        if (n >= 1) {
            JGeometry[] jGeometryArray = this.getElements(n);
            if (jGeometryArray != null) {
                return jGeometryArray[0];
            }
            return null;
        }
        return null;
    }

    public JGeometry[] getElements() {
        JGeometry[] jGeometryArray = this.getElements(-1);
        return jGeometryArray;
    }

    protected JGeometry[] getElements(int n) {
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        JGeometry jGeometry = null;
        int n2 = 0;
        if (this.gtype == 1 || this.gtype == 2 || this.gtype == 3) {
            arrayList.add(this);
            ++n2;
        } else if (this.gtype == 6 || this.gtype == 7 || this.gtype == 4 || this.gtype == 5) {
            if (this.elemInfo == null || this.ordinates == null) {
                return null;
            }
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            for (int i = 0; i < this.elemInfo.length; i += 3) {
                int n7;
                boolean bl;
                int n8;
                int n9;
                if (this.elemInfo[i + 1] == 2) {
                    if (++n2 == n || n == -1) {
                        n9 = 2;
                        n4 = this.elemInfo[i] - 1;
                        n6 = i + 3 < this.elemInfo.length ? this.elemInfo[i + 3] - 1 : this.ordinates.length;
                        jGeometry = this.makeElementGeometry(n9, i, i + 3, n4, n6);
                        jGeometry.dim = this.dim;
                        jGeometry.linfo = this.linfo;
                        arrayList.add(jGeometry);
                    }
                    if (n2 != n) continue;
                    i = this.elemInfo.length;
                    continue;
                }
                if (this.elemInfo[i + 1] == 4) {
                    n9 = this.elemInfo[i + 2];
                    if (++n2 == n || n == -1) {
                        n8 = 2;
                        n3 = i;
                        n4 = this.elemInfo[i] - 1;
                        if (i + 3 + 3 * n9 < this.elemInfo.length) {
                            n6 = this.elemInfo[i + 3 + 3 * n9] - 1;
                            n5 = i + 3 + 3 * n9;
                        } else {
                            n6 = this.ordinates.length;
                            n5 = this.elemInfo.length;
                        }
                        jGeometry = this.makeElementGeometry(n8, n3, n5, n4, n6);
                        jGeometry.dim = this.dim;
                        jGeometry.linfo = this.linfo;
                        arrayList.add(jGeometry);
                    }
                    if (n2 == n) {
                        i = this.elemInfo.length;
                        continue;
                    }
                    i += 3 * n9;
                    continue;
                }
                if (this.elemInfo[i + 1] == 1003 || this.elemInfo[i + 1] == 1005 || this.elemInfo[i + 1] == 3 || this.elemInfo[i + 1] == 5) {
                    ++n2;
                    n9 = 3;
                    n8 = this.elemInfo[i + 1];
                    n3 = i;
                    n4 = this.elemInfo[i] - 1;
                    bl = false;
                    if ((n8 == 1003 || n8 == 3) && i + 3 < this.elemInfo.length) {
                        n6 = this.elemInfo[i + 3] - 1;
                        n5 = i + 3;
                        bl = true;
                    } else if ((n8 == 1005 || n8 == 5) && i + 3 + 3 * this.elemInfo[i + 2] < this.elemInfo.length) {
                        n7 = this.elemInfo[i + 2];
                        n6 = this.elemInfo[i + 3 + 3 * n7] - 1;
                        n5 = i + 3 + 3 * n7;
                        i += 3 * n7;
                        bl = true;
                    } else {
                        n6 = this.ordinates.length;
                        n5 = this.elemInfo.length;
                    }
                    n7 = 1;
                    while (bl && n7 != 0) {
                        if (i + 3 + 1 < this.elemInfo.length) {
                            int n10 = this.elemInfo[i + 3 + 1];
                            if (n10 == 2003) {
                                if ((i += 3) + 3 + 1 > this.elemInfo.length) {
                                    n6 = this.ordinates.length;
                                    n5 = this.elemInfo.length;
                                    n7 = 0;
                                    continue;
                                }
                                n6 = this.elemInfo[i + 3] - 1;
                                n5 = i + 3;
                                n7 = 1;
                                continue;
                            }
                            if (n10 == 2005) {
                                int n11;
                                if ((i += 3) + 3 + 3 * (n11 = this.elemInfo[i + 2]) < this.elemInfo.length) {
                                    n6 = this.elemInfo[i + 3 + 3 * n11] - 1;
                                    n5 = i + 3 + 3 * n11;
                                    n7 = 1;
                                } else {
                                    n6 = this.ordinates.length;
                                    n5 = this.elemInfo.length;
                                    n7 = 0;
                                }
                                i += 3 * n11;
                                continue;
                            }
                            n7 = 0;
                            continue;
                        }
                        bl = false;
                    }
                    if (n2 == n || n == -1) {
                        jGeometry = this.makeElementGeometry(n9, n3, n5, n4, n6);
                        jGeometry.dim = this.dim;
                        arrayList.add(jGeometry);
                    }
                    if (n2 != n) continue;
                    i = this.elemInfo.length;
                    continue;
                }
                if (this.elemInfo[i + 1] == 1) {
                    n9 = this.elemInfo[i + 2];
                    n8 = 1;
                    n4 = this.elemInfo[i] - 1;
                    bl = false;
                    if (n9 >= 1) {
                        if (i + 3 < this.elemInfo.length) {
                            if (n9 == 1 && this.elemInfo[i + 4] == 1 && this.elemInfo[i + 5] == 0) {
                                bl = true;
                            }
                            if (bl && i + 6 < this.elemInfo.length) {
                                n6 = this.elemInfo[i + 6] - 1;
                            } else if (bl) {
                                n6 = this.ordinates.length;
                            }
                        }
                        for (n7 = 0; n7 < n9; ++n7) {
                            ++n2;
                            if (this.dim == 2 && !bl) {
                                if (n2 == n || n == -1) {
                                    jGeometry = new JGeometry(this.ordinates[n4], this.ordinates[n4 + 1], this.srid);
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += 2;
                                continue;
                            }
                            if (this.dim == 3 && !bl) {
                                if (n2 == n || n == -1) {
                                    jGeometry = new JGeometry(this.ordinates[n4], this.ordinates[n4 + 1], this.ordinates[n4 + 2], this.srid);
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += 3;
                                continue;
                            }
                            if (!bl) {
                                if (n2 == n || n == -1) {
                                    int[] nArray = new int[]{1, 1, 1};
                                    double[] dArray = new double[this.dim];
                                    dArray = this.getOrdinatesOfElement(n4, n4 + this.dim);
                                    jGeometry = new JGeometry(n8, this.srid, nArray, dArray);
                                    jGeometry.dim = this.dim;
                                    arrayList.add(jGeometry);
                                }
                                if (n2 == n) {
                                    n7 = n9;
                                    i = this.elemInfo.length;
                                    continue;
                                }
                                n4 += this.dim;
                                continue;
                            }
                            if (!bl) continue;
                            if (n2 == n || n == -1) {
                                jGeometry = this.makeElementGeometry(n8, i, i + 6, n4, n6);
                                jGeometry.dim = this.dim;
                                arrayList.add(jGeometry);
                            }
                            if (n2 == n) {
                                n7 = n9;
                                i = this.elemInfo.length;
                                continue;
                            }
                            i += 3;
                        }
                        continue;
                    }
                    return null;
                }
                i += 3;
            }
        }
        if (n > n2 || n2 == 0) {
            return null;
        }
        JGeometry[] jGeometryArray = new JGeometry[arrayList.size()];
        return arrayList.toArray(jGeometryArray);
    }

    public int getOrientMultiPointOffset() {
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.dim == 2 || this.dim == 3 && this.linfo == 3 ? 2 : 3;
        }
        return n;
    }

    public final Shape createShape() {
        GeneralPath generalPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            float f = (float)this.ordinates[0];
            float f2 = (float)this.ordinates[1];
            float f3 = (float)this.ordinates[2];
            float f4 = (float)this.ordinates[3];
            return new Rectangle2D.Double(f, Math.min(f2, f4), f3 - f, Math.abs(f4 - f2));
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.computeArc(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                Object object;
                double[] dArray;
                if (elementIterator.etype != 1 && elementIterator.eitpr == 1) {
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)this.ordinates[n2 + i * (this.dim + n)], (float)this.ordinates[n2 + i * (this.dim + n) + 1]);
                    } else {
                        generalPath.lineTo((float)this.ordinates[n2 + i * (this.dim + n)], (float)this.ordinates[n2 + i * (this.dim + n) + 1]);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                    object = JGeometry.reFormulateArc(dArray);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)this.ordinates[n2 + i * this.dim], (float)this.ordinates[n2 + i * this.dim + 1]);
                    } else {
                        generalPath.lineTo((float)this.ordinates[n2 + i * this.dim], (float)this.ordinates[n2 + i * this.dim + 1]);
                    }
                    Arc2D.Double double_ = new Arc2D.Double((double)(object[0] - object[2]), (double)(object[1] - object[2]), (double)(object[2] * 2.0), (double)(object[2] * 2.0), (double)(object[3] / Math.PI * 180.0), (double)((object[5] - object[3]) / Math.PI * 180.0), 0);
                    generalPath.append(double_, true);
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    float f = (float)this.ordinates[n2 + 0];
                    float f5 = (float)this.ordinates[n2 + 1];
                    float f6 = (float)this.ordinates[n2 + this.dim];
                    float f7 = (float)this.ordinates[n2 + this.dim + 1];
                    if (elementIterator.original_etype < 2000) {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f6, f5);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f, f7);
                        generalPath.closePath();
                    } else {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f5);
                        generalPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                dArray = JGeometry.computeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                object = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
                generalPath.append((Shape)object, false);
                if (elementIterator.original_etype > 2000) {
                    generalPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return generalPath;
    }

    public final Shape createShape(AffineTransform affineTransform) {
        return this.createShape(affineTransform, false);
    }

    public final Shape createShape(AffineTransform affineTransform, boolean bl) {
        if (affineTransform == null) {
            return this.createShape();
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        GeneralPath generalPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            float f = (float)((Point2D)double_2).getX();
            float f2 = (float)((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2], this.ordinates[3]);
            affineTransform.transform(double_, double_2);
            float f3 = (float)((Point2D)double_2).getX();
            float f4 = (float)((Point2D)double_2).getY();
            return new Rectangle2D.Double(f, Math.min(f2, f4), f3 - f, Math.abs(f4 - f2));
        }
        if (this.isCircle()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d2 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[this.dim], this.ordinates[this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d3 = ((Point2D)double_2).getX();
            double d4 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d5 = ((Point2D)double_2).getX();
            double d6 = ((Point2D)double_2).getY();
            double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_3;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        double d = 0.0;
        double d7 = 0.0;
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (generalPath == null) {
                generalPath = new GeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            double d8 = Double.MAX_VALUE;
            double d9 = Double.MAX_VALUE;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.etype != 1 && elementIterator.eitpr == 1) {
                    d = this.ordinates[n2 + i * (this.dim + n)];
                    d7 = this.ordinates[n2 + i * (this.dim + n) + 1];
                    ((Point2D)double_).setLocation(d, d7);
                    affineTransform.transform(double_, double_2);
                    d = ((Point2D)double_2).getX();
                    d7 = ((Point2D)double_2).getY();
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        d8 = d;
                        d9 = d7;
                        generalPath.moveTo((float)d, (float)d7);
                    } else {
                        boolean bl2;
                        double d10 = d - d8;
                        double d11 = d7 - d9;
                        boolean bl3 = bl2 = d10 < -0.25 || d10 > 0.25 || d11 < -0.25 || d11 > 0.25;
                        if (!bl || bl2) {
                            d8 = d;
                            d9 = d7;
                            generalPath.lineTo((float)d, (float)d7);
                        }
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                    affineTransform.transform(dArray, 0, dArray, 0, 3);
                    double[] dArray2 = JGeometry.reFormulateArc(dArray);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        generalPath.moveTo((float)dArray[0], (float)dArray[1]);
                    } else {
                        generalPath.lineTo((float)dArray[0], (float)dArray[1]);
                    }
                    Arc2D.Double double_4 = new Arc2D.Double(dArray2[0] - dArray2[2], dArray2[1] - dArray2[2], dArray2[2] * 2.0, dArray2[2] * 2.0, dArray2[3] / Math.PI * 180.0, (dArray2[5] - dArray2[3]) / Math.PI * 180.0, 0);
                    generalPath.append(double_4, true);
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    generalPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    ((Point2D)double_).setLocation(this.ordinates[n2 + 0], this.ordinates[n2 + 1]);
                    affineTransform.transform(double_, double_2);
                    float f = (float)((Point2D)double_2).getX();
                    float f5 = (float)((Point2D)double_2).getY();
                    ((Point2D)double_).setLocation(this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1]);
                    affineTransform.transform(double_, double_2);
                    float f6 = (float)((Point2D)double_2).getX();
                    float f7 = (float)((Point2D)double_2).getY();
                    if (elementIterator.original_etype < 2000) {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f6, f5);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f, f7);
                        generalPath.closePath();
                    } else {
                        generalPath.moveTo(f, f5);
                        generalPath.lineTo(f, f7);
                        generalPath.lineTo(f6, f7);
                        generalPath.lineTo(f6, f5);
                        generalPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                affineTransform.transform(dArray, 0, dArray, 0, 3);
                double[] dArray3 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                Ellipse2D.Double double_5 = new Ellipse2D.Double(dArray3[0] - dArray3[2], dArray3[1] - dArray3[2], 2.0 * dArray3[2], 2.0 * dArray3[2]);
                generalPath.append(double_5, false);
                if (elementIterator.original_etype > 2000) {
                    generalPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return generalPath;
    }

    public final Shape createDoubleShape() {
        SDODoubleGeneralPath sDODoubleGeneralPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            double d = this.ordinates[0];
            double d2 = this.ordinates[1];
            double d3 = this.ordinates[2];
            double d4 = this.ordinates[3];
            return new Rectangle2D.Double(d, d2, d3 - d, d4 - d2);
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.computeArc(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (sDODoubleGeneralPath == null) {
                sDODoubleGeneralPath = new SDODoubleGeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.eitpr == 1) {
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(this.ordinates[n2 + i * (this.dim + n)], this.ordinates[n2 + i * (this.dim + n) + 1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(this.ordinates[n2 + i * (this.dim + n)], this.ordinates[n2 + i * (this.dim + n) + 1]);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(dArray[0], dArray[1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(dArray[0], dArray[1]);
                    }
                    for (int j = 1; j < dArray.length / 2; ++j) {
                        sDODoubleGeneralPath.lineTo(dArray[j * 2], dArray[j * 2 + 1]);
                    }
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    double d = this.ordinates[n2 + 0];
                    double d5 = this.ordinates[n2 + 1];
                    double d6 = this.ordinates[n2 + this.dim];
                    double d7 = this.ordinates[n2 + this.dim + 1];
                    if (elementIterator.original_etype < 2000) {
                        sDODoubleGeneralPath.moveTo(d, d5);
                        sDODoubleGeneralPath.lineTo(d6, d5);
                        sDODoubleGeneralPath.lineTo(d6, d7);
                        sDODoubleGeneralPath.lineTo(d, d7);
                        sDODoubleGeneralPath.closePath();
                    } else {
                        sDODoubleGeneralPath.moveTo(d, d5);
                        sDODoubleGeneralPath.lineTo(d, d7);
                        sDODoubleGeneralPath.lineTo(d6, d7);
                        sDODoubleGeneralPath.lineTo(d6, d5);
                        sDODoubleGeneralPath.closePath();
                    }
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = JGeometry.computeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                Ellipse2D.Double double_ = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
                sDODoubleGeneralPath.append((Shape)double_, false);
                if (elementIterator.original_etype > 2000) {
                    sDODoubleGeneralPath.setWindingRule(0);
                }
                i += 2;
            }
        }
        return sDODoubleGeneralPath;
    }

    public final Shape createDoubleShape(AffineTransform affineTransform) {
        if (affineTransform == null) {
            return this.createDoubleShape();
        }
        Point2D.Double double_ = new Point2D.Double();
        Point2D.Double double_2 = new Point2D.Double();
        SDODoubleGeneralPath sDODoubleGeneralPath = null;
        if (this.isRectangle() || this.isGeodeticMBR()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d2 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2], this.ordinates[3]);
            affineTransform.transform(double_, double_2);
            double d3 = ((Point2D)double_2).getX();
            double d4 = ((Point2D)double_2).getY();
            return new Rectangle2D.Double(d, Math.min(d2, d4), d3 - d, Math.abs(d4 - d2));
        }
        if (this.isCircle()) {
            ((Point2D)double_).setLocation(this.ordinates[0], this.ordinates[1]);
            affineTransform.transform(double_, double_2);
            double d = ((Point2D)double_2).getX();
            double d5 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[this.dim], this.ordinates[this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d6 = ((Point2D)double_2).getX();
            double d7 = ((Point2D)double_2).getY();
            ((Point2D)double_).setLocation(this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            affineTransform.transform(double_, double_2);
            double d8 = ((Point2D)double_2).getX();
            double d9 = ((Point2D)double_2).getY();
            double[] dArray = JGeometry.computeArc(d, d5, d6, d7, d8, d9);
            Ellipse2D.Double double_3 = new Ellipse2D.Double(dArray[0] - dArray[2], dArray[1] - dArray[2], 2.0 * dArray[2], 2.0 * dArray[2]);
            return double_3;
        }
        int n = 0;
        if (this.isOrientedMultiPoint()) {
            n = this.getOrientMultiPointOffset();
        }
        double d = 0.0;
        double d10 = 0.0;
        ElementIterator elementIterator = new ElementIterator(this);
        block0: while (elementIterator.next()) {
            if (sDODoubleGeneralPath == null) {
                sDODoubleGeneralPath = new SDODoubleGeneralPath();
            }
            int n2 = elementIterator.ord_offset;
            for (int i = 0; i < elementIterator.nCoord; ++i) {
                if (elementIterator.eitpr == 1) {
                    d = this.ordinates[n2 + i * (this.dim + n)];
                    d10 = this.ordinates[n2 + i * (this.dim + n) + 1];
                    ((Point2D)double_).setLocation(d, d10);
                    affineTransform.transform(double_, double_2);
                    d = ((Point2D)double_2).getX();
                    d10 = ((Point2D)double_2).getY();
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(d, d10);
                    } else {
                        sDODoubleGeneralPath.lineTo(d, d10);
                    }
                    if (i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (elementIterator.etype == 1) {
                        return null;
                    }
                    if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n2 + i * this.dim)) / this.dim < 2) continue block0;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]);
                    affineTransform.transform(dArray, 0, dArray, 0, dArray.length / 2);
                    if (i == 0 && (!elementIterator.isCompound || elementIterator.isFirstElemOfCompound)) {
                        sDODoubleGeneralPath.moveTo(dArray[0], dArray[1]);
                    } else {
                        sDODoubleGeneralPath.lineTo(dArray[0], dArray[1]);
                    }
                    for (int j = 1; j < dArray.length / 2; ++j) {
                        sDODoubleGeneralPath.lineTo(dArray[j * 2], dArray[j * 2 + 1]);
                    }
                    if (++i < elementIterator.nCoord - 1 || elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                    sDODoubleGeneralPath.closePath();
                    continue;
                }
                if (elementIterator.eitpr == 3) {
                    ((Point2D)double_).setLocation(this.ordinates[n2 + 0], this.ordinates[n2 + 1]);
                    affineTransform.transform(double_, double_2);
                    double d11 = ((Point2D)double_2).getX();
                    double d12 = ((Point2D)double_2).getY();
                    ((Point2D)double_).setLocation(this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1]);
                    affineTransform.transform(double_, double_2);
                    double d13 = ((Point2D)double_2).getX();
                    double d14 = ((Point2D)double_2).getY();
                    sDODoubleGeneralPath.moveTo(d11, d12);
                    sDODoubleGeneralPath.lineTo(d13, d12);
                    sDODoubleGeneralPath.lineTo(d13, d14);
                    sDODoubleGeneralPath.lineTo(d11, d14);
                    sDODoubleGeneralPath.closePath();
                    ++i;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n2 + i * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n2 + i * this.dim >= elementIterator.next_ord_offset - this.dim) continue block0;
                double[] dArray = new double[]{this.ordinates[n2 + i * this.dim], this.ordinates[n2 + i * this.dim + 1], this.ordinates[n2 + (i + 1) * this.dim], this.ordinates[n2 + (i + 1) * this.dim + 1], this.ordinates[n2 + (i + 2) * this.dim], this.ordinates[n2 + (i + 2) * this.dim + 1]};
                affineTransform.transform(dArray, 0, dArray, 0, 3);
                double[] dArray2 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
                Ellipse2D.Double double_4 = new Ellipse2D.Double(dArray2[0] - dArray2[2], dArray2[1] - dArray2[2], 2.0 * dArray2[2], 2.0 * dArray2[2]);
                sDODoubleGeneralPath.append((Shape)double_4, false);
                i += 2;
            }
        }
        return sDODoubleGeneralPath;
    }

    @Deprecated
    public static final JGeometry load(STRUCT sTRUCT) throws SQLException {
        Datum[] datumArray;
        Datum[] datumArray2 = sTRUCT.getOracleAttributes();
        int n = datumArray2[0] != null ? datumArray2[0].intValue() : 0;
        int n2 = datumArray2[1] != null ? datumArray2[1].intValue() : 0;
        STRUCT sTRUCT2 = (STRUCT)datumArray2[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (sTRUCT2 != null) {
            datumArray = sTRUCT2.getOracleAttributes();
            if (datumArray[0] != null && datumArray[1] != null) {
                d = datumArray[0].doubleValue();
                d2 = datumArray[1].doubleValue();
            }
            if (datumArray[2] != null) {
                d3 = datumArray[2].doubleValue();
            }
        }
        datumArray = datumArray2[3] != null ? ((ARRAY)datumArray2[3]).getIntArray() : null;
        double[] dArray = null;
        if (datumArray2[4] != null) {
            if (n % 1000 / 100 == 0) {
                dArray = ((ARRAY)datumArray2[4]).getDoubleArray();
            } else {
                int n3 = n % 1000 / 100;
                int n4 = n / 1000 > 0 ? n / 1000 : 2;
                Datum[] datumArray3 = ((ARRAY)datumArray2[4]).getOracleArray();
                int n5 = datumArray3.length;
                dArray = new double[n5];
                if (n4 != 2 && (n4 == 3 && n4 == n3 || n4 == 4 && (n3 == 3 || n3 == 4))) {
                    for (int i = 0; i < n5; ++i) {
                        if (datumArray3[i] == null && i % n4 != n3 - 1) {
                            throw new SQLException("An invalid null value is found in LRS sdo_ordinates");
                        }
                        dArray[i] = datumArray3[i] != null ? datumArray3[i].doubleValue() : Double.NaN;
                    }
                } else {
                    throw new SQLException("An invalid sdo_gtype is found");
                }
            }
        }
        if (dArray != null && datumArray != null) {
            return new JGeometry(n, n2, d, d2, d3, (int[])datumArray, dArray);
        }
        if (!Double.isNaN(d) && !Double.isNaN(d2)) {
            if (!Double.isNaN(d3)) {
                return new JGeometry(d, d2, d3, n2);
            }
            return new JGeometry(d, d2, n2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final JGeometry loadJS(Struct struct) throws SQLException {
        void var11_12;
        if (!(struct instanceof Struct)) {
            throw new SQLException("Expecting java.sql.Struct type but could not find it");
        }
        Object[] objectArray = struct.getAttributes();
        int n = objectArray[0] != null ? Integer.valueOf(objectArray[0].toString()) : 0;
        int n2 = objectArray[1] != null ? Integer.valueOf(objectArray[1].toString()) : 0;
        Struct struct2 = (Struct)objectArray[2];
        double d = Double.NaN;
        double d2 = Double.NaN;
        double d3 = Double.NaN;
        if (struct2 != null) {
            Object[] objectArray2 = struct2.getAttributes();
            if (objectArray2[0] != null && objectArray2[1] != null) {
                d = Double.valueOf(objectArray2[0].toString());
                d2 = Double.valueOf(objectArray2[1].toString());
            }
            if (objectArray2[2] != null) {
                d3 = Double.valueOf(objectArray2[2].toString());
            }
        }
        Object var11_9 = null;
        if (objectArray[3] != null) {
            if (objectArray[3] instanceof ARRAY) {
                int[] nArray = ((ARRAY)objectArray[3]).getIntArray();
            } else {
                if (!(objectArray[3] instanceof OracleArray)) throw new SQLException("Wrong ElemInfo array type");
                int[] nArray = ((OracleArray)objectArray[3]).getIntArray();
            }
        }
        double[] dArray = null;
        if (objectArray[4] != null) {
            if (n % 1000 / 100 == 0) {
                if (objectArray[4] instanceof ARRAY) {
                    dArray = ((ARRAY)objectArray[4]).getDoubleArray();
                } else {
                    if (!(objectArray[4] instanceof OracleArray)) throw new SQLException("Wrong ordinates array type");
                    dArray = ((OracleArray)objectArray[4]).getDoubleArray();
                }
            } else {
                int n3 = n % 1000 / 100;
                int n4 = n / 1000 > 0 ? n / 1000 : 2;
                Object[] objectArray3 = (Object[])((Array)objectArray[4]).getArray();
                int n5 = objectArray3.length;
                dArray = new double[n5];
                if (n4 == 2 || (n4 != 3 || n4 != n3) && (n4 != 4 || n3 != 3 && n3 != 4)) throw new SQLException("An invalid sdo_gtype is found");
                for (int i = 0; i < n5; ++i) {
                    if (objectArray3[i] == null && i % n4 != n3 - 1) {
                        throw new SQLException("An invalid null value is found in LRS sdo_ordinates");
                    }
                    dArray[i] = objectArray3[i] != null ? Double.valueOf(objectArray3[i].toString()) : Double.NaN;
                }
            }
        }
        if (dArray != null && var11_12 != null) {
            return new JGeometry(n, n2, d, d2, d3, (int[])var11_12, dArray);
        }
        if (Double.isNaN(d) || Double.isNaN(d2)) return null;
        if (Double.isNaN(d3)) return new JGeometry(d, d2, n2);
        return new JGeometry(d, d2, d3, n2);
    }

    private static boolean etype0_exists(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length / 3; ++i) {
            if (nArray[3 * i + 1] != 0) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean ordOffset0_exists(int[] nArray) {
        boolean bl = false;
        for (int i = 0; i < nArray.length / 3; ++i) {
            if (nArray[3 * i] >= 1) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected static void remove_etype0(int[] nArray, double[] dArray, ArrayList arrayList, ArrayList arrayList2) {
        int n;
        int[] nArray2 = new int[nArray.length];
        double[] dArray2 = new double[dArray.length];
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        for (n2 = 0; n2 < nArray.length / 3; ++n2) {
            if (nArray[3 * n2 + 1] == 0) {
                n7 = nArray[3 * n2] - 1;
                n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
                n6 += n8 - n7 + 1;
                continue;
            }
            n7 = nArray[3 * n2] - 1;
            n8 = 3 * (n2 + 1) <= nArray.length - 1 ? nArray[3 * (n2 + 1)] - 2 : dArray.length - 1;
            for (n3 = n7; n3 <= n8; ++n3) {
                dArray2[n5] = dArray[n3];
                ++n5;
            }
            nArray2[n4] = nArray[3 * n2] - n6;
            ++n4;
            for (n3 = 1; n3 < 3; ++n3) {
                nArray2[n4] = nArray[3 * n2 + n3];
                ++n4;
            }
        }
        for (n = 0; n < n4; ++n) {
            arrayList.add(nArray2[n]);
        }
        for (n = 0; n < n5; ++n) {
            arrayList2.add(dArray2[n]);
        }
    }

    static final JGeometry loadAndReorient(STRUCT sTRUCT) throws SQLException {
        JGeometry jGeometry = JGeometry.load(sTRUCT);
        if (jGeometry == null) {
            return null;
        }
        if (!(jGeometry.gtype != 2 && jGeometry.gtype != 6 && jGeometry.gtype != 4 || jGeometry.hasCircularArcs())) {
            jGeometry.reOrientCurves();
        }
        return jGeometry;
    }

    static final JGeometry loadAndReorientJS(Struct struct) throws SQLException {
        JGeometry jGeometry = JGeometry.loadJS(struct);
        if (jGeometry == null) {
            return null;
        }
        if (!(jGeometry.gtype != 2 && jGeometry.gtype != 6 && jGeometry.gtype != 4 || jGeometry.hasCircularArcs())) {
            jGeometry.reOrientCurves();
        }
        return jGeometry;
    }

    @Deprecated
    public static STRUCT store(JGeometry jGeometry, Connection connection) throws SQLException {
        return JGeometry.store(jGeometry, connection, null);
    }

    @Deprecated
    public static STRUCT store(JGeometry jGeometry, Connection connection, boolean bl) throws SQLException {
        return JGeometry.store(jGeometry, connection, null, bl);
    }

    public static Struct storeJS(JGeometry jGeometry, Connection connection) throws SQLException {
        return JGeometry.storeJS(jGeometry, connection, null);
    }

    public static Struct storeJS(JGeometry jGeometry, Connection connection, boolean bl) throws SQLException {
        return JGeometry.storeJS(jGeometry, connection, null, bl);
    }

    @Deprecated
    public static STRUCT store(JGeometry jGeometry, Connection connection, Object[] objectArray) throws SQLException {
        return JGeometry.store(jGeometry, connection, objectArray, false);
    }

    @Deprecated
    public static STRUCT store(JGeometry jGeometry, Connection connection, Object[] objectArray, boolean bl) throws SQLException {
        ARRAY aRRAY;
        Object[] objectArray2;
        ARRAY aRRAY2;
        StructDescriptor structDescriptor = null;
        StructDescriptor structDescriptor2 = null;
        ArrayDescriptor arrayDescriptor = null;
        ArrayDescriptor arrayDescriptor2 = null;
        if (objectArray != null && objectArray.length >= 4) {
            structDescriptor = (StructDescriptor)objectArray[0];
            structDescriptor2 = (StructDescriptor)objectArray[1];
            arrayDescriptor = (ArrayDescriptor)objectArray[2];
            arrayDescriptor2 = (ArrayDescriptor)objectArray[3];
        } else {
            if (geomDesc == null) {
                JGeometry.createDBDescriptors(connection);
            }
            structDescriptor = geomDesc;
            structDescriptor2 = pointDesc;
            arrayDescriptor = elemInfoDesc;
            arrayDescriptor2 = ordinatesDesc;
        }
        if (structDescriptor == null) {
            throw new SQLException("sdo_geometry descriptor is null.");
        }
        if (structDescriptor2 == null) {
            throw new SQLException("sdo_point descriptor is null.");
        }
        if (arrayDescriptor == null) {
            throw new SQLException("elem_info descriptor is null.");
        }
        if (arrayDescriptor2 == null) {
            throw new SQLException("ordinates descriptor is null.");
        }
        NUMBER nUMBER = new NUMBER(jGeometry.gtype + jGeometry.linfo * 100 + jGeometry.dim * 1000);
        NUMBER nUMBER2 = jGeometry.srid == 0 ? null : new NUMBER(jGeometry.srid);
        STRUCT sTRUCT = null;
        if (bl) {
            ARRAY aRRAY3 = aRRAY2 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (aRRAY2 != null) {
                aRRAY2[0] = new NUMBER(new BigDecimal(jGeometry.x));
                aRRAY2[1] = new NUMBER(new BigDecimal(jGeometry.y));
                aRRAY2[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(new BigDecimal(jGeometry.z));
                sTRUCT = new STRUCT(structDescriptor2, connection, (Object[])aRRAY2);
            }
        } else {
            Object object = aRRAY2 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (aRRAY2 != null) {
                aRRAY2[0] = new NUMBER(jGeometry.x);
                aRRAY2[1] = new NUMBER(jGeometry.y);
                aRRAY2[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(jGeometry.z);
                sTRUCT = new STRUCT(structDescriptor2, connection, (Object[])aRRAY2);
            }
        }
        ARRAY aRRAY4 = aRRAY2 = jGeometry.elemInfo == null ? null : new ARRAY(arrayDescriptor, connection, (Object)jGeometry.elemInfo);
        if (bl) {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new BigDecimal[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new BigDecimal(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new BigDecimal(jGeometry.ordinates[i]);
                    }
                }
            }
            aRRAY = jGeometry.ordinates == null ? null : new ARRAY(arrayDescriptor2, connection, (Object)objectArray2);
        } else {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new Double[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new Double(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new Double(jGeometry.ordinates[i]);
                    }
                }
            }
            aRRAY = jGeometry.ordinates == null ? null : new ARRAY(arrayDescriptor2, connection, (Object)objectArray2);
        }
        objectArray2 = new Object[]{nUMBER, nUMBER2, sTRUCT, aRRAY2, aRRAY};
        return new STRUCT(structDescriptor, connection, objectArray2);
    }

    public static Struct storeJS(JGeometry jGeometry, Connection connection, Object[] objectArray) throws SQLException {
        return JGeometry.storeJS(jGeometry, connection, objectArray, false);
    }

    public static Struct storeJS(JGeometry jGeometry, Connection connection, Object[] objectArray, boolean bl) throws SQLException {
        Array array;
        Object[] objectArray2;
        Object[] objectArray3;
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        if (objectArray != null && objectArray.length >= 4) {
            string = (String)objectArray[0];
            string2 = (String)objectArray[1];
            string3 = (String)objectArray[2];
            string4 = (String)objectArray[3];
        } else {
            if (geomDescStr == null) {
                JGeometry.createDBDescriptorsStr();
            }
            string = geomDescStr;
            string2 = pointDescStr;
            string3 = elemInfoDescStr;
            string4 = ordinatesDescStr;
        }
        if (string == null) {
            throw new SQLException("sdo_geometry descriptor is null.");
        }
        if (string2 == null) {
            throw new SQLException("sdo_point descriptor is null.");
        }
        if (string3 == null) {
            throw new SQLException("elem_info descriptor is null.");
        }
        if (string4 == null) {
            throw new SQLException("ordinates descriptor is null.");
        }
        NUMBER nUMBER = new NUMBER(jGeometry.gtype + jGeometry.linfo * 100 + jGeometry.dim * 1000);
        NUMBER nUMBER2 = jGeometry.srid == 0 ? null : new NUMBER(jGeometry.srid);
        Struct struct = null;
        if (bl) {
            Object[] objectArray4 = objectArray3 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (objectArray3 != null) {
                objectArray3[0] = new NUMBER(new BigDecimal(jGeometry.x));
                objectArray3[1] = new NUMBER(new BigDecimal(jGeometry.y));
                objectArray3[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(new BigDecimal(jGeometry.z));
                struct = connection.createStruct(string2, objectArray3);
            }
        } else {
            Object[] objectArray5 = objectArray3 = Double.isNaN(jGeometry.x) || Double.isNaN(jGeometry.y) ? null : new NUMBER[3];
            if (objectArray3 != null) {
                objectArray3[0] = new NUMBER(jGeometry.x);
                objectArray3[1] = new NUMBER(jGeometry.y);
                objectArray3[2] = Double.isNaN(jGeometry.z) ? null : new NUMBER(jGeometry.z);
                struct = connection.createStruct(string2, objectArray3);
            }
        }
        Object[] objectArray6 = objectArray3 = jGeometry.elemInfo == null ? null : ((OracleConnection)connection).createOracleArray(string3, (Object)jGeometry.elemInfo);
        if (bl) {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new BigDecimal[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new BigDecimal(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new BigDecimal(jGeometry.ordinates[i]);
                    }
                }
            }
            array = jGeometry.ordinates == null ? null : ((OracleConnection)connection).createOracleArray(string4, (Object)objectArray2);
        } else {
            objectArray2 = null;
            if (jGeometry.ordinates != null) {
                objectArray2 = new Double[jGeometry.ordinates.length];
                if (jGeometry.linfo == 0) {
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        objectArray2[i] = new Double(jGeometry.ordinates[i]);
                    }
                } else {
                    if (jGeometry.dim == 2 || jGeometry.dim == 3 && jGeometry.linfo != 3 || jGeometry.dim == 4 && jGeometry.linfo != 3 && jGeometry.linfo != 4) {
                        throw new SQLException("An invalid gtype value for LRS is found");
                    }
                    for (int i = 0; i < jGeometry.ordinates.length; ++i) {
                        if (Double.isNaN(jGeometry.ordinates[i]) && i % jGeometry.dim != jGeometry.linfo - 1) {
                            throw new SQLException("An invalid Double.NaN is found in LRS ordinates");
                        }
                        objectArray2[i] = Double.isNaN(jGeometry.ordinates[i]) ? null : new Double(jGeometry.ordinates[i]);
                    }
                }
            }
            array = jGeometry.ordinates == null ? null : ((OracleConnection)connection).createOracleArray(string4, (Object)objectArray2);
        }
        objectArray2 = new Object[]{nUMBER, nUMBER2, struct, objectArray3, array};
        return connection.createStruct(string, objectArray2);
    }

    @Deprecated
    public static Object[] getOracleDescriptors(Connection connection) throws SQLException {
        StructDescriptor structDescriptor = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        StructDescriptor structDescriptor2 = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        ArrayDescriptor arrayDescriptor = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ArrayDescriptor arrayDescriptor2 = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
        return new Object[]{structDescriptor, structDescriptor2, arrayDescriptor, arrayDescriptor2};
    }

    public static Object[] getOracleDescriptorsStr() throws SQLException {
        String string = "MDSYS.SDO_GEOMETRY";
        String string2 = "MDSYS.SDO_POINT_TYPE";
        String string3 = "MDSYS.SDO_ELEM_INFO_ARRAY";
        String string4 = "MDSYS.SDO_ORDINATE_ARRAY";
        return new Object[]{string, string2, string3, string4};
    }

    protected final boolean isOptimizedPoint() {
        return this.gtype % 100 == 1 && this.ordinates == null && !Double.isNaN(this.x) && !Double.isNaN(this.y);
    }

    protected static final void createDBDescriptors(Connection connection) throws SQLException {
        geomDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
        pointDesc = StructDescriptor.createDescriptor((String)"MDSYS.SDO_POINT_TYPE", (Connection)connection);
        elemInfoDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ELEM_INFO_ARRAY", (Connection)connection);
        ordinatesDesc = ArrayDescriptor.createDescriptor((String)"MDSYS.SDO_ORDINATE_ARRAY", (Connection)connection);
    }

    protected static final void createDBDescriptorsStr() throws SQLException {
        geomDescStr = "MDSYS.SDO_GEOMETRY";
        pointDescStr = "MDSYS.SDO_POINT_TYPE";
        elemInfoDescStr = "MDSYS.SDO_ELEM_INFO_ARRAY";
        ordinatesDescStr = "MDSYS.SDO_ORDINATE_ARRAY";
    }

    protected final boolean isSimpleElement(int n) {
        return n == 1 || n == 2 || n % 10 == 3;
    }

    protected final boolean isCompoundElement(int n) {
        return n == 4 || n % 10 == 5;
    }

    protected static final void expandMBR(double[] dArray, double d, double d2) {
        if (dArray[0] > d) {
            dArray[0] = d;
        }
        if (dArray[1] > d2) {
            dArray[1] = d2;
        }
        if (dArray[2] < d) {
            dArray[2] = d;
        }
        if (dArray[3] < d2) {
            dArray[3] = d2;
        }
    }

    protected static final void expandMBR(double[] dArray, double d, double d2, double d3) {
        if (dArray[0] > d) {
            dArray[0] = d;
        }
        if (dArray[1] > d2) {
            dArray[1] = d2;
        }
        if (dArray[2] > d3) {
            dArray[2] = d3;
        }
        if (dArray[3] < d) {
            dArray[3] = d;
        }
        if (dArray[4] < d2) {
            dArray[4] = d2;
        }
        if (dArray[5] < d3) {
            dArray[5] = d3;
        }
    }

    protected final void expandMBR(double[] dArray, double[] dArray2, int n) {
        for (int i = 0; i < dArray2.length / n; ++i) {
            int n2 = i * n;
            if (n == 2) {
                JGeometry.expandMBR(dArray, dArray2[n2], dArray2[n2 + 1]);
                continue;
            }
            JGeometry.expandMBR(dArray, dArray2[n2], dArray2[n2 + 1], dArray2[n2 + 2]);
        }
    }

    protected final void expandMBR(double[] dArray, double[] dArray2, int n, int n2, int n3) {
        for (int i = 0; i < n2 / n3; ++i) {
            int n4 = n + i * n3;
            if (n3 == 2) {
                JGeometry.expandMBR(dArray, dArray2[n4], dArray2[n4 + 1]);
                continue;
            }
            JGeometry.expandMBR(dArray, dArray2[n4], dArray2[n4 + 1], dArray2[n4 + 2]);
        }
    }

    protected void reOrientCurves() {
    }

    public static final double[] computeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9 = d - d3;
        double d10 = d3 - d5;
        double d11 = d4 - d6;
        double d12 = d2 - d4;
        double d13 = d + d3;
        double d14 = d3 + d5;
        double d15 = d2 + d4;
        double d16 = d4 + d6;
        double d17 = d9 * d11 - d10 * d12;
        if (d17 > -4.9E-323 && d17 < 4.9E-323) {
            return null;
        }
        double[] dArray = new double[6];
        double d18 = (d11 * d13 * d9 - d12 * d14 * d10 + d12 * d11 * (d12 + d11)) / d17;
        double d19 = Math.abs(d4 - d6) < 5.0E-8 ? (d15 * d12 + (d13 - d18) * d9) / d12 : (d16 * d11 + (d14 - d18) * d10) / d11;
        double d20 = Math.sqrt(((d18 *= 0.5) - d) * (d18 - d) + ((d19 *= 0.5) - d2) * (d19 - d2));
        double d21 = Math.atan2(d2 - d19, d - d18);
        if (d21 < 0.0) {
            d21 += Math.PI * 2;
        }
        if ((d8 = Math.atan2(d4 - d19, d3 - d18)) < 0.0) {
            d8 += Math.PI * 2;
        }
        if ((d7 = Math.atan2(d6 - d19, d5 - d18)) < 0.0) {
            d7 += Math.PI * 2;
        }
        dArray[0] = d18;
        dArray[1] = d19;
        dArray[2] = d20;
        dArray[3] = d21;
        dArray[4] = d8;
        dArray[5] = d7;
        return dArray;
    }

    protected static final double[] computeArcMBR(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double[] dArray2 = new double[]{Math.min(d, d5), Math.min(d2, d6), Math.max(d, d5), Math.max(d2, d6)};
        if (JGeometry.thetaInArc(0.0, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 + d9, d8);
        }
        if (JGeometry.thetaInArc(1.5707963267948966, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 + d9);
        }
        if (JGeometry.thetaInArc(Math.PI, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7 - d9, d8);
        }
        if (JGeometry.thetaInArc(4.71238898038469, d10, d12, d13) != 0) {
            JGeometry.expandMBR(dArray2, d7, d8 - d9);
        }
        dArray = new double[]{dArray2[0], dArray2[1], dArray2[0], dArray2[3], dArray2[2], dArray2[3], dArray2[2], dArray2[1]};
        return dArray;
    }

    protected static final short thetaInArc(double d, double d2, double d3, double d4) {
        if (d == d2 || d == d3 || d == d2 + Math.PI * 2 || d == d3 + Math.PI * 2 || d == d2 - Math.PI * 2 || d == d3 - Math.PI * 2) {
            return -1;
        }
        int n = 0;
        if (d4 > 0.0) {
            n = (short)(n + 1);
        }
        if (d3 > d2) {
            n = (short)(n + 1);
        }
        if (d2 < d && d < d3 || d2 > d && d > d3) {
            n = (short)(n + 1);
        }
        return (short)(n & 1);
    }

    protected static final double orientation(double d, double d2, double d3, double d4, double d5, double d6) {
        return d * d4 + d3 * d6 + d5 * d2 - (d5 * d4 + d3 * d2 + d * d6);
    }

    public static double[] expandCircle(double d, double d2, double d3, double d4, double d5, double d6) {
        int n = 4;
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[3];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d14 = d10;
        double d15 = d12;
        if (d13 > 0.0) {
            d15 = 1.0;
        } else if (d13 < 0.0) {
            d15 = -1.0;
        }
        double[] dArray2 = new double[10];
        for (int i = 0; i <= n; ++i) {
            double d16 = d14 + (double)i * 1.5707963267948966 * d15;
            dArray2[i * 2] = d7 + d9 * Math.cos(d16);
            dArray2[i * 2 + 1] = d8 + d9 * Math.sin(d16);
        }
        dArray2[0] = d;
        dArray2[1] = d2;
        dArray2[8] = d;
        dArray2[9] = d2;
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, int n) {
        int n2 = n - 1;
        if (n2 < 1) {
            double[] dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d7 = dArray[0];
        double d8 = dArray[1];
        double d9 = dArray[2];
        double d10 = dArray[3];
        double d11 = dArray[4];
        double d12 = dArray[5];
        double d13 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        double d14 = d10;
        double d15 = d12;
        if (d13 > 0.0 && d15 < d14) {
            d15 += Math.PI * 2;
        } else if (d13 < 0.0 && d15 > d14) {
            d15 -= Math.PI * 2;
        }
        double d16 = d12 - d10;
        if (d13 > 0.0 && d16 < 0.0) {
            d16 += Math.PI * 2;
        } else if (d13 < 0.0 && d16 > 0.0) {
            d16 -= Math.PI * 2;
        }
        double d17 = Math.abs(d16) / (double)n2;
        double d18 = Math.sin(d17);
        double d19 = Math.cos(d17);
        if (d13 > 0.0) {
            d18 = -d18;
        }
        double d20 = d - d7;
        double d21 = d2 - d8;
        double[] dArray2 = new double[(n2 + 1) * 2];
        dArray2[0] = d;
        dArray2[1] = d2;
        double d22 = 0.0;
        for (int i = 1; i < n2; ++i) {
            d22 = d20 * d19 + d21 * d18;
            d21 = -d20 * d18 + d21 * d19;
            d20 = d22;
            dArray2[2 * i] = d7 + d20;
            dArray2[2 * i + 1] = d8 + d21;
        }
        dArray2[(n2 + 1) * 2 - 2] = d5;
        dArray2[(n2 + 1) * 2 - 1] = d6;
        return dArray2;
    }

    private static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6, double d7, boolean bl) {
        double d8;
        int n;
        if (d7 <= 0.0) {
            return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, 0);
        }
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        if (dArray == null) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d9 = dArray[0];
        double d10 = dArray[1];
        double d11 = dArray[2];
        double d12 = dArray[3];
        double d13 = dArray[4];
        double d14 = dArray[5];
        double d15 = JGeometry.orientation(d, d2, d3, d4, d5, d6);
        if (bl) {
            d7 = d11 * (1.0 - Math.cos(Math.asin(d7 / (2.0 * d11))));
        }
        double d16 = d14 - d12;
        if (d15 > 0.0 && d16 < 0.0) {
            d16 += Math.PI * 2;
        } else if (d15 < 0.0 && d16 > 0.0) {
            d16 -= Math.PI * 2;
        }
        if (d16 < 0.0) {
            d16 = -d16;
        }
        if ((n = (int)Math.ceil(d16 / (d8 = Math.acos(1.0 - d7 / d11) * 2.0))) > 1000) {
            n = 1000;
        }
        if (n < 2) {
            dArray = new double[]{d, d2, d3, d4, d5, d6};
            return dArray;
        }
        double d17 = Math.abs(d16) / (double)n;
        double d18 = Math.sin(d17);
        double d19 = Math.cos(d17);
        if (d15 > 0.0) {
            d18 = -d18;
        }
        double d20 = d - d9;
        double d21 = d2 - d10;
        double[] dArray2 = new double[(n + 1) * 2];
        dArray2[0] = d;
        dArray2[1] = d2;
        double d22 = 0.0;
        for (int i = 1; i < n; ++i) {
            d22 = d20 * d19 + d21 * d18;
            d21 = -d20 * d18 + d21 * d19;
            d20 = d22;
            dArray2[2 * i] = d9 + d20;
            dArray2[2 * i + 1] = d10 + d21;
        }
        dArray2[(n + 1) * 2 - 2] = d5;
        dArray2[(n + 1) * 2 - 1] = d6;
        return dArray2;
    }

    public static double[] linearizeArc(double d, double d2, double d3, double d4, double d5, double d6) {
        double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
        double d7 = dArray[2] / 250.0;
        return JGeometry.linearizeArc(d, d2, d3, d4, d5, d6, d7, false);
    }

    public static double[] reFormulateArc(double[] dArray) {
        double[] dArray2 = JGeometry.computeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (dArray2 == null) {
            dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]};
            return dArray2;
        }
        double d = dArray2[0];
        double d2 = dArray2[1];
        double d3 = dArray2[2];
        double d4 = -dArray2[3];
        double d5 = dArray2[4];
        double d6 = -dArray2[5];
        double d7 = -JGeometry.orientation(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5]);
        if (d7 > 0.0 && d6 < d4) {
            if ((d6 += Math.PI * 2) > Math.PI * 2) {
                d6 -= Math.PI * 2;
                d4 -= Math.PI * 2;
            }
        } else if (d7 < 0.0 && d6 > d4 && (d6 -= Math.PI * 2) < Math.PI * -2) {
            d6 += Math.PI * 2;
            d4 += Math.PI * 2;
        }
        double[] dArray3 = new double[]{d, d2, d3, d4, d5, d6};
        return dArray3;
    }

    protected static final double[] closeCoords(double[] dArray, int n) {
        int n2 = dArray.length / n - 1;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (dArray[0 + i] == dArray[n2 * n + i]) continue;
            bl = false;
        }
        if (bl) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length + n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        ++n2;
        for (int i = 0; i < n; ++i) {
            dArray2[n2 * n + i] = dArray2[i];
        }
        return dArray2;
    }

    private static double[] closeCoordsInternalLRS(double[] dArray, int n, boolean bl) {
        int n2;
        int n3 = dArray.length / n - 1;
        boolean bl2 = true;
        if (!bl) {
            for (n2 = 0; n2 < n; ++n2) {
                if (dArray[0 + n2] == dArray[n3 * n + n2]) continue;
                bl2 = false;
            }
        } else {
            for (n2 = 0; n2 < n - 1; ++n2) {
                if (dArray[0 + n2] == dArray[n3 * n + n2]) continue;
                bl2 = false;
            }
        }
        if (bl2) {
            return dArray;
        }
        double[] dArray2 = new double[dArray.length + n];
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
        ++n3;
        for (int i = 0; i < n; ++i) {
            dArray2[n3 * n + i] = dArray2[i];
        }
        return dArray2;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.gtype);
        objectOutputStream.writeInt(this.linfo);
        objectOutputStream.writeInt(this.srid);
        objectOutputStream.writeDouble(this.x);
        objectOutputStream.writeDouble(this.y);
        objectOutputStream.writeDouble(this.z);
        objectOutputStream.writeObject(this.elemInfo);
        objectOutputStream.writeObject(this.ordinates);
        objectOutputStream.writeInt(this.dim);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.gtype = objectInputStream.readInt();
        this.linfo = objectInputStream.readInt();
        this.srid = objectInputStream.readInt();
        this.x = objectInputStream.readDouble();
        this.y = objectInputStream.readDouble();
        this.z = objectInputStream.readDouble();
        this.elemInfo = (int[])objectInputStream.readObject();
        this.ordinates = (double[])objectInputStream.readObject();
        this.dim = objectInputStream.readInt();
    }

    public long getSize() {
        return 40 + (this.elemInfo == null ? 0 : 4 * this.elemInfo.length) + (this.ordinates == null ? 0 : 8 * this.ordinates.length);
    }

    public String toString() {
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        return string;
    }

    public String toStringFull() {
        int n;
        if (this == null) {
            return "NULL JGeometry";
        }
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        if (this.isOptimizedPoint()) {
            string = string + ", Point=(";
            string = string + this.x + "," + this.y;
            if (this.dim > 2) {
                string = string + "," + this.z;
            }
            string = string + "))";
            return string;
        }
        string = string + ",  \n ElemInfo(";
        for (n = 0; n < this.elemInfo.length - 1; ++n) {
            string = string + this.elemInfo[n] + ",";
        }
        string = string + this.elemInfo[this.elemInfo.length - 1] + ")";
        string = string + ",  \n Ordinates(";
        for (n = 0; n < this.ordinates.length / this.dim; ++n) {
            for (int i = 0; i < this.dim; ++i) {
                string = string + this.ordinates[i + n * this.dim];
                if (i >= this.dim - 1) continue;
                string = string + ",";
            }
            string = string + "\n";
        }
        string = string + "))";
        return string;
    }

    public String toStringFull(int n) {
        int n2;
        if (this == null) {
            return "NULL JGeometry";
        }
        DecimalFormat decimalFormat = new DecimalFormat();
        ((NumberFormat)decimalFormat).setMaximumFractionDigits(n);
        ((NumberFormat)decimalFormat).setMinimumFractionDigits(n);
        ((NumberFormat)decimalFormat).setGroupingUsed(false);
        String string = "JGeometry (gtype=" + this.gtype + ", dim=" + this.dim + ", srid=" + this.srid;
        if (this.isOptimizedPoint()) {
            String string2 = decimalFormat.format(this.x).toString();
            String string3 = decimalFormat.format(this.y).toString();
            string = string + ", Point=(";
            string = string + string2 + "," + string3;
            if (this.dim > 2) {
                string = string + "," + decimalFormat.format(this.z).toString();
            }
            string = string + "))";
            return string;
        }
        string = string + ",  \n ElemInfo(";
        for (n2 = 0; n2 < this.elemInfo.length - 1; ++n2) {
            string = string + this.elemInfo[n2] + ",";
        }
        string = string + this.elemInfo[this.elemInfo.length - 1] + ")";
        string = string + ",  \n Ordinates(";
        for (n2 = 0; n2 < this.ordinates.length / this.dim; ++n2) {
            for (int i = 0; i < this.dim; ++i) {
                double d = this.ordinates[i + n2 * this.dim];
                String string4 = decimalFormat.format(d).toString();
                string = string + string4;
                if (i >= this.dim - 1) continue;
                string = string + ",";
            }
            string = string + "\n";
        }
        string = string + "))";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof JGeometry)) {
            return false;
        }
        JGeometry jGeometry = (JGeometry)object;
        return this.getType() == jGeometry.getType() && Arrays.equals(this.getPoint(), jGeometry.getPoint()) && Arrays.equals(this.getElemInfo(), jGeometry.getElemInfo()) && Arrays.equals(this.getOrdinatesArray(), jGeometry.getOrdinatesArray());
    }

    public static final JGeometry load(byte[] byArray) throws Exception {
        if (byArray == null || byArray.length < 8) {
            return null;
        }
        return SdoPickler.unpickle(byArray);
    }

    public static byte[] store(JGeometry jGeometry) throws Exception {
        return SdoPickler.pickle(jGeometry);
    }

    @Deprecated
    public static final STRUCT store(Connection connection, JGeometry jGeometry) throws Exception {
        Object[] objectArray = JGeometry.getOracleDescriptors(connection);
        return JGeometry.store(jGeometry, connection, objectArray);
    }

    public static final Struct storeJS(Connection connection, JGeometry jGeometry) throws Exception {
        Object[] objectArray = JGeometry.getOracleDescriptorsStr();
        return JGeometry.storeJS(jGeometry, connection, objectArray);
    }

    public static final STRUCT store(Connection connection, JGeometry jGeometry, StructDescriptor structDescriptor) throws Exception {
        if (structDescriptor == null) {
            geomDesc = JGeometry.getGeomDescriptor(connection);
            return new STRUCT(geomDesc, SdoPickler.pickle(jGeometry), connection);
        }
        return new STRUCT(structDescriptor, SdoPickler.pickle(jGeometry), connection);
    }

    public static StructDescriptor getGeomDescriptor(Connection connection) throws SQLException {
        return StructDescriptor.createDescriptor((String)"MDSYS.SDO_GEOMETRY", (Connection)connection);
    }

    public static String byteArrayToHexString(byte[] byArray) {
        byte by = 0;
        if (byArray == null || byArray.length <= 0) {
            return null;
        }
        String[] stringArray = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F"};
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(byArray[i] & 0xF0);
            by = (byte)(by >>> 4);
            by = (byte)(by & 0xF);
            stringBuffer.append(stringArray[by]);
            by = (byte)(byArray[i] & 0xF);
            stringBuffer.append(stringArray[by]);
        }
        String string = new String(stringBuffer);
        return string;
    }

    public final JGeometry projectToLTP(double d, double d2) throws DataException {
        boolean bl;
        if (this.srid == 0) {
            return null;
        }
        Gc_trans gc_trans = new Gc_trans(d, d2);
        if (this.isOptimizedPoint()) {
            JGeometry jGeometry = new JGeometry(this.x, this.y, 0);
            double[] dArray = new double[3];
            dArray[0] = this.x;
            dArray[1] = this.y;
            boolean bl2 = this.lltogXYZ(dArray, gc_trans);
            double[] dArray2 = new double[]{dArray[0], dArray[1], dArray[2], dArray[0], dArray[1], dArray[2]};
            double[] dArray3 = new double[3];
            bl2 = this.gxyzgmcenter(dArray3, dArray2, gc_trans);
            LT_transform lT_transform = new LT_transform(dArray3[0], dArray3[1], gc_trans);
            bl2 = this.ltxform(dArray, lT_transform);
            jGeometry.x = dArray[0];
            jGeometry.y = dArray[1];
            jGeometry.lttpH = lT_transform;
            jGeometry.gtransH = gc_trans;
            return jGeometry;
        }
        double[] dArray = new double[3 * (this.ordinates.length / 2)];
        double[] dArray4 = new double[3];
        for (int i = 0; i < dArray.length / 3; ++i) {
            dArray4[0] = this.ordinates[2 * i];
            dArray4[1] = this.ordinates[2 * i + 1];
            dArray4[2] = 0.0;
            bl = this.lltogXYZ(dArray4, gc_trans);
            dArray[i * 3] = dArray4[0];
            dArray[i * 3 + 1] = dArray4[1];
            dArray[i * 3 + 2] = dArray4[2];
        }
        double[] dArray5 = new double[6];
        dArray5[0] = dArray5[3] = dArray[0];
        dArray5[1] = dArray5[4] = dArray[1];
        dArray5[2] = dArray5[5] = dArray[2];
        for (int i = 0; i < dArray.length / 3; ++i) {
            if (dArray5[0] > dArray[i * 3]) {
                dArray5[0] = dArray[i * 3];
            }
            if (dArray5[1] > dArray[i * 3 + 1]) {
                dArray5[1] = dArray[i * 3 + 1];
            }
            if (dArray5[2] > dArray[i * 3 + 2]) {
                dArray5[2] = dArray[i * 3 + 2];
            }
            if (dArray5[3] < dArray[i * 3]) {
                dArray5[3] = dArray[i * 3];
            }
            if (dArray5[4] < dArray[i * 3 + 1]) {
                dArray5[4] = dArray[i * 3 + 1];
            }
            if (!(dArray5[5] < dArray[i * 3 + 2])) continue;
            dArray5[5] = dArray[i * 3 + 2];
        }
        double[] dArray6 = new double[3];
        bl = this.gxyzgmcenter(dArray6, dArray5, gc_trans);
        LT_transform lT_transform = new LT_transform(dArray6[0], dArray6[1], gc_trans);
        double[] dArray7 = new double[2 * (dArray.length / 3)];
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (int i = 0; i < dArray.length / 3; ++i) {
            dArray4[0] = dArray[i * 3];
            dArray4[1] = dArray[i * 3 + 1];
            dArray4[2] = dArray[i * 3 + 2];
            bl = this.ltxform(dArray4, lT_transform);
            dArray7[2 * i] = dArray4[0];
            dArray7[2 * i + 1] = dArray4[1];
            if (dArray7[2 * i] < d6) {
                d6 = dArray7[2 * i];
            }
            if (dArray7[2 * i] > d4) {
                d4 = dArray7[2 * i];
            }
            if (dArray7[2 * i + 1] < d5) {
                d5 = dArray7[2 * i + 1];
            }
            if (!(dArray7[2 * i + 1] > d3)) continue;
            d3 = dArray7[2 * i + 1];
        }
        if (d4 - d6 > 1.274E7 || d3 - d5 > 1.274E7) {
            throw new DataException("Buffer Distance Too large for LTP");
        }
        JGeometry jGeometry = new JGeometry(this.gtype, 0, this.elemInfo, dArray7);
        jGeometry.lttpH = lT_transform;
        jGeometry.gtransH = gc_trans;
        return jGeometry;
    }

    public final JGeometry projectFromLTP() throws DataException {
        int n;
        if (this.isOptimizedPoint()) {
            JGeometry jGeometry = new JGeometry(this.x, this.y, this.gtransH.txsrid);
            double[] dArray = new double[]{this.x, this.y, 0.0};
            boolean bl = this.iltxform(dArray, this.lttpH, this.gtransH);
            bl = this.gXYZtoll(dArray, this.gtransH);
            jGeometry.x = dArray[0] / this.gtransH.unitfactor;
            jGeometry.y = dArray[1] / this.gtransH.unitfactor;
            jGeometry.setSRID(this.getSRID());
            return jGeometry;
        }
        double[] dArray = new double[this.ordinates.length];
        double[] dArray2 = new double[3];
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (n = 0; n < this.ordinates.length / 2; ++n) {
            if (this.ordinates[2 * n] < d4) {
                d4 = this.ordinates[2 * n];
            }
            if (this.ordinates[2 * n] > d2) {
                d2 = this.ordinates[2 * n];
            }
            if (this.ordinates[2 * n + 1] < d3) {
                d3 = this.ordinates[2 * n + 1];
            }
            if (!(this.ordinates[2 * n + 1] > d)) continue;
            d = this.ordinates[2 * n + 1];
        }
        if (d2 - d4 > 1.274E7 || d - d3 > 1.274E7) {
            throw new DataException("Buffer Distance Too large for LTP");
        }
        for (n = 0; n < this.ordinates.length / 2; ++n) {
            dArray2[0] = this.ordinates[2 * n];
            dArray2[1] = this.ordinates[2 * n + 1];
            dArray2[2] = 0.0;
            boolean bl = this.iltxform(dArray2, this.lttpH, this.gtransH);
            bl = this.gXYZtoll(dArray2, this.gtransH);
            dArray[2 * n] = dArray2[0] / this.gtransH.unitfactor;
            dArray[2 * n + 1] = dArray2[1] / this.gtransH.unitfactor;
        }
        JGeometry jGeometry = new JGeometry(this.gtype, this.getSRID(), this.elemInfo, dArray);
        return jGeometry;
    }

    public final JGeometry projectToGNM_longLat() throws DataException {
        double d = 0.0;
        double d2 = 0.0;
        double[] dArray = this.getMBR();
        double[] dArray2 = new double[dArray.length / 2];
        for (int i = 0; i < dArray.length / 2; ++i) {
            dArray2[i] = (dArray[i + dArray.length / 2] + dArray[i]) / 2.0;
        }
        d = Math.PI / 180 * dArray2[0];
        d2 = Math.PI / 180 * dArray2[1];
        if (this.getType() == 1) {
            d /= 2.0;
            d2 /= 2.0;
        }
        return this.projectToGNM_longLat(d, d2);
    }

    public final JGeometry projectToGNM_longLat(double d, double d2) throws DataException {
        double[] dArray;
        double[] dArray2;
        int[] nArray;
        JGeometry jGeometry = null;
        double d3 = 6378000.0;
        if (this.getElemInfo() == null) {
            nArray = new int[]{1, 1, 1};
        } else {
            nArray = new int[this.getElemInfo().length];
            for (int i = 0; i < this.getElemInfo().length; ++i) {
                nArray[i] = this.getElemInfo()[i];
            }
        }
        if (this.getOrdinatesArray() == null) {
            if (this.dim == 2) {
                dArray2 = new double[2];
                dArray = new double[]{this.x, this.y};
            } else {
                dArray2 = new double[3];
                dArray = new double[]{this.x, this.y, this.z};
            }
        } else {
            dArray2 = new double[this.getOrdinatesArray().length];
            dArray = new double[this.getOrdinatesArray().length];
            for (int i = 0; i < this.getOrdinatesArray().length; ++i) {
                dArray[i] = this.getOrdinatesArray()[i];
            }
        }
        int n = 0;
        double[] dArray3 = this.getMBR();
        for (int i = 0; i < dArray.length / (dArray3.length / 2); ++i) {
            double d4 = Math.PI / 180 * dArray[dArray3.length / 2 * i];
            double d5 = Math.PI / 180 * dArray[dArray3.length / 2 * i + 1];
            double d6 = 0.0;
            if (dArray3.length == 6) {
                d6 = dArray[dArray3.length / 2 * i + 2];
            }
            double d7 = Math.sin(d2) * Math.sin(d5) + Math.cos(d2) * Math.cos(d5) * Math.cos(d4 - d);
            double d8 = 0.0;
            double d9 = 0.0;
            if (Math.abs(d2 - 1.5707963267948966) <= 1.0E-16) {
                d8 = 1.0 / Math.tan(d5) * Math.sin(d4 - d);
                d9 = -1.0 / Math.tan(d5) * Math.cos(d4 - d);
            } else if (Math.abs(d2 - -1.5707963267948966) <= 1.0E-16) {
                d8 = -1.0 / Math.tan(d5) * Math.sin(d4 - d);
                d9 = 1.0 / Math.tan(d5) * Math.cos(d4 - d);
            } else if (Math.abs(d2) <= 1.0E-16) {
                d8 = Math.tan(d4 - d);
                d9 = Math.tan(d5) / Math.cos(d4 - d);
            } else {
                d8 = Math.cos(d5) * Math.sin(d4 - d) / d7;
                d9 = (Math.cos(d2) * Math.sin(d5) - Math.sin(d2) * Math.cos(d5) * Math.cos(d4 - d)) / d7;
            }
            dArray2[n] = d3 * d8;
            dArray2[++n] = d3 * d9;
            ++n;
            if (dArray3.length != 6) continue;
            dArray2[n] = d6;
            ++n;
        }
        jGeometry = new JGeometry(this.getType(), 0, nArray, dArray2);
        int n2 = this.dim;
        int n3 = this.linfo;
        jGeometry.dim = n2;
        jGeometry.linfo = n3;
        return jGeometry;
    }

    public final JGeometry projectFromGNM_longLat(double d, double d2) throws DataException {
        double[] dArray;
        double[] dArray2;
        int[] nArray;
        JGeometry jGeometry = null;
        double d3 = 6378000.0;
        if (this.getElemInfo() == null) {
            nArray = new int[]{1, 1, 1};
        } else {
            nArray = new int[this.getElemInfo().length];
            for (int i = 0; i < this.getElemInfo().length; ++i) {
                nArray[i] = this.getElemInfo()[i];
            }
        }
        if (this.getOrdinatesArray() == null) {
            if (this.dim == 2) {
                dArray2 = new double[2];
                dArray = new double[]{this.x, this.y};
            } else {
                dArray2 = new double[3];
                dArray = new double[]{this.x, this.y, this.z};
            }
        } else {
            dArray2 = new double[this.getOrdinatesArray().length];
            dArray = new double[this.getOrdinatesArray().length];
            for (int i = 0; i < this.getOrdinatesArray().length; ++i) {
                dArray[i] = this.getOrdinatesArray()[i];
            }
        }
        int n = 0;
        double[] dArray3 = this.getMBR();
        for (int i = 0; i < dArray.length / (dArray3.length / 2); ++i) {
            double d4 = dArray[dArray3.length / 2 * i] / d3;
            double d5 = dArray[dArray3.length / 2 * i + 1] / d3;
            double d6 = 0.0;
            if (dArray3.length == 6) {
                d6 = dArray[dArray3.length / 2 * i + 2];
            }
            double d7 = Math.sqrt(d4 * d4 + d5 * d5);
            double d8 = Math.atan2(d7, 1.0);
            double d9 = 0.0;
            d9 = d7 <= 1.0E-16 ? d2 : Math.asin(Math.cos(d8) * Math.sin(d2) + d5 * Math.sin(d8) * Math.cos(d2) / d7);
            double d10 = 0.0;
            d10 = Math.abs(d2 - 1.5707963267948966) <= 1.0E-16 ? d + Math.atan2(d4, -d5) : (Math.abs(d2 - -1.5707963267948966) <= 1.0E-16 ? d + Math.atan2(d4, d5) : d + Math.atan2(d4 * Math.sin(d8), d7 * Math.cos(d2) * Math.cos(d8) - d5 * Math.sin(d2) * Math.sin(d8)));
            dArray2[n] = 57.29577951308232 * d10;
            dArray2[++n] = 57.29577951308232 * d9;
            ++n;
            if (dArray3.length != 6) continue;
            dArray2[n] = d6;
            ++n;
        }
        jGeometry = new JGeometry(this.getType(), this.getSRID(), nArray, dArray2);
        int n2 = this.dim;
        int n3 = this.linfo;
        jGeometry.dim = n2;
        jGeometry.linfo = n3;
        return jGeometry;
    }

    public final JGeometry densifyArcs(double d) {
        return this.densifyArcs(d, false);
    }

    public JGeometry densifyArcs(double d, boolean bl) {
        int n;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        ArrayList<Double> arrayList2 = new ArrayList<Double>();
        int n2 = this.dim * 1000 + this.linfo * 100 + this.gtype;
        if (this.isOptimizedPoint()) {
            return new JGeometry(this.x, this.y, this.srid);
        }
        if (this.isPoint() || this.isMultiPoint()) {
            return new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
        }
        if (this.isCircle()) {
            double[] dArray = JGeometry.expandCircle(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
            int[] nArray = new int[]{1, 1003, 1};
            double[] dArray2 = JGeometry.linearizeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], d, bl);
            for (int i = 0; i < dArray2.length; ++i) {
                arrayList2.add(new Double(dArray2[i]));
            }
            double[] dArray3 = JGeometry.linearizeArc(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], d, bl);
            for (int i = 2; i < dArray3.length; ++i) {
                arrayList2.add(new Double(dArray3[i]));
            }
            double[] dArray4 = new double[arrayList2.size()];
            for (int i = 0; i < arrayList2.size(); ++i) {
                dArray4[i] = (Double)arrayList2.get(i);
            }
            return new JGeometry(this.gtype, this.srid, nArray, dArray4);
        }
        ElementIterator elementIterator = new ElementIterator(this);
        block3: while (elementIterator.next()) {
            int n3 = elementIterator.ord_offset;
            if (elementIterator.isCompound && elementIterator.isFirstElemOfCompound || !elementIterator.isCompound) {
                arrayList.add(new Integer(arrayList2.size() + 1));
                n = elementIterator.original_etype;
                if (n == 4) {
                    n = 2;
                } else if (n == 1005) {
                    n = 1003;
                } else if (n == 2005) {
                    n = 2003;
                }
                arrayList.add(new Integer(n));
                if (elementIterator.eitpr == 3) {
                    arrayList.add(new Integer(1));
                } else {
                    arrayList.add(new Integer(1));
                }
            }
            for (n = 0; n < elementIterator.nCoord - 1; ++n) {
                if (elementIterator.eitpr == 1) {
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim]));
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 1]));
                    if (!(elementIterator.lastElem && n == elementIterator.nCoord - 2 || !elementIterator.isCompound && n == elementIterator.nCoord - 2) && (!elementIterator.isCompound || n != elementIterator.nCoord - 2 || elementIterator.nSubElement != 1)) continue;
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 2]));
                    arrayList2.add(new Double(this.ordinates[n3 + n * this.dim + 3]));
                    continue;
                }
                if (elementIterator.eitpr == 2) {
                    if (n3 + n * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n3 + n * this.dim >= elementIterator.next_ord_offset - this.dim || (elementIterator.next_ord_offset - (n3 + n * this.dim)) / this.dim < 2) continue block3;
                    double[] dArray = JGeometry.linearizeArc(this.ordinates[n3 + n * this.dim], this.ordinates[n3 + n * this.dim + 1], this.ordinates[n3 + (n + 1) * this.dim], this.ordinates[n3 + (n + 1) * this.dim + 1], this.ordinates[n3 + (n + 2) * this.dim], this.ordinates[n3 + (n + 2) * this.dim + 1], d, bl);
                    for (int i = 0; i < dArray.length - 2; ++i) {
                        arrayList2.add(new Double(dArray[i]));
                    }
                    if (elementIterator.lastElem && n == elementIterator.nCoord - 3 || !elementIterator.isCompound && n == elementIterator.nCoord - 3 || elementIterator.isCompound && n == elementIterator.nCoord - 3 && elementIterator.nSubElement == 1) {
                        arrayList2.add(new Double(dArray[dArray.length - 2]));
                        arrayList2.add(new Double(dArray[dArray.length - 1]));
                    }
                    if (++n >= elementIterator.nCoord - 1 && elementIterator.top_etype != 3 && elementIterator.top_etype != 5) continue;
                }
                if (elementIterator.eitpr == 3) {
                    double d2 = this.ordinates[n3 + 0];
                    double d3 = this.ordinates[n3 + 1];
                    double d4 = this.ordinates[n3 + this.dim];
                    double d5 = this.ordinates[n3 + this.dim + 1];
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d3));
                    arrayList2.add(new Double(d4));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d5));
                    arrayList2.add(new Double(d2));
                    arrayList2.add(new Double(d3));
                    ++n;
                    continue;
                }
                if (elementIterator.eitpr != 4) continue;
                if (n3 + n * this.dim >= elementIterator.next_ord_offset || elementIterator.lastElem && n3 + n * this.dim >= elementIterator.next_ord_offset - this.dim) continue block3;
                double[] dArray = JGeometry.expandCircle(this.ordinates[n3 + n * this.dim], this.ordinates[n3 + n * this.dim + 1], this.ordinates[n3 + (n + 1) * this.dim], this.ordinates[n3 + (n + 1) * this.dim + 1], this.ordinates[n3 + (n + 2) * this.dim], this.ordinates[n3 + (n + 2) * this.dim + 1]);
                int[] nArray = new int[]{1, 1003, 1};
                double[] dArray5 = JGeometry.linearizeArc(dArray[0], dArray[1], dArray[2], dArray[3], dArray[4], dArray[5], d, bl);
                for (int i = 0; i < dArray5.length; ++i) {
                    arrayList2.add(new Double(dArray5[i]));
                }
                double[] dArray6 = JGeometry.linearizeArc(dArray[4], dArray[5], dArray[6], dArray[7], dArray[8], dArray[9], d, bl);
                for (int i = 2; i < dArray6.length; ++i) {
                    arrayList2.add(new Double(dArray6[i]));
                }
                n += 2;
            }
        }
        double[] dArray = new double[arrayList2.size()];
        for (n = 0; n < arrayList2.size(); ++n) {
            dArray[n] = (Double)arrayList2.get(n);
        }
        int[] nArray = new int[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            nArray[i] = (Integer)arrayList.get(i);
        }
        return new JGeometry(this.gtype, this.srid, nArray, dArray);
    }

    private double[] simplify(double[] dArray, double d) {
        int n = dArray.length / this.dim;
        int[] nArray = new int[n];
        if (d <= 0.0 || dArray.length < 4) {
            double[] dArray2 = new double[dArray.length];
            for (int i = 0; i < dArray.length; ++i) {
                dArray2[i] = dArray[i];
            }
            return dArray2;
        }
        int n2 = 0;
        int n3 = 0;
        nArray[n3++] = 0;
        int n4 = n - 1;
        nArray[n4] = n - 1;
        int n5 = 0;
        do {
            double d2;
            int n6;
            int n7;
            int n8 = nArray[n4];
            int n9 = 2 * n2;
            int n10 = 2 * n8;
            double d3 = dArray[n10] - dArray[n9];
            double d4 = dArray[n10 + 1] - dArray[n9 + 1];
            double d5 = Math.sqrt(d3 * d3 + d4 * d4);
            double d6 = 0.0;
            if (d5 <= d) {
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d3 = dArray[n6] - dArray[n9];
                    d4 = dArray[n6 + 1] - dArray[n9 + 1];
                    d2 = Math.sqrt(d3 * d3 + d4 * d4);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
            } else if (Math.abs(d3) <= Math.abs(d4)) {
                double d7 = d3 / d4;
                double d8 = d7 * dArray[n9 + 1];
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d2 = Math.abs(dArray[n6] - dArray[n9] + d8 - d7 * dArray[n6 + 1]);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
                d6 = Math.abs(d6 * d4 / d5);
            } else {
                double d9 = d4 / d3;
                double d10 = d9 * dArray[n9];
                for (n7 = n2 + 1; n7 < n8; ++n7) {
                    n6 = 2 * n7;
                    d2 = Math.abs(dArray[n6 + 1] - dArray[n9 + 1] + d10 - d9 * dArray[n6]);
                    if (!(d2 >= d6)) continue;
                    d6 = d2;
                    n5 = n7;
                }
                d6 = Math.abs(d6 * d3 / d5);
            }
            if (d6 > d) {
                nArray[--n4] = n5;
                continue;
            }
            nArray[n3++] = n8;
            ++n4;
            n2 = n8;
        } while (n4 < n);
        double[] dArray3 = new double[n3 * 2];
        for (n4 = 0; n4 < n3; ++n4) {
            n2 = nArray[n4];
            dArray3[n4 * 2] = dArray[2 * n2];
            dArray3[n4 * 2 + 1] = dArray[2 * n2 + 1];
        }
        return dArray3;
    }

    public JGeometry simplify(double d, double d2, double d3) throws Exception, SQLException {
        if (d2 == 0.0 || d3 == 0.0) {
            return this.simplify(d);
        }
        JGeometry jGeometry = this.projectToLTP(d2, 1.0 / d3);
        JGeometry jGeometry2 = jGeometry.simplify(d);
        jGeometry2.lttpH = jGeometry.lttpH;
        jGeometry2.gtransH = jGeometry.gtransH;
        jGeometry2.setSRID(this.getSRID());
        return jGeometry2.projectFromLTP();
    }

    public final JGeometry simplify(double d) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = this.elemInfo.length / 3;
        double[][] dArrayArray = new double[n6][];
        for (n5 = 0; n5 < n6; ++n5) {
            int n7 = n5 == n6 - 1 ? this.ordinates.length - 2 : this.elemInfo[3 * (n5 + 1)] - 3;
            int n8 = this.elemInfo[3 * n5] - 1;
            double[] dArray = new double[n7 - n8 + 2];
            int n9 = 0;
            n4 = this.elemInfo[3 * n5] - 1;
            while (n4 <= n7) {
                dArray[2 * n9] = this.ordinates[n4];
                dArray[2 * n9 + 1] = this.ordinates[n4 + 1];
                n4 += 2;
                ++n9;
            }
            dArrayArray[n5] = this.simplify(dArray, d);
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            if (this.elemInfo[3 * i + 1] == 1003 || this.elemInfo[3 * i + 1] == 2003) {
                if (dArrayArray[i].length == 4) {
                    n5 += 4;
                    continue;
                }
                if (dArrayArray[i].length == 6) {
                    n5 += 4;
                    continue;
                }
                n5 += dArrayArray[i].length;
                continue;
            }
            n5 += dArrayArray[i].length;
        }
        double[] dArray = new double[n5];
        int[] nArray = new int[3 * n6];
        n4 = 1;
        for (n3 = 0; n3 < n6; ++n3) {
            if (this.elemInfo[3 * n3 + 1] == 1003 || this.elemInfo[3 * n3 + 1] == 2003) {
                if (dArrayArray[n3].length == 4) {
                    nArray[3 * n3] = n4;
                    nArray[3 * n3 + 1] = 2;
                    nArray[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 2; ++n2) {
                        dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                    }
                    dArray[(n4 += 2) - 1] = this.ordinates[this.elemInfo[3 * n3] + 1];
                    dArray[n4] = this.ordinates[this.elemInfo[3 * n3] + 2];
                    n4 += 2;
                    continue;
                }
                if (dArrayArray[n3].length == 6) {
                    nArray[3 * n3] = n4;
                    nArray[3 * n3 + 1] = 2;
                    nArray[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 4; ++n2) {
                        dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                    }
                    n4 += 4;
                    continue;
                }
                nArray[3 * n3] = n4;
                nArray[3 * n3 + 1] = this.elemInfo[3 * n3 + 1];
                nArray[3 * n3 + 2] = 1;
                for (n2 = 0; n2 < dArrayArray[n3].length; ++n2) {
                    dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
                }
                n4 += dArrayArray[n3].length;
                continue;
            }
            nArray[3 * n3] = n4;
            nArray[3 * n3 + 1] = this.elemInfo[3 * n3 + 1];
            nArray[3 * n3 + 2] = 1;
            for (n2 = 0; n2 < dArrayArray[n3].length; ++n2) {
                dArray[n2 + n4 - 1] = dArrayArray[n3][n2];
            }
            n4 += dArrayArray[n3].length;
        }
        n3 = 0;
        n2 = 0;
        int n10 = 0;
        for (n = 0; n < n6; ++n) {
            if (nArray[3 * n + 1] == 1003) {
                ++n2;
                continue;
            }
            if (nArray[3 * n + 1] == 2) {
                ++n10;
                continue;
            }
            ++n3;
        }
        n = 0;
        if (n2 > 0) {
            ++n;
        }
        if (n10 > 0) {
            ++n;
        }
        if (n3 > 0) {
            ++n;
        }
        int n11 = 2004;
        if (n > 1) {
            n11 = 2004;
        } else if (n2 == 1) {
            n11 = 2003;
        } else if (n2 > 1) {
            n11 = 2007;
        } else if (n10 == 1) {
            n11 = 2002;
        } else if (n10 > 1) {
            n11 = 2006;
        } else if (n3 == 1) {
            n11 = 2001;
        } else if (n3 > 1) {
            n11 = 2005;
        }
        return new JGeometry(n11, this.srid, nArray, dArray);
    }

    public JGeometry buffer(double d, double d2, double d3, double d4) throws Exception, SQLException {
        JGeometry jGeometry;
        if (d2 == 0.0 || d3 == 0.0) {
            return this.buffer(d);
        }
        JGeometry jGeometry2 = this.projectToLTP(d2, 1.0 / d3);
        try {
            jGeometry = jGeometry2.buffer(d);
        }
        catch (Exception exception) {
            return null;
        }
        if (jGeometry == null) {
            return null;
        }
        JGeometry jGeometry3 = jGeometry.densifyArcs(d4);
        jGeometry3.lttpH = jGeometry2.lttpH;
        jGeometry3.gtransH = jGeometry2.gtransH;
        jGeometry3.setSRID(this.getSRID());
        return jGeometry3.projectFromLTP();
    }

    public JGeometry buffer(double d) throws Exception, SQLException, DataException {
        if (d < 0.0) {
            throw new DataException("Invalid Buffer Size");
        }
        final Buffer buffer = new Buffer(d);
        this.parseGeometry(new GeomParser(){
            Chain exteriorChain = null;

            @Override
            public void point(double d, double d2) {
                buffer.add(new BufGeom(new JPoint2DD(d, d2)));
            }

            @Override
            public void circle(double d, double d2, double d3, double d4, double d5, double d6) {
                double[] dArray = JGeometry.computeArc(d, d2, d3, d4, d5, d6);
                if (dArray == null) {
                    throw new IllegalArgumentException("Not a circle");
                }
                buffer.add(new BufGeom(new Chain.CenterPoint(new JPoint2DD(dArray[0], dArray[1]), dArray[2], false)));
                throw new NullPointerException();
            }

            @Override
            public void ring(boolean bl, List<LineStringInfo> list) {
                Chain chain = this.chainFromLsiList(list);
                if (bl) {
                    this.exteriorChain.addMetaData(chain);
                } else {
                    this.outputExteriorChain();
                    this.exteriorChain = chain;
                }
            }

            @Override
            public void linestring(List<LineStringInfo> list) {
                Chain chain = this.chainFromLsiList(list);
                buffer.add(new BufGeom(chain, true));
            }

            @Override
            public void finish() {
                this.outputExteriorChain();
            }

            public Chain chainFromLsiList(List<LineStringInfo> list) {
                Chain chain = Chain.create()[0];
                JPoint2DD jPoint2DD = null;
                for (LineStringInfo lineStringInfo : list) {
                    Iterator iterator = lineStringInfo.iterator();
                    JPoint2DD jPoint2DD2 = (JPoint2DD)iterator.next();
                    if (jPoint2DD == null) {
                        jPoint2DD = jPoint2DD2;
                        chain.add(jPoint2DD);
                    }
                    if (lineStringInfo.isArc()) {
                        while (iterator.hasNext()) {
                            JPoint2DD jPoint2DD3 = (JPoint2DD)iterator.next();
                            JPoint2DD jPoint2DD4 = (JPoint2DD)iterator.next();
                            double[] dArray = JGeometry.computeArc(jPoint2DD.x, jPoint2DD.y, jPoint2DD3.x, jPoint2DD3.y, jPoint2DD4.x, jPoint2DD4.y);
                            if (dArray == null) {
                                chain.add(jPoint2DD3);
                                chain.add(jPoint2DD4);
                            } else {
                                this.appendArc(chain, jPoint2DD, jPoint2DD4, dArray);
                            }
                            jPoint2DD = jPoint2DD4;
                        }
                        continue;
                    }
                    while (iterator.hasNext()) {
                        jPoint2DD = (JPoint2DD)iterator.next();
                        chain.add(jPoint2DD);
                    }
                }
                return chain;
            }

            void outputExteriorChain() {
                if (this.exteriorChain != null) {
                    buffer.add(new BufGeom(this.exteriorChain, false));
                }
                this.exteriorChain = null;
            }

            void appendArc(Chain chain, JPoint2DD jPoint2DD, JPoint2DD jPoint2DD2, double[] dArray) {
                double d;
                double d2;
                JPoint2DD jPoint2DD3;
                boolean bl;
                boolean bl2;
                double d3;
                double d4 = dArray[0];
                double d5 = dArray[1];
                double d6 = dArray[2];
                double d7 = dArray[3];
                double d8 = dArray[4];
                double d9 = dArray[5];
                double d10 = d9 - d7;
                if (d10 < 0.0) {
                    d10 += Math.PI * 2;
                }
                if ((d3 = d8 - d7) < 0.0) {
                    d3 += Math.PI * 2;
                }
                boolean bl3 = d3 < d10;
                double d11 = bl3 ? d10 : Math.PI * 2 - d10;
                boolean bl4 = jPoint2DD.y > d5 || jPoint2DD2.y > d5 || d8 < Math.PI || d11 > Math.PI;
                boolean bl5 = bl2 = jPoint2DD.y < d5 || jPoint2DD2.y < d5 || d8 > Math.PI || d11 > Math.PI;
                boolean bl6 = jPoint2DD.y < d5 || jPoint2DD.y == d5 && jPoint2DD.x < d4 == bl3;
                chain.add(new Chain.CenterPoint(new JPoint2DD(d4, d5), d6, bl6));
                boolean bl7 = bl = bl4 && bl2;
                if (!bl) {
                    chain.add(jPoint2DD2);
                    return;
                }
                double[] dArray2 = new double[6];
                for (int i = 0; i < dArray.length; ++i) {
                    dArray2[i] = dArray[i];
                }
                if (bl6 == bl3) {
                    jPoint2DD3 = new JPoint2DD(d4 + d6, d5);
                    d2 = 0.0;
                } else {
                    jPoint2DD3 = new JPoint2DD(d4 - d6, d5);
                    d2 = Math.PI;
                }
                chain.add(jPoint2DD3);
                double d12 = d9 - d2;
                if (d12 < 0.0 && bl3) {
                    d12 += Math.PI * 2;
                }
                if (d12 > 0.0 && !bl3) {
                    d12 -= Math.PI * 2;
                }
                if ((d = d2 + d12 / 2.0) < 0.0) {
                    d += Math.PI * 2;
                }
                if (d > Math.PI * 2) {
                    d -= Math.PI * 2;
                }
                dArray2[3] = d2;
                dArray2[4] = d;
                this.appendArc(chain, jPoint2DD3, jPoint2DD2, dArray2);
            }
        });
        BufGeom bufGeom = buffer.process();
        ChainConverter chainConverter = new ChainConverter();
        for (Chain object2 : bufGeom.chains) {
            if (object2.signedArea() > 0.0) {
                object2.reverse();
            }
            chainConverter.convert(object2);
            ArrayList<Chain> n = object2.getMetaData();
            if (n == null) continue;
            for (Chain chain : n) {
                if (chain.size() <= 3) continue;
                if (chain.signedArea() < 0.0) {
                    chain.reverse();
                }
                chainConverter.convert(chain);
            }
        }
        Object object3 = new double[2 * chainConverter.numAllVertices];
        int[] nArray = new int[3 * chainConverter.numTriplets];
        int n = 0;
        for (Chain chain : bufGeom.chains) {
            n = chainConverter.writeOrdinates(chain, true, n, (double[])object3, nArray);
            ArrayList<Chain> arrayList = chain.getMetaData();
            if (arrayList == null) continue;
            for (Chain chain2 : arrayList) {
                if (chain2.size() <= 3) continue;
                n = chainConverter.writeOrdinates(chain2, false, n, (double[])object3, nArray);
            }
        }
        if (n != ((Object)object3).length || nArray[nArray.length - 1] <= 0) {
            throw new IllegalArgumentException("Internal error creating JGeometry from buffer");
        }
        return new JGeometry(bufGeom.chains.size() > 1 ? 7 : 3, this.getSRID(), nArray, (double[])object3);
    }

    void parseGeometry(GeomParser geomParser) throws Exception {
        if (this.isOptimizedPoint()) {
            geomParser.point(this.x, this.y);
        } else if (this.isCircle()) {
            geomParser.circle(this.ordinates[0], this.ordinates[1], this.ordinates[this.dim], this.ordinates[this.dim + 1], this.ordinates[2 * this.dim], this.ordinates[2 * this.dim + 1]);
        } else {
            int n = this.elemInfo.length / 3;
            block11: for (int i = 0; i < n; ++i) {
                int n2 = this.elemInfo[3 * i] - 1;
                int n3 = this.elemInfo[3 * i + 1];
                int n4 = this.elemInfo[3 * i + 2];
                int n5 = i + 1 < n ? this.elemInfo[3 * (i + 1)] - 1 - this.dim : this.ordinates.length - this.dim;
                switch (n3) {
                    case 1: {
                        for (int j = n2; j <= n5; j += this.dim) {
                            geomParser.point(this.ordinates[n2], this.ordinates[n2 + 1]);
                        }
                        continue block11;
                    }
                    case 2: {
                        final LineStringInfoOrdinates lineStringInfoOrdinates = new LineStringInfoOrdinates(n2, n5, n4 == 2, false);
                        AbstractList<LineStringInfo> abstractList = new AbstractList<LineStringInfo>(){

                            @Override
                            public LineStringInfo get(int n) {
                                return lineStringInfoOrdinates;
                            }

                            @Override
                            public int size() {
                                return 1;
                            }
                        };
                        geomParser.linestring((List<LineStringInfo>)abstractList);
                        continue block11;
                    }
                    case 3: 
                    case 1003: 
                    case 2003: {
                        ArrayList<LineStringInfo> arrayList;
                        LineStringInfo lineStringInfo;
                        switch (n4) {
                            case 1: 
                            case 2: {
                                lineStringInfo = new LineStringInfoOrdinates(n2, n5, n4 == 2, true);
                                break;
                            }
                            case 3: {
                                arrayList = new JPoint2DD(this.ordinates[n2], this.ordinates[n2 + 1]);
                                JPoint2DD jPoint2DD = new JPoint2DD(this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1]);
                                ArrayList<JPoint2DD> arrayList2 = new ArrayList<JPoint2DD>(5);
                                arrayList2.add((JPoint2DD)((Object)arrayList));
                                if (n3 != 2003) {
                                    arrayList2.add(new JPoint2DD(jPoint2DD.x, ((JPoint2DD)((Object)arrayList)).y));
                                    arrayList2.add(jPoint2DD);
                                    arrayList2.add(new JPoint2DD(((JPoint2DD)((Object)arrayList)).x, jPoint2DD.y));
                                } else {
                                    arrayList2.add(new JPoint2DD(((JPoint2DD)((Object)arrayList)).x, jPoint2DD.y));
                                    arrayList2.add(jPoint2DD);
                                    arrayList2.add(new JPoint2DD(jPoint2DD.x, ((JPoint2DD)((Object)arrayList)).y));
                                }
                                arrayList2.add((JPoint2DD)((Object)arrayList));
                                lineStringInfo = new LineStringInfoList(arrayList2, false, true);
                                break;
                            }
                            case 4: {
                                double[] dArray = JGeometry.computeArc(this.ordinates[n2 + 0], this.ordinates[n2 + 1], this.ordinates[n2 + this.dim], this.ordinates[n2 + this.dim + 1], this.ordinates[n2 + 2 * this.dim], this.ordinates[n2 + 2 * this.dim + 1]);
                                ArrayList<JPoint2DD> arrayList3 = new ArrayList<JPoint2DD>(5);
                                double d = dArray[2];
                                JPoint2DD jPoint2DD = new JPoint2DD(dArray[0] - d, dArray[1]);
                                JPoint2DD jPoint2DD2 = new JPoint2DD(dArray[0] + d, dArray[1]);
                                JPoint2DD jPoint2DD3 = new JPoint2DD(dArray[0], dArray[1] + d);
                                JPoint2DD jPoint2DD4 = new JPoint2DD(dArray[0], dArray[1] - d);
                                arrayList3.add(jPoint2DD);
                                if (n3 != 2003) {
                                    arrayList3.add(jPoint2DD4);
                                    arrayList3.add(jPoint2DD2);
                                    arrayList3.add(jPoint2DD3);
                                } else {
                                    arrayList3.add(jPoint2DD3);
                                    arrayList3.add(jPoint2DD2);
                                    arrayList3.add(jPoint2DD4);
                                }
                                arrayList3.add(jPoint2DD);
                                lineStringInfo = new LineStringInfoList(arrayList3, true, true);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Internal error. Interpretation=" + n4);
                            }
                        }
                        arrayList = new AbstractList<LineStringInfo>(){

                            @Override
                            public LineStringInfo get(int n) {
                                return lineStringInfo;
                            }

                            @Override
                            public int size() {
                                return 1;
                            }
                        };
                        geomParser.ring(n3 == 2003, arrayList);
                        continue block11;
                    }
                    case 4: 
                    case 5: 
                    case 1005: 
                    case 2005: {
                        boolean bl = n3 != 4;
                        int n6 = i + n4 + 1 < n ? this.elemInfo[3 * (i + n4 + 1)] - 1 - this.dim : this.ordinates.length - this.dim;
                        ArrayList<LineStringInfo> arrayList = new ArrayList<LineStringInfo>(n4);
                        for (int j = 0; j < n4; ++j) {
                            int n7 = this.elemInfo[3 * ++i + 2];
                            int n8 = this.elemInfo[3 * i] - 1;
                            int n9 = j + 1 < n4 ? this.elemInfo[3 * (i + 1)] - 1 : n6;
                            arrayList.add(new LineStringInfoOrdinates(n8, n9, n7 == 2, bl));
                        }
                        if (bl) {
                            geomParser.ring(n3 == 2005, arrayList);
                            continue block11;
                        }
                        geomParser.linestring(arrayList);
                        continue block11;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown etype " + n3);
                    }
                }
            }
        }
        geomParser.finish();
    }

    double maxMagnitudeXY() {
        double d = 0.0;
        if (!Double.isNaN(this.x) && !Double.isNaN(this.y)) {
            d = Math.max(Math.abs(this.x), Math.abs(this.y));
        }
        if (this.ordinates != null) {
            for (int i = 0; i < this.ordinates.length; i += this.dim) {
                d = Math.max(d, Math.abs(this.ordinates[i]));
                d = Math.max(d, Math.abs(this.ordinates[i + 1]));
            }
        }
        return d;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JGeometry affineTransforms(boolean bl, double d, double d2, double d3, boolean bl2, JGeometry jGeometry, double d4, double d5, double d6, boolean bl3, JGeometry jGeometry2, JGeometry jGeometry3, double d7, int n, boolean bl4, double d8, double d9, double d10, double d11, double d12, double d13, boolean bl5, JGeometry jGeometry4, JGeometry jGeometry5, int n2, boolean bl6, double[] dArray, double[] dArray2) throws Exception {
        double[][] dArray3;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        double d14;
        double[] dArray4;
        double[] dArray5;
        int n3;
        int n4;
        int n5;
        double d15 = 1.0E-16;
        JGeometry jGeometry6 = null;
        int n6 = 0;
        JGeometry jGeometry7 = null;
        JGeometry jGeometry8 = null;
        JGeometry jGeometry9 = null;
        if (this.dim == 4) {
            n5 = 3;
            if (!this.isLRSGeometry()) throw new Exception("Affinetransform cannot be performed for this gtype");
            n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 4 : 1;
        } else if (this.dim == 3) {
            n5 = 3;
            if (this.isLRSGeometry()) {
                n5 = 2;
                n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 3 : 1;
            } else {
                n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 3 : 0;
            }
        } else {
            if (this.dim != 2) throw new Exception("Affinetransform cannot be performed for this gtype");
            n5 = 2;
            n6 = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 2 : 0;
        }
        int[] nArray = new int[]{1, 1, 1};
        double[] dArray6 = null;
        if (jGeometry != null) {
            if (n5 == 2) {
                if (jGeometry.dim == 3) throw new Exception("Invalid parameter for affine transform");
            }
            if (n5 == 3 && jGeometry.dim == 2) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry.elemInfo == null && jGeometry.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry.x, jGeometry.y};
                } else if (n5 == 3) {
                    dArray6 = new double[]{jGeometry.x, jGeometry.y, jGeometry.z};
                }
                jGeometry7 = new JGeometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray6);
                jGeometry7.dim = jGeometry.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry.ordinates[0], jGeometry.ordinates[1]};
                }
                if (n5 == 3) {
                    dArray6 = new double[]{jGeometry.ordinates[0], jGeometry.ordinates[1], jGeometry.ordinates[2]};
                }
                jGeometry7 = new JGeometry(jGeometry.getType(), jGeometry.getSRID(), nArray, dArray6);
                jGeometry7.dim = jGeometry.dim;
            }
        }
        if (jGeometry2 != null) {
            if (jGeometry2.getType() != 1) throw new Exception("Invalid parameter for affine transform");
            if (jGeometry3 != null) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry2.elemInfo == null && jGeometry2.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry2.x, jGeometry2.y};
                } else if (n5 == 3) {
                    return this.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, null, new JGeometry(3002, 0, new int[]{1, 2, 1}, new double[]{jGeometry2.x, jGeometry2.y, 1.0, jGeometry2.x, jGeometry2.y, 0.0}), d7, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
                }
                jGeometry8 = new JGeometry(jGeometry2.getType(), jGeometry2.getSRID(), nArray, dArray6);
                jGeometry8.dim = jGeometry2.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry2.ordinates[0], jGeometry2.ordinates[1]};
                }
                if (n5 == 3) {
                    return this.affineTransforms(false, 0.0, 0.0, 0.0, false, null, 0.0, 0.0, 0.0, true, null, new JGeometry(3002, 0, new int[]{1, 2, 1}, new double[]{jGeometry2.ordinates[0], jGeometry2.ordinates[1], 1.0, jGeometry2.ordinates[0], jGeometry2.ordinates[1], 0.0}), d7, -1, false, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, false, null, null, 0, false, null, null);
                }
                jGeometry8 = new JGeometry(jGeometry2.getType(), jGeometry2.getSRID(), nArray, dArray6);
                jGeometry8.dim = jGeometry2.dim;
            }
        }
        if (jGeometry4 != null) {
            if (n5 == 2) {
                if (jGeometry4.dim == 3) throw new Exception("Invalid parameter for affine transform");
            }
            if (n5 == 3 && jGeometry4.dim == 2) {
                throw new Exception("Invalid parameter for affine transform");
            }
            if (jGeometry4.elemInfo == null && jGeometry4.ordinates == null) {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry4.x, jGeometry4.y};
                } else if (n5 == 3) {
                    dArray6 = new double[]{jGeometry4.x, jGeometry4.y, jGeometry4.z};
                }
                jGeometry9 = new JGeometry(jGeometry4.getType(), jGeometry4.getSRID(), nArray, dArray6);
                jGeometry9.dim = jGeometry4.dim;
            } else {
                if (n5 == 2) {
                    dArray6 = new double[]{jGeometry4.ordinates[0], jGeometry4.ordinates[1]};
                }
                if (n5 == 3) {
                    dArray6 = new double[]{jGeometry4.ordinates[0], jGeometry4.ordinates[1], jGeometry4.ordinates[2]};
                }
                jGeometry9 = new JGeometry(jGeometry4.getType(), jGeometry4.getSRID(), nArray, dArray6);
                jGeometry9.dim = jGeometry4.dim;
            }
        }
        double[][] dArray7 = new double[n5 + 1][n5 + 1];
        double[][] dArray8 = new double[n5 + 1][n5 + 1];
        double[][] dArray9 = new double[n5 + 1][n5 + 1];
        double[][] dArray10 = new double[n5 + 1][n5 + 1];
        double[][] dArray11 = new double[n5 + 1][n5 + 1];
        double[][] dArray12 = new double[n5 + 1][n5 + 1];
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            for (n3 = 0; n3 < n5 + 1; ++n3) {
                if (n4 == n3) {
                    dArray7[n4][n3] = 1.0;
                    dArray8[n4][n3] = 1.0;
                    dArray9[n4][n3] = 1.0;
                    dArray10[n4][n3] = 1.0;
                    dArray11[n4][n3] = 1.0;
                    dArray12[n4][n3] = 1.0;
                    continue;
                }
                dArray7[n4][n3] = 0.0;
                dArray8[n4][n3] = 0.0;
                dArray9[n4][n3] = 0.0;
                dArray10[n4][n3] = 0.0;
                dArray11[n4][n3] = 0.0;
                dArray12[n4][n3] = 0.0;
            }
        }
        if (n5 == 3) {
            double d16;
            if (bl) {
                dArray7 = JGeometry.translation(n5, d, d2, d3);
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray7);
            if (bl2) {
                if (jGeometry == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry.dim != 3) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray8 = JGeometry.translation(n5, jGeometry7.ordinates[0], jGeometry7.ordinates[1], jGeometry7.ordinates[2]);
                double[][] dArray13 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray13[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray13[0][0] = d4;
                dArray13[1][1] = d5;
                dArray13[2][2] = d6;
                dArray8 = JGeometry.matrixMatrixMult(dArray8, dArray13);
                dArray8 = JGeometry.matrixMatrixMult(dArray8, JGeometry.translation(n5, -jGeometry7.ordinates[0], -jGeometry7.ordinates[1], -jGeometry7.ordinates[2]));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray8);
            if (bl3) {
                if (jGeometry2 != null) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                if (jGeometry3 == null) {
                    if (n == 0) {
                        dArray9[1][1] = Math.cos(d7);
                        dArray9[1][2] = -Math.sin(d7);
                        dArray9[2][1] = Math.sin(d7);
                        dArray9[2][2] = Math.cos(d7);
                    } else if (n == 1) {
                        dArray9[0][0] = Math.cos(d7);
                        dArray9[0][2] = Math.sin(d7);
                        dArray9[2][0] = -Math.sin(d7);
                        dArray9[2][2] = Math.cos(d7);
                    } else if (n == 2) {
                        dArray9[0][0] = Math.cos(d7);
                        dArray9[0][1] = -Math.sin(d7);
                        dArray9[1][0] = Math.sin(d7);
                        dArray9[1][1] = Math.cos(d7);
                    } else {
                        System.out.println("Error: Rotation variable dir has to be 0,1 or 2");
                    }
                } else {
                    if (jGeometry3.dim != 3) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry3.getType() != 2) throw new Exception("Invalid parameter for affine transform");
                    if (n == 0) throw new Exception("Invalid parameter for affine transform");
                    if (n == 1) throw new Exception("Invalid parameter for affine transform");
                    if (n == 2) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[][] dArray14 = new double[n5 + 1][n5 + 1];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry3.ordinates[3] - jGeometry3.ordinates[0];
                    dArray5[1] = jGeometry3.ordinates[4] - jGeometry3.ordinates[1];
                    dArray5[2] = jGeometry3.ordinates[5] - jGeometry3.ordinates[2];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    dArray4[2] = dArray5[2] / d14;
                    dArray9 = JGeometry.matrixMatrixMult(dArray9, JGeometry.translation(n5, -jGeometry3.ordinates[0], -jGeometry3.ordinates[1], -jGeometry3.ordinates[2]));
                    d16 = Math.sqrt(dArray4[1] * dArray4[1] + dArray4[2] * dArray4[2]);
                    object5 = new double[n5 + 1][n5 + 1];
                    object4 = new double[n5 + 1][n5 + 1];
                    object3 = new double[n5 + 1][n5 + 1];
                    object2 = new double[n5 + 1][n5 + 1];
                    object = new double[n5 + 1][n5 + 1];
                    double[][] dArray15 = new double[n5 + 1][n5 + 1];
                    for (n4 = 0; n4 < n5 + 1; ++n4) {
                        for (n3 = 0; n3 < n5 + 1; ++n3) {
                            if (n4 == n3) {
                                object5[n4][n3] = 1.0;
                                object4[n4][n3] = 1.0;
                                object3[n4][n3] = 1.0;
                                object2[n4][n3] = 1.0;
                                object[n4][n3] = 1.0;
                                dArray15[n4][n3] = 1.0;
                                continue;
                            }
                            object5[n4][n3] = 0.0;
                            object4[n4][n3] = 0.0;
                            object3[n4][n3] = 0.0;
                            object2[n4][n3] = 0.0;
                            object[n4][n3] = 0.0;
                            dArray15[n4][n3] = 0.0;
                        }
                    }
                    if (Math.abs(d16) > d15) {
                        object5[1][1] = dArray4[2] / d16;
                        object5[2][1] = dArray4[1] / d16;
                        object5[1][2] = -dArray4[1] / d16;
                        object5[2][2] = dArray4[2] / d16;
                    }
                    dArray9 = JGeometry.matrixMatrixMult((double[][])object5, dArray9);
                    object4[0][0] = d16;
                    object4[0][2] = -dArray4[0];
                    object4[2][0] = dArray4[0];
                    object4[2][2] = d16;
                    dArray9 = JGeometry.matrixMatrixMult((double[][])object4, dArray9);
                    object3[0][0] = Math.cos(d7);
                    object3[0][1] = Math.sin(d7);
                    object3[1][0] = -Math.sin(d7);
                    object3[1][1] = Math.cos(d7);
                    dArray9 = JGeometry.matrixMatrixMult((double[][])object3, dArray9);
                    object[0][0] = d16;
                    object[0][2] = dArray4[0];
                    object[2][0] = -dArray4[0];
                    object[2][2] = d16;
                    dArray9 = JGeometry.matrixMatrixMult((double[][])object, dArray9);
                    if (Math.abs(d16) > d15) {
                        object2[1][1] = dArray4[2] / d16;
                        object2[2][1] = -dArray4[1] / d16;
                        object2[1][2] = dArray4[1] / d16;
                        object2[2][2] = dArray4[2] / d16;
                    }
                    dArray9 = JGeometry.matrixMatrixMult((double[][])object2, dArray9);
                    double[][] dArray16 = JGeometry.translation(n5, jGeometry3.ordinates[0], jGeometry3.ordinates[1], jGeometry3.ordinates[2]);
                    dArray9 = JGeometry.matrixMatrixMult(dArray16, dArray9);
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray9);
            if (bl4) {
                dArray10[0][1] = d8;
                dArray10[0][2] = d10;
                dArray10[1][0] = d9;
                dArray10[1][2] = d12;
                dArray10[2][0] = d11;
                dArray10[2][1] = d13;
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray10);
            if (bl5) {
                if (jGeometry5 == null) {
                    if (n2 == 0) {
                        dArray11[0][0] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (n2 == 1) {
                        dArray11[1][1] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (n2 == 2) {
                        dArray11[2][2] = -1.0;
                        if (bl6) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                    } else if (bl6) {
                        if (jGeometry4 != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray == null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 == null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                        double[] dArray17 = new double[n5];
                        dArray5 = new double[n5];
                        dArray4 = new double[n5];
                        dArray5[0] = 0.0;
                        dArray5[1] = 0.0;
                        dArray5[2] = 1.0;
                        dArray4[0] = 1.0;
                        dArray4[1] = 0.0;
                        dArray4[2] = 0.0;
                        d14 = dArray5[0] * dArray[0] + dArray5[1] * dArray[1] + dArray5[2] * dArray[2];
                        if (d14 < d15) {
                            d16 = dArray4[0] * dArray[0] + dArray4[1] * dArray[1] + dArray4[2] * dArray[2];
                            if (d16 < d15) {
                                dArray17[0] = 0.0;
                                dArray17[1] = -dArray2[0] / dArray[1];
                                dArray17[2] = 0.0;
                            } else {
                                dArray17[0] = -dArray2[0] / dArray[0];
                                dArray17[1] = 0.0;
                                dArray17[2] = 0.0;
                            }
                        } else {
                            dArray17[0] = 0.0;
                            dArray17[1] = 0.0;
                            dArray17[2] = -dArray2[0] / dArray[2];
                        }
                        double[][] dArray18 = new double[n5][n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray18[n4][n3] = dArray[n4] * dArray[n3];
                            }
                        }
                        dArray3 = new double[n5][n5];
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray3[n4][n3] = n4 == n3 ? 1.0 - 2.0 * dArray18[n4][n3] : -2.0 * dArray18[n4][n3];
                            }
                        }
                        object5 = new double[n5];
                        object5 = JGeometry.matvecMult(dArray18, dArray17);
                        for (n4 = 0; n4 < n5; ++n4) {
                            object5[n4] = 2.0 * object5[n4];
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            for (n3 = 0; n3 < n5; ++n3) {
                                dArray11[n4][n3] = dArray3[n4][n3];
                            }
                        }
                        for (n4 = 0; n4 < n5; ++n4) {
                            dArray11[n4][n5] = (double)object5[n4];
                        }
                    } else {
                        if (jGeometry4 == null) throw new Exception("Invalid parameter for affine transform");
                        if (jGeometry4.dim != 3) throw new Exception("Invalid parameter for affine transform");
                        if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                        if (dArray2 != null) {
                            throw new Exception("Invalid parameter for affine transform");
                        }
                        dArray11 = JGeometry.translation(n5, -jGeometry9.ordinates[0], -jGeometry9.ordinates[1], -jGeometry9.ordinates[2]);
                        double[][] dArray19 = new double[n5 + 1][n5 + 1];
                        for (n4 = 0; n4 < n5 + 1; ++n4) {
                            for (n3 = 0; n3 < n5 + 1; ++n3) {
                                dArray19[n4][n3] = n4 == n3 ? -1.0 : 0.0;
                            }
                        }
                        dArray19[n5][n5] = 1.0;
                        dArray11 = JGeometry.matrixMatrixMult(dArray19, dArray11);
                        dArray11 = JGeometry.matrixMatrixMult(JGeometry.translation(n5, jGeometry9.ordinates[0], jGeometry9.ordinates[1], jGeometry9.ordinates[2]), dArray11);
                    }
                } else {
                    if (jGeometry5.dim != 3) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 0) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 1) throw new Exception("Invalid parameter for affine transform");
                    if (n2 == 2) throw new Exception("Invalid parameter for affine transform");
                    if (bl6) throw new Exception("Invalid parameter for affine transform");
                    if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                    if (dArray2 != null) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry4 != null) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[] dArray20 = new double[n5];
                    dArray20[0] = jGeometry5.ordinates[0];
                    dArray20[1] = jGeometry5.ordinates[1];
                    dArray20[2] = jGeometry5.ordinates[2];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry5.ordinates[3] - jGeometry5.ordinates[0];
                    dArray5[1] = jGeometry5.ordinates[4] - jGeometry5.ordinates[1];
                    dArray5[2] = jGeometry5.ordinates[5] - jGeometry5.ordinates[2];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1] + dArray5[2] * dArray5[2]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    dArray4[2] = dArray5[2] / d14;
                    double[][] dArray21 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray21[n4][n3] = dArray4[n4] * dArray4[n3];
                        }
                    }
                    dArray3 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray3[n4][n3] = n4 == n3 ? -1.0 + 2.0 * dArray21[n4][n3] : 2.0 * dArray21[n4][n3];
                        }
                    }
                    object5 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            object5[n4][n3] = n4 == n3 ? (Object)(2.0 - 2.0 * dArray21[n4][n3]) : (Object)(-2.0 * dArray21[n4][n3]);
                        }
                    }
                    object4 = new double[n5];
                    object4 = JGeometry.matvecMult((double[][])object5, dArray20);
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = dArray3[n4][n3];
                        }
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        dArray11[n4][n5] = (double)object4[n4];
                    }
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray11);
        } else {
            if (bl) {
                if (Math.abs(d3) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray7 = JGeometry.translation(n5, d, d2, 0.0);
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray7);
            if (bl2) {
                if (jGeometry == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry7.dim != 2) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d6) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray8 = JGeometry.translation(n5, jGeometry7.ordinates[0], jGeometry7.ordinates[1], 0.0);
                double[][] dArray22 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray22[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray22[0][0] = d4;
                dArray22[1][1] = d5;
                dArray8 = JGeometry.matrixMatrixMult(dArray8, dArray22);
                dArray8 = JGeometry.matrixMatrixMult(dArray8, JGeometry.translation(n5, -jGeometry7.ordinates[0], -jGeometry7.ordinates[1], 0.0));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray8);
            if (bl3) {
                if (jGeometry2 == null) throw new Exception("Invalid parameter for affine transform");
                if (jGeometry3 != null) throw new Exception("Invalid parameter for affine transform");
                if (n == 0) throw new Exception("Invalid parameter for affine transform");
                if (n == 1) throw new Exception("Invalid parameter for affine transform");
                if (n == 2) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray9 = JGeometry.translation(n5, jGeometry8.ordinates[0], jGeometry8.ordinates[1], 0.0);
                double[][] dArray23 = new double[n5 + 1][n5 + 1];
                for (n4 = 0; n4 < n5 + 1; ++n4) {
                    for (n3 = 0; n3 < n5 + 1; ++n3) {
                        dArray23[n4][n3] = n4 == n3 ? 1.0 : 0.0;
                    }
                }
                dArray23[0][0] = Math.cos(d7);
                dArray23[0][1] = -Math.sin(d7);
                dArray23[1][0] = Math.sin(d7);
                dArray23[1][1] = Math.cos(d7);
                dArray9 = JGeometry.matrixMatrixMult(dArray9, dArray23);
                dArray9 = JGeometry.matrixMatrixMult(dArray9, JGeometry.translation(n5, -jGeometry8.ordinates[0], -jGeometry8.ordinates[1], 0.0));
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray9);
            if (bl4) {
                if (Math.abs(d10) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d11) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d12) > d15) throw new Exception("Invalid parameter for affine transform");
                if (Math.abs(d13) > d15) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                dArray10[0][1] = d8;
                dArray10[1][0] = d9;
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray10);
            if (bl5) {
                if (n2 == 0) throw new Exception("Invalid parameter for affine transform");
                if (n2 == 1) throw new Exception("Invalid parameter for affine transform");
                if (n2 == 2) throw new Exception("Invalid parameter for affine transform");
                if (bl6) throw new Exception("Invalid parameter for affine transform");
                if (dArray != null) throw new Exception("Invalid parameter for affine transform");
                if (dArray2 != null) {
                    throw new Exception("Invalid parameter for affine transform");
                }
                if (jGeometry5 == null) {
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = n4 == n3 ? -1.0 : 0.0;
                        }
                    }
                    dArray11[0][2] = 2.0 * jGeometry9.ordinates[0];
                    dArray11[1][2] = 2.0 * jGeometry9.ordinates[1];
                    dArray11[2][2] = 1.0;
                } else {
                    if (jGeometry5.dim == 3) throw new Exception("Invalid parameter for affine transform");
                    if (jGeometry4 != null) {
                        throw new Exception("Invalid parameter for affine transform");
                    }
                    double[] dArray24 = new double[n5];
                    dArray24[0] = jGeometry5.ordinates[0];
                    dArray24[1] = jGeometry5.ordinates[1];
                    dArray5 = new double[n5];
                    dArray4 = new double[n5];
                    dArray5[0] = jGeometry5.ordinates[2] - jGeometry5.ordinates[0];
                    dArray5[1] = jGeometry5.ordinates[3] - jGeometry5.ordinates[1];
                    d14 = Math.sqrt(dArray5[0] * dArray5[0] + dArray5[1] * dArray5[1]);
                    dArray4[0] = dArray5[0] / d14;
                    dArray4[1] = dArray5[1] / d14;
                    double[][] dArray25 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray25[n4][n3] = dArray4[n4] * dArray4[n3];
                        }
                    }
                    dArray3 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray3[n4][n3] = n4 == n3 ? -1.0 + 2.0 * dArray25[n4][n3] : 2.0 * dArray25[n4][n3];
                        }
                    }
                    object5 = new double[n5][n5];
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            object5[n4][n3] = n4 == n3 ? (Object)(2.0 - 2.0 * dArray25[n4][n3]) : (Object)(-2.0 * dArray25[n4][n3]);
                        }
                    }
                    object4 = new double[n5];
                    object4 = JGeometry.matvecMult((double[][])object5, dArray24);
                    for (n4 = 0; n4 < n5; ++n4) {
                        for (n3 = 0; n3 < n5; ++n3) {
                            dArray11[n4][n3] = dArray3[n4][n3];
                        }
                    }
                    for (n4 = 0; n4 < n5; ++n4) {
                        dArray11[n4][n5] = (double)object4[n4];
                    }
                }
            }
            dArray12 = JGeometry.matrixMatrixMult(dArray12, dArray11);
        }
        if (this.elemInfo != null && this.ordinates != null) {
            int n7 = this.getType();
            int n8 = this.getSRID();
            int n9 = this.dim;
            int n10 = this.linfo;
            int[] nArray2 = new int[this.elemInfo.length];
            System.arraycopy(this.elemInfo, 0, nArray2, 0, this.elemInfo.length);
            double[] dArray26 = new double[this.ordinates.length];
            System.arraycopy(this.ordinates, 0, dArray26, 0, this.ordinates.length);
            JGeometry jGeometry10 = null;
            boolean bl7 = false;
            int n11 = 0;
            while (n11 + 2 < this.getElemInfo().length) {
                if (this.getElemInfo()[n11 + 1] == 1007 && this.getElemInfo()[n11 + 2] == 3) {
                    bl7 = true;
                    break;
                }
                if (this.getElemInfo()[n11 + 1] == 1003 && this.getElemInfo()[n11 + 2] == 3) {
                    bl7 = true;
                    break;
                }
                if (this.getElemInfo()[n11 + 1] == 2003 && this.getElemInfo()[n11 + 2] == 3) {
                    bl7 = true;
                    break;
                }
                if (this.getElemInfo()[n11 + 1] == 2 && this.getElemInfo()[n11 + 2] == 3) {
                    throw new Exception("ORA-13107: operation not supported for Non-Uniform Rational B-Spline type");
                }
                n11 += 3;
            }
            if (n5 == 2 && bl7) {
                object5 = JGeometry.make_3d(this, true, 0, 0.0);
                nArray2 = new int[((JGeometry)object5).elemInfo.length];
                System.arraycopy(((JGeometry)object5).elemInfo, 0, nArray2, 0, ((JGeometry)object5).elemInfo.length);
                dArray26 = new double[((JGeometry)object5).ordinates.length];
                System.arraycopy(((JGeometry)object5).ordinates, 0, dArray26, 0, ((JGeometry)object5).ordinates.length);
                int n12 = ((JGeometry)object5).getSRID();
                object3 = new J3D_Geometry(((JGeometry)object5).getType() % 100, n12, nArray2, dArray26);
                object2 = J3D_Geometry.expandGeom((J3D_Geometry)object3);
                nArray2 = new int[((J3D_Geometry)object2).elemInfo.length];
                System.arraycopy(((J3D_Geometry)object2).elemInfo, 0, nArray2, 0, ((J3D_Geometry)object2).elemInfo.length);
                dArray26 = new double[((J3D_Geometry)object2).ordinates.length];
                System.arraycopy(((J3D_Geometry)object2).ordinates, 0, dArray26, 0, ((J3D_Geometry)object2).ordinates.length);
                object = new JGeometry(((JGeometry)object2).getType() % 100 + 3000, n12, nArray2, dArray26);
                ((JGeometry)object).dim = 3;
                jGeometry10 = JGeometry.make_2d((JGeometry)object, false, n8);
                nArray2 = new int[jGeometry10.elemInfo.length];
                System.arraycopy(jGeometry10.elemInfo, 0, nArray2, 0, jGeometry10.elemInfo.length);
                dArray26 = new double[jGeometry10.ordinates.length];
                System.arraycopy(jGeometry10.ordinates, 0, dArray26, 0, jGeometry10.ordinates.length);
                jGeometry10.dim = n9;
                jGeometry10.linfo = n10;
                jGeometry6 = new JGeometry(n7 % 100 + n5 * 1000, n8, nArray2, dArray26);
                jGeometry6.dim = n9;
                jGeometry6.linfo = n10;
            } else if (n5 == 3 && bl7) {
                object5 = new J3D_Geometry(n7 % 100, n8, nArray2, dArray26);
                ((J3D_Geometry)object5).dim = n9;
                ((J3D_Geometry)object5).linfo = n10;
                object4 = J3D_Geometry.expandGeom((J3D_Geometry)object5);
                nArray2 = new int[((J3D_Geometry)object4).elemInfo.length];
                System.arraycopy(((J3D_Geometry)object4).elemInfo, 0, nArray2, 0, ((J3D_Geometry)object4).elemInfo.length);
                dArray26 = new double[((J3D_Geometry)object4).ordinates.length];
                System.arraycopy(((J3D_Geometry)object4).ordinates, 0, dArray26, 0, ((J3D_Geometry)object4).ordinates.length);
                jGeometry10 = new JGeometry(n7 % 100 + n5 * 1000, n8, nArray2, dArray26);
                jGeometry10.dim = n9;
                jGeometry10.linfo = n10;
                jGeometry6 = new JGeometry(n7 % 100 + n5 * 1000, n8, nArray2, dArray26);
                jGeometry6.dim = n9;
                jGeometry6.linfo = n10;
            } else {
                jGeometry10 = new JGeometry(n7 % 100 + n5 * 1000, n8, nArray2, dArray26);
                jGeometry10.dim = n9;
                jGeometry10.linfo = n10;
                jGeometry6 = new JGeometry(n7 % 100 + n5 * 1000, n8, nArray2, dArray26);
                jGeometry6.dim = n9;
                jGeometry6.linfo = n10;
            }
            n4 = 0;
            while (n4 < jGeometry10.ordinates.length / (n5 + n6)) {
                object5 = new double[n5 + 1];
                double[] dArray27 = new double[n5 + 1];
                for (n3 = 0; n3 < n5; ++n3) {
                    object5[n3] = jGeometry10.ordinates[(n5 + n6) * n4 + n3];
                }
                object5[n5] = 1.0;
                dArray27 = JGeometry.matvecMult(dArray12, (double[])object5);
                for (n3 = 0; n3 < n5; ++n3) {
                    jGeometry6.ordinates[(n5 + n6) * n4 + n3] = dArray27[n3];
                }
                ++n4;
            }
            return jGeometry6;
        }
        double[] dArray28 = new double[n5 + 1];
        dArray5 = new double[n5 + 1];
        dArray28[0] = this.x;
        dArray28[1] = this.y;
        if (n5 == 3) {
            dArray28[2] = this.z;
        }
        dArray28[n5] = 1.0;
        dArray5 = JGeometry.matvecMult(dArray12, dArray28);
        if (n5 == 2) {
            return new JGeometry(dArray5[0], dArray5[1], this.getSRID());
        }
        if (n5 != 3) return jGeometry6;
        return new JGeometry(dArray5[0], dArray5[1], dArray5[2], this.getSRID());
    }

    private static double[][] translation(int n, double d, double d2, double d3) {
        double[][] dArray = new double[n + 1][n + 1];
        for (int i = 0; i < n + 1; ++i) {
            for (int j = 0; j < n + 1; ++j) {
                dArray[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        dArray[0][n] = d;
        dArray[1][n] = d2;
        if (n == 3) {
            dArray[2][n] = d3;
        }
        return dArray;
    }

    private static double[][] matrixMatrixMult(double[][] dArray, double[][] dArray2) {
        int n;
        int n2;
        int n3 = dArray.length;
        int n4 = dArray[0].length;
        int n5 = dArray2[0].length;
        double[][] dArray3 = new double[n3][n5];
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                dArray3[n2][n] = 0.0;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < n5; ++n) {
                for (int i = 0; i < n4; ++i) {
                    double[] dArray4 = dArray3[n2];
                    int n6 = n;
                    dArray4[n6] = dArray4[n6] + dArray[n2][i] * dArray2[i][n];
                }
            }
        }
        return dArray3;
    }

    private static double[] matvecMult(double[][] dArray, double[] dArray2) {
        int n;
        int n2 = dArray.length;
        int n3 = dArray[0].length;
        int n4 = dArray2.length;
        double[] dArray3 = new double[n2];
        for (n = 0; n < n2; ++n) {
            dArray3[n] = 0.0;
        }
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < n3; ++i) {
                int n5 = n;
                dArray3[n5] = dArray3[n5] + dArray[n][i] * dArray2[i];
            }
        }
        return dArray3;
    }

    public JGeometry densifyGeodesic() throws Exception {
        double[] dArray;
        double[] dArray2;
        double[] dArray3 = this.getMBR();
        if (dArray3.length == 4) {
            dArray2 = new double[]{dArray3[0] * (Math.PI / 180), dArray3[1] * (Math.PI / 180)};
            dArray = new double[]{dArray3[2] * (Math.PI / 180), dArray3[3] * (Math.PI / 180)};
        } else {
            dArray2 = new double[]{dArray3[0] * (Math.PI / 180), dArray3[1] * (Math.PI / 180)};
            dArray = new double[]{dArray3[3] * (Math.PI / 180), dArray3[4] * (Math.PI / 180)};
        }
        double d = JGeometry.jMdspheedis(dArray2, dArray);
        if (d == -1.0) {
            d = 2.0015108787169147E7;
        }
        return this.densifyGeodesic(Math.max(10.0, d / 1000.0));
    }

    public JGeometry densifyGeodesic(double d) throws Exception {
        DensifyData densifyData = new DensifyData();
        JGeometry jGeometry = null;
        if (this.dim == 3) {
            if (this.isLRSGeometry()) {
                densifyData.dim = 2;
                densifyData.stride = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 3 : 1;
            } else if (this.isOrientedMultiPoint() || this.isOrientedPoint()) {
                throw new Exception("13035");
            }
        } else if (this.dim == 2) {
            densifyData.dim = 2;
            densifyData.stride = this.isOrientedMultiPoint() || this.isOrientedPoint() ? 2 : 0;
        } else {
            throw new Exception("13030");
        }
        if (this.elemInfo != null && this.ordinates != null) {
            int[] nArray = new int[this.elemInfo.length];
            System.arraycopy(this.elemInfo, 0, nArray, 0, this.elemInfo.length);
            densifyData.ordlist = new ArrayList<Double>(this.ordinates.length * 2);
            int n = 0;
            while (n + 2 < this.getElemInfo().length) {
                int n2 = this.getElemInfo()[n + 1];
                int n3 = this.getElemInfo()[n + 2];
                int n4 = this.getElemInfo()[n];
                int n5 = n + 3 < this.getElemInfo().length ? this.getElemInfo()[n + 3] - 1 : this.ordinates.length;
                nArray[n] = densifyData.ordlist.size() + 1;
                switch (n2) {
                    case 1: {
                        this.densifyNoProcess(n4, n5, densifyData);
                        break;
                    }
                    case 2: {
                        if (n3 == 1) {
                            this.densifyProcessSegments(n4, n5, d, densifyData);
                            break;
                        }
                        if (n3 == 2) {
                            throw new Exception("13035");
                        }
                        throw new Exception("13035");
                    }
                    case 1003: 
                    case 2003: {
                        if (n3 == 1) {
                            this.densifyProcessSegments(n4, n5, d, densifyData);
                            break;
                        }
                        if (n3 == 2) {
                            throw new Exception("13035");
                        }
                        if (n3 == 3) {
                            this.densifyNoProcess(n4, n5, densifyData);
                            break;
                        }
                        if (n3 == 4) {
                            throw new Exception("13033");
                        }
                        throw new Exception("13033");
                    }
                    case 4: 
                    case 1005: 
                    case 2005: {
                        if (n5 < n4) break;
                        throw new Exception("Malformed geometry (etype " + n2 + " ordinates " + n4 + ".." + n5 + ")");
                    }
                    case 1006: {
                        if (n5 < n4) break;
                        throw new Exception("Malformed geometry (etype " + n2 + " ordinates " + n4 + ".." + n5 + ")");
                    }
                    case 1007: {
                        if (n5 < n4) break;
                        throw new Exception("Malformed geometry (etype " + n2 + " ordinates " + n4 + ".." + n5 + ")");
                    }
                    case 0: {
                        this.densifyNoProcess(n4, n5, densifyData);
                        break;
                    }
                    default: {
                        throw new Exception("13033");
                    }
                }
                n += 3;
            }
            double[] dArray = new double[densifyData.ordlist.size()];
            int n6 = 0;
            for (Double d2 : densifyData.ordlist) {
                dArray[n6++] = d2;
            }
            jGeometry = new JGeometry(this.getType(), this.getSRID(), nArray, dArray);
            jGeometry.dim = this.dim;
            jGeometry.linfo = this.linfo;
        } else if (densifyData.dim == 2) {
            jGeometry = new JGeometry(this.x, this.y, this.getSRID());
        } else if (densifyData.dim == 3) {
            jGeometry = new JGeometry(this.x, this.y, this.z, this.getSRID());
        }
        return jGeometry;
    }

    private void greatCircle(D2 d2, D2 d22, double d, DensifyData densifyData) {
        D2 d23 = this.splitGreatCircle(d2, d22, d, densifyData, true);
        if (d23 != null) {
            this.greatCircle(d2, d23, d, densifyData);
            densifyData.addNewVertex(d23.x, d23.y);
            this.greatCircle(d23, d22, d, densifyData);
        }
    }

    private D2 splitGreatCircle(D2 d2, D2 d22, double d, DensifyData densifyData, boolean bl) {
        D2 d23 = new D2(d2.x, d2.y);
        if (Math.abs(d2.x - d22.x) > 180.0) {
            d23.x = d23.x < d22.x ? (d23.x += 360.0) : (d23.x -= 360.0);
        }
        D2 d24 = new D2((d23.x + d22.x) / 2.0, (d23.y + d22.y) / 2.0);
        if (d24.x < -180.0) {
            d24.x += 360.0;
        }
        if (d24.x > 180.0) {
            d24.x -= 360.0;
        }
        D3 d3 = new D3(d2);
        D3 d32 = new D3(d22);
        d3.normalize();
        d32.normalize();
        D3 d33 = new D3((d3.x + d32.x) / 2.0, (d3.y + d32.y) / 2.0, (d3.z + d32.z) / 2.0);
        d33.normalize();
        D2 d25 = new D2(d33);
        double d4 = d33.distance(new D3(d24));
        if (d4 < 0.9 * d) {
            d25 = null;
        }
        if (bl) {
            if (d25 == null) {
                d25 = this.splitGreatCircle(d2, new D2(d33), d, densifyData, false);
            }
            if (d25 == null) {
                d25 = this.splitGreatCircle(new D2(d33), d22, d, densifyData, false);
            }
        }
        return d25;
    }

    private void densifyNoProcess(int n, int n2, DensifyData densifyData) {
        for (int i = n; i <= n2; ++i) {
            densifyData.ordlist.add(this.ordinates[i - 1]);
        }
    }

    private void densifyProcessSegments(int n, int n2, double d, DensifyData densifyData) {
        D2 d2 = null;
        int n3 = n;
        while (n3 + densifyData.dim + densifyData.stride - 1 <= n2) {
            int n4 = n3 - 1;
            D2 d22 = new D2(this.ordinates[n4], this.ordinates[n4 + 1]);
            if (d2 == null) {
                densifyData.addOldVertex(n3);
            } else {
                int n5 = densifyData.ordlist.size() - densifyData.dim - densifyData.stride;
                this.greatCircle(d2, d22, d, densifyData);
                densifyData.addOldVertex(n3);
                densifyData.interpolate(n5, densifyData.ordlist.size() - densifyData.dim - densifyData.stride);
            }
            d2 = d22;
            n3 += densifyData.dim + densifyData.stride;
        }
    }

    private void convertOrientedPointsFw(int[] nArray, double[] dArray) {
        for (int i = 0; i < nArray.length; i += 3) {
            int n;
            if (nArray[i + 1] != 1 || nArray[i + 2] != 0) continue;
            int n2 = nArray[i + 0];
            if (this.getSRID() == 8307) {
                for (n = 0; n < this.getDimensions(); ++n) {
                    int n3 = n2 + n;
                    dArray[n3] = dArray[n3] / 100000.0;
                }
            }
            for (n = 0; n < this.getDimensions(); ++n) {
                int n4 = n2 + n;
                dArray[n4] = dArray[n4] + dArray[n2 + n - 3];
            }
        }
    }

    private void convertOrientedPointsRv(int[] nArray, double[] dArray) {
        for (int i = 0; i < nArray.length; i += 3) {
            if (nArray[i + 1] != 1 || nArray[i + 2] != 0) continue;
            int n = nArray[i + 0];
            for (int j = 0; j < this.getDimensions(); ++j) {
                int n2 = n + j;
                dArray[n2] = dArray[n2] - dArray[n + j - 3];
            }
            double d = Math.sqrt(dArray[n + 0] * dArray[n + 0] + dArray[n + 1] * dArray[n + 1]);
            for (int j = 0; j < this.getDimensions(); ++j) {
                int n3 = n + j;
                dArray[n3] = dArray[n3] / d;
            }
        }
    }

    private double tfm_8307_to_PopularMercator_x(double d) {
        return 0.0 + 6378137.0 * (d - 0.0);
    }

    private double tfm_8307_to_PopularMercator_y(double d, boolean bl) {
        double d2 = bl ? MERCATOR_e54004 : MERCATOR_e3785;
        return 0.0 + 6378137.0 * Math.log(Math.tan(0.7853981633974483 + d / 2.0) * Math.pow((1.0 - d2 * Math.sin(d)) / (1.0 + d2 * Math.sin(d)), d2 / 2.0));
    }

    public void tfm_8307_to_PopularMercator(int[] nArray, double[] dArray, boolean bl) {
        if (nArray != null) {
            this.convertOrientedPointsFw(nArray, dArray);
        }
        if (dArray != null) {
            for (int i = 0; i < dArray.length; i += this.getDimensions()) {
                dArray[i + 0] = this.tfm_8307_to_PopularMercator_x(dArray[i + 0] * Math.PI / 180.0);
                dArray[i + 1] = this.tfm_8307_to_PopularMercator_y(dArray[i + 1] * Math.PI / 180.0, bl);
            }
        }
        if (nArray != null) {
            this.convertOrientedPointsRv(nArray, dArray);
        }
    }

    public void tfm_8307_to_PopularMercator(boolean bl) {
        if (this.getSRID() != 8307) {
            throw new RuntimeException("Source geometry must be SRID 8307, when transforming to 3785/54004.");
        }
        if (this.hasCircularArcs()) {
            throw new RuntimeException("Circular Arcs not allowed in 8307.");
        }
        double[] dArray = this.getPoint();
        if (dArray != null) {
            this.tfm_8307_to_PopularMercator(null, dArray, bl);
            this.x = dArray[0];
            this.y = dArray[1];
        }
        this.tfm_8307_to_PopularMercator(this.getElemInfo(), this.getOrdinatesArray(), bl);
        this.setSRID(bl ? 54004 : 3785);
    }

    private double tfm_PopularMercator_to_8307_lon(double d) {
        return (d - 0.0) / 6378137.0 + 0.0;
    }

    private double tfm_PopularMercator_to_8307_lat(double d, boolean bl) {
        double d2 = bl ? MERCATOR_e54004 : MERCATOR_e3785;
        return d + (d2 * d2 / 2.0 + Math.pow(d2, 6.0) / 12.0 + 5.0 * Math.pow(d2, 4.0) / 24.0 + 13.0 * Math.pow(d2, 8.0) / 360.0) * Math.sin(2.0 * d) + (7.0 * Math.pow(d2, 4.0) / 48.0 + 29.0 * Math.pow(d2, 6.0) / 240.0 + 811.0 * Math.pow(d2, 8.0) / 11520.0) * Math.sin(4.0 * d) + (7.0 * Math.pow(d2, 6.0) / 120.0 + 81.0 * Math.pow(d2, 8.0) / 1120.0) * Math.sin(6.0 * d) + 4279.0 * Math.pow(d2, 8.0) / 161280.0 * Math.sin(8.0 * d);
    }

    public void tfm_PopularMercator_to_8307(int[] nArray, double[] dArray, boolean bl) {
        if (nArray != null) {
            this.convertOrientedPointsFw(nArray, dArray);
        }
        if (dArray != null) {
            for (int i = 0; i < dArray.length; i += this.getDimensions()) {
                double d = dArray[i + 0];
                double d2 = dArray[i + 1];
                double d3 = Math.pow(MERCATOR_B, (0.0 - d2) / 6378137.0);
                double d4 = 1.5707963267948966 - 2.0 * Math.atan2(d3, 1.0);
                dArray[i + 1] = this.tfm_PopularMercator_to_8307_lat(d4, bl) * 180.0 / Math.PI;
                dArray[i + 0] = this.tfm_PopularMercator_to_8307_lon(d) * 180.0 / Math.PI;
            }
        }
        if (nArray != null) {
            this.convertOrientedPointsRv(nArray, dArray);
        }
    }

    public void tfm_PopularMercator_to_8307(boolean bl) {
        if (this.getSRID() != (bl ? 54004 : 3785)) {
            throw new RuntimeException("Source geometry must be SRID 3785/54004, when transforming to 8307.");
        }
        if (this.hasCircularArcs()) {
            throw new RuntimeException("Circular Arcs not allowed in 8307.");
        }
        double[] dArray = this.getPoint();
        if (dArray != null) {
            this.tfm_PopularMercator_to_8307(null, dArray, bl);
            this.x = dArray[0];
            this.y = dArray[1];
        }
        this.tfm_PopularMercator_to_8307(this.getElemInfo(), this.getOrdinatesArray(), bl);
        this.setSRID(8307);
    }

    public static JGeometry simplifyVW(JGeometry jGeometry, double d, boolean bl, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) throws Exception, SQLException {
        if (d8 == 0.0 || d9 == 0.0) {
            return JGeometry.simplifyVW(jGeometry, d, bl, d2, d3, d4, d5, d6, d7);
        }
        JGeometry jGeometry2 = jGeometry.projectToLTP(d8, 1.0 / d9);
        JGeometry jGeometry3 = JGeometry.simplifyVW(jGeometry2, d, bl, d2, d3, d4, d5, d6, d7);
        jGeometry3.lttpH = jGeometry2.lttpH;
        jGeometry3.gtransH = jGeometry2.gtransH;
        jGeometry3.setSRID(jGeometry.getSRID());
        return jGeometry3.projectFromLTP();
    }

    public static JGeometry simplifyVW(JGeometry jGeometry, double d, boolean bl, double d2, double d3, double d4, double d5, double d6, double d7) throws Exception {
        int n;
        int n2;
        int n3;
        Object object;
        int n4;
        int n5;
        int n6 = jGeometry.elemInfo.length / 3;
        ArrayList<JGeometry> arrayList = new ArrayList<JGeometry>();
        for (n5 = 0; n5 < n6; ++n5) {
            int n7 = n5 == n6 - 1 ? jGeometry.ordinates.length - 2 : jGeometry.elemInfo[3 * (n5 + 1)] - 3;
            int n8 = jGeometry.elemInfo[3 * n5] - 1;
            double[] dArray = new double[n7 - n8 + 2];
            int n9 = 0;
            n4 = jGeometry.elemInfo[3 * n5] - 1;
            while (n4 <= n7) {
                dArray[2 * n9] = jGeometry.ordinates[n4];
                dArray[2 * n9 + 1] = jGeometry.ordinates[n4 + 1];
                n4 += 2;
                ++n9;
            }
            object = new JGeometry(2002, jGeometry.getSRID(), new int[]{1, 2, 1}, dArray);
            arrayList.add(JGeometry.simplifyVW_core((JGeometry)object, d, bl, d2, d3, d4, d5, d6, d7));
        }
        n5 = 0;
        for (int i = 0; i < n6; ++i) {
            if (jGeometry.elemInfo[3 * i + 1] == 1003 || jGeometry.elemInfo[3 * i + 1] == 2003) {
                if (((JGeometry)arrayList.get(i)).getOrdinatesArray().length == 4) {
                    n5 += 4;
                    continue;
                }
                if (((JGeometry)arrayList.get(i)).getOrdinatesArray().length == 6) {
                    n5 += 4;
                    continue;
                }
                n5 += ((JGeometry)arrayList.get(i)).getOrdinatesArray().length;
                continue;
            }
            n5 += ((JGeometry)arrayList.get(i)).getOrdinatesArray().length;
        }
        double[] dArray = new double[n5];
        object = new int[3 * n6];
        n4 = 1;
        for (n3 = 0; n3 < n6; ++n3) {
            if (jGeometry.elemInfo[3 * n3 + 1] == 1003 || jGeometry.elemInfo[3 * n3 + 1] == 2003) {
                if (((JGeometry)arrayList.get(n3)).getOrdinatesArray().length == 4) {
                    object[3 * n3] = n4;
                    object[3 * n3 + 1] = 2;
                    object[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 2; ++n2) {
                        dArray[n2 + n4 - 1] = ((JGeometry)arrayList.get(n3)).getOrdinatesArray()[n2];
                    }
                    dArray[(n4 += 2) - 1] = jGeometry.ordinates[jGeometry.elemInfo[3 * n3] + 1];
                    dArray[n4] = jGeometry.ordinates[jGeometry.elemInfo[3 * n3] + 2];
                    n4 += 2;
                    continue;
                }
                if (((JGeometry)arrayList.get(n3)).getOrdinatesArray().length == 6) {
                    object[3 * n3] = n4;
                    object[3 * n3 + 1] = 2;
                    object[3 * n3 + 2] = 1;
                    for (n2 = 0; n2 < 4; ++n2) {
                        dArray[n2 + n4 - 1] = ((JGeometry)arrayList.get(n3)).getOrdinatesArray()[n2];
                    }
                    n4 += 4;
                    continue;
                }
                object[3 * n3] = n4;
                object[3 * n3 + 1] = jGeometry.elemInfo[3 * n3 + 1];
                object[3 * n3 + 2] = 1;
                for (n2 = 0; n2 < ((JGeometry)arrayList.get(n3)).getOrdinatesArray().length; ++n2) {
                    dArray[n2 + n4 - 1] = ((JGeometry)arrayList.get(n3)).getOrdinatesArray()[n2];
                }
                n4 += ((JGeometry)arrayList.get(n3)).getOrdinatesArray().length;
                continue;
            }
            object[3 * n3] = n4;
            object[3 * n3 + 1] = jGeometry.elemInfo[3 * n3 + 1];
            object[3 * n3 + 2] = 1;
            for (n2 = 0; n2 < ((JGeometry)arrayList.get(n3)).getOrdinatesArray().length; ++n2) {
                dArray[n2 + n4 - 1] = ((JGeometry)arrayList.get(n3)).getOrdinatesArray()[n2];
            }
            n4 += ((JGeometry)arrayList.get(n3)).getOrdinatesArray().length;
        }
        n3 = 0;
        n2 = 0;
        int n10 = 0;
        for (n = 0; n < n6; ++n) {
            if (object[3 * n + 1] == 1003) {
                ++n2;
                continue;
            }
            if (object[3 * n + 1] == 2) {
                ++n10;
                continue;
            }
            ++n3;
        }
        n = 0;
        if (n2 > 0) {
            ++n;
        }
        if (n10 > 0) {
            ++n;
        }
        if (n3 > 0) {
            ++n;
        }
        int n11 = 2004;
        if (n > 1) {
            n11 = 2004;
        } else if (n2 == 1) {
            n11 = 2003;
        } else if (n2 > 1) {
            n11 = 2007;
        } else if (n10 == 1) {
            n11 = 2002;
        } else if (n10 > 1) {
            n11 = 2006;
        } else if (n3 == 1) {
            n11 = 2001;
        } else if (n3 > 1) {
            n11 = 2005;
        }
        return new JGeometry(n11, jGeometry.getSRID(), (int[])object, dArray);
    }

    private static JGeometry simplifyVW_core(JGeometry jGeometry, double d, boolean bl, double d2, double d3, double d4, double d5, double d6, double d7) throws Exception {
        J3D_Geometry j3D_Geometry;
        J3D_Geometry j3D_Geometry2;
        Object object;
        double d8;
        double d9;
        Cloneable cloneable;
        int n;
        double d10 = 1.0E-9;
        JGeometry jGeometry2 = null;
        ArrayList<Object[]> arrayList = new ArrayList<Object[]>();
        if (jGeometry == null) {
            return jGeometry;
        }
        if (jGeometry.gtype % 100 != 2) {
            return jGeometry;
        }
        if (jGeometry.ordinates.length / 3 <= 2) {
            return jGeometry;
        }
        int n2 = n = jGeometry.gtype / 1000 > 0 ? jGeometry.gtype / 1000 : 2;
        if (n != 2) {
            return jGeometry;
        }
        ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
        ArrayList<Double> arrayList3 = new ArrayList<Double>();
        ArrayList<Integer> arrayList4 = new ArrayList<Integer>();
        arrayList2.add(new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[0], jGeometry.ordinates[1], 0.0}));
        arrayList3.add((Double)Double.MAX_VALUE);
        arrayList4.add(0);
        int n3 = jGeometry.ordinates.length / n;
        for (int i = 1; i < n3 - 1; ++i) {
            cloneable = null;
            cloneable = new J3D_Geometry(3, jGeometry.getSRID(), new int[]{1, 1003, 1}, new double[]{jGeometry.ordinates[n * (i - 1)], jGeometry.ordinates[n * (i - 1) + 1], 0.0, jGeometry.ordinates[n * i], jGeometry.ordinates[n * i + 1], 0.0, jGeometry.ordinates[n * (i + 1)], jGeometry.ordinates[n * (i + 1) + 1], 0.0, jGeometry.ordinates[n * (i - 1)], jGeometry.ordinates[n * (i - 1) + 1], 0.0});
            double d11 = ((J3D_Geometry)cloneable).area(d10);
            d9 = 0.0;
            double d12 = 0.0;
            d8 = 0.0;
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[n * (i - 1)], jGeometry.ordinates[n * (i - 1) + 1], 0.0});
            J3D_Geometry j3D_Geometry4 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[n * i], jGeometry.ordinates[n * i + 1], 0.0});
            object = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[n * (i + 1)], jGeometry.ordinates[n * (i + 1) + 1], 0.0});
            d9 = j3D_Geometry3.distance((J3D_Geometry)object, d10);
            j3D_Geometry2 = new J3D_Geometry(2, jGeometry.getSRID(), new int[]{1, 2, 1}, new double[]{j3D_Geometry3.getOrdinatesArray()[0], j3D_Geometry3.getOrdinatesArray()[1], 0.0, ((JGeometry)object).getOrdinatesArray()[0], ((JGeometry)object).getOrdinatesArray()[1], 0.0});
            d12 = j3D_Geometry4.distance(j3D_Geometry2, d10);
            j3D_Geometry = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{(j3D_Geometry3.getOrdinatesArray()[0] + ((JGeometry)object).getOrdinatesArray()[0]) / 2.0, (j3D_Geometry3.getOrdinatesArray()[1] + ((JGeometry)object).getOrdinatesArray()[1]) / 2.0, 0.0});
            d8 = j3D_Geometry4.distance(j3D_Geometry, d10);
            double d13 = 0.5 * d12 * d9;
            double d14 = 1.0;
            d14 = JGeometry.flatnessFilter(d2, d3, d12, d4, d9, d5, bl);
            double d15 = 1.0;
            d15 = JGeometry.skewnessFilter(d12, d6, d8, d7);
            double d16 = 1.0;
            d16 = JGeometry.convexityFilter(j3D_Geometry3, j3D_Geometry4, (J3D_Geometry)object);
            double d17 = d14 * d15 * d16 * d13;
            arrayList2.add(new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[n * i], jGeometry.ordinates[n * i + 1], 0.0}));
            arrayList3.add(d17);
            arrayList4.add(i);
        }
        arrayList2.add(new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{jGeometry.ordinates[n * (n3 - 1)], jGeometry.ordinates[n * (n3 - 1) + 1], 0.0}));
        arrayList3.add((Double)Double.MAX_VALUE);
        arrayList4.add(n3 - 1);
        ArrayList arrayList5 = new ArrayList();
        cloneable = new ArrayList<Double>();
        ArrayList<Integer> arrayList6 = new ArrayList<Integer>();
        int n4 = 0;
        d9 = 0.0;
        while (arrayList2.size() > 2) {
            double d18;
            double d19;
            double d20;
            double d21;
            double d22;
            J3D_Geometry j3D_Geometry5;
            J3D_Geometry j3D_Geometry6;
            J3D_Geometry j3D_Geometry7;
            J3D_Geometry j3D_Geometry8;
            J3D_Geometry j3D_Geometry9;
            double d23;
            d9 = (Double)arrayList3.get(0);
            n4 = 0;
            for (int i = 1; i < arrayList3.size(); ++i) {
                double d24 = (Double)arrayList3.get(i);
                if (!(d24 < d9)) continue;
                d9 = d24;
                n4 = i;
            }
            arrayList5.add(arrayList2.get(n4));
            ((ArrayList)cloneable).add(d9);
            arrayList6.add((Integer)arrayList4.get(n4));
            if (n4 - 2 > 0) {
                double d25 = 0.0;
                d8 = 0.0;
                d23 = 0.0;
                object = (Object[])arrayList2.get(n4 - 2);
                j3D_Geometry2 = (J3D_Geometry)arrayList2.get(n4 - 1);
                j3D_Geometry = (J3D_Geometry)arrayList2.get(n4);
                j3D_Geometry9 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{((JGeometry)object).getOrdinatesArray()[0], ((JGeometry)object).getOrdinatesArray()[1], 0.0});
                j3D_Geometry8 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1], 0.0});
                j3D_Geometry7 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.getOrdinatesArray()[0], j3D_Geometry.getOrdinatesArray()[1], 0.0});
                d25 = j3D_Geometry9.distance(j3D_Geometry7, d10);
                j3D_Geometry6 = new J3D_Geometry(2, jGeometry.getSRID(), new int[]{1, 2, 1}, new double[]{j3D_Geometry9.getOrdinatesArray()[0], j3D_Geometry9.getOrdinatesArray()[1], 0.0, j3D_Geometry7.getOrdinatesArray()[0], j3D_Geometry7.getOrdinatesArray()[1], 0.0});
                d8 = j3D_Geometry8.distance(j3D_Geometry6, d10);
                j3D_Geometry5 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{(j3D_Geometry9.getOrdinatesArray()[0] + j3D_Geometry7.getOrdinatesArray()[0]) / 2.0, (j3D_Geometry9.getOrdinatesArray()[1] + j3D_Geometry7.getOrdinatesArray()[1]) / 2.0, 0.0});
                d23 = j3D_Geometry8.distance(j3D_Geometry5, d10);
                d22 = 0.5 * d8 * d25;
                d21 = 1.0;
                d21 = JGeometry.flatnessFilter(d2, d3, d8, d4, d25, d5, bl);
                d20 = 1.0;
                d20 = JGeometry.skewnessFilter(d8, d6, d23, d7);
                d19 = 1.0;
                d19 = JGeometry.convexityFilter(j3D_Geometry9, j3D_Geometry8, j3D_Geometry7);
                d18 = d21 * d20 * d19 * d22;
                if (d18 < d9) {
                    arrayList3.set(n4 - 1, d9);
                } else {
                    arrayList3.set(n4 - 1, d18);
                }
            }
            if (n4 + 2 < arrayList2.size()) {
                double d26 = 0.0;
                d8 = 0.0;
                d23 = 0.0;
                object = (J3D_Geometry)arrayList2.get(n4);
                j3D_Geometry2 = (J3D_Geometry)arrayList2.get(n4 + 1);
                j3D_Geometry = (J3D_Geometry)arrayList2.get(n4 + 2);
                j3D_Geometry9 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{((JGeometry)object).getOrdinatesArray()[0], ((JGeometry)object).getOrdinatesArray()[1], 0.0});
                j3D_Geometry8 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry2.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1], 0.0});
                j3D_Geometry7 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{j3D_Geometry.getOrdinatesArray()[0], j3D_Geometry.getOrdinatesArray()[1], 0.0});
                d26 = j3D_Geometry9.distance(j3D_Geometry7, d10);
                j3D_Geometry6 = new J3D_Geometry(2, jGeometry.getSRID(), new int[]{1, 2, 1}, new double[]{j3D_Geometry9.getOrdinatesArray()[0], j3D_Geometry9.getOrdinatesArray()[1], 0.0, j3D_Geometry7.getOrdinatesArray()[0], j3D_Geometry7.getOrdinatesArray()[1], 0.0});
                d8 = j3D_Geometry8.distance(j3D_Geometry6, d10);
                j3D_Geometry5 = new J3D_Geometry(1, jGeometry.getSRID(), new int[]{1, 1, 1}, new double[]{(j3D_Geometry9.getOrdinatesArray()[0] + j3D_Geometry7.getOrdinatesArray()[0]) / 2.0, (j3D_Geometry9.getOrdinatesArray()[1] + j3D_Geometry7.getOrdinatesArray()[1]) / 2.0, 0.0});
                d23 = j3D_Geometry8.distance(j3D_Geometry5, d10);
                d22 = 0.5 * d8 * d26;
                d21 = 1.0;
                d21 = JGeometry.flatnessFilter(d2, d3, d8, d4, d26, d5, bl);
                d20 = 1.0;
                d20 = JGeometry.skewnessFilter(d8, d6, d23, d7);
                d19 = 1.0;
                d19 = JGeometry.convexityFilter(j3D_Geometry9, j3D_Geometry8, j3D_Geometry7);
                d18 = d21 * d20 * d19 * d22;
                if (d18 < d9) {
                    arrayList3.set(n4 + 1, d9);
                } else {
                    arrayList3.set(n4 + 1, d18);
                }
            }
            arrayList2.remove(n4);
            arrayList3.remove(n4);
            arrayList4.remove(n4);
        }
        if (arrayList5.size() != ((ArrayList)cloneable).size()) {
            throw new Exception("ranked_vertex and ranked_effArea ArrayLists sizes donot match");
        }
        if (arrayList5.size() != arrayList6.size()) {
            throw new Exception("ranked_vertex and ranked_index ArrayLists sizes donot match");
        }
        int n5 = (int)Math.ceil(d / 100.0 * (double)(n3 - 2));
        Object[] objectArray = new Object[]{(J3D_Geometry)arrayList2.get(0), (double)((Double)arrayList3.get(0))};
        arrayList.add(objectArray);
        for (int i = 0; i < arrayList5.size(); ++i) {
            Object[] objectArray2;
            int n6 = arrayList6.indexOf(i + 1);
            if (n6 < n5) {
                objectArray2 = new Object[]{(J3D_Geometry)arrayList5.get(n6), Double.NEGATIVE_INFINITY};
                arrayList.add(objectArray2);
                continue;
            }
            objectArray2 = new Object[]{(J3D_Geometry)arrayList5.get(n6), (double)((Double)((ArrayList)cloneable).get(n6))};
            arrayList.add(objectArray2);
        }
        Object[] objectArray3 = new Object[]{(J3D_Geometry)arrayList2.get(1), (double)((Double)arrayList3.get(1))};
        arrayList.add(objectArray3);
        double[] dArray = new double[n * (n3 - n5)];
        int n7 = 0;
        for (int i = 0; i < arrayList.size(); ++i) {
            object = new Object[2];
            object = (Object[])arrayList.get(i);
            j3D_Geometry2 = (J3D_Geometry)object[0];
            double d27 = (Double)object[1];
            if (Double.compare(d27, Double.NEGATIVE_INFINITY) == 0) continue;
            dArray[n7] = j3D_Geometry2.getOrdinatesArray()[0];
            dArray[n7 + 1] = j3D_Geometry2.getOrdinatesArray()[1];
            n7 += 2;
        }
        jGeometry2 = new JGeometry(2002, jGeometry.getSRID(), new int[]{1, 2, 1}, dArray);
        return jGeometry2;
    }

    private static double flatnessFilter(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        double d7 = 1.0;
        d7 = bl ? Math.pow((4.0 * d * Math.atan(d3 / (d4 * d5)) / Math.PI + d2) / (d + d2), d6) : Math.pow((4.0 * d * Math.atan(d4 * d5 / d3) / Math.PI + d2) / (d + d2), d6);
        return d7;
    }

    private static double skewnessFilter(double d, double d2, double d3, double d4) {
        double d5 = 1.0;
        d5 = Math.pow((d2 + d / d3) / (d2 + 1.0), d4);
        return d5;
    }

    private static double convexityFilter(J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, J3D_Geometry j3D_Geometry3) {
        double d = 1.0;
        double d2 = JGeometry.orientation(j3D_Geometry.getOrdinatesArray()[0], j3D_Geometry.getOrdinatesArray()[1], j3D_Geometry2.getOrdinatesArray()[0], j3D_Geometry2.getOrdinatesArray()[1], j3D_Geometry3.getOrdinatesArray()[0], j3D_Geometry3.getOrdinatesArray()[1]);
        d = d2 > 0.0 ? 1.0 : (d2 < 0.0 ? 1.0 : 0.0);
        return d;
    }

    public static double geodetic3DLength(JGeometry jGeometry) {
        double d = Math.PI / 180;
        double d2 = 6378137.0;
        double d3 = 0.003352810664747;
        double d4 = 1.0;
        return JGeometry.geodetic3DLength(jGeometry, d2, d3, d4);
    }

    public static double geodetic3DLength(JGeometry jGeometry, double d, double d2, double d3) {
        double d4 = 0.0;
        double d5 = 0.0;
        int n = 0;
        double d6 = Math.PI / 180;
        double d7 = Math.sqrt(1.0 - (2.0 - d2) * d2);
        double[] dArray = new double[2];
        double[] dArray2 = new double[2];
        double[] dArray3 = jGeometry.getOrdinatesArray();
        for (n = 0; n < dArray3.length / 3 - 1; ++n) {
            d5 = 0.0;
            dArray[0] = d6 * dArray3[3 * n];
            dArray[1] = d6 * dArray3[3 * n + 1];
            dArray2[0] = d6 * dArray3[3 * (n + 1)];
            dArray2[1] = d6 * dArray3[3 * (n + 1) + 1];
            double d8 = d3 * dArray3[3 * n + 2];
            double d9 = d3 * dArray3[3 * (n + 1) + 2];
            double d10 = d8 > d9 ? d9 : d8;
            d5 = JGeometry.jMdspheedis(dArray, dArray2, d + d10, d2, d7);
            if (Math.abs(d8 - d9) > 1.0) {
                d5 = Math.sqrt(d5 * d5 + (d8 - d9) * (d8 - d9));
            }
            d4 += d5;
        }
        return d4;
    }

    private static double jMdspheedis(double[] dArray, double[] dArray2) {
        return JGeometry.jMdspheedis(dArray, dArray2, 6378137.0, 0.0033528106647474805, 1.0);
    }

    private static double jMdspheedis(double[] dArray, double[] dArray2, double d, double d2, double d3) {
        double d4 = dArray[0];
        double d5 = dArray[1];
        double d6 = dArray2[0];
        double d7 = dArray2[1];
        double d8 = 1.5707963267948966 - Math.abs(d5) < 1.0E-10 ? d5 : Math.atan(d3 * Math.tan(d5));
        double d9 = 1.5707963267948966 - Math.abs(d7) < 1.0E-10 ? d7 : Math.atan(d3 * Math.tan(d7));
        double d10 = (d8 + d9) / 2.0;
        double d11 = (d8 - d9) / 2.0;
        double d12 = Math.abs(d4 - d6);
        if (d12 > Math.PI) {
            d12 = Math.PI * 2 - d12;
        }
        if ((d12 /= 2.0) < 5.0E-8 && Math.abs(d11) < 5.0E-8) {
            return 0.0;
        }
        if (1.5707963267948966 - d12 < 5.0E-8 && Math.abs(d10) < 5.0E-8 || 1.5707963267948966 - Math.abs(d11) < 5.0E-8) {
            return -1.0;
        }
        double d13 = Math.sin(d10);
        double d14 = Math.cos(d10);
        double d15 = Math.sin(d11);
        double d16 = Math.cos(d11);
        double d17 = Math.sin(d12);
        double d18 = d15 * d15 + d17 * d17 * (d16 * d16 - d13 * d13);
        double d19 = Math.acos(1.0 - 2.0 * d18);
        double d20 = Math.sin(d19);
        double d21 = 2.0 * (1.0 - 2.0 * d18);
        double d22 = 2.0 * d13 * d13 * d16 * d16 / (1.0 - d18);
        double d23 = 2.0 * d15 * d15 * d14 * d14 / d18;
        double d24 = d22 + d23;
        double d25 = d22 - d23;
        double d26 = d19 / d20;
        double d27 = 4.0 * d26 * d26;
        double d28 = d27 * d21;
        return d * d20 * (d26 - d2 * (d26 * d24 - d25) / 4.0 + d2 * d2 * (d24 * (d28 + (d26 - (d28 - d21) / 2.0) * d24) - d25 * (2.0 * d27 + d21 * d25) + d27 * d24 * d25) / 64.0);
    }

    public static JGeometry circle_polygon(double d, double d2, double d3, double d4) {
        JGeometry jGeometry = null;
        double d5 = Math.PI;
        double d6 = 2.0 * d5;
        int n = (int)Math.round(Math.ceil(d5 / (2.0 * Math.acos(1.0 - d4 / d3)))) * 2;
        jGeometry = new JGeometry(2003, 8307, new int[]{1, 1003, 1}, new double[2 * (n + 1)]);
        double d7 = d6 / (double)n;
        double d8 = Math.cos(d7);
        double d9 = Math.sin(d7);
        double d10 = 1.0;
        double d11 = 0.0;
        double d12 = d2 * (Math.PI / 180);
        double d13 = Math.cos(d12);
        double d14 = Math.sin(d12);
        d12 = d * (Math.PI / 180);
        double d15 = Math.cos(d12);
        double d16 = Math.sin(d12);
        double d17 = d3 / 6371007.0;
        double d18 = Math.cos(d17);
        double d19 = Math.sin(d17);
        for (int i = 0; i < n; ++i) {
            jGeometry.ordinates[2 * i] = Math.atan2(d18 * d16 * d13 + d19 * (d16 * d10 * d14 + d15 * d11), d18 * d15 * d13 + d19 * (d15 * d10 * d14 - d16 * d11)) / (Math.PI / 180);
            jGeometry.ordinates[2 * i + 1] = Math.asin(d18 * d14 - d19 * d13 * d10) / (Math.PI / 180);
            double d20 = d10 * d8 - d11 * d9;
            d11 = d11 * d8 + d10 * d9;
            d10 = d20;
        }
        jGeometry.ordinates[2 * n] = jGeometry.ordinates[0];
        jGeometry.ordinates[2 * n + 1] = jGeometry.ordinates[1];
        return jGeometry;
    }

    public static JGeometry circle_polygon(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7;
        double d8;
        double d9;
        JGeometry jGeometry = null;
        if (d4 >= 0.0 && d5 >= 0.0 || d4 < 0.0 && d5 < 0.0) {
            d9 = Math.abs(Math.abs(d4) - Math.abs(d5)) * (Math.PI / 180);
        } else if (d4 * d5 < 0.0) {
            d9 = (Math.abs(d4) + Math.abs(d5)) * (Math.PI / 180);
        } else {
            return null;
        }
        int n = (int)Math.round(Math.ceil(d9 / (2.0 * Math.acos(1.0 - d6 / d3)))) + 1;
        jGeometry = new JGeometry(2002, 8307, new int[]{1, 2, 1}, new double[n * 2]);
        double d10 = d4 > d5 ? -d9 / (double)n : d9 / (double)n;
        double d11 = Math.cos(d10);
        double d12 = Math.sin(d10);
        if (d4 < 0.0) {
            d8 = Math.cos((360.0 + d4) * (Math.PI / 180));
            d7 = Math.sin((360.0 + d4) * (Math.PI / 180));
        } else {
            d8 = Math.cos(d4 * (Math.PI / 180));
            d7 = Math.sin(d4 * (Math.PI / 180));
        }
        double d13 = d2 * (Math.PI / 180);
        double d14 = Math.cos(d13);
        double d15 = Math.sin(d13);
        d13 = d * (Math.PI / 180);
        double d16 = Math.cos(d13);
        double d17 = Math.sin(d13);
        double d18 = d3 / 6371007.0;
        double d19 = Math.cos(d18);
        double d20 = Math.sin(d18);
        for (int i = 0; i < n; ++i) {
            jGeometry.ordinates[2 * i] = Math.atan2(d19 * d17 * d14 + d20 * (d17 * d8 * d15 + d16 * d7), d19 * d16 * d14 + d20 * (d16 * d8 * d15 - d17 * d7)) / (Math.PI / 180);
            jGeometry.ordinates[2 * i + 1] = Math.asin(d19 * d15 - d20 * d14 * d8) / (Math.PI / 180);
            double d21 = d8 * d11 - d7 * d12;
            d7 = d7 * d11 + d8 * d12;
            d8 = d21;
        }
        return jGeometry;
    }

    public static JGeometry make_3d(JGeometry jGeometry, boolean bl, int n, double d) {
        int n2 = 0;
        int n3 = 0;
        JGeometry jGeometry2 = null;
        int n4 = jGeometry.getType();
        int[] nArray = null;
        double[] dArray = null;
        int n5 = bl ? 0 : n;
        n3 = jGeometry.getDimensions();
        if (n3 >= 3) {
            return jGeometry;
        }
        if (jGeometry.elemInfo == null && jGeometry.ordinates == null) {
            double d2 = jGeometry.x;
            double d3 = jGeometry.y;
            jGeometry2 = new JGeometry(d2, d3, d, n5);
            return jGeometry2;
        }
        int[] nArray2 = new int[jGeometry.elemInfo.length];
        System.arraycopy(jGeometry.elemInfo, 0, nArray2, 0, jGeometry.elemInfo.length);
        double[] dArray2 = new double[jGeometry.ordinates.length];
        System.arraycopy(jGeometry.ordinates, 0, dArray2, 0, jGeometry.ordinates.length);
        nArray = new int[nArray2.length];
        for (n2 = 1; n2 <= nArray2.length / 3; ++n2) {
            nArray[3 * n2 - 2 - 1] = (nArray2[3 * n2 - 2 - 1] - 1) * 3 / 2 + 1;
            nArray[3 * n2 - 1 - 1] = nArray2[3 * n2 - 1 - 1];
            nArray[3 * n2 - 0 - 1] = nArray2[3 * n2 - 0 - 1];
        }
        dArray = new double[dArray2.length * 3 / 2];
        for (n2 = 1; n2 <= dArray2.length / 2; ++n2) {
            dArray[3 * n2 - 2 - 1] = dArray2[2 * n2 - 1 - 1];
            dArray[3 * n2 - 1 - 1] = dArray2[2 * n2 - 0 - 1];
            dArray[3 * n2 - 0 - 1] = d;
        }
        jGeometry2 = new JGeometry(n4 + 3000, n5, nArray, dArray);
        jGeometry2.dim = 3;
        return jGeometry2;
    }

    public static J3D_Geometry make_3dgeom(JGeometry jGeometry, boolean bl, int n, double d) {
        JGeometry jGeometry2 = null;
        jGeometry2 = JGeometry.make_3d(jGeometry, bl, n, d);
        J3D_Geometry j3D_Geometry = jGeometry2.elemInfo == null || jGeometry2.ordinates == null ? new J3D_Geometry(jGeometry2.gtype, jGeometry2.srid, jGeometry2.x, jGeometry2.y, jGeometry2.z) : new J3D_Geometry(jGeometry2.gtype, jGeometry2.srid, jGeometry2.elemInfo, jGeometry2.ordinates);
        return j3D_Geometry;
    }

    public static JGeometry make_2d(JGeometry jGeometry, boolean bl, int n) {
        int n2 = 0;
        int n3 = 0;
        JGeometry jGeometry2 = null;
        int n4 = jGeometry.getType();
        int[] nArray = null;
        double[] dArray = null;
        int n5 = bl ? 0 : n;
        n3 = jGeometry.getDimensions();
        if (n3 <= 2) {
            return jGeometry;
        }
        if (jGeometry.elemInfo == null && jGeometry.ordinates == null) {
            double d = jGeometry.x;
            double d2 = jGeometry.y;
            jGeometry2 = new JGeometry(d, d2, n5);
            return jGeometry2;
        }
        int[] nArray2 = new int[jGeometry.elemInfo.length];
        System.arraycopy(jGeometry.elemInfo, 0, nArray2, 0, jGeometry.elemInfo.length);
        double[] dArray2 = new double[jGeometry.ordinates.length];
        System.arraycopy(jGeometry.ordinates, 0, dArray2, 0, jGeometry.ordinates.length);
        nArray = new int[nArray2.length];
        for (n2 = 1; n2 <= nArray2.length / 3; ++n2) {
            nArray[3 * n2 - 2 - 1] = (nArray2[3 * n2 - 2 - 1] - 1) * 2 / 3 + 1;
            nArray[3 * n2 - 1 - 1] = nArray2[3 * n2 - 1 - 1];
            nArray[3 * n2 - 0 - 1] = nArray2[3 * n2 - 0 - 1];
        }
        dArray = new double[dArray2.length * 2 / 3];
        for (n2 = 1; n2 <= dArray2.length / 3; ++n2) {
            dArray[2 * n2 - 1 - 1] = dArray2[3 * n2 - 2 - 1];
            dArray[2 * n2 - 0 - 1] = dArray2[3 * n2 - 1 - 1];
        }
        jGeometry2 = new JGeometry(n4 + 2000, n5, nArray, dArray);
        jGeometry2.dim = 2;
        return jGeometry2;
    }

    public boolean anyInteract(JGeometry jGeometry, double d, String string) throws Exception {
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = null;
        boolean bl = false;
        if (this.dim == 2 && jGeometry.dim == 2) {
            JGeometry jGeometry2;
            JGeometry jGeometry3;
            if (string.equals("TRUE")) {
                jGeometry3 = new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
                jGeometry2 = new JGeometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
            } else {
                jGeometry3 = this.densifyArcs(10.0 * d, true);
                jGeometry2 = jGeometry.densifyArcs(10.0 * d, true);
            }
            j3D_Geometry = JGeometry.make_3dgeom(jGeometry3, true, 0, 0.0);
            j3D_Geometry2 = JGeometry.make_3dgeom(jGeometry2, true, 0, 0.0);
        } else if (this.dim == 3 && jGeometry.dim == 3) {
            j3D_Geometry = new J3D_Geometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
            j3D_Geometry2 = new J3D_Geometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
        } else {
            throw new Exception("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        bl = j3D_Geometry.anyInteract(j3D_Geometry2, d, string);
        return bl;
    }

    public boolean isInside(JGeometry jGeometry, double d, String string) throws Exception {
        if (this.dim == 2 && jGeometry.dim == 2) {
            J3D_Geometry j3D_Geometry;
            int n;
            JGeometry jGeometry2;
            JGeometry jGeometry3;
            double d2 = 0.0;
            double d3 = 0.0;
            if (jGeometry.gtype != 3 && jGeometry.gtype != 7) {
                return false;
            }
            if (string.equals("TRUE")) {
                jGeometry3 = new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
                jGeometry2 = new JGeometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
            } else {
                jGeometry3 = this.densifyArcs(10.0 * d, true);
                jGeometry2 = jGeometry.densifyArcs(10.0 * d, true);
            }
            for (int i = 1; i < jGeometry2.elemInfo.length; i += 3) {
                n = jGeometry2.elemInfo[i];
                if (n == 2003) {
                    jGeometry2.elemInfo[i] = 1003;
                }
                jGeometry2.gtype = 7;
            }
            d2 = jGeometry2.ordinates[0];
            d3 = jGeometry2.ordinates[1];
            JGeometry[] jGeometryArray = jGeometry2.getElements();
            n = jGeometryArray.length;
            int n2 = 0;
            if (string.equals("TRUE")) {
                J3D_Geometry j3D_Geometry2 = JGeometry.make_3dgeom(jGeometry3, true, 0, 0.0);
                j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry2, d2, d3);
            } else {
                j3D_Geometry = JGeometry.make_3dgeom(jGeometry3, true, 0, 0.0);
            }
            for (int i = 0; i < n; ++i) {
                J3D_Geometry j3D_Geometry3;
                if (string.equals("TRUE")) {
                    J3D_Geometry j3D_Geometry4 = JGeometry.make_3dgeom(jGeometryArray[i], true, 0, 0.0);
                    j3D_Geometry3 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry4, d2, d3);
                } else {
                    j3D_Geometry3 = JGeometry.make_3dgeom(jGeometryArray[i], true, 0, 0.0);
                }
                if (j3D_Geometry.elemInfo == null || j3D_Geometry.ordinates == null) {
                    if (!j3D_Geometry.pointInPolygon(j3D_Geometry3, d)) continue;
                    ++n2;
                    continue;
                }
                J3D_Geometry j3D_Geometry5 = new J3D_Geometry(3001, j3D_Geometry3.srid, 0.0, 0.0, 0.0);
                boolean bl = true;
                for (int j = 1; j <= j3D_Geometry.ordinates.length / 3; ++j) {
                    j3D_Geometry5.ordinates[0] = j3D_Geometry.ordinates[3 * j - 3];
                    j3D_Geometry5.ordinates[1] = j3D_Geometry.ordinates[3 * j - 2];
                    j3D_Geometry5.ordinates[2] = j3D_Geometry.ordinates[3 * j - 1];
                    if (j3D_Geometry5.pointInPolygon(j3D_Geometry3, d)) continue;
                    bl = false;
                    break;
                }
                if (!bl) continue;
                ++n2;
            }
            return n2 % 2 != 0;
        }
        if (this.dim == 3 && jGeometry.dim == 3) {
            double d4 = 0.0;
            double d5 = 0.0;
            J3D_Geometry j3D_Geometry = null;
            J3D_Geometry j3D_Geometry6 = null;
            j3D_Geometry = this.elemInfo == null || this.ordinates == null ? new J3D_Geometry(this.gtype, this.srid, this.x, this.y, this.z) : new J3D_Geometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
            if (jGeometry.elemInfo == null || jGeometry.ordinates == null) {
                j3D_Geometry6 = new J3D_Geometry(jGeometry.gtype, jGeometry.srid, jGeometry.x, jGeometry.y, jGeometry.z);
                d4 = j3D_Geometry6.x;
                d5 = j3D_Geometry6.y;
            } else {
                j3D_Geometry6 = new J3D_Geometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
                d4 = j3D_Geometry6.ordinates[0];
                d5 = j3D_Geometry6.ordinates[1];
            }
            if (j3D_Geometry6.gtype == 3 || j3D_Geometry6.gtype == 7) {
                Object object;
                if (string.equals("TRUE")) {
                    j3D_Geometry = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry, d4, d5);
                }
                ArrayList<J3D_Geometry> arrayList = new ArrayList<J3D_Geometry>();
                int[] nArray = new int[1];
                if (j3D_Geometry6.gtype == 7 || j3D_Geometry6.elemInfo[1] % 1000 == 6) {
                    J3D_Geometry j3D_Geometry7;
                    object = new ElementExtractor(j3D_Geometry6, 0, 0, 3, false);
                    nArray[0] = 0;
                    while ((j3D_Geometry7 = ((ElementExtractor)object).nextElement(nArray)) != null) {
                        arrayList.add(j3D_Geometry7);
                    }
                } else {
                    arrayList.add(j3D_Geometry6);
                }
                object = new ArrayList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    J3D_Geometry j3D_Geometry8 = (J3D_Geometry)arrayList.get(i);
                    for (int j = 1; j < j3D_Geometry8.elemInfo.length; j += 3) {
                        int n = j3D_Geometry8.elemInfo[j];
                        if (n == 2003) {
                            j3D_Geometry8.elemInfo[j] = 1003;
                        }
                        j3D_Geometry8.gtype = 7;
                    }
                    ((ArrayList)object).add(j3D_Geometry8);
                }
                int[] nArray2 = new int[]{0};
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    J3D_Geometry j3D_Geometry9;
                    J3D_Geometry j3D_Geometry10 = (J3D_Geometry)((ArrayList)object).get(i);
                    ArrayList<J3D_Geometry> arrayList2 = new ArrayList<J3D_Geometry>();
                    if (j3D_Geometry10.getType() == 7 && j3D_Geometry10.getElemInfo().length > 3) {
                        ElementExtractor elementExtractor = new ElementExtractor(j3D_Geometry10, 0, 0, 3, false);
                        nArray[0] = 0;
                        while ((j3D_Geometry9 = elementExtractor.nextElement(nArray)) != null) {
                            arrayList2.add(j3D_Geometry9);
                        }
                    } else {
                        arrayList2.add(j3D_Geometry10);
                    }
                    for (int j = 0; j < arrayList2.size(); ++j) {
                        j3D_Geometry9 = (J3D_Geometry)arrayList2.get(j);
                        if (string.equals("TRUE")) {
                            j3D_Geometry9 = J3D_Geometry.projectToGnomonicFromLongLat(j3D_Geometry9, d4, d5);
                        }
                        JGeometry.process1003ForIsInside(nArray2, j3D_Geometry, j3D_Geometry9, d);
                    }
                }
                return nArray2[0] % 2 != 0;
            }
            return j3D_Geometry.inside3d(j3D_Geometry6, d, string);
        }
        throw new Exception("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
    }

    private static void process1003ForIsInside(int[] nArray, J3D_Geometry j3D_Geometry, J3D_Geometry j3D_Geometry2, double d) {
        if (j3D_Geometry.elemInfo == null || j3D_Geometry.ordinates == null) {
            if (j3D_Geometry.pointInPolygon(j3D_Geometry2, d)) {
                nArray[0] = nArray[0] + 1;
            }
        } else {
            J3D_Geometry j3D_Geometry3 = new J3D_Geometry(3001, j3D_Geometry2.srid, 0.0, 0.0, 0.0);
            boolean bl = true;
            for (int i = 1; i <= j3D_Geometry.ordinates.length / 3; ++i) {
                j3D_Geometry3.ordinates[0] = j3D_Geometry.ordinates[3 * i - 3];
                j3D_Geometry3.ordinates[1] = j3D_Geometry.ordinates[3 * i - 2];
                j3D_Geometry3.ordinates[2] = j3D_Geometry.ordinates[3 * i - 1];
                if (j3D_Geometry3.pointInPolygon(j3D_Geometry2, d)) continue;
                bl = false;
                break;
            }
            if (bl) {
                nArray[0] = nArray[0] + 1;
            }
        }
    }

    public double distance(JGeometry jGeometry, double d, String string) throws Exception {
        JGeometry jGeometry2 = null;
        JGeometry jGeometry3 = null;
        J3D_Geometry j3D_Geometry = null;
        J3D_Geometry j3D_Geometry2 = null;
        double d2 = 0.0;
        if (this.dim == 2 && jGeometry.dim == 2) {
            if (string.equals("TRUE")) {
                jGeometry2 = new JGeometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
                jGeometry3 = new JGeometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
            } else {
                jGeometry2 = this.densifyArcs(10.0 * d, true);
                jGeometry3 = jGeometry.densifyArcs(10.0 * d, true);
            }
            j3D_Geometry = JGeometry.make_3dgeom(jGeometry2, true, 0, 0.0);
            j3D_Geometry2 = JGeometry.make_3dgeom(jGeometry3, true, 0, 0.0);
        } else if (this.dim == 3 && jGeometry.dim == 3) {
            j3D_Geometry = new J3D_Geometry(this.gtype, this.srid, this.elemInfo, this.ordinates);
            j3D_Geometry2 = new J3D_Geometry(jGeometry.gtype, jGeometry.srid, jGeometry.elemInfo, jGeometry.ordinates);
        } else {
            throw new Exception("13355: SDO_ORDINATE_ARRAY not grouped by number of dimensions specified");
        }
        d2 = j3D_Geometry.distance(j3D_Geometry2, d, string, 6378137.0, 0.0033528106647474805, 1.0);
        return d2;
    }

    public static JGeometry getNurbsApprox(JGeometry jGeometry) throws Exception {
        int n;
        int n2;
        int n3;
        JGeometry jGeometry2 = new JGeometry(jGeometry.getType(), jGeometry.getSRID());
        ArrayList<Double> arrayList = new ArrayList<Double>();
        int n4 = jGeometry.elemInfo.length / 3;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = -1;
        int n9 = jGeometry.elemInfo.length;
        jGeometry2.dim = jGeometry.dim;
        int[] nArray = new int[n9];
        for (n3 = 0; n3 < n4; ++n3) {
            n5 = jGeometry.elemInfo[3 * n3] - 1;
            n6 = n3 != n4 - 1 ? jGeometry.elemInfo[3 * (n3 + 1)] - 1 : jGeometry.ordinates.length;
            nArray[3 * n3] = n7 + 1;
            nArray[3 * n3 + 1] = jGeometry.elemInfo[3 * n3 + 1];
            if (jGeometry.elemInfo[3 * n3 + 1] == 4) {
                nArray[3 * n3 + 2] = n2 = jGeometry.elemInfo[3 * n3 + 2];
                n = n7;
                int n10 = n - 1;
                int n11 = 0;
                for (int i = 1; i <= n2; ++i) {
                    int n12 = jGeometry.elemInfo[3 * (n3 + i)] - 1;
                    int n13 = jGeometry.elemInfo[3 * (n3 + i) + 2];
                    nArray[3 * (n3 + i)] = n12 + 1;
                    nArray[3 * (n3 + i) + 1] = 2;
                    int n14 = n3 + i != n4 - 1 ? jGeometry.elemInfo[3 * (n3 + i + 1)] - 1 : jGeometry.ordinates.length;
                    if (n13 == 3) {
                        if (n11 == 0) {
                            n11 = 1;
                        } else if (n11 != 1) {
                            nArray[3 * (n3 + i) + 2] = 1;
                            n11 = 1;
                        } else {
                            n9 -= 3;
                            nArray[3 * (n3 + i) + 2] = 0;
                            int n15 = 3 * n3 + 2;
                            nArray[n15] = nArray[n15] - 1;
                        }
                        JGeometry.nurbsEvalPlElem(arrayList, jGeometry.ordinates, n12, jGeometry.dim);
                        n10 += 400;
                        if (i != 1 && jGeometry.elemInfo[3 * (n3 + i - 1) + 2] != 3) {
                            arrayList.remove(n);
                            arrayList.remove(n);
                            n10 -= 2;
                        }
                        if (i != n2) {
                            arrayList.remove(arrayList.size() - 1);
                            arrayList.remove(arrayList.size() - 1);
                            n10 -= 2;
                        }
                    } else {
                        if (n11 == 0 || n11 != n13) {
                            nArray[3 * (n3 + i) + 2] = n13;
                            n11 = n13;
                        } else {
                            n9 -= 3;
                            nArray[3 * (n3 + i) + 2] = 0;
                            int n16 = 3 * n3 + 2;
                            nArray[n16] = nArray[n16] - 1;
                        }
                        double[] dArray = jGeometry.getOrdinatesOfElement(n12, n14);
                        for (int j = 0; j < dArray.length; ++j) {
                            arrayList.add(dArray[j]);
                        }
                        n10 += n14 - n12;
                    }
                    n = n10 + 1;
                }
                if (nArray[3 * n3 + 2] == 1) {
                    n9 -= 3;
                }
                n8 = n10;
                n7 = n8 + 1;
                if (nArray[3 * (n3 += n2) + 2] != 1) continue;
                n9 -= 3;
                continue;
            }
            if (jGeometry.elemInfo[3 * n3 + 1] == 2 && jGeometry.elemInfo[3 * n3 + 2] == 3) {
                nArray[3 * n3 + 2] = 1;
                JGeometry.nurbsEvalPlElem(arrayList, jGeometry.ordinates, n5, jGeometry.dim);
                n7 = (n8 += 400) + 1;
                continue;
            }
            nArray[3 * n3 + 2] = jGeometry.elemInfo[3 * n3 + 2];
            double[] dArray = jGeometry.getOrdinatesOfElement(n5, n6);
            for (n = 0; n < dArray.length; ++n) {
                arrayList.add(dArray[n]);
            }
            n7 = (n8 += n6 - n5) + 1;
        }
        jGeometry2.ordinates = new double[arrayList.size()];
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            jGeometry2.ordinates[n3] = (Double)arrayList.get(n3);
        }
        jGeometry2.elemInfo = new int[n9];
        n3 = 0;
        n2 = 0;
        for (n = 0; n < nArray.length; n += 3) {
            if (nArray[n + 1] == 4) {
                if (nArray[n + 2] == 1) continue;
                jGeometry2.elemInfo[n3] = nArray[n];
                jGeometry2.elemInfo[n3 + 1] = nArray[n + 1];
                jGeometry2.elemInfo[n3 + 2] = nArray[n + 2];
                n3 += 3;
                continue;
            }
            if (nArray[n + 2] == 0) continue;
            jGeometry2.elemInfo[n3] = nArray[n];
            jGeometry2.elemInfo[n3 + 1] = nArray[n + 1];
            jGeometry2.elemInfo[n3 + 2] = nArray[n + 2];
            n3 += 3;
        }
        return jGeometry2;
    }

    private static void nurbsEvalPlElem(ArrayList arrayList, double[] dArray, int n, int n2) throws Exception {
        int n3;
        double d = 200.0;
        double d2 = 1.0 / (d - 1.0);
        double d3 = 0.0;
        double[] dArray2 = new double[n2 + 1];
        double[] dArray3 = new double[n2];
        int n4 = Double.valueOf(dArray[n]).intValue();
        int n5 = Double.valueOf(dArray[n + 1]).intValue();
        double[] dArray4 = new double[n4 + 1];
        double[] dArray5 = new double[n4 + 1];
        double[] dArray6 = new double[n4 + 1];
        for (n3 = 0; n3 < n2; ++n3) {
            arrayList.add(dArray[n + 2 + n3] / dArray[n + 2 + n2]);
        }
        int n6 = Double.valueOf(dArray[n + 1 + (n2 + 1) * n5 + 1]).intValue();
        double d4 = dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + n4] + d2;
        for (int i = n4; i < n6 - n4 - 1; ++i) {
            while (dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i] < 1.0 && dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i] == dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i + 1]) {
                ++i;
            }
            while (d4 < dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i + 1]) {
                dArray4[0] = 1.0;
                for (n3 = 1; n3 <= n4; ++n3) {
                    double d5 = 0.0;
                    dArray6[n3] = d4 - dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i + 1 - n3];
                    dArray5[n3] = dArray[n + 1 + (n2 + 1) * n5 + 1 + 1 + i + n3] - d4;
                    for (int j = 0; j < n3; ++j) {
                        double d6 = dArray4[j] / (dArray5[j + 1] + dArray6[n3 - j]);
                        dArray4[j] = d5 + dArray5[j + 1] * d6;
                        d5 = dArray6[n3 - j] * d6;
                    }
                    dArray4[n3] = d5;
                }
                d3 = 0.0;
                for (n3 = 0; n3 < n2; ++n3) {
                    dArray3[n3] = 0.0;
                }
                for (int j = 0; j <= n4; ++j) {
                    for (n3 = 0; n3 < n2 + 1; ++n3) {
                        dArray2[n3] = dArray[n + 1 + (n2 + 1) * (i - n4 + j) + 1 + n3];
                    }
                    int n7 = j;
                    dArray4[n7] = dArray4[n7] * dArray2[n2];
                    d3 += dArray4[j];
                    for (n3 = 0; n3 < n2; ++n3) {
                        int n8 = n3;
                        dArray3[n8] = dArray3[n8] + dArray4[j] * dArray2[n3];
                    }
                }
                for (n3 = 0; n3 < n2; ++n3) {
                    int n9 = n3;
                    dArray3[n9] = dArray3[n9] / d3;
                    arrayList.add(dArray3[n3]);
                }
                d4 += d2;
            }
        }
        for (n3 = 0; n3 < n2; ++n3) {
            arrayList.add(dArray[n + 1 + (n2 + 1) * (n5 - 1) + 1 + n3] / dArray[n + 1 + (n2 + 1) * (n5 - 1) + 1 + n2]);
        }
    }

    private class D3 {
        double x;
        double y;
        double z;

        D3(double d, double d2, double d3) {
            this.x = d;
            this.y = d2;
            this.z = d3;
        }

        D3(D2 d2) {
            if (d2.y > 90.0 || d2.y < -90.0 || d2.x > 180.0 || d2.x < -180.0) {
                throw new IllegalArgumentException("13019");
            }
            this.z = Math.sin(Math.PI / 180 * d2.y);
            this.x = Math.cos(Math.PI / 180 * d2.y) * Math.cos(Math.PI / 180 * d2.x);
            this.y = Math.cos(Math.PI / 180 * d2.y) * Math.sin(Math.PI / 180 * d2.x);
        }

        D3 normalize() {
            double d = Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
            this.x /= d;
            this.y /= d;
            this.z /= d;
            return this;
        }

        double dot(D3 d3) {
            return d3.x * this.x + d3.y * this.y + d3.z * this.z;
        }

        double distance(D3 d3) {
            double d = this.dot(d3);
            if (d < -1.0) {
                d = -1.0;
            } else if (d > 1.0) {
                d = 1.0;
            }
            return Math.acos(d) * 6371007.0;
        }
    }

    private class D2 {
        double x;
        double y;

        D2(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        D2(D3 d3) {
            d3.normalize();
            this.y = Math.asin(d3.z) * 57.29577951308232;
            this.x = Math.atan2(d3.y, d3.x) * 57.29577951308232;
        }

        public String toString() {
            return this.x + " " + this.y;
        }
    }

    private class DensifyData {
        int dim;
        int stride;
        List<Double> ordlist;

        private DensifyData() {
        }

        private void addNewVertex(double d, double d2) {
            this.ordlist.add(d);
            this.ordlist.add(d2);
            for (int i = 2; i < this.dim + this.stride; ++i) {
                this.ordlist.add(Double.NaN);
            }
        }

        private void addOldVertex(int n) {
            for (int i = 0; i < this.dim + this.stride; ++i) {
                this.ordlist.add(JGeometry.this.ordinates[n + i - 1]);
            }
        }

        private void interpolate(int n, int n2) {
            double[] dArray = new double[n2 - n];
            double d = 0.0;
            int n3 = 0;
            for (int i = n; i < n2; i += this.dim + this.stride) {
                double[] dArray2 = new double[]{this.ordlist.get(i) * (Math.PI / 180), this.ordlist.get(i + 1) * (Math.PI / 180)};
                double[] dArray3 = new double[]{this.ordlist.get(i + this.dim + this.stride) * (Math.PI / 180), this.ordlist.get(i + this.dim + this.stride + 1) * (Math.PI / 180)};
                double d2 = JGeometry.jMdspheedis(dArray2, dArray3);
                if (d2 == -1.0) {
                    d2 = 2.0015108787169147E7;
                }
                dArray[n3++] = d2;
                d += d2;
            }
            n3 = 0;
            double d3 = 0.0;
            for (int i = n + this.dim + this.stride; i < n2; i += this.dim + this.stride) {
                for (int j = 2; j < this.dim + this.stride; ++j) {
                    double d4 = (d3 += dArray[n3++]) / d;
                    this.ordlist.set(i + j, (1.0 - d4) * this.ordlist.get(n + j) + d4 * this.ordlist.get(n2 + j));
                }
            }
        }
    }

    static interface GeomParser {
        public void point(double var1, double var3) throws Exception;

        public void circle(double var1, double var3, double var5, double var7, double var9, double var11) throws Exception;

        public void ring(boolean var1, List<LineStringInfo> var2) throws Exception;

        public void linestring(List<LineStringInfo> var1) throws Exception;

        public void finish() throws Exception;
    }

    class LineStringInfoList
    extends LineStringInfo {
        List<JPoint2DD> coords;

        LineStringInfoList(List<JPoint2DD> list, boolean bl, boolean bl2) {
            this.coords = list;
            this.isArc = bl;
            this.ofRing = bl2;
        }

        @Override
        boolean isArc() {
            return this.isArc;
        }

        @Override
        boolean ofRing() {
            return this.ofRing;
        }

        @Override
        public JPoint2DD get(int n) {
            return this.coords.get(n);
        }

        @Override
        public int size() {
            return this.coords.size();
        }
    }

    class LineStringInfoOrdinates
    extends LineStringInfo {
        private final int first;
        private final int last;

        LineStringInfoOrdinates(int n, int n2, boolean bl, boolean bl2) {
            this.first = n;
            this.last = n2;
            this.isArc = bl;
            this.ofRing = bl2;
        }

        @Override
        boolean isArc() {
            return this.isArc;
        }

        @Override
        boolean ofRing() {
            return this.ofRing;
        }

        @Override
        public JPoint2DD get(int n) {
            return new JPoint2DD(JGeometry.this.ordinates[this.first + n * JGeometry.this.dim], JGeometry.this.ordinates[this.first + n * JGeometry.this.dim + 1]);
        }

        @Override
        public int size() {
            return (this.last - this.first) / JGeometry.this.dim + 1;
        }
    }

    abstract class LineStringInfo
    extends AbstractList<JPoint2DD> {
        boolean isArc;
        boolean ofRing;

        LineStringInfo() {
        }

        abstract boolean isArc();

        abstract boolean ofRing();
    }

    protected static class ChainConverter {
        int numLinestrings = 0;
        int numArcs = 0;
        int numAllVertices = 0;
        int numTriplets = 0;
        boolean hasArc;
        boolean hasLinestring;
        boolean isCircle;
        State segType = State.NULL;
        State prevSegType = State.NULL;
        int segStart = -1;
        int segEnd = -1;
        int segCenter = -1;
        boolean isSegCCW = false;

        protected ChainConverter() {
        }

        void convert(Chain chain) {
            this.hasArc = false;
            this.hasLinestring = false;
            this.isCircle = false;
            this.segType = State.NULL;
            this.prevSegType = State.NULL;
            this.segStart = -1;
            this.segEnd = -1;
            this.segCenter = -1;
            this.isSegCCW = false;
            int n = chain.size();
            if (n < 1) {
                throw new IllegalArgumentException("Internal error - empty chain in buffer");
            }
            this.numAllVertices += n;
            JPoint2DD jPoint2DD = chain.get(0);
            int n2 = 0;
            int n3 = 1;
            while (n3 < n) {
                Chain.CenterPoint centerPoint = null;
                int n4 = -1;
                JPoint2DD jPoint2DD2 = chain.get(n3);
                if (jPoint2DD2 instanceof Chain.CenterPoint) {
                    centerPoint = (Chain.CenterPoint)jPoint2DD2;
                    n4 = n3++;
                    jPoint2DD2 = chain.get(n3);
                }
                if (centerPoint != null) {
                    if (this.segType == State.ARC && centerPoint.equals(chain.get(this.segCenter)) && ((Chain.CenterPoint)chain.get((int)this.segCenter)).radius == centerPoint.radius) {
                        chain.set(n4, null);
                        chain.set(this.segEnd, null);
                        this.segEnd = n3;
                        this.numAllVertices -= 2;
                    } else {
                        this.finishSeg(chain);
                        this.newArc(chain, n2, n4, n3);
                    }
                } else {
                    this.finishSeg(chain);
                    this.newLinestring();
                }
                jPoint2DD = jPoint2DD2;
                n2 = n3++;
            }
            this.finishSeg(chain);
            if (this.hasArc && this.hasLinestring) {
                ++this.numTriplets;
            }
        }

        private void finishSeg(Chain chain) {
            switch (this.segType) {
                case NULL: {
                    break;
                }
                case ARC: {
                    JPoint2DD jPoint2DD = chain.get(this.segStart);
                    JPoint2DD jPoint2DD2 = chain.get(this.segEnd);
                    Chain.CenterPoint centerPoint = (Chain.CenterPoint)chain.get(this.segCenter);
                    if (jPoint2DD.equals(jPoint2DD2)) {
                        chain.set(this.segStart, new JPoint2DD(centerPoint.x - centerPoint.radius, centerPoint.y));
                        chain.set(this.segCenter, new Chain.CenterPoint(new JPoint2DD(centerPoint.x, centerPoint.y + (double)(this.isSegCCW ? -1 : 1) * centerPoint.radius), -centerPoint.radius, false));
                        chain.set(this.segEnd, new JPoint2DD(centerPoint.x + centerPoint.radius, centerPoint.y));
                        this.isCircle = true;
                        this.hasArc = true;
                        ++this.numArcs;
                        break;
                    }
                    double d = Math.atan2(jPoint2DD.y - centerPoint.y, jPoint2DD.x - centerPoint.x);
                    double d2 = Math.atan2(jPoint2DD2.y - centerPoint.y, jPoint2DD2.x - centerPoint.x);
                    double d3 = d2 - d;
                    if (d3 < -Math.PI) {
                        d3 += Math.PI * 2;
                    }
                    if (d3 > Math.PI) {
                        d3 -= Math.PI * 2;
                    }
                    if (Math.abs(d3) < Math.PI / 90) {
                        boolean bl;
                        double d4;
                        int n;
                        int n2;
                        this.segType = State.LINESTRING;
                        this.hasLinestring = true;
                        ++this.numLinestrings;
                        if (this.isSegCCW && d3 < 0.0) {
                            d3 += Math.PI * 2;
                        }
                        if (!this.isSegCCW && d3 > 0.0) {
                            d3 -= Math.PI * 2;
                        }
                        if (this.isSegCCW) {
                            n2 = (int)Math.floor(d / 1.5707963267948966);
                            n = (int)Math.floor(d2 / 1.5707963267948966);
                        } else {
                            n2 = (int)Math.ceil(d / 1.5707963267948966);
                            n = (int)Math.ceil(d2 / 1.5707963267948966);
                        }
                        if (n2 != n) {
                            d4 = (double)n * Math.PI / 2.0;
                            bl = true;
                        } else if (Math.abs(d3) > Math.PI / 180) {
                            d4 = d + (d3 /= 2.0);
                            bl = true;
                        } else {
                            bl = false;
                            d4 = d;
                        }
                        if (bl) {
                            chain.set(this.segCenter, new JPoint2DD(centerPoint.x + centerPoint.radius * Math.cos(d4), centerPoint.y + centerPoint.radius * Math.sin(d4)));
                            break;
                        }
                        chain.set(this.segCenter, null);
                        --this.numAllVertices;
                        break;
                    }
                    if (this.isSegCCW && d3 < 0.0) {
                        d3 += Math.PI * 2;
                    }
                    if (!this.isSegCCW && d3 > 0.0) {
                        d3 -= Math.PI * 2;
                    }
                    chain.set(this.segCenter, new Chain.CenterPoint(new JPoint2DD(centerPoint.x + centerPoint.radius * Math.cos(d + (d3 /= 2.0)), centerPoint.y + centerPoint.radius * Math.sin(d + d3)), centerPoint.radius, false));
                    this.hasArc = true;
                    ++this.numArcs;
                    break;
                }
                case LINESTRING: {
                    this.hasLinestring = true;
                    ++this.numLinestrings;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Internal error");
                }
            }
            if (this.segType != this.prevSegType) {
                ++this.numTriplets;
            }
            this.prevSegType = this.segType;
            this.segType = State.NULL;
        }

        private void newArc(Chain chain, int n, int n2, int n3) {
            this.segType = State.ARC;
            this.segStart = n;
            this.segCenter = n2;
            this.segEnd = n3;
            this.isSegCCW = PSSegment.compare(chain.get(n), chain.get(n3)) > 0 ^ ((Chain.CenterPoint)chain.get((int)this.segCenter)).CUW;
        }

        private void newLinestring() {
            this.segType = State.LINESTRING;
        }

        int writeOrdinates(Chain chain, boolean bl, int n, double[] dArray, int[] nArray) {
            this.hasArc = false;
            this.hasLinestring = false;
            int n2 = 0;
            int n3 = chain.size();
            int n4 = n + 1;
            int n5 = -nArray[nArray.length - 1];
            if (n5 < 0) {
                throw new IllegalArgumentException("Internal error: elemInfo full");
            }
            int n6 = -1;
            JPoint2DD jPoint2DD = chain.get(0);
            dArray[n++] = jPoint2DD.x;
            dArray[n++] = jPoint2DD.y;
            State state = State.NULL;
            boolean bl2 = false;
            for (int i = 1; i < n3; ++i) {
                int n7 = n - 2;
                JPoint2DD jPoint2DD2 = chain.get(i);
                State state2 = State.NULL;
                if (jPoint2DD2 == null) continue;
                dArray[n++] = jPoint2DD2.x;
                dArray[n++] = jPoint2DD2.y;
                if (jPoint2DD2 instanceof Chain.CenterPoint) {
                    this.hasArc = true;
                    state2 = State.ARC;
                    if (((Chain.CenterPoint)jPoint2DD2).radius < 0.0) {
                        bl2 = true;
                    }
                    while ((jPoint2DD2 = chain.get(++i)) == null) {
                    }
                    dArray[n++] = jPoint2DD2.x;
                    dArray[n++] = jPoint2DD2.y;
                } else {
                    this.hasLinestring = true;
                    state2 = State.LINESTRING;
                }
                if (state != State.NULL && state2 != state) {
                    if (n6 < 0) {
                        nArray[n5++] = n4;
                        nArray[n5++] = bl ? 1005 : 2005;
                        n6 = n5;
                        nArray[n5++] = -1;
                    }
                    ++n2;
                    nArray[n5++] = n4;
                    nArray[n5++] = 2;
                    nArray[n5++] = state == State.ARC ? 2 : 1;
                    n4 = n7 + 1;
                }
                state = state2;
            }
            if (n6 < 0) {
                ++n2;
                nArray[n5++] = n4;
                int n8 = nArray[n5++] = bl ? 1003 : 2003;
                nArray[n5++] = state == State.ARC ? (bl2 ? 4 : 2) : 1;
            } else {
                nArray[n5++] = n4;
                nArray[n5++] = 2;
                nArray[n5++] = state == State.ARC ? 2 : 1;
                nArray[n6] = ++n2;
            }
            if (n5 < nArray.length) {
                nArray[nArray.length - 1] = -n5;
            }
            return n;
        }

        static enum State {
            ARC,
            LINESTRING,
            NULL;

        }
    }

    protected static class ElementIterator {
        public int ei = 0;
        public int nextei = 0;
        public int dim = 2;
        public int gtype = 0;
        public int[] elemInfo = null;
        public double[] ordinates = null;
        public int ord_offset = 0;
        public int etype = 0;
        public int original_etype = 0;
        public int top_etype = 0;
        public int eitpr = 0;
        public int next_ord_offset = 0;
        public int nCoord = 0;
        public int nSubElement = 0;
        public boolean lastElem = false;
        public boolean isFirstElemOfCompound = false;
        public boolean isCompound = false;
        public boolean isOrientedPoint = false;
        public int orient_offset = 2;

        public ElementIterator(JGeometry jGeometry) {
            this.gtype = jGeometry.gtype;
            this.elemInfo = jGeometry.elemInfo;
            this.ordinates = jGeometry.ordinates;
            if (jGeometry.dim > 0) {
                this.dim = jGeometry.dim;
            }
            if (jGeometry.isOrientedPoint() || jGeometry.isOrientedMultiPoint()) {
                this.isOrientedPoint = true;
                if (jGeometry.isOrientedMultiPoint()) {
                    this.orient_offset = jGeometry.getOrientMultiPointOffset();
                }
            }
        }

        public boolean next() {
            if (this.elemInfo == null) {
                return false;
            }
            if (this.isFirstElemOfCompound && this.nSubElement > 0) {
                this.isFirstElemOfCompound = false;
            }
            if (this.nSubElement > 0) {
                --this.nSubElement;
            }
            if (this.nSubElement == 0) {
                this.isCompound = false;
            }
            while (true) {
                if (this.ei > this.elemInfo.length - 3 || this.ei == 3 && this.isOrientedPoint) {
                    return false;
                }
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.original_etype = this.elemInfo[this.ei + 1];
                if (!this.isCompound) {
                    this.top_etype = this.etype;
                }
                this.eitpr = this.etype == 1 ? 1 : this.elemInfo[this.ei + 2];
                if (this.etype != 0) break;
                this.ei += 3;
            }
            if (this.etype >= 4) {
                this.isFirstElemOfCompound = true;
                this.isCompound = true;
                this.nSubElement = this.eitpr;
                this.ei += 3;
                this.etype = this.elemInfo[this.ei + 1] % 10;
                this.eitpr = this.elemInfo[this.ei + 2];
            }
            this.nextei = this.ei + 3;
            this.ord_offset = this.elemInfo[this.ei] - 1;
            this.etype = this.elemInfo[this.ei + 1];
            this.eitpr = this.etype == 1 ? 1 : this.elemInfo[this.ei + 2];
            boolean bl = this.lastElem = this.nextei > this.elemInfo.length - 3 || this.nextei == 3 && this.isOrientedPoint;
            if (this.isOrientedPoint) {
                this.nCoord = this.ordinates.length / (this.dim + this.orient_offset);
            } else {
                this.next_ord_offset = this.lastElem ? this.ordinates.length : this.elemInfo[this.nextei] - 1;
                this.nCoord = (this.next_ord_offset - this.ord_offset) / this.dim;
            }
            if (this.nSubElement > 1) {
                ++this.nCoord;
            }
            this.ei += 3;
            return true;
        }
    }

    public static class Point {
        double x;
        double y;
        double z;
        double m;

        public Point() {
            this.x = 0.0;
            this.y = 0.0;
        }

        public Point(double d, double d2) {
            this.x = d;
            this.y = d2;
        }

        public final boolean equals(Point point) {
            return this.x == point.x && this.y == point.y;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public void set(double d, double d2) {
            this.x = d;
            this.y = d2;
        }
    }

    private class LT_transform {
        double ne;
        double xc;
        double yc;
        double zc;
        double[] xrow;
        double[] yrow;
        double[] zrow;

        public LT_transform(double d, double d2, Gc_trans gc_trans) {
            double d3 = Math.cos(d2);
            double d4 = Math.sin(d2);
            double d5 = Math.cos(d);
            double d6 = Math.sin(d);
            this.ne = gc_trans.smax / Math.sqrt(1.0 - gc_trans.esq * d4 * d4);
            this.xc = d3 * d5 * this.ne;
            this.yc = d3 * d6 * this.ne;
            this.zc = d4 * (1.0 - gc_trans.esq) * this.ne;
            this.xrow = new double[3];
            this.yrow = new double[3];
            this.zrow = new double[3];
            this.xrow[0] = -d6;
            this.xrow[1] = d5;
            this.xrow[2] = 0.0;
            this.yrow[0] = -d5 * d4;
            this.yrow[1] = -d6 * d4;
            this.yrow[2] = d3;
            this.zrow[0] = d3 * d5;
            this.zrow[1] = d3 * d6;
            this.zrow[2] = d4;
        }
    }

    private class Gc_trans {
        double smax;
        double smin;
        double flat;
        double esq;
        double e;
        double t;
        double radius;
        double area;
        double unitfactor;
        int txsrid;

        public Gc_trans(double d, double d2) {
            this.txsrid = JGeometry.this.srid;
            this.smax = d;
            this.flat = d2;
            this.smin = this.smax * (1.0 - this.flat);
            this.esq = this.flat * (-this.flat + 2.0);
            this.e = Math.sqrt(this.esq);
            this.radius = this.e < 1.0E-8 ? this.smax * (1.0 - this.e / 4.0) : this.smax * Math.sqrt((2.0 * this.e + (1.0 - this.esq) * (Math.log(1.0 + this.e) - Math.log(1.0 - this.e))) / (4.0 * this.e));
            this.t = Math.sqrt(1.0 - this.esq);
            this.unitfactor = Math.PI / 180;
            this.area = Math.PI * 4 * this.radius * this.radius;
        }
    }
}

