/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicListUI;
import oracle.ide.util.JDK;

public class WindowsListUI
extends BasicListUI {
    private KeyListener keyListener;

    public static ComponentUI createUI(JComponent c) {
        return new WindowsListUI();
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            this.keyListener = this.createKeyListener();
            this.list.addKeyListener(this.keyListener);
        }
    }

    @Override
    protected void uninstallListeners() {
        super.uninstallListeners();
        if (JDK.HAS_BUG_TYPE_DOES_NOT_SCROLL_IN_JLIST) {
            this.list.removeKeyListener(this.keyListener);
            this.keyListener = null;
        }
    }

    private KeyListener createKeyListener() {
        return new KeyHandler();
    }

    static final class KeyHandler
    extends KeyAdapter {
        KeyHandler() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            JList src = (JList)e.getSource();
            ListModel model = src.getModel();
            if (model.getSize() == 0 || e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                return;
            }
            int index = src.getSelectedIndex();
            if (index >= 0) {
                src.ensureIndexIsVisible(index);
            }
        }
    }
}

