/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.plaf;

import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.MouseEvent;
import javax.swing.BoundedRangeModel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultCaret;

class FixedFieldCaret
extends DefaultCaret
implements UIResource {
    private boolean m_selectAll = true;

    FixedFieldCaret() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.getComponent().isEnabled()) {
            this.setVisible(true);
            this.setSelectionVisible(true);
            if (this.m_selectAll) {
                this.setDot(0);
                this.moveDot(this.getComponent().getDocument().getLength());
            }
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        super.focusLost(e);
        boolean doIt = true;
        if (doIt && !e.isTemporary()) {
            this.m_selectAll = true;
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (SwingUtilities.isLeftMouseButton(e)) {
            this.m_selectAll = false;
        }
        super.mousePressed(e);
    }

    @Override
    protected void adjustVisibility(Rectangle r) {
        JTextField field = (JTextField)this.getComponent();
        BoundedRangeModel vis = field.getHorizontalVisibility();
        int x = r.x + vis.getValue();
        int quarterSpan = vis.getExtent() / 4;
        if (x < vis.getValue()) {
            vis.setValue(x - quarterSpan);
        } else if (x > vis.getValue() + vis.getExtent()) {
            vis.setValue(x - 3 * quarterSpan);
        }
    }
}

