/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.net;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.logging.Level;
import javax.ide.util.MetaClass;
import javax.swing.Icon;
import oracle.ide.ExtensionRegistry;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLFileSystemHelperDecorator;
import oracle.ide.net.URLFileSystemListener;
import oracle.ide.net.URLFilter;

final class LazyURLFileSystemHelperDecorator
extends URLFileSystemHelperDecorator {
    private final MetaClass decoratorClass;
    private URLFileSystemHelper decorator;

    LazyURLFileSystemHelperDecorator(URLFileSystemHelper helper, MetaClass decoratorClass) {
        super(helper);
        this.decoratorClass = decoratorClass;
    }

    public URLFileSystemHelper getHelper() {
        return this.getDecorator();
    }

    private synchronized URLFileSystemHelper getDecorator() {
        if (this.decorator == null) {
            try {
                Class clazz = this.decoratorClass.toClass();
                Constructor c = clazz.getDeclaredConstructor(URLFileSystemHelper.class);
                this.decorator = (URLFileSystemHelper)c.newInstance(this._helper);
            }
            catch (ClassNotFoundException cnfe) {
                ExtensionRegistry.getExtensionRegistry().getLogger().severe("Failed to create URLFileSystemHelperDectorator " + this.decoratorClass.getClassName() + ". Class not found on classpath.");
            }
            catch (IllegalAccessException ille) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create URLFileSystemHelperDectorator " + this.decoratorClass.getClassName(), ille);
            }
            catch (InstantiationException ie) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create URLFileSystemHelperDectorator " + this.decoratorClass.getClassName(), ie);
            }
            catch (NoSuchMethodException nsme) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create URLFileSystemHelperDectorator " + this.decoratorClass.getClassName(), nsme);
            }
            catch (InvocationTargetException ite) {
                ExtensionRegistry.getExtensionRegistry().getLogger().log(Level.SEVERE, "Failed to create URLFileSystemHelperDectorator " + this.decoratorClass.getClassName(), ite);
            }
            if (this.decorator == null) {
                this.decorator = this._helper;
            }
        }
        return this.decorator;
    }

    public URL canonicalize(URL url) {
        return this.getDecorator().canonicalize(url);
    }

    public boolean canRead(URL url) {
        return this.getDecorator().canRead(url);
    }

    public boolean canWrite(URL url) {
        return this.getDecorator().canWrite(url);
    }

    public boolean canCreate(URL url) {
        return this.getDecorator().canCreate(url);
    }

    public boolean canDelete(URL url) {
        return this.getDecorator().canDelete(url);
    }

    public boolean isValid(URL url) {
        return this.getDecorator().isValid(url);
    }

    public URL convertSuffix(URL url, String oldSuffix, String newSuffix) {
        return this.getDecorator().convertSuffix(url, oldSuffix, newSuffix);
    }

    public void delete(URL url) throws IOException {
        this.getDecorator().delete(url);
    }

    public URL ensureSuffix(URL url, String suffix) {
        return this.getDecorator().ensureSuffix(url, suffix);
    }

    public boolean equals(URL url1, URL url2) {
        return this.getDecorator().equals(url1, url2);
    }

    public int hashCode(URL url) {
        return this.getDecorator().hashCode(url);
    }

    public boolean exists(URL url) {
        return this.getDecorator().exists(url);
    }

    public Icon getDefaultIcon(URL url) {
        return this.getDecorator().getDefaultIcon(url);
    }

    public String getFileName(URL url) {
        return this.getDecorator().getFileName(url);
    }

    public long getLength(URL url) {
        return this.getDecorator().getLength(url);
    }

    public String getName(URL url) {
        return this.getDecorator().getName(url);
    }

    public URL getParent(URL url) {
        return this.getDecorator().getParent(url);
    }

    public String getPath(URL url) {
        return this.getDecorator().getPath(url);
    }

    public String getPathNoExt(URL url) {
        return this.getDecorator().getPathNoExt(url);
    }

    public String getPlatformPathName(URL url) {
        return this.getDecorator().getPlatformPathName(url);
    }

    public String getSuffix(URL url) {
        return this.getDecorator().getSuffix(url);
    }

    public String getSystemDisplayName(URL url) {
        return this.getDecorator().getSystemDisplayName(url);
    }

    public Icon getSystemIcon(URL url) {
        return this.getDecorator().getSystemIcon(url);
    }

    public boolean hasSuffix(URL url, String suffix) {
        return this.getDecorator().hasSuffix(url, suffix);
    }

    public boolean isBaseURLFor(URL url1, URL url2) {
        return this.getDecorator().isBaseURLFor(url1, url2);
    }

    public boolean isDirectory(URL url) {
        return this.getDecorator().isDirectory(url);
    }

    public boolean isDirectoryPath(URL url) {
        return this.getDecorator().isDirectoryPath(url);
    }

    public boolean isHidden(URL url) {
        return this.getDecorator().isHidden(url);
    }

    public boolean isReadOnly(URL url) {
        return this.getDecorator().isReadOnly(url);
    }

    public boolean isRegularFile(URL url) {
        return this.getDecorator().isRegularFile(url);
    }

    public boolean isLocal(URL url) {
        return this.getDecorator().isLocal(url);
    }

    public long lastModified(URL url) {
        return this.getDecorator().lastModified(url);
    }

    public URL[] list(URL url) {
        return this.getDecorator().list(url);
    }

    public URL[] list(URL url, URLFilter filter) {
        return this.getDecorator().list(url, filter);
    }

    public URLFileSystem.FileInfo[] ls(URL url) {
        return this.getDecorator().ls(url);
    }

    public URLFileSystem.FileInfo[] ls(URL url, URLFilter filter) {
        return this.getDecorator().ls(url, filter);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url) {
        return this.getDecorator().lsCached(url);
    }

    public URLFileSystem.FileInfo[] lsCached(URL url, URLFilter filter) {
        return this.getDecorator().lsCached(url, filter);
    }

    public boolean mkdir(URL url) {
        return this.getDecorator().mkdir(url);
    }

    public boolean mkdirs(URL url) {
        return this.getDecorator().mkdirs(url);
    }

    public URL createTempFile(String prefix, String suffix, URL directory) throws IOException {
        return this.getDecorator().createTempFile(prefix, suffix, directory);
    }

    public InputStream openInputStream(URL url) throws IOException {
        return this.getDecorator().openInputStream(url);
    }

    public OutputStream openOutputStream(URL url) throws IOException {
        return this.getDecorator().openOutputStream(url);
    }

    public void rename(URL oldURL, URL newURL) throws IOException {
        this.getDecorator().rename(oldURL, newURL);
    }

    public boolean setLastModified(URL url, long time) {
        return this.getDecorator().setLastModified(url, time);
    }

    public boolean setReadOnly(URL url, boolean readOnly) {
        return this.getDecorator().setReadOnly(url, readOnly);
    }

    public String toDisplayString(URL url) {
        return this.getDecorator().toDisplayString(url);
    }

    public String toEncodedString(URL url) {
        return this.getDecorator().toEncodedString(url);
    }

    public String toRelativeSpec(URL url, URL base) {
        return this.getDecorator().toRelativeSpec(url, base);
    }

    public String toRelativeSpec(URL url, URL base, boolean mustConsumeBase) {
        return this.getDecorator().toRelativeSpec(url, base, mustConsumeBase);
    }

    public URL getBaseParent(URL url, String relativeSpec) {
        return this.getDecorator().getBaseParent(url, relativeSpec);
    }

    public Reader createReader(URL url, String encoding) throws IOException {
        return this.getDecorator().createReader(url, encoding);
    }

    public void addURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this.getDecorator().addURLFileSystemListener(rootURL, listener);
    }

    public void removeURLFileSystemListener(URL rootURL, URLFileSystemListener listener) {
        this.getDecorator().removeURLFileSystemListener(rootURL, listener);
    }
}

