/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.layout;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.controls.WaitCursor;
import oracle.ide.layout.LayoutResetEvent;
import oracle.ide.layout.LayoutResetListener;
import oracle.ide.layout.Layouts;
import oracle.ide.util.Assert;
import oracle.ide.util.DefaultStructuredPropertyAccess;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ide.view.View;
import oracle.ideimpl.docking.VisibilityLayout;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import org.xml.sax.SAXException;

public class LayoutsImpl
extends Layouts {
    private static final String LAYOUT_FILE_NAME = "windowinglayout";
    private static final String LAYOUT_ROOT_TAG = "LayoutInfo";
    private static LayoutsImpl INSTANCE;
    private DefaultStructuredPropertyAccess _layoutInfo;
    private HashMap _visibilityLayouts = new HashMap();
    private static final String KEY_KNOWN_DOCKABLE_FACTORIES = "knownDockableFactories";
    private static final String KEY_DOCKABLE_POSITIONS = "dockingPositions";
    private static final String KEY_VISIBILITY_LAYOUT = "visibilityLayouts";
    private static final String KEY_CLIENT_LAYOUT_DATA = "clientLayoutData";
    private static final String KEY_KNOWN_TIGGERED_LAYOUTS = "knowTriggeredLayouts";
    private Collection<String> triggeredLayouts = new HashSet<String>();
    private File testFileConfig;

    private LayoutsImpl() {
    }

    public static LayoutsImpl createInstance() {
        Assert.check((INSTANCE == null ? 1 : 0) != 0);
        INSTANCE = new LayoutsImpl();
        return LayoutsImpl.getInstance();
    }

    public static LayoutsImpl getInstance() {
        return INSTANCE;
    }

    private DefaultStructuredPropertyAccess getLayoutInfo() {
        if (this._layoutInfo == null) {
            this.loadLayoutInfo();
        }
        return this._layoutInfo;
    }

    public boolean hasLayoutInfo(String root) {
        boolean hasLayoutInfo = false;
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        if (layoutInfo.hasChildNodes()) {
            Iterator childNodes = layoutInfo.getChildNodes(root);
            hasLayoutInfo = childNodes.hasNext();
        }
        return hasLayoutInfo;
    }

    public StructuredPropertyAccess getLayoutInfo(String root) {
        StructuredPropertyAccess ret = this.getLayoutInfo().getChildNode(root);
        return ret;
    }

    public void setLayoutInfo(StructuredPropertyAccess root) {
        String rootName = root.getName();
        StructuredPropertyAccess oldInfo = this.getLayoutInfo(rootName);
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        if (oldInfo != null) {
            layoutInfo.removeChild(oldInfo);
        }
        layoutInfo.appendChild(root);
    }

    private void loadLayoutInfo() {
        String[] serialiazedTriggeredLayouts;
        File fileConfig = null;
        fileConfig = this.testFileConfig != null ? this.testFileConfig : LayoutsImpl.getLayoutFile();
        if (fileConfig.exists()) {
            try {
                this._layoutInfo = DefaultStructuredPropertyAccess.loadFromXML(fileConfig);
                this.loadVisibility();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (this._layoutInfo == null) {
            this._layoutInfo = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_TAG);
        }
        if ((serialiazedTriggeredLayouts = this.getStringArrayFromStructure(KEY_KNOWN_TIGGERED_LAYOUTS)) != null) {
            this.triggeredLayouts.addAll(Arrays.asList(serialiazedTriggeredLayouts));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreLayoutsToFactorySettings(ActionListener resetAction) {
        WaitCursor waitCursor = new WaitCursor((Component)((Object)Ide.getMainWindow()));
        waitCursor.show();
        try {
            LayoutResetEvent event = new LayoutResetEvent(this.getActiveLayout());
            List<LayoutResetListener> listeners = super.layoutResetListeners();
            View lastActiveView = Ide.getMainWindow().getLastActiveView();
            Context context = Ide.getMainWindow().getIdeMainWindowView().getContext();
            if (context == null && lastActiveView != null) {
                context = lastActiveView.getContext();
            }
            for (LayoutResetListener l : listeners) {
                l.beforeLayoutReset(event);
            }
            this.doResetLayouts(listeners, event, resetAction);
            for (LayoutResetListener l : listeners) {
                l.afterLayoutReset(event);
            }
        }
        finally {
            waitCursor.hide();
        }
    }

    private void doResetLayouts(List<LayoutResetListener> listeners, LayoutResetEvent event, ActionListener resetAction) {
        this._layoutInfo = new DefaultStructuredPropertyAccess(LAYOUT_ROOT_TAG);
        this.saveLayoutInfo(this._layoutInfo);
        resetAction.actionPerformed(null);
        for (LayoutResetListener l : listeners) {
            l.afterLayoutActivation(event);
        }
    }

    public void saveLayoutInfo() {
        this.saveLayoutInfo(this.getLayoutInfo());
    }

    private void saveLayoutInfo(DefaultStructuredPropertyAccess layoutInfo) {
        File fileConfig = LayoutsImpl.getLayoutFile();
        try {
            DefaultStructuredPropertyAccess.saveToXML(layoutInfo, fileConfig);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static File getLayoutFile() {
        URL url = ExtensionRegistry.getOracleRegistry().getSystemDirectory("oracle.ide");
        File fileConfig = new File(url.getPath(), LAYOUT_FILE_NAME + ExtensionManagerImpl.getExtensionRegistry().getRoleManager().getActiveRole().getId() + ".xml");
        return fileConfig;
    }

    @Override
    public void saveAll() {
        super.saveAll();
        this.saveVisibility();
        this.saveLayoutInfo();
    }

    private void saveVisibility() {
        DefaultStructuredPropertyAccess visibilityNode = new DefaultStructuredPropertyAccess(KEY_VISIBILITY_LAYOUT);
        Set knownLayouts = this._visibilityLayouts.keySet();
        for (String layoutName : knownLayouts) {
            VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(layoutName);
            StructuredPropertyAccess layout = visibilityLayout.save();
            visibilityNode.appendChild(layout);
        }
        DefaultStructuredPropertyAccess layoutInfo = this.getLayoutInfo();
        StructuredPropertyAccess oldVisibilityNode = layoutInfo.getChildNode(KEY_VISIBILITY_LAYOUT);
        if (oldVisibilityNode != null) {
            layoutInfo.removeChild(oldVisibilityNode);
        }
        this.getLayoutInfo().appendChild(visibilityNode);
    }

    private void loadVisibility() {
        StructuredPropertyAccess root = this.getLayoutInfo(KEY_VISIBILITY_LAYOUT);
        if (root != null) {
            Iterator childNodes = root.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                VisibilityLayout visibilityLayout = VisibilityLayout.load(child);
                String layoutName = child.getName();
                this._visibilityLayouts.put(layoutName, visibilityLayout);
            }
        }
    }

    public boolean hasDockableFactoryNode() {
        return this.hasLayoutInfo(KEY_KNOWN_DOCKABLE_FACTORIES);
    }

    public String[] getKnownDockableFactories() {
        return this.getStringArrayFromStructure(KEY_KNOWN_DOCKABLE_FACTORIES);
    }

    private String[] getStringArrayFromStructure(String key) {
        ArrayList<String> ret = new ArrayList<String>();
        StructuredPropertyAccess spa = this.getLayoutInfo(key);
        if (spa != null) {
            Iterator childNodes = spa.getChildNodes();
            while (childNodes.hasNext()) {
                StructuredPropertyAccess child = (StructuredPropertyAccess)childNodes.next();
                String name = child.getName();
                ret.add(name);
            }
        }
        return ret.toArray(new String[ret.size()]);
    }

    public void setKnownDockableFactories(String[] factoryNames) {
        this.setStringArrayStructure(factoryNames, KEY_KNOWN_DOCKABLE_FACTORIES);
        String[] triggeredLayoutsArray = this.triggeredLayouts.toArray(new String[this.triggeredLayouts.size()]);
        this.setStringArrayStructure(triggeredLayoutsArray, KEY_KNOWN_TIGGERED_LAYOUTS);
    }

    private void setStringArrayStructure(String[] names, String key) {
        DefaultStructuredPropertyAccess newNode = new DefaultStructuredPropertyAccess(key);
        for (int i = 0; i < names.length; ++i) {
            String name = names[i];
            DefaultStructuredPropertyAccess node = new DefaultStructuredPropertyAccess(name);
            newNode.appendChild(node);
        }
        StructuredPropertyAccess oldNode = this.getLayoutInfo(key);
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        this.getLayoutInfo().appendChild(newNode);
    }

    public StructuredPropertyAccess getDockablePositions() {
        StructuredPropertyAccess dockablePositions = null;
        dockablePositions = this.getLayoutInfo(KEY_DOCKABLE_POSITIONS);
        return dockablePositions;
    }

    public void setDockablePositions(StructuredPropertyAccess positions) {
        StructuredPropertyAccess oldNode = this.getDockablePositions();
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        positions.setName(KEY_DOCKABLE_POSITIONS);
        this.getLayoutInfo().appendChild(positions);
    }

    public VisibilityLayout getVisibilityLayout(String displayName) {
        String internalName = displayName.replace(' ', '_');
        VisibilityLayout visibilityLayout = (VisibilityLayout)this._visibilityLayouts.get(internalName);
        if (visibilityLayout == null) {
            visibilityLayout = new VisibilityLayout(internalName, displayName);
            this._visibilityLayouts.put(internalName, visibilityLayout);
        }
        return visibilityLayout;
    }

    public StructuredPropertyAccess getClientLayoutData() {
        StructuredPropertyAccess pa = this.getLayoutInfo(KEY_CLIENT_LAYOUT_DATA);
        if (pa == null) {
            pa = new DefaultStructuredPropertyAccess(KEY_CLIENT_LAYOUT_DATA);
            this.getLayoutInfo().appendChild(pa);
        }
        return pa;
    }

    public StructuredPropertyAccess findClientLayoutData() {
        return this.getLayoutInfo(KEY_CLIENT_LAYOUT_DATA);
    }

    public void setClientLayoutData(StructuredPropertyAccess clientData) {
        StructuredPropertyAccess oldNode = this.findClientLayoutData();
        if (oldNode != null) {
            this.getLayoutInfo().removeChild(oldNode);
        }
        clientData.setName(KEY_CLIENT_LAYOUT_DATA);
        this.getLayoutInfo().appendChild(clientData);
    }

    @Deprecated
    public boolean isDockableTabbed(String ID) {
        return LayoutsImpl.isDockableTabbed(ID, this.getDockablePositions());
    }

    private static boolean isDockableTabbed(String ID, StructuredPropertyAccess node) {
        if (node == null) {
            return false;
        }
        Iterator nodes = node.getChildNodes();
        while (nodes.hasNext()) {
            StructuredPropertyAccess node_ = (StructuredPropertyAccess)nodes.next();
            Iterator dockables = node.getChildNodes("dockable");
            int i = 0;
            boolean rightLeaf = false;
            while (dockables.hasNext()) {
                ++i;
                StructuredPropertyAccess dockable = (StructuredPropertyAccess)dockables.next();
                if (dockable.getProperty("ID", "").equals(ID)) {
                    rightLeaf = true;
                }
                if (!rightLeaf || i <= 1) continue;
                return true;
            }
            if (!LayoutsImpl.isDockableTabbed(ID, node_)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public boolean isVisible(String id) {
        if (this.getKnownDockableFactories() != null && this.getKnownDockableFactories().length == 0) {
            return true;
        }
        return LayoutsImpl.checkVisibilityLayout(id, this.getVisibilityLayout(this.getActive().getName()));
    }

    private static boolean checkVisibilityLayout(String id, VisibilityLayout vl) {
        StructuredPropertyAccess pa = vl.save();
        Iterator i = pa.getChildNodes();
        String activeRoleId = ExtensionManagerImpl.getExtensionRegistry().getRoleManager().getActiveRole().getId();
        while (i.hasNext()) {
            String roleId;
            StructuredPropertyAccess spa = (StructuredPropertyAccess)i.next();
            if (!spa.getName().equals(id) && !spa.getName().contains(id + ".") || !vl.isRaised(spa.getName()) || !vl.isVisible(spa.getName()) || (roleId = vl.getExclusiveRoleForDockable(spa.getName())) != null && (roleId == null || !roleId.equals(activeRoleId))) continue;
            return true;
        }
        return false;
    }

    public void addTriggeredLayout(String layoutName) {
        if (layoutName == null) {
            return;
        }
        this.triggeredLayouts.add(layoutName);
    }

    public Collection<String> getTriggeredLayouts() {
        return Collections.unmodifiableCollection(this.triggeredLayouts);
    }

    private void setTestFileConfig(File testFileConfig) {
        this.testFileConfig = testFileConfig;
    }
}

