/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.jsr198.model;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ide.model.Document;
import javax.ide.model.DocumentEvent;
import javax.ide.model.DocumentFactory;
import javax.ide.model.DocumentListener;
import javax.ide.model.spi.DocumentImpl;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ideimpl.jsr198.model.ElementBridge;

class NodeBridge
extends ElementBridge
implements DocumentImpl {
    private static BridgeNodeListener s_bridgeListener = new BridgeNodeListener();
    private final URI _uri;

    public NodeBridge(URI uri) {
        this._uri = uri;
    }

    @Override
    protected final Element getIdeElement() {
        try {
            return NodeFactory.findOrCreate(VirtualFileSystem.getVirtualFileSystem().toURL(this._uri));
        }
        catch (Exception mue) {
            mue.printStackTrace();
            return null;
        }
    }

    private final Node getIdeNode() {
        return (Node)this.getIdeElement();
    }

    public final URI getURI() {
        return this._uri;
    }

    public final void setURI(URI uri) {
        try {
            URL url = uri.toURL();
            this.getIdeNode().setURL(url);
        }
        catch (MalformedURLException mfe) {
            mfe.printStackTrace();
        }
    }

    public final boolean isOpen() {
        return this.getIdeNode().isOpen();
    }

    public final boolean isNew() {
        return this.getIdeNode().isNew();
    }

    public final void open() throws IOException {
        this.getIdeNode().open();
    }

    public final void close() throws IOException {
        this.getIdeNode().close();
    }

    public final void save() throws IOException {
        this.getIdeNode().save();
    }

    public final boolean isReadOnly() {
        return this.getIdeNode().isReadOnly();
    }

    public final boolean isDirty() {
        return this.getIdeNode().isDirty();
    }

    public final void markDirty(boolean dirty) {
        this.getIdeNode().markDirty(dirty);
    }

    public final long getTimestamp() {
        return this.getIdeNode().getTimestamp();
    }

    public Reader getReader() throws IOException {
        return new InputStreamReader(this.getIdeNode().getInputStream());
    }

    public final void addDocumentListener(DocumentListener listener) {
        Node node = this.getIdeNode();
        if (!s_bridgeListener.hasListenersFor(node)) {
            node.addNodeListener(s_bridgeListener);
        }
        s_bridgeListener.addDocumentListener(node, listener);
    }

    public final void removeDocumentListener(DocumentListener listener) {
        Node node = this.getIdeNode();
        s_bridgeListener.removeDocumentListener(node, listener);
        if (!s_bridgeListener.hasListenersFor(node)) {
            node.removeNodeListener(s_bridgeListener);
        }
    }

    private static class BridgeNodeListener
    extends NodeListener {
        private Map _javaxideListeners = new HashMap();

        private BridgeNodeListener() {
        }

        boolean hasListenersFor(Node node) {
            return this._javaxideListeners.keySet().contains(node);
        }

        void addDocumentListener(Node doc, DocumentListener listener) {
            ArrayList<DocumentListener> l = (ArrayList<DocumentListener>)this._javaxideListeners.get(doc);
            if (l == null) {
                l = new ArrayList<DocumentListener>();
                this._javaxideListeners.put(doc, l);
            }
            l.add(listener);
        }

        void removeDocumentListener(Node doc, DocumentListener listener) {
            List l = (List)this._javaxideListeners.get(doc);
            if (l != null) {
                l.remove(listener);
            }
        }

        private DocumentEvent createDocumentEvent(NodeEvent ne) {
            URL url = ne.getNodeURL();
            try {
                URI uri = URIFactory.newURI((URL)url);
                Document document = DocumentFactory.getDocumentFactory().findOrCreate(uri);
                return new DocumentEvent(document);
            }
            catch (Exception e) {
                e.printStackTrace();
                return new DocumentEvent(null);
            }
        }

        private List getListeners(Node node) {
            List l = (List)this._javaxideListeners.get(node);
            if (l == null) {
                return Collections.EMPTY_LIST;
            }
            return l;
        }

        @Override
        public void nodeClosed(NodeEvent e) {
            DocumentEvent event = this.createDocumentEvent(e);
            for (DocumentListener dl : this.getListeners(e.getNode())) {
                dl.closed(event);
            }
        }

        @Override
        public void nodeDeleted(NodeEvent e) {
        }

        @Override
        public void nodeDirtyStateChanged(NodeEvent e, boolean isNowDirty) {
            if (isNowDirty) {
                DocumentEvent event = this.createDocumentEvent(e);
                for (DocumentListener dl : this.getListeners(e.getNode())) {
                    dl.modified(event);
                }
            }
        }

        @Override
        public void nodeOpened(NodeEvent e) {
            DocumentEvent event = this.createDocumentEvent(e);
            for (DocumentListener dl : this.getListeners(e.getNode())) {
                dl.opened(event);
            }
        }

        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
        }

        @Override
        public void nodeReverted(NodeEvent e) {
        }

        @Override
        public void nodeSaved(NodeEvent e) {
            DocumentEvent event = this.createDocumentEvent(e);
            for (DocumentListener dl : this.getListeners(e.getNode())) {
                dl.saved(event);
            }
        }

        @Override
        public void nodeWillBeSaved(NodeEvent e) {
            DocumentEvent event = this.createDocumentEvent(e);
            for (DocumentListener dl : this.getListeners(e.getNode())) {
                dl.willBeSaved(event);
            }
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            DocumentEvent event = this.createDocumentEvent(e);
            for (DocumentListener dl : this.getListeners(e.getNode())) {
                dl.willBeClosed(event);
            }
        }

        @Override
        public void nodeWillOpen(NodeEvent e) {
        }
    }
}

