/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.util;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.IDEExtension;

public class ExtensionLoadingReason {
    public static final short UNKNOWN_REASON_TYPE = -1;
    public static final short DIRECTLY_TRIGGERED_REASON_TYPE = 1;
    public static final short INCLUDED_VIA_DEPENDENCY_REASON_TYPE = 2;
    public static final short INCLUDED_VIA_FEATURE_REASON_TYPE = 3;
    public static final short INCLUDED_VIA_BRIDGE_REASON_TYPE = 4;
    public static final short STARTUP_EXTENSION_REASON_TYPE = 5;
    public static final String UNKNOWN_MESSAGE = "Unknown";
    private final IDEExtension _extension;
    private String _triggerReason = null;
    private String _loadingSet = null;
    private short _reasonType = (short)-1;
    private Set<String> _incomingDependenciesInLoadingSet = null;
    private Bridge _bridge = null;

    public ExtensionLoadingReason(IDEExtension extension) {
        this._extension = extension;
    }

    public String getTriggerReason() {
        if (this._triggerReason == null) {
            return UNKNOWN_MESSAGE;
        }
        return this._triggerReason;
    }

    public void setTriggerReason(String triggerReason) {
        if (!this.isAlreadyLoaded() && this._triggerReason == null) {
            this.setReasonTypeIfUnset((short)1);
            this._triggerReason = triggerReason;
        }
    }

    public String getLoadingSet() {
        if (this._loadingSet == null) {
            return UNKNOWN_MESSAGE;
        }
        return this._loadingSet;
    }

    public void setLoadingSet(String loadingSet) {
        if (!this.isAlreadyLoaded() && this._loadingSet == null) {
            this._loadingSet = loadingSet;
        }
    }

    public short getReasonType() {
        return this._reasonType;
    }

    public void setReasonTypeIfUnset(short reasonType) {
        if (!this.isAlreadyLoaded() && this._reasonType == -1) {
            this._reasonType = reasonType;
        }
    }

    public Set<String> getIncomingDependenciesInLoadingSet() {
        if (this._incomingDependenciesInLoadingSet == null) {
            return Collections.emptySet();
        }
        return this._incomingDependenciesInLoadingSet;
    }

    public void reportIncomingDependencyInLoadingSet(String relatedExtensionId) {
        if (!this.isAlreadyLoaded()) {
            this.setReasonTypeIfUnset((short)2);
            if (this._incomingDependenciesInLoadingSet == null) {
                this._incomingDependenciesInLoadingSet = new LinkedHashSet<String>(4);
            }
            this._incomingDependenciesInLoadingSet.add(relatedExtensionId);
        }
    }

    public void reportLoadedViaBridge(Bridge bridge) {
        if (!this.isAlreadyLoaded()) {
            this.setReasonTypeIfUnset((short)4);
            this._bridge = bridge;
        }
    }

    public Bridge getBridge() {
        return this._bridge;
    }

    public boolean isAlreadyLoaded() {
        return this._extension.getState() == IDEExtension.State.FULLY_LOADED;
    }
}

