/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.util;

import java.util.logging.Logger;
import javax.ide.extension.Extension;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.util.ExtensionLoadingLogRecord;
import oracle.ideimpl.extension.util.ExtensionLoadingReason;

public final class ExtensionLoadingDiagnostics {
    private static ExtensionLoadingDiagnostics _sInstance = new ExtensionLoadingDiagnostics();

    public static ExtensionLoadingDiagnostics getInstance() {
        return _sInstance;
    }

    public void setTriggerReason(Extension extension, String triggerReason) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            reason.setTriggerReason(triggerReason);
        }
    }

    public void setLoadingSet(Extension extension, String loadingSet) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            reason.setLoadingSet(loadingSet);
        }
    }

    public void reportReasonTypeIfUnset(Extension extension, short reasonType) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            reason.setReasonTypeIfUnset(reasonType);
        }
    }

    public void reportIncomingDependency(Extension extension, String relatedExtensionId) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            reason.reportIncomingDependencyInLoadingSet(relatedExtensionId);
        }
    }

    public void reportLoadedViaBridge(Extension extension, Bridge bridge) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            reason.reportLoadedViaBridge(bridge);
        }
    }

    public void logExtensionLoadingDiagnostics(Extension extension, Logger logger) {
        ExtensionLoadingReason reason = this._getExtensionLoadingReason(extension);
        if (reason != null) {
            IDEExtension ideExtension = (IDEExtension)extension;
            ExtensionLoadingLogRecord record = new ExtensionLoadingLogRecord(ideExtension);
            logger.log(record);
        }
    }

    private ExtensionLoadingReason _getExtensionLoadingReason(Extension extension) {
        if (extension instanceof IDEExtension) {
            return ((IDEExtension)extension).getDetailedLoadingReason();
        }
        return null;
    }

    private ExtensionLoadingDiagnostics() {
    }
}

