/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Ide;
import oracle.ide.config.DTCache;
import oracle.ide.config.Preferences;
import oracle.ide.extension.preference.ManageFeaturesPanelListener;
import oracle.ide.extension.preference.ManageFeaturesPanelType;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.Assert;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.extension.preference.FeatureFilter;
import oracle.ideimpl.extension.preference.ManageFeaturesTreePanel;
import oracle.ideimpl.resource.ManageFeaturesArb;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.RichHintLabel;

final class ManageFeaturesPanel
extends JPanel
implements ManageFeaturesPanelListener {
    private static final String TREE_EXPANSION_STATE_KEY = "features-tree-expansion-state";
    private static final GridBagConstraints NORTH_CONSTRAINTS = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
    private static final GridBagConstraints CENTER_CONSTRAINTS = new GridBagConstraints(0, 1, 1, 5, 1.0, 1.0, 10, 1, new Insets(10, 0, 8, 0), 0, 0);
    private static final GridBagConstraints SOUTH_CONSTRAINTS = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 14, 0, new Insets(0, 0, 0, 0), 0, 0);
    private final RichHintLabel _headerLabel = new RichHintLabel();
    private final ManageFeaturesTreePanel _treePanel;
    private final JButton _updateStatusButton = new JButton();

    ManageFeaturesPanel() {
        this(false);
    }

    ManageFeaturesPanel(boolean readOnly) {
        super(new GridBagLayout());
        this._treePanel = new ManageFeaturesTreePanel(readOnly);
        try {
            this._headerLabel.setHtmlText(ManageFeaturesArb.format(1, Ide.getProgramShortName()));
            this.add((Component)this._headerLabel, NORTH_CONSTRAINTS);
            this.add((Component)this._treePanel, CENTER_CONSTRAINTS);
            AbstractAction updateStatusAction = this.getUpdateStatusAction();
            updateStatusAction.setEnabled(false);
            this._treePanel.setPanelChangedListener(this);
            this._updateStatusButton.setAction(updateStatusAction);
            this.add((Component)this._updateStatusButton, SOUTH_CONSTRAINTS);
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
        }
    }

    private AbstractAction getUpdateStatusAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ManageFeaturesPanel.this.doUpdate();
            }
        };
        String label = ManageFeaturesArb.getString(24);
        action.putValue("Name", StringUtils.stripMnemonic((String)label));
        action.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)label));
        return action;
    }

    void setDisabledIds(Set<String> set) {
        this._treePanel.setDisabledIds(set);
    }

    void populate() {
        this.populate(null);
    }

    void populate(FeatureFilter filter) {
        this._treePanel.setFilter(filter);
        this._treePanel.populate();
        DTCache cache = Ide.getDTCache();
        String expandedNodes = cache.getString(TREE_EXPANSION_STATE_KEY);
        if (expandedNodes != null) {
            this._treePanel.restoreTreeExpansion(expandedNodes.split(";"));
        }
    }

    void saveTreeExpansionState() {
        String[] expansionState = this._treePanel.getTreeExpansionState();
        DTCache cache = Ide.getDTCache();
        if (expansionState.length == 0) {
            cache.remove(TREE_EXPANSION_STATE_KEY);
            return;
        }
        StringBuilder b = new StringBuilder();
        String delim = "";
        for (String s : expansionState) {
            b.append(delim).append(s);
            delim = ";";
        }
        cache.putString(TREE_EXPANSION_STATE_KEY, b.toString());
    }

    Component getFirstFocusComponent() {
        return this._treePanel.getFirstFocusComponent();
    }

    void setHeaderComponent(Component header) {
        this.remove((Component)this._headerLabel);
        if (header != null) {
            this.add(header, NORTH_CONSTRAINTS);
        }
    }

    private void doUpdate() {
        if (this.haveDisabledIdsChanged()) {
            this.applyExtensionPreferences();
            try {
                Preferences.getPreferences().save();
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
            if (ManageFeaturesPanel.confirmRestart()) {
                try {
                    Ide.restart();
                }
                catch (UnsupportedOperationException uoe) {
                    MessageDialog.error((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(454), (String)IdeArb.getString(453), null);
                }
            }
        }
    }

    private void applyExtensionPreferences() {
        if (this._treePanel.isReadOnly()) {
            return;
        }
        if (!this.haveDisabledIdsChanged()) {
            return;
        }
        ExtensionPreferences prefs = ExtensionPreferences.getInstance();
        prefs.setDisabledIds(this._treePanel.getDisabledIds());
        try {
            prefs.save();
            this._updateStatusButton.setEnabled(false);
        }
        catch (IOException ioe) {
            Assert.printStackTrace((Throwable)ioe);
        }
    }

    public boolean haveDisabledIdsChanged() {
        return this._treePanel.hasChanges();
    }

    private static boolean confirmRestart() {
        return MessageDialog.confirm((Component)((Object)Ide.getMainWindow()), (Object)IdeArb.getString(452), (String)IdeArb.getString(451), null);
    }

    @Override
    public void panelChanged(ManageFeaturesPanelType type) {
        this._updateStatusButton.setEnabled(this._treePanel.hasChanges());
        if (this._treePanel.hasChanges()) {
            this._updateStatusButton.requestFocus();
        }
    }
}

