/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.preference;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.ewt.help.HelpUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.util.IdeUtil;
import oracle.ideimpl.extension.preference.ExtensionPreferences;
import oracle.ideimpl.extension.preference.ManageFeaturesAndUpdatesPanel;
import oracle.ideimpl.extension.preference.ManageFeaturesPanel;
import oracle.ideimpl.resource.ManageFeaturesArb;

class ManageFeaturesController
implements Controller {
    private boolean _disabled;
    JEWTDialog dlg;
    private static final int MANAGE_FEATURES_CMD_ID = Ide.findOrCreateCmdID("oracle.ide.features.ManageFeaturesAction");

    ManageFeaturesController() {
        Set<Object> keySet = System.getProperties().keySet();
        if (keySet.contains("ide.extensions") || keySet.contains("ide.noextensions")) {
            this._disabled = true;
        }
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        if (MANAGE_FEATURES_CMD_ID == action.getCommandId()) {
            HashSet<Object> _disabledIds = null;
            ExtensionPreferences options = ExtensionPreferences.getInstance();
            _disabledIds = options != null ? new HashSet<String>(options.getDisabledIds()) : new HashSet();
            ManageFeaturesPanel featuresPanel = new ManageFeaturesPanel(this._disabled);
            HashSet<String> copy = new HashSet<String>(_disabledIds);
            featuresPanel.setDisabledIds(copy);
            featuresPanel.populate();
            ManageFeaturesAndUpdatesPanel featuresAndUpdatePanel = new ManageFeaturesAndUpdatesPanel(featuresPanel);
            String dlgTitle = ManageFeaturesArb.getString(0);
            this.dlg = JEWTDialog.createDialog((Component)IdeUtil.getMainWindow(), (String)dlgTitle, (int)4);
            HelpUtils.setHelpID((JComponent)featuresAndUpdatePanel, (String)"f1_idedidemangefeatures_html");
            this.dlg.setContent((Component)featuresAndUpdatePanel);
            this.dlg.setInitialFocus(featuresPanel.getFirstFocusComponent());
            this.dlg.pack();
            this.dlg.setMaximumInitialSize(800, 600);
            this.dlg.setResizable(true);
            JButton closeButton = new JButton();
            closeButton.setName("Close_Button");
            closeButton.setAction(this.getCloseAction(featuresAndUpdatePanel));
            this.dlg.addCustomButton((Component)closeButton);
            this.dlg.runDialog();
            featuresPanel.saveTreeExpansionState();
            this.dlg.dispose();
            return true;
        }
        return false;
    }

    private AbstractAction getCloseAction(final ManageFeaturesAndUpdatesPanel panel) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (panel.shouldClose()) {
                    ManageFeaturesController.this.dlg.closeDialog(true);
                }
            }
        };
        String label = ManageFeaturesArb.getString(35);
        action.putValue("Name", StringUtils.stripMnemonic((String)label));
        action.putValue("MnemonicKey", StringUtils.getMnemonicKeyCode((String)label));
        return action;
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        if (MANAGE_FEATURES_CMD_ID == action.getCommandId()) {
            action.setEnabled(true);
            return true;
        }
        return false;
    }
}

