/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.macros;

import java.lang.reflect.Field;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.ElementContext;
import javax.ide.extension.spi.ExtensionLogRecord;
import oracle.ide.extension.macros.ExtensionMacroByPrefix;
import oracle.javatools.icons.OracleIcons;

public class OracleIconsExtensionMacro
extends ExtensionMacroByPrefix {
    static final String ORACLEICONS = "OracleIcons.";

    @Override
    public String getPrefix() {
        return ORACLEICONS;
    }

    @Override
    public String expandMacro(String unexpandedMacro, ElementContext elementContext) {
        String fieldName = unexpandedMacro.substring(ORACLEICONS.length());
        try {
            String basePath = "res:/" + OracleIcons.class.getPackage().getName().replace('.', '/') + '/';
            Field f = OracleIcons.class.getField(fieldName);
            if (f != null) {
                return basePath + f.get(null);
            }
        }
        catch (NoSuchFieldException e) {
            elementContext.getLogger().log((LogRecord)new ExtensionLogRecord(elementContext, Level.WARNING, "No icon called '" + fieldName + "' exists in OracleIcons."));
        }
        catch (Exception e) {
            ExtensionLogRecord record = new ExtensionLogRecord(elementContext, Level.SEVERE, "An exception occurred retrieving OracleIcons." + fieldName);
            record.setThrown(e);
            elementContext.getLogger().log((LogRecord)record);
        }
        return null;
    }
}

