/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.feature;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.ide.extension.Extension;
import javax.ide.extension.ExtensionDependency;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.extension.feature.FeatureRegistry;
import oracle.ide.extension.feature.FeatureType;
import oracle.ide.extension.feature.TechnologyFeatureType;
import oracle.ideimpl.extension.ExtensionGroups;
import oracle.ideimpl.extension.feature.FeatureImpl;

public final class FeatureRegistryImpl
extends FeatureRegistry {
    private static final FeatureRegistryImpl _sInstance = new FeatureRegistryImpl();
    private ConcurrentHashMap<String, FeatureImpl> _featureMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FeatureImpl> _technologyToFeatureMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, FeatureCategory> _featureCategoryMap = new ConcurrentHashMap();
    private ConcurrentHashMap<Extension, Set<Feature>> _featuresInDependencyTreeCache = new ConcurrentHashMap();
    private ConcurrentHashMap<Feature, Set<Feature>> _outgoingDependencyCache = new ConcurrentHashMap();

    public static FeatureRegistryImpl getInstance() {
        return _sInstance;
    }

    @Override
    public List<Feature> getFeatures() {
        ArrayList<Feature> featureList = new ArrayList<Feature>(this._featureMap.size());
        featureList.addAll(this._featureMap.values());
        return featureList;
    }

    @Override
    public Feature getFeature(String id) {
        return this._featureMap.get(id);
    }

    @Override
    public List<FeatureCategory> getCategories() {
        ArrayList<FeatureCategory> categoryList = new ArrayList<FeatureCategory>(this._featureCategoryMap.size());
        categoryList.addAll(this._featureCategoryMap.values());
        return categoryList;
    }

    @Override
    public FeatureCategory getCategory(String id) {
        return this._featureCategoryMap.get(id);
    }

    @Override
    public Feature getFeatureForExtension(String memberExtensionId) {
        ExtensionGroups extensionGroups = ExtensionGroups.getInstance();
        String featureId = extensionGroups.getExtensionGroupOfMember(memberExtensionId);
        if (featureId != null && !"*NOT_IN_EXTENSION_GROUP*".equals(featureId)) {
            return this.getFeature(featureId);
        }
        return null;
    }

    @Override
    public Set<Feature> getOutgoingDependenciesOfFeature(Feature feature) {
        Set<Feature> result = this._getOutgoingDependenciesOfFeatureHelper(feature, new CycleDetector());
        return result;
    }

    @Override
    public Set<Feature> getIncomingDependenciesOnFeature(Feature feature) {
        HashSet<Feature> incomingDeps = new HashSet<Feature>();
        for (Feature current : this.getFeatures()) {
            if (!this.getOutgoingDependenciesOfFeature(current).contains(feature)) continue;
            incomingDeps.add(current);
        }
        return incomingDeps;
    }

    @Override
    public Set<Feature> getFeaturesToReloadAtStartup() {
        ExtensionRegistry extRegistry = ExtensionRegistry.getExtensionRegistry();
        HashSet<Feature> result = new HashSet<Feature>();
        for (Feature feature : this.getFeatures()) {
            FeatureImpl featureImpl;
            String extId;
            Extension extension;
            FeatureType type = feature.getType();
            if (type == null || !type.reloadIfUsed() || (extension = extRegistry.findExtension(extId = (featureImpl = (FeatureImpl)feature).getOwningExtensionId())) == null || !extRegistry.isFullyLoaded(extension)) continue;
            result.add(feature);
        }
        return result;
    }

    @Override
    public Feature getFeatureAssociatedWithTechnology(String technologyKey) {
        return this._technologyToFeatureMap.get(technologyKey);
    }

    boolean __registerFeature(FeatureImpl featureImpl) {
        FeatureImpl previous = this._featureMap.putIfAbsent(featureImpl.getId(), featureImpl);
        if (previous == null) {
            FeatureType type = featureImpl.getType();
            if (type instanceof TechnologyFeatureType) {
                String key = ((TechnologyFeatureType)type).getTechnologyKey();
                this._technologyToFeatureMap.putIfAbsent(key, featureImpl);
            }
            return true;
        }
        return false;
    }

    boolean __registerFeatureCategory(FeatureCategory featureCategory) {
        FeatureCategory previous = this._featureCategoryMap.putIfAbsent(featureCategory.getId(), featureCategory);
        return previous == null;
    }

    FeatureCategory __getFeatureCategory(String identifier) {
        return this._featureCategoryMap.get(identifier);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Feature> _getOutgoingDependenciesOfFeatureHelper(Feature feature, CycleDetector cycleDetector) {
        if (cycleDetector.contains(feature)) {
            cycleDetector.setCycleDetected(true);
            return Collections.emptySet();
        }
        Set<Feature> depFeatures = null;
        cycleDetector.push(feature);
        try {
            depFeatures = this._outgoingDependencyCache.get(feature);
            if (depFeatures == null) {
                depFeatures = new HashSet<Feature>();
                ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
                for (String memberId : feature.getMembers()) {
                    Extension member = registry.findMinimalExtension(memberId);
                    if (member == null) continue;
                    depFeatures.addAll(this._getFeaturesInDependencyTree(member, registry));
                }
                LinkedList<Feature> processingQueue = new LinkedList<Feature>(depFeatures);
                while (!processingQueue.isEmpty()) {
                    Feature current = processingQueue.removeFirst();
                    if (current == feature) continue;
                    for (Feature possibleExpansion : this._getOutgoingDependenciesOfFeatureHelper(current, cycleDetector)) {
                        boolean notSeenBefore = depFeatures.add(possibleExpansion);
                        if (!notSeenBefore) continue;
                        processingQueue.add(possibleExpansion);
                    }
                }
                depFeatures.remove(feature);
                if (depFeatures.isEmpty()) {
                    depFeatures = Collections.emptySet();
                }
                if (!cycleDetector.isCycleDetected() || !cycleDetector.isNestedCall()) {
                    this._outgoingDependencyCache.putIfAbsent(feature, depFeatures);
                }
            }
        }
        finally {
            cycleDetector.pop();
        }
        return depFeatures;
    }

    public Set<Feature> _getFeaturesInDependencyTree(Extension extension, ExtensionRegistry registry) {
        Set<Feature> featureSet = this._featuresInDependencyTreeCache.get(extension);
        if (featureSet == null) {
            Collection dependencies;
            featureSet = new HashSet<Feature>();
            Feature feature = this.getFeatureForExtension(extension.getID());
            if (feature != null) {
                featureSet.add(feature);
            }
            if ((dependencies = extension.getDependencies()) != null) {
                for (ExtensionDependency dependency : dependencies) {
                    Extension dExt = registry.findMinimalExtension(dependency.getID());
                    if (dExt == null) continue;
                    featureSet.addAll(this._getFeaturesInDependencyTree(dExt, registry));
                }
            }
            if (featureSet.isEmpty()) {
                featureSet = Collections.emptySet();
            }
            this._featuresInDependencyTreeCache.putIfAbsent(extension, featureSet);
        }
        return featureSet;
    }

    private FeatureRegistryImpl() {
    }

    private class CycleDetector {
        private LinkedList<Feature> _stack = new LinkedList();
        private boolean _cycleDetected = false;

        public void push(Feature feature) {
            this._stack.push(feature);
        }

        public Feature pop() {
            return this._stack.pop();
        }

        public boolean contains(Feature feature) {
            return this._stack.contains(feature);
        }

        public boolean isNestedCall() {
            return !this._stack.isEmpty();
        }

        public void setCycleDetected(boolean cycleDetected) {
            this._cycleDetected = cycleDetected;
        }

        public boolean isCycleDetected() {
            return this._cycleDetected;
        }
    }
}

