/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension.feature;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementContext;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.XMLParsingUtils;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.feature.Feature;
import oracle.ide.extension.feature.FeatureCategory;
import oracle.ide.extension.feature.FeatureType;
import oracle.ideimpl.extension.DisabledReason;
import oracle.ideimpl.extension.ExtensionGroups;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.feature.FeatureRegistryImpl;

public class FeatureImpl
extends Feature {
    private Callable<String> _displayNameCallable;
    private Callable<String> _descriptionCallable;
    private String _vendor;
    private String _license;
    private String _copyright;
    private List<String> _categoryIdList = Collections.emptyList();
    private FeatureType _type;
    private String _owningExtension;
    private LocationAdapter _locator;
    private static Logger _sLogger = Logger.getLogger(FeatureImpl.class.getName());

    public FeatureImpl(String identifier, ElementContext context) {
        super(identifier);
        this._owningExtension = context.getExtension().getID();
        this._locator = XMLParsingUtils.copyAndCastToLocationAdapter(context.getScopeData().get("xml.locator"));
        ExtensionGroups.getInstance().addExtensionGroup(context, identifier, this._owningExtension);
    }

    public void setDisplayName(Callable<String> displayNameCallable) {
        this._displayNameCallable = displayNameCallable;
    }

    @Override
    protected String getDisplayNameImpl() {
        String displayName = null;
        if (this._displayNameCallable != null) {
            try {
                displayName = this._displayNameCallable.call();
            }
            catch (Exception e) {
                _sLogger.log(Level.SEVERE, "Unexpected exception while processing feature display name", e);
            }
        }
        return displayName;
    }

    public void setDescription(Callable<String> descriptionCallable) {
        this._descriptionCallable = descriptionCallable;
    }

    @Override
    public String getDescription() {
        String description = null;
        if (this._descriptionCallable != null) {
            try {
                description = this._descriptionCallable.call();
            }
            catch (Exception e) {
                _sLogger.log(Level.SEVERE, "Unexpected exception while processing feature description", e);
            }
        }
        return description;
    }

    public void setCategory(List<String> categoryIdList) {
        if (categoryIdList == null) {
            categoryIdList = Collections.emptyList();
        }
        this._categoryIdList = categoryIdList;
    }

    @Override
    public List<FeatureCategory> getCategory() {
        if (this._categoryIdList.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<String> idIter = this._categoryIdList.iterator();
        FeatureCategory current = FeatureRegistryImpl.getInstance().__getFeatureCategory(idIter.next());
        List<FeatureCategory> result = null;
        if (current != null) {
            result = new ArrayList<FeatureCategory>(this._categoryIdList.size());
            result.add(current);
            while (idIter.hasNext() && (current = current.getSubCategory(idIter.next())) != null) {
                result.add(current);
            }
        } else {
            result = Collections.emptyList();
        }
        return result;
    }

    public void setType(FeatureType type) {
        this._type = type;
    }

    @Override
    public FeatureType getType() {
        return this._type;
    }

    @Override
    public List<String> getMembers() {
        return ExtensionGroups.getInstance().getExtensionGroupMembers(this.getId());
    }

    public void addMember(ElementContext context, String extensionId) {
        ExtensionGroups.getInstance().addExtensionMember(context, extensionId, this.getId());
    }

    public static void addMemberRef(ElementContext context, String featureId, String memberId) {
        ExtensionGroups.getInstance().addExtensionRef(context, featureId, memberId);
    }

    public void setVendor(String vendor) {
        this._vendor = vendor;
    }

    @Override
    public String getVendor() {
        return this._vendor;
    }

    public void setLicense(String license) {
        this._license = license;
    }

    @Override
    public String getLicense() {
        return this._license;
    }

    public void setCopyright(String copyright) {
        this._copyright = copyright;
    }

    @Override
    public String getCopyright() {
        return this._copyright;
    }

    @Override
    public String getOwningExtensionId() {
        return this._owningExtension;
    }

    @Override
    public LocationAdapter getLocator() {
        return this._locator;
    }

    @Override
    public boolean isEnabled() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        Extension owningExt = registry.findExtension(this._owningExtension);
        return owningExt != null;
    }

    @Override
    public DisabledReason getDisabledReason() {
        if (this.isEnabled()) {
            return null;
        }
        ExtensionManagerImpl manager = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
        return manager.getDisabledReason(this._owningExtension);
    }
}

