/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Component;
import java.awt.Font;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.net.URIFactory;
import javax.ide.net.VirtualFileSystem;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.help.HelpInfo;
import oracle.ide.layout.ViewId;
import oracle.ide.log.DefaultLogPage;
import oracle.ide.log.LogManager;
import oracle.ide.log.LogOwner;
import oracle.ide.log.LogPage;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.view.View;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.ManifestActivator;
import oracle.ideimpl.extension.util.ExtensionLoadingLogRecord;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.util.SwingUtils;

final class MessagePresenter
extends Handler
implements IdeListener {
    private static final String UNKNOWN_SOURCE = "(Unknown Source)";
    private static final String EXTENSION_LOADING_SOURCE = "Extension Loading Diagnostics";
    private MessageTreeModel model = new MessageTreeModel();
    private static MessagePresenter INSTANCE = null;
    private static boolean readyToDisplay = false;
    private static boolean greaterThanThresholdLogged;
    private static Level thresholdLevel;

    public static synchronized MessagePresenter getInstance(Level level) {
        if (INSTANCE == null) {
            INSTANCE = new MessagePresenter(level);
        }
        return INSTANCE;
    }

    private MessagePresenter(Level level) {
        if (Ide.isRunning()) {
            Ide.addIdeListener(this);
        }
        this.setLevel(level);
        String threshold = System.getProperty("oracle.ide.extension.logging.defaultThreshold", "INFO");
        thresholdLevel = Level.parse(threshold);
    }

    private LogPage getExtensionLogPage() {
        LogPage[] pages;
        LogManager logManager = LogManager.getLogManager();
        for (LogPage page : pages = logManager.getPages()) {
            if (!(page instanceof ManifestExtensionLogPage)) continue;
            return page;
        }
        return null;
    }

    void ensureLogPageCreated(boolean showLogWindow, boolean selectLogPage) {
        if (readyToDisplay) {
            LogManager logManager = LogManager.getLogManager();
            if (logManager == null) {
                return;
            }
            if (this.getExtensionLogPage() == null) {
                ManifestExtensionLogPage logPage = new ManifestExtensionLogPage();
                logManager.addPage(logPage);
                if (!logManager.isLogVisible()) {
                    logManager.showLog();
                }
            }
            if (logManager != null && showLogWindow && !logManager.isLogVisible()) {
                logManager.showLog();
            }
            if (logManager != null) {
                if (selectLogPage) {
                    LogManager.getIdeLogWindow().selectPage(this.getExtensionLogPage());
                } else {
                    this.highlightExtensionLogPage();
                }
            }
        }
    }

    private void highlightExtensionLogPage() {
        LogPage lpage;
        if (readyToDisplay && (lpage = this.getExtensionLogPage()) != null) {
            View view = lpage.getLogPageView();
            if ((view = view.owner()) != null && view instanceof LogOwner) {
                ((LogOwner)((Object)view)).highlightPage(lpage);
            }
        }
    }

    private void showLogPageIfNecessary(Level level) {
        if (level == null) {
            return;
        }
        if (level.intValue() > thresholdLevel.intValue()) {
            greaterThanThresholdLogged = true;
            this.ensureLogPageCreated(true, false);
        } else {
            this.highlightExtensionLogPage();
        }
    }

    @Override
    public void publish(final LogRecord record) {
        if (!this.isLoggable(record)) {
            return;
        }
        SwingUtils.dispatch((Runnable)new Runnable(){

            @Override
            public void run() {
                if (record instanceof ExtensionLogRecord || record instanceof ExtensionLoadingLogRecord) {
                    MessagePresenter.this.model.publish(record);
                    MessagePresenter.this.showLogPageIfNecessary(record.getLevel());
                }
            }
        });
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        greaterThanThresholdLogged = false;
    }

    @Override
    public void addinsLoaded(IdeEvent e) {
    }

    @Override
    public void mainWindowClosing(IdeEvent e) {
    }

    @Override
    public void mainWindowOpened(IdeEvent e) {
        Ide.removeIdeListener(this);
        readyToDisplay = true;
        if (greaterThanThresholdLogged) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    MessagePresenter.this.showLogPageIfNecessary(Level.SEVERE);
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                runnable.run();
            } else {
                SwingUtilities.invokeLater(runnable);
            }
        }
    }

    private Comparator<LogRecord> recordComparator() {
        final Collator collator = Collator.getInstance();
        return new Comparator<LogRecord>(){

            @Override
            public int compare(LogRecord o1, LogRecord o2) {
                int levelComp = this.compareLevels(o1, o2);
                if (levelComp != 0) {
                    return levelComp;
                }
                int lineNumberComp = this.compareLineNumbers(o1, o2);
                if (lineNumberComp != 0) {
                    return lineNumberComp;
                }
                return collator.compare(o1.getMessage(), o2.getMessage());
            }

            private int compareLineNumbers(LogRecord o1, LogRecord o2) {
                if (o1 instanceof ExtensionLogRecord && o2 instanceof ExtensionLogRecord) {
                    int o1Line = ((ExtensionLogRecord)o1).getLocationAdapter().getLineNumber();
                    int o2Line = ((ExtensionLogRecord)o2).getLocationAdapter().getLineNumber();
                    return o1Line - o2Line;
                }
                return 0;
            }

            private int compareLevels(LogRecord o1, LogRecord o2) {
                return o1.getLevel().intValue() - o2.getLevel().intValue();
            }
        };
    }

    private void _expandTree(JTree tree) {
        TreePath selectedPath = tree.getSelectionPath();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            TreePath path = tree.getPathForRow(i);
            Object item = path.getLastPathComponent();
            if (item instanceof ExtensionLoadingLogRecord || item == EXTENSION_LOADING_SOURCE) continue;
            tree.expandRow(i);
        }
        if (selectedPath != null) {
            tree.setSelectionPath(selectedPath);
        } else {
            tree.setSelectionRow(0);
        }
    }

    private final class MessageTreeModel
    implements TreeModel {
        private final Object ROOT = new Object();
        private final List<TreeModelListener> listeners = new CopyOnWriteArrayList<TreeModelListener>();
        private final Map<String, Collection<LogRecord>> recordsByLocation = new TreeMap<String, Collection<LogRecord>>();

        private MessageTreeModel() {
        }

        public boolean hasMessages() {
            return this.getChildCount(this.ROOT) != 0;
        }

        public void publish(LogRecord record) {
            int index;
            String location = this.location(record);
            Collection<LogRecord> records = this.recordsByLocation.get(location);
            if (records == null) {
                records = new TreeSet<LogRecord>(MessagePresenter.this.recordComparator());
                this.recordsByLocation.put(location, records);
                index = this.getIndexOfChild(this.ROOT, location);
                this.fireNodesInserted(new Object[]{this.ROOT}, new int[]{index}, new Object[]{location});
            }
            if (records.add(record)) {
                index = this.getIndexOfChild(location, record);
                this.fireNodesInserted(new Object[]{this.ROOT, location}, new int[]{index}, new Object[]{record});
            }
        }

        private void fireNodesInserted(Object[] path, int[] childIndices, Object[] children) {
            TreeModelEvent event = new TreeModelEvent((Object)this, path, childIndices, children);
            for (TreeModelListener listener : this.listeners) {
                listener.treeNodesInserted(event);
            }
        }

        private String location(LogRecord record) {
            if (record instanceof ExtensionLogRecord) {
                LocationAdapter locator = ((ExtensionLogRecord)record).getLocationAdapter();
                String displayString = locator.getSystemId();
                if (displayString == null) {
                    return MessagePresenter.UNKNOWN_SOURCE;
                }
                try {
                    URI uri = URIFactory.newURI((String)displayString);
                    if (uri != null && uri.getScheme() != null) {
                        URL url = VirtualFileSystem.getVirtualFileSystem().toURL(uri);
                        if (url == null) {
                            return MessagePresenter.UNKNOWN_SOURCE;
                        }
                        if ("jar".equals(url.getProtocol())) {
                            url = JarUtil.getJarFileURL((URL)url);
                        }
                        return ExtensionManagerImpl.getExtensionIdFromFilename(URLFileSystem.getFileName((URL)url));
                    }
                }
                catch (MalformedURLException malformedURLException) {}
            } else if (record instanceof ExtensionLoadingLogRecord) {
                return MessagePresenter.EXTENSION_LOADING_SOURCE;
            }
            return MessagePresenter.UNKNOWN_SOURCE;
        }

        private Object get(Collection collection, int index) {
            int c = 0;
            for (Object t : collection) {
                if (c == index) {
                    return t;
                }
                ++c;
            }
            return null;
        }

        @Override
        public Object getRoot() {
            return this.ROOT;
        }

        private Collection collectionForParent(Object parent) {
            Collection<LogRecord> result;
            if (parent == this.ROOT) {
                return this.recordsByLocation.keySet();
            }
            if (parent instanceof String && (result = this.recordsByLocation.get(parent)) != null) {
                return result;
            }
            if (parent instanceof ExtensionLoadingLogRecord) {
                return ((ExtensionLoadingLogRecord)parent).getDetailMessages();
            }
            return Collections.emptySet();
        }

        @Override
        public Object getChild(Object parent, int index) {
            return this.get(this.collectionForParent(parent), index);
        }

        @Override
        public int getChildCount(Object parent) {
            return this.collectionForParent(parent).size();
        }

        @Override
        public boolean isLeaf(Object node) {
            return !(node instanceof ExtensionLoadingLogRecord) && node instanceof LogRecord;
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            int index = 0;
            for (Object o : this.collectionForParent(parent)) {
                if (o == child) {
                    return index;
                }
                ++index;
            }
            return -1;
        }

        @Override
        public void addTreeModelListener(TreeModelListener l) {
            this.listeners.add(l);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener l) {
            this.listeners.remove(l);
        }
    }

    private final class ManifestExtensionLogPage
    extends DefaultLogPage {
        public ManifestExtensionLogPage() {
            super(new ViewId("ManifestExtensionLogPage", ExtensionManagerArb.getString(18)), null, false, HIDE_FIX_SOURCE_MENU);
            this.getTree().setModel(MessagePresenter.this.model);
            this.getTree().setCellRenderer(new ManifestLogCellRender());
            this.getTree().setShowsRootHandles(true);
            MessagePresenter.this._expandTree(this.getTree());
            this.getTree().getSelectionModel().setSelectionMode(4);
            MessagePresenter.this.model.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                    if (e.getTreePath().getPathCount() == 1) {
                        MessagePresenter.this._expandTree(ManifestExtensionLogPage.this.getTree());
                    }
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                }
            });
        }

        @Override
        public HelpInfo getHelpInfo() {
            return new HelpInfo("f1_idelogwindowgen_html");
        }

        @Override
        protected String treeNodeToString(Object treeNode) {
            if (treeNode instanceof LogRecord) {
                return this.getRecordText((LogRecord)treeNode);
            }
            return super.treeNodeToString(treeNode);
        }

        private String getRecordText(LogRecord rec) {
            return this.getFormattedMessage(rec);
        }

        private String initCap(String str) {
            StringBuffer b = new StringBuffer(str);
            boolean upper = true;
            for (int i = 0; i < b.length(); ++i) {
                char c = b.charAt(i);
                if (Character.isWhitespace(c)) {
                    upper = true;
                    continue;
                }
                b.setCharAt(i, upper ? Character.toUpperCase(c) : Character.toLowerCase(c));
                upper = false;
            }
            return b.toString();
        }

        private String getFormattedMessage(LogRecord record) {
            StringBuilder message = new StringBuilder();
            if (record.getLevel() == Level.SEVERE) {
                message.append("Error");
            } else {
                message.append(this.initCap(record.getLevel().toString()));
            }
            message.append(": ");
            String msg = record.getMessage();
            Object[] parameters = record.getParameters();
            if (parameters == null || parameters.length == 0) {
                message.append(msg);
            } else {
                try {
                    message.append(MessageFormat.format(msg, parameters));
                }
                catch (Exception e) {
                    message.append("[Malformed message] ");
                    if (msg != null) {
                        message.append("'").append(msg).append("'");
                    } else {
                        message.append(msg);
                    }
                    message.append(" with parameters: ").append(Arrays.toString(parameters));
                }
            }
            return message.toString();
        }

        @Override
        protected void activateObject(Object object) {
            if (!(object instanceof ExtensionLogRecord)) {
                return;
            }
            LocationAdapter targetLocator = ((ExtensionLogRecord)object).getLocationAdapter();
            String systemId = targetLocator.getSystemId();
            int lineNumber = targetLocator.getLineNumber();
            int columnNumber = targetLocator.getColumnNumber();
            ManifestActivator.openExtensionManifest(systemId, lineNumber, columnNumber);
        }

        @Override
        public void clearAll() {
            MessagePresenter.this.model = new MessageTreeModel();
            super.setModel(MessagePresenter.this.model);
        }

        private boolean isWarning(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.WARNING;
        }

        private boolean isError(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.SEVERE;
        }

        private boolean isInformation(Object obj) {
            return obj instanceof LogRecord && ((LogRecord)obj).getLevel() == Level.INFO;
        }

        private class ManifestLogCellRender
        extends DefaultTreeCellRenderer {
            private Font _defaultFont = null;
            private Font _boldFont = null;

            private ManifestLogCellRender() {
            }

            @Override
            public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (this._defaultFont == null) {
                    this._defaultFont = this.getFont();
                    this._boldFont = new Font(this._defaultFont.getName(), 1, this._defaultFont.getSize());
                }
                if (value instanceof LogRecord) {
                    LogRecord rec = (LogRecord)value;
                    if (value instanceof ExtensionLoadingLogRecord.DetailRecord || value instanceof ExtensionLoadingLogRecord) {
                        this.setText(rec.getMessage());
                    } else {
                        this.setText(ManifestExtensionLogPage.this.getRecordText(rec));
                    }
                }
                if (value instanceof ExtensionLoadingLogRecord.DetailRecord) {
                    this.setFont(this._defaultFont);
                } else if (leaf || value instanceof LogRecord) {
                    if (ManifestExtensionLogPage.this.isError(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"error.png"));
                    } else if (ManifestExtensionLogPage.this.isWarning(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"warning.png"));
                    } else if (ManifestExtensionLogPage.this.isInformation(value)) {
                        this.setIcon(OracleIcons.getIcon((String)"info.png"));
                    }
                    if (value instanceof ExtensionLoadingLogRecord && ((ExtensionLoadingLogRecord)value).shouldBeBold()) {
                        this.setFont(this._boldFont);
                    } else {
                        this.setFont(this._defaultFont);
                    }
                } else {
                    this.setIcon(OracleIcons.getIcon((String)"extras/extension.png"));
                    this.setFont(this._boldFont);
                }
                return this;
            }
        }
    }
}

