/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.Extension;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ideimpl.extension.IDEExtension;
import oracle.javatools.data.HashStructure;

public final class MenuCustomizationHook
extends HashStructureHook {
    public static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/customization", "menu-customizations");
    private static final String IDREF = "idref";
    private static final String ACTION_UNAVAILABLE = "unavailable";

    @Override
    public void start(ElementStartContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            this.checkHookUsage(context);
            super.start(context);
        }
    }

    private void checkHookUsage(ElementStartContext context) {
        String extensionId;
        Extension extension = this.getExtension((ElementContext)context);
        if (extension instanceof IDEExtension && IDEExtension.State.HOOKS_LOADING == ((IDEExtension)extension).getState() && !(extensionId = context.getExtension().getID()).startsWith("_role")) {
            context.getLogger().warning(extensionId + " is registering menu-customizations in hooks hook; should be registered in the trigger-hooks hook.");
        }
    }

    @Override
    public void end(ElementEndContext context) {
        if (ExtensionRegistry.isCustomizationContext((ElementContext)context)) {
            super.end(context);
        }
    }

    public List<String> getPermanentlyUnavailableActions(HashStructure hash) {
        List data = hash.getAsList("action");
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>(data.size());
        for (HashStructure hs : data) {
            String idref = hs.getString(IDREF);
            if (idref == null || idref.trim().isEmpty() || hs.getBoolean("hidden/#text", false) || !hs.getBoolean(ACTION_UNAVAILABLE, false)) continue;
            ids.add(idref);
        }
        return Collections.unmodifiableList(ids);
    }

    public List<String> getHiddenMenuComponents() {
        return this.getHiddenMenuComponents(this.getHashStructure());
    }

    public List<String> getHiddenMenuComponents(HashStructure hash) {
        List data = hash.getAsList("action");
        if (data == null) {
            return Collections.emptyList();
        }
        ArrayList<String> ids = new ArrayList<String>(data.size());
        for (HashStructure hs : data) {
            String idref = hs.getString(IDREF);
            if (idref == null || idref.trim().length() <= 0 || !hs.getBoolean("hidden/#text", false)) continue;
            ids.add(idref);
        }
        return Collections.unmodifiableList(ids);
    }
}

