/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

public enum GlobalClassLoader {
    INSTANCE;

    private volatile transient ClassLoader globalClassLoader = null;

    public ClassLoader getClassLoader() {
        if (this.globalClassLoader == null) {
            ThreadGroup g = Thread.currentThread().getThreadGroup();
            while (g.getParent() != null) {
                g = g.getParent();
            }
            int s = g.activeCount() + 1;
            Thread[] ts = new Thread[s];
            int x = g.enumerate(ts, true);
            if (x < s) {
                for (int i = 0; i < x; ++i) {
                    ClassLoader tccl = ts[i].getContextClassLoader();
                    if (tccl == null || !tccl.getClass().getName().endsWith("ModuleManager$SystemClassLoader")) continue;
                    this.globalClassLoader = tccl;
                    break;
                }
            }
        }
        return this.globalClassLoader;
    }
}

