/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.ide.extension.Extension;
import oracle.ideimpl.extension.Bridge;
import oracle.ideimpl.extension.BridgeExtensionException;

public final class BridgeExtensionRegistry {
    private static final BridgeExtensionRegistry _sInstance = new BridgeExtensionRegistry();
    private ConcurrentHashMap<String, Bridge> _idToBridgeMap = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Set<String>> _endpointToBridgeIdsMap = new ConcurrentHashMap();

    public static BridgeExtensionRegistry getInstance() {
        return _sInstance;
    }

    public void registerBridge(Bridge bridge) throws BridgeExtensionException {
        if (!this._isEndpointRegistered(bridge.getId(), bridge.getFromExtension())) {
            String message = "Extension " + bridge.getFromExtension().getID() + " is not a registered endpoint of bridge " + bridge.getId() + ". Use the bridge-endpoint-hook in the endpoint's extension.xml file to register the endpoint.";
            throw new BridgeExtensionException(message);
        }
        if (!this._isEndpointRegistered(bridge.getId(), bridge.getToExtension())) {
            String message = "Extension " + bridge.getToExtension().getID() + " is not a registered endpoint of bridge " + bridge.getId() + ". Use the bridge-endpoint-hook in the endpoint's extension.xml file to register the endpoint.";
            throw new BridgeExtensionException(message);
        }
        Bridge previous = this._idToBridgeMap.putIfAbsent(bridge.getId(), bridge);
        if (previous != null) {
            String message = "Duplicate bridge id.  A bridge with id " + previous.getId() + " is already registered in extension " + previous.getBridgeExtension().getID();
            throw new BridgeExtensionException(message);
        }
    }

    public Bridge getBridge(String bridgeId) {
        return this._idToBridgeMap.get(bridgeId);
    }

    public void registerEndpoint(String bridgeId, Extension endpoint) {
        CopyOnWriteArraySet<String> bridgeIdSet = this._endpointToBridgeIdsMap.get(endpoint.getID());
        if (bridgeIdSet == null) {
            CopyOnWriteArraySet<String> newSet = new CopyOnWriteArraySet<String>();
            bridgeIdSet = this._endpointToBridgeIdsMap.putIfAbsent(endpoint.getID(), newSet);
            if (bridgeIdSet == null) {
                bridgeIdSet = newSet;
            }
        }
        bridgeIdSet.add(bridgeId);
    }

    public List<Bridge> getBridgesWithEndpoint(Extension endpoint) {
        Set<String> bridgeIdSet = this._endpointToBridgeIdsMap.get(endpoint.getID());
        if (bridgeIdSet != null) {
            ArrayList<Bridge> result = new ArrayList<Bridge>(bridgeIdSet.size());
            for (String bridgeId : bridgeIdSet) {
                Bridge bridge = this.getBridge(bridgeId);
                if (bridge == null) continue;
                result.add(bridge);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private boolean _isEndpointRegistered(String bridgeId, Extension endpoint) {
        Set<String> bridgeIdSet = this._endpointToBridgeIdsMap.get(endpoint.getID());
        if (bridgeIdSet != null) {
            return bridgeIdSet.contains(bridgeId);
        }
        return false;
    }

    private BridgeExtensionRegistry() {
    }
}

