/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.AddinManager;
import oracle.ideimpl.extension.AddinInfo;
import oracle.ideimpl.extension.AddinManagerImpl;
import oracle.ideimpl.extension.SimpleTableModel;
import oracle.ideimpl.help.AboutTablePage;
import oracle.ideimpl.resource.ExtensionManagerArb;
import oracle.javatools.ui.table.GenericTable;

public final class AddinsAboutPage
extends AboutTablePage {
    private static final int COL_INFO = 0;
    private static final int COL_TIME = 1;
    private static final int COL_EXTENSION_ID = 2;
    private static final int COL_HEADLESS = 3;
    private static final int COL_COUNT = 4;

    public AddinsAboutPage() {
        this.setName(ExtensionManagerArb.getString(48));
    }

    @Override
    protected void configureTable(GenericTable table) {
        table.setSortColumn(1, false);
    }

    @Override
    protected void configureTableRenderers(GenericTable table) {
        table.setDefaultRenderer(Object.class, (TableCellRenderer)new CellRenderer());
    }

    @Override
    protected TableModel buildTableModel() {
        AddinManagerImpl am = (AddinManagerImpl)AddinManager.getAddinManager();
        List<AddinInfo> infos = am.getAddinInfos();
        ArrayList<Object[]> data = new ArrayList<Object[]>();
        for (AddinInfo info : infos) {
            Object[] row = new Object[]{info, info.getTimeToLoad() / 1000000L, info.getExtension().getID(), !info.hasUI()};
            data.add(row);
        }
        String[] colNames = new String[]{ExtensionManagerArb.getString(49), ExtensionManagerArb.getString(50), ExtensionManagerArb.getString(51), ExtensionManagerArb.getString(52)};
        return new SimpleTableModel(data, colNames){

            public Class getColumnClass(int column) {
                if (column == 1) {
                    return Long.class;
                }
                return super.getColumnClass(column);
            }

            @Override
            public int getColumnAlignment(int column) {
                if (column == 1) {
                    return 4;
                }
                return super.getColumnAlignment(column);
            }
        };
    }

    private final class CellRenderer
    extends DefaultTableCellRenderer {
        private CellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component label = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            TableModel model = table.getModel();
            AddinInfo info = (AddinInfo)model.getValueAt(row, 0);
            if (info != null && !info.isLoaded()) {
                label.setForeground(Color.GRAY);
            }
            if (value instanceof AddinInfo) {
                this.setText(((AddinInfo)value).getClassName());
            }
            return label;
        }
    }
}

