/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.UIManager;

final class Splitter
extends JComponent {
    static final int HORIZONTAL = 0;
    static final int VERTICAL = 1;
    private final int _orientation;
    private static final Color C0 = UIManager.getColor("ScrollBar.thumb");
    private static final Color C1 = UIManager.getColor("ScrollBar.thumbHighlight");
    private static final Color C2 = UIManager.getColor("ScrollBar.thumbShadow");

    public Splitter(int orientation) {
        this._orientation = orientation;
        this.setCursor(Cursor.getPredefinedCursor(orientation == 0 ? 9 : 10));
    }

    @Override
    public Dimension getPreferredSize() {
        if (!this.isPreferredSizeSet()) {
            Dimension size = this.getSize();
            if (this._orientation == 0) {
                size.height = 5;
            } else {
                size.width = 5;
            }
            this.setPreferredSize(size);
        }
        return super.getPreferredSize();
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Dimension size = this.getSize();
        int height = size.height;
        int width = size.width;
        g.setColor(C0);
        g.fillRect(0, 0, width - 1, height - 1);
        g.setColor(C2);
        g.drawRect(0, 0, width - 1, height - 1);
        g.setColor(C1);
        g.drawLine(1, 1, width - 2, 1);
        g.drawLine(1, 1, 1, height - 2);
    }
}

