/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.IdeMainWindow;
import oracle.ide.cmd.CloseNodeCommand;
import oracle.ide.config.ClientSetting;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.Controller;
import oracle.ide.controller.ControllerProvider;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.WindowManagerStartingController;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorAddin;
import oracle.ide.editor.EditorInfo;
import oracle.ide.editor.EditorManager;
import oracle.ide.editor.EditorPath;
import oracle.ide.editor.EditorsOptions;
import oracle.ide.editor.OpenEditorOptions;
import oracle.ide.editor.RecentFile;
import oracle.ide.feedback.FeedbackApi;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.keyboard.KeyUtil;
import oracle.ide.layout.BaseLayoutListener;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layout;
import oracle.ide.layout.LayoutListener;
import oracle.ide.layout.Layouts;
import oracle.ide.layout.PreferredLayoutListener;
import oracle.ide.layout.ViewId;
import oracle.ide.model.Node;
import oracle.ide.model.NodeEvent;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.NodeListener;
import oracle.ide.model.NodeUtil;
import oracle.ide.model.TextNode;
import oracle.ide.performance.PerformanceLogger;
import oracle.ide.util.Assert;
import oracle.ide.util.BitField;
import oracle.ide.util.IdeUtil;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.ActiveViewHandlerImpl;
import oracle.ideimpl.MainWindowImpl;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.editor.DeclarativeDynamicEditorAddin;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.ideimpl.editor.DefaultEditorManager;
import oracle.ideimpl.editor.Desktop;
import oracle.ideimpl.editor.EditorActionCreator;
import oracle.ideimpl.editor.EditorAddinRegistry;
import oracle.ideimpl.editor.EditorCreation;
import oracle.ideimpl.editor.EditorCriteriaImpl;
import oracle.ideimpl.editor.EditorCustomizationHook;
import oracle.ideimpl.editor.EditorCustomizationOptions;
import oracle.ideimpl.editor.EditorIterator;
import oracle.ideimpl.editor.EditorPathImpl;
import oracle.ideimpl.editor.EditorSelector;
import oracle.ideimpl.editor.EditorState;
import oracle.ideimpl.editor.LastUsedFiles;
import oracle.ideimpl.editor.RecentFilesLRU;
import oracle.ideimpl.editor.RecentFilesLRUProvider;
import oracle.ideimpl.editor.SplitPane;
import oracle.ideimpl.editor.SplitPaneState;
import oracle.ideimpl.editor.TabGroup;
import oracle.ideimpl.editor.TabGroupState;
import oracle.javatools.buffer.TextBuffer;
import oracle.javatools.util.Log;
import oracle.javatools.util.ModelUtil;
import oracle.javatools.util.MultiMap;

@Deprecated
@FeedbackApi(value="editor_window")
public class EditorManagerImpl
extends DefaultEditorManager
implements LayoutListener,
ActiveViewListener,
ControllerProvider,
IdeListener,
RecentFilesLRUProvider {
    static final String FM_API_NAME = "editor_window";
    private static EditorSelector EDITOR_SELECTOR = null;
    static final int MAX_MENUS = 9;
    private static final int MAX_ACCELERATOR = 9;
    private static EditorManagerImpl INSTANCE;
    private final HashMap<String, BaseLayoutListener> _layoutListener = new HashMap();
    protected Desktop _desktop;
    private static IdeAction nextPaneAction;
    private static IdeAction prevPaneAction;
    private static IdeAction nextEditorAction;
    private static IdeAction prevEditorAction;
    private static IdeAction splitDocumentVertically;
    private static IdeAction splitDocumentHorizontally;
    private static IdeAction unsplitDocument;
    private static IdeAction detachDocument;
    private static IdeAction regroupDocuments;
    private static IdeAction navigateLruFiles;
    private static IdeAction maximizeTabGroup;
    private static IdeAction restoreTabGroup;
    private static IdeAction toggleMaximizeTabGroup;
    private final LinkedList _orderedDocumentList = new LinkedList();
    final int[] _windowListCmdID = new int[9];
    int[] _activateCmdId;
    int[] _assignCmdId;
    private final oracle.ide.util.MultiMap _preferredLayouts = new oracle.ide.util.MultiMap();
    private final LinkedList _splitpanePool = new LinkedList();
    private static final String EDITOR_FRAME_ID = "EditorFrame";
    protected HashMap _idsToViews;
    protected HashMap _viewsToIds;
    private static EditorsOptions _editorsOptions;
    private TabGroup _lastActiveTabGroup;
    private SplitPane _lastActiveSplitPane;
    private RecentFilesLRU _recentFilesLRU;
    protected static final int EMO_TOP_EDITOR_TABS = 1;
    protected static final int EMO_HIDE_SINGLE_EDITOR_TABS = 2;
    protected static final int EMO_GRADIENT_EDITOR_TABS = 4;
    private static Integer _editorManagerOptions;
    private final Collection<TextBuffer> _openBuffers = new HashSet<TextBuffer>();
    private final NodeListener _closeListener = new NodeCloseListener();
    private Log LOG = new Log("editor-manager");

    public EditorManagerImpl() {
        if (WindowManagerStartingController.getInstance() == null) {
            this._recentFilesLRU = new RecentFilesLRU();
            this._desktop = new Desktop();
            this._idsToViews = new HashMap();
            this._viewsToIds = new HashMap();
        }
    }

    protected static boolean getEditorManagerOption(int option) {
        if (_editorManagerOptions == null) {
            int values = 0;
            EditorCustomizationHook customization = (EditorCustomizationHook)ExtensionRegistry.getExtensionRegistry().getHook(EditorCustomizationHook.ELEMENT);
            if (customization != null) {
                EditorCustomizationOptions options = customization.getCustomizationOptions();
                if (options.isTopTabMode()) {
                    values |= 1;
                }
                if (options.isTabsUseGradient()) {
                    values |= 4;
                }
                if (options.isHideTabsIfSingleEditor()) {
                    values |= 2;
                }
            }
            _editorManagerOptions = values;
        }
        return BitField.isSet(_editorManagerOptions, option);
    }

    public void setActiveViewHandler(ActiveViewHandlerImpl activeViewHandler) {
        if (activeViewHandler != null) {
            activeViewHandler.addActiveViewListener(this);
            activeViewHandler.addControllerProvider(this._desktop, this);
        }
    }

    public List getWindowList() {
        ArrayList<JMenuItem> ret = new ArrayList<JMenuItem>();
        Iterator iterator = this._orderedDocumentList.iterator();
        for (int i = 1; i <= 9 && iterator.hasNext(); ++i) {
            final TabGroupState tabGroupState = (TabGroupState)iterator.next();
            Context context = tabGroupState.getContext();
            Node node = context.getNode();
            Icon icon = node.getIcon();
            String label = Integer.toString(i) + " " + node.getShortLabel();
            AbstractAction abstractAction = new AbstractAction(label, icon){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MenuSelectionManager.defaultManager().clearSelectedPath();
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            EditorManagerImpl.this.whenWindowMenuActivates(tabGroupState);
                        }
                    });
                }
            };
            JMenuItem menuItem = new JMenuItem(abstractAction);
            menuItem.setMnemonic(48 + i);
            ret.add(menuItem);
        }
        return ret;
    }

    public static EditorManagerImpl createInstance() {
        if (INSTANCE != null) {
            throw new IllegalStateException();
        }
        INSTANCE = new EditorManagerImpl();
        return INSTANCE;
    }

    public static EditorManagerImpl getInstance() {
        return INSTANCE;
    }

    @Override
    public void initialize() {
        if (WindowManagerStartingController.getInstance() == null) {
            EDITOR_SELECTOR = EditorSelector.getInstance();
            Layouts.getLayouts().addStartupLayoutListener(EDITOR_FRAME_ID, this);
        }
        this.createActions();
        KeyStrokeContextRegistry kcr = Ide.getKeyStrokeContextRegistry();
        kcr.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/ideimpl/editor/accelerators.xml");
        Ide.addIdeListener(this);
    }

    private void createActions() {
        EditorActionCreator creator = new EditorActionCreator();
        creator.createActions(this);
        nextPaneAction = EditorActionCreator.nextPaneAction;
        prevPaneAction = EditorActionCreator.prevPaneAction;
        nextEditorAction = EditorActionCreator.nextEditorAction;
        prevEditorAction = EditorActionCreator.prevEditorAction;
        splitDocumentVertically = EditorActionCreator.splitDocumentVertically;
        splitDocumentHorizontally = EditorActionCreator.splitDocumentHorizontally;
        unsplitDocument = EditorActionCreator.unsplitDocument;
        detachDocument = EditorActionCreator.detachDocument;
        regroupDocuments = EditorActionCreator.regroupDocuments;
        navigateLruFiles = EditorActionCreator.navigateLruFiles;
        maximizeTabGroup = EditorActionCreator.maximizeTabGroup;
        restoreTabGroup = EditorActionCreator.restoreTabGroup;
        toggleMaximizeTabGroup = EditorActionCreator.toggleMaximizeTabGroup;
    }

    @Override
    public void addinsLoaded(IdeEvent e) {
    }

    @Override
    public void mainWindowOpened(IdeEvent e) {
    }

    @Override
    public void mainWindowClosing(IdeEvent e) {
        Desktop desktop = this.getDesktop();
        if (desktop == null) {
            return;
        }
        int tabGroupCount = desktop.getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            TabGroup tabGroup = desktop.getTabGroup(i);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            for (int j = 0; j < tabGroupStateCount; ++j) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(j);
                boolean restorableAtStartup = tabGroupState.isRestorableAtStartup();
                if (restorableAtStartup) continue;
                Context context = tabGroupState.getContext();
                this.removeFromLRUList(context);
            }
        }
    }

    Desktop getDesktop() {
        return this._desktop;
    }

    private EditorAddin bestEditorAddin(Context context) {
        Node node;
        EditorAddin ret = this.getMostRecentEditorAddin(context);
        if (ret == null && (node = context.getNode()) != null) {
            ret = this.getBestEditorAddin(context);
        }
        return ret;
    }

    public EditorAddin getMostRecentEditorAddin(Context context) {
        EditorAddin ret = null;
        RecentFile recentFile = this._recentFilesLRU.getRecentFile(context);
        if (recentFile != null) {
            List<EditorAddin> editorAddins;
            String editorAddinClass = recentFile.getEditor();
            if (editorAddinClass != null) {
                ret = this._editorAddinRegistry.getRegisteredEditorAddin(editorAddinClass);
            }
            if (ret == null && editorAddinClass != null && (editorAddins = this.getAddins(context)) != null) {
                ret = this._editorAddinRegistry.getRegisteredEditorAddin(editorAddinClass);
            }
        }
        return ret;
    }

    @Override
    public void addLayoutListener(String editorId, BaseLayoutListener listener) {
        this._layoutListener.put(editorId, listener);
    }

    @Override
    public void removeLayoutListener(String editorId) {
        this._layoutListener.remove(editorId);
    }

    @Override
    public void registerPreferredLayoutListener(Class docClass, Class editorClass, String preferredLayoutBaseName, PreferredLayoutListener listener) {
        this._preferredLayouts.add((Object)editorClass, (Object)new Object[]{docClass, preferredLayoutBaseName, listener});
    }

    void initPreferredLayoutInfo(Editor editor, Context context) {
        Class<?> editorClass = editor.getClass();
        Object[] bestLayoutListener = null;
        List list = this._preferredLayouts.get(editorClass);
        if (list != null) {
            Class<?> nodeClass;
            Node node = context.getNode();
            block0: for (Class<?> searchNodeClass = nodeClass = node.getClass(); searchNodeClass != null; searchNodeClass = searchNodeClass.getSuperclass()) {
                for (int i = 0; i < list.size(); ++i) {
                    Object[] layoutListenerInfo = (Object[])list.get(i);
                    Class layoutListenerNodeClass = (Class)layoutListenerInfo[0];
                    if (searchNodeClass == layoutListenerNodeClass) {
                        bestLayoutListener = layoutListenerInfo;
                        continue block0;
                    }
                    if (!layoutListenerNodeClass.isAssignableFrom(searchNodeClass)) continue;
                    bestLayoutListener = layoutListenerInfo;
                }
            }
            if (bestLayoutListener != null) {
                PreferredLayoutListener listener = (PreferredLayoutListener)bestLayoutListener[2];
                editor.addPreferredLayoutListener(listener);
                String preferredLayoutBaseName = (String)bestLayoutListener[1];
                editor.setPreferredLayoutBaseName(preferredLayoutBaseName);
                String type = nodeClass.getName() + "-" + editorClass.getName();
                editor.setType(type);
            }
        }
    }

    public boolean searchEditor(EditorPathImpl editorPath, EditorCriteriaImpl editorCriteria) {
        boolean ret = false;
        int tabGroupCount = this._desktop.getTabGroupCount();
        for (int i = 0; !ret && i < tabGroupCount; ++i) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            if (!tabGroup.match(editorCriteria) && !tabGroup.searchEditor(editorPath, editorCriteria)) continue;
            editorPath._tabGroupPos = i;
            ret = true;
        }
        return ret;
    }

    @Override
    public JComponent getDesktopComponent() {
        return this.getDesktop();
    }

    SplitPane createSplitPane() {
        SplitPane splitPane = this._splitpanePool.isEmpty() ? new SplitPane() : (SplitPane)this._splitpanePool.removeFirst();
        return splitPane;
    }

    void releaseSplitPane(SplitPane splitPane) {
        this._splitpanePool.addFirst(splitPane);
    }

    @Override
    public Editor openDefaultEditorInFrame(Context context) {
        Editor editor = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            this.focusEditor(editorPath);
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else {
            Class editorClass;
            EditorAddin addin = this.bestEditorAddin(context);
            if (addin != null && (editor = this.openEditorInFrame(editorClass = addin.getEditorClass(), context)) != null) {
                editor.setEditorAddin(addin);
            }
        }
        return editor;
    }

    private static void updateContext(Editor editor, Context context) {
        Context editorContext = editor.getContext();
        if (ModelUtil.areDifferent((Object)editorContext.getProject(), (Object)context.getProject()) || ModelUtil.areDifferent((Object)editorContext.getWorkspace(), (Object)context.getWorkspace())) {
            editor.setContext(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Editor openEditorInFrame(Class editorClass, Context context) {
        Editor ret = null;
        WaitCursor wc = Ide.getWaitCursor();
        wc.show();
        try {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.focusEditor(editorClass, context, editorPath)) {
                EditorState editorState = editorPath.getEditorState();
                ret = editorState.getEditor();
                EditorManagerImpl.updateContext(ret, context);
            } else {
                OpenEditorOptions openEditorOptions = new OpenEditorOptions(context, editorClass);
                if (this.createEditor(openEditorOptions, editorPath)) {
                    EditorState editorState = editorPath.getEditorState();
                    ret = editorState.getEditor();
                }
            }
        }
        finally {
            wc.hide();
        }
        return ret;
    }

    @Override
    public Editor openEditor(OpenEditorOptions openEditorOptions) {
        EditorState editorState;
        EditorCriteriaImpl editorCriteria;
        Editor editor = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        Context context = openEditorOptions.getContext();
        Class editorClass = openEditorOptions.getEditorClass();
        if (editorClass == null) {
            editorCriteria = new EditorCriteriaImpl(context);
            EditorAddin editorAddin = this.bestEditorAddin(context);
            if (editorAddin != null) {
                openEditorOptions.setEditorClass(editorAddin.getEditorClass());
            }
        } else {
            editorCriteria = new EditorCriteriaImpl(context, editorClass);
        }
        if (this.searchEditor(editorPath, editorCriteria)) {
            int openFlags = openEditorOptions.getFlags();
            if (BitField.isSet(openFlags, 1)) {
                if (BitField.isSet(openFlags, 5)) {
                    this.focusEditor(editorPath);
                } else {
                    this.activateEditor(editorPath);
                }
            }
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            editor = tabGroupState.getCurrentEditor();
            EditorManagerImpl.updateContext(editor, context);
        } else if (this.createEditor(openEditorOptions, editorPath) && (editorState = editorPath.getEditorState()) != null) {
            editor = editorState.getEditor();
        }
        return editor;
    }

    boolean focusEditor(EditorPathImpl editorPath) {
        boolean ret = false;
        if (this.activateEditor(editorPath)) {
            TabGroup tabGroup = editorPath.getTabGroup();
            tabGroup.focusCurrentEditor();
            ret = true;
        }
        return ret;
    }

    public void focusCurrentEditorTab() {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (EditorManagerImpl.getInstance().getCurrentEditorPath(editorPath)) {
            editorPath.getTabGroup().focusCurrentEditor();
        }
    }

    private void focusActiveEditor() {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.getCurrentEditorPath(editorPath)) {
            this.focusEditor(editorPath);
        }
    }

    private boolean focusEditor(Class editorClass, Context context, EditorPathImpl editorPath) {
        boolean ret = false;
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context, editorClass);
        if (this.searchEditor(editorPath, editorCriteria) && this.focusEditor(editorPath)) {
            ret = true;
        }
        return ret;
    }

    private void holdOnToBuffer(Node node) {
        if (!(node instanceof TextNode)) {
            return;
        }
        TextBuffer b = ((TextNode)node).acquireTextBuffer();
        this._openBuffers.add(b);
        this.LOG.trace("EditorManager: hold on to node {0}", (Object)node);
        node.addNodeListener(this._closeListener);
    }

    boolean createEditor(OpenEditorOptions openEditorOptions, EditorPathImpl editorPath) {
        List<EditorAddin> editorAddins;
        this.LOG.trace("EditorManager: create editor {0}", (Object)openEditorOptions.getContext());
        boolean ret = false;
        Context context = openEditorOptions.getContext();
        Node node = context.getNode();
        if (node != null && !(editorAddins = this.getAddins(context)).isEmpty()) {
            EditorCreation editorCreation = new EditorCreation();
            editorCreation.setOpenEditorOptions(openEditorOptions);
            editorCreation.setEditorAddins(editorAddins);
            editorCreation.setEditorPath(editorPath);
            if (this.createEditor(editorCreation)) {
                this.holdOnToBuffer(node);
                ret = true;
            }
        }
        return ret;
    }

    private boolean createEditor(EditorCreation editorCreation) {
        boolean isNewTabGroup;
        TabGroup tabGroup;
        boolean ret = false;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPath = editorCreation.getEditorPath();
        int refPosition = 0;
        TabGroup refTabGroup = null;
        OpenEditorOptions openEditorOptions = editorCreation.getOpenEditorOptions();
        EditorPath positionReference = openEditorOptions.getPositionReference();
        if (positionReference instanceof EditorPathImpl) {
            EditorPathImpl refEditorPath = (EditorPathImpl)positionReference;
            refTabGroup = refEditorPath.getTabGroup();
            refPosition = openEditorOptions.getPosition();
        }
        if (editorPath._tabGroupPos == -1) {
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            if (currentTabGroupPos == -1) {
                tabGroup = new TabGroup();
                isNewTabGroup = true;
            } else if (refTabGroup != null) {
                if (refPosition == 4) {
                    tabGroup = refTabGroup;
                    isNewTabGroup = false;
                    this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroup));
                } else {
                    tabGroup = new TabGroup();
                    isNewTabGroup = true;
                }
            } else {
                editorPath._tabGroupPos = currentTabGroupPos;
                tabGroup = desktop.getTabGroup(currentTabGroupPos);
                isNewTabGroup = false;
            }
        } else {
            tabGroup = desktop.getTabGroup(editorPath._tabGroupPos);
            isNewTabGroup = false;
        }
        if (tabGroup.addTabGroupState(editorCreation)) {
            int creationFlags;
            if (isNewTabGroup) {
                DockLayoutConstraint constraint = new DockLayoutConstraint(refTabGroup, refPosition, 1, null);
                editorPath._tabGroupPos = desktop.addTabGroup(tabGroup, constraint);
            }
            if (BitField.isSet(creationFlags = openEditorOptions.getFlags(), 1)) {
                ret = tabGroup.activateEditor(editorPath);
                if (ret) {
                    EditorState editorState = editorPath.getEditorState();
                    EditorAddin editorAddin = editorState.getEditorAddin();
                    Context context = openEditorOptions.getContext();
                    EditorManagerImpl.raiseContextInLRUList(context, editorAddin);
                } else if (editorPath._tabGroupStatePos != -1) {
                    tabGroup.closeTabGroupState(editorPath._tabGroupStatePos);
                }
            } else {
                ret = true;
            }
            if (ret) {
                if (BitField.isSet(creationFlags, 8)) {
                    Context context = openEditorOptions.getContext();
                    this._recentFilesLRU.setExplicit(context, true);
                }
                if (BitField.isSet(creationFlags, 2)) {
                    tabGroup.validate();
                }
                if (BitField.isSet(creationFlags, 5)) {
                    tabGroup.focusCurrentEditor();
                }
            }
        }
        return ret;
    }

    public boolean activateEditor(EditorPathImpl editorPath) {
        return this.getDesktop().activateEditor(editorPath);
    }

    @Override
    public void activateCurrentEditorFrame() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
            tabGroup.focusCurrentEditor();
        }
    }

    public List findEditors(Context context) {
        ArrayList list = new ArrayList();
        int tabGroupCount = this._desktop.getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            List subList = tabGroup.findEditors(context);
            list.addAll(subList);
        }
        return list;
    }

    public List getAllEditors() {
        ArrayList list = new ArrayList();
        int tabGroupCount = this._desktop.getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            TabGroup tabGroup = this._desktop.getTabGroup(i);
            List subList = tabGroup.getAllEditors();
            list.addAll(subList);
        }
        return list;
    }

    @Override
    public Editor getCurrentEditor() {
        Editor ret = null;
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
            ret = tabGroup.getCurrentEditor();
        }
        return ret;
    }

    public JComponent getDesktopBackground() {
        return this.getDesktop().getDesktopBackground();
    }

    private boolean getCurrentEditorPath(EditorPathImpl editorPath) {
        return this._desktop.getCurrentEditorPath(editorPath);
    }

    @Override
    public void replaceEditors(Context oldContext, Context newContext) {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(oldContext);
        if (this.searchEditor(editorPath, editorCriteria)) {
            TabGroupState tabGroupState = editorPath.getTabGroupState();
            tabGroupState.setContext(newContext);
        }
    }

    public List getEditorsInfo() {
        ArrayList list = new ArrayList();
        EditorIterator toAdd = new EditorIterator(15);
        IdeUtil.addAll(list, toAdd);
        return list;
    }

    @Override
    public void closeEditors(List listEditors) {
        if (listEditors.size() == 0) {
            return;
        }
        EditorState[] editorStates = new EditorState[listEditors.size()];
        for (int i = 0; i < listEditors.size(); ++i) {
            Editor editor;
            EditorPathImpl editorPath;
            Object o = listEditors.get(i);
            if (o instanceof EditorState) {
                editorStates[i] = (EditorState)o;
                continue;
            }
            if (!(o instanceof Editor) || !this.searchEditor(editorPath = new EditorPathImpl(), new EditorCriteriaImpl(editor = (Editor)o))) continue;
            editorStates[i] = editorPath.getEditorState();
        }
        this.closeEditors(editorStates);
    }

    private void closeEditors(EditorState[] editorStates) {
        HashSet<TabGroupState> tabGroupStateSet = new HashSet<TabGroupState>();
        for (int i = 0; i < editorStates.length; ++i) {
            TabGroupState parentTabGroupState;
            SplitPaneState parentSplitPaneState;
            EditorState editorState = editorStates[i];
            if (editorState == null || (parentSplitPaneState = editorState.getParentSplitPaneState()) == null || (parentTabGroupState = parentSplitPaneState.getParentTabGroupState()) == null) continue;
            tabGroupStateSet.add(parentTabGroupState);
        }
        TabGroupState[] tabGroupStates = tabGroupStateSet.toArray(new TabGroupState[tabGroupStateSet.size()]);
        this.closeEditors(tabGroupStates);
    }

    public void closeEditors(TabGroupState[] tabGroupStates) {
        Component permanentFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getPermanentFocusOwner();
        boolean refocusEditor = permanentFocusOwner == null ? false : SwingUtilities.isDescendingFrom(permanentFocusOwner, this.getDesktop());
        this.getDesktop().freezeFocusChanges(true);
        HashSet<TabGroupState> tabGroupStateSet = new HashSet<TabGroupState>(Arrays.asList(tabGroupStates));
        HashSet<Node> documentsToClose = new HashSet<Node>();
        HashSet<Node> docsThatStayOpen = new HashSet<Node>();
        MultiMap contextsAndDocs = new MultiMap();
        int tabGroupCount = this.getDesktop().getTabGroupCount();
        for (int i = 0; i < tabGroupCount; ++i) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(i);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            for (int j = 0; j < tabGroupStateCount; ++j) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(j);
                boolean isClosing = tabGroupStateSet.contains(tabGroupState);
                Editor currentEditor = tabGroupState.getCurrentEditor();
                if (currentEditor != null) {
                    currentEditor.prepareForSaving(isClosing);
                }
                Context context = new Context(tabGroupState.getContext());
                Node node = context.getNode();
                if (isClosing) {
                    documentsToClose.add(node);
                    contextsAndDocs.add((Object)context, (Object)node);
                } else {
                    docsThatStayOpen.add(node);
                }
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                for (int k = 0; k < splitPaneStateCount; ++k) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(k);
                    int nbrEditorStates = splitPaneState.getEditorStateCount();
                    for (int l = 0; l < nbrEditorStates; ++l) {
                        Node[] dependentNodes;
                        EditorState editorState = splitPaneState.getEditorState(l);
                        Editor editor = editorState.getEditor();
                        if (editor == null || (dependentNodes = editor.getDependentNodes()) == null) continue;
                        for (int m = 0; m < dependentNodes.length; ++m) {
                            Node dependentNode = dependentNodes[m];
                            if (isClosing) {
                                documentsToClose.add(dependentNode);
                                contextsAndDocs.add((Object)context, (Object)dependentNode);
                                continue;
                            }
                            docsThatStayOpen.add(dependentNode);
                        }
                    }
                }
            }
        }
        for (Collection nodes : contextsAndDocs.values()) {
            nodes.removeAll(docsThatStayOpen);
        }
        documentsToClose.removeAll(docsThatStayOpen);
        IdeAction closeNodeAction = IdeActions.getFileCloseAction();
        Command closeNodeCommandObject = CommandProcessor.createCommandFromMeta(closeNodeAction.getCommandMetaClass(), new Context());
        CloseNodeCommand cmd = closeNodeCommandObject instanceof CloseNodeCommand ? (CloseNodeCommand)closeNodeCommandObject : new CloseNodeCommand();
        int status = cmd.checkSave(documentsToClose.iterator());
        if (status != 1) {
            int tabGroupCount2 = this._desktop.getTabGroupCount();
            for (int i = tabGroupCount2 - 1; i >= 0; --i) {
                TabGroup tabGroup = this._desktop.getTabGroup(i);
                tabGroup.close(tabGroupStates);
            }
            for (Map.Entry entry : contextsAndDocs.entrySet()) {
                Context context = (Context)entry.getKey();
                Collection lstDocs = (Collection)entry.getValue();
                cmd.setContext(context);
                cmd.clearAffectedNodes();
                assert (lstDocs != null) : "Bug 6157300 occurred with context " + context;
                status = cmd.close(lstDocs.iterator(), context, false, true);
                if (status != 1) continue;
                break;
            }
        }
        this.getDesktop().freezeFocusChanges(false);
        if (refocusEditor) {
            this.focusActiveEditor();
        }
    }

    @Override
    public void activateEditor(EditorInfo editorInfo) {
        EditorPathImpl editorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(editorInfo);
        EditorManagerImpl editorManager = EditorManagerImpl.getInstance();
        if (editorManager.searchEditor(editorPath, editorCriteria)) {
            this.activateEditor(editorPath);
        }
    }

    @Override
    public void setExplicit(Editor editor, boolean explicit) {
        Context context = editor.getContext();
        this._recentFilesLRU.setExplicit(context, explicit);
    }

    public static void raiseContextInLRUList(Context context, EditorAddin editorAddin) {
        boolean canRaise = true;
        if (editorAddin != null) {
            canRaise = EditorManagerImpl.isRestorable(context, editorAddin);
        }
        if (canRaise) {
            String editorAddinClassName = null;
            editorAddinClassName = editorAddin instanceof DeclarativeEditorAddin || editorAddin instanceof DeclarativeDynamicEditorAddin ? EditorAddinRegistry.createDeclarativeEditorAddinUniqueID(editorAddin) : editorAddin.getClass().getName();
            RecentFilesLRU recentFilesLRU = ((RecentFilesLRUProvider)((Object)EditorManager.getEditorManager())).getRecentFilesLRU();
            recentFilesLRU.raiseContextInLRUList(context, editorAddinClassName);
        }
    }

    public static boolean isRestorable(Context context, EditorAddin editorAddin) {
        if (Boolean.FALSE.equals(editorAddin.getAttribute("no-recent-file"))) {
            return false;
        }
        if (context == null) {
            return false;
        }
        Node node = context.getNode();
        if (node == null) {
            return false;
        }
        URL url = node.getURL();
        if (url == null) {
            return false;
        }
        String protocol = url.getProtocol();
        if (protocol == null) {
            return false;
        }
        if (protocol.startsWith("ide.")) {
            return false;
        }
        Boolean restorable = (Boolean)editorAddin.getAttribute("restorable-from-url");
        return restorable == null ? true : restorable;
    }

    void removeFromLRUList(Context context) {
        this._recentFilesLRU.remove(context);
    }

    private static int getExplicitNumber() {
        TabGroupState tabGroupState;
        int assignedNumber;
        int found;
        TabGroupState tabGroupState2;
        int i;
        EditorIterator editorIterator = new EditorIterator(3);
        ArrayList tabGroupStates = Collections.list(editorIterator);
        Collections.sort(tabGroupStates, new Comparator(){

            public int compare(Object o1, Object o2) {
                TabGroupState ts1 = (TabGroupState)o1;
                TabGroupState ts2 = (TabGroupState)o2;
                return ts1.getNodeNumber() - ts2.getNodeNumber();
            }
        });
        for (i = 0; i < tabGroupStates.size() && !(tabGroupState2 = (TabGroupState)tabGroupStates.get(i)).isExplicit(); ++i) {
        }
        for (found = 0; i < tabGroupStates.size() && found >= (assignedNumber = (tabGroupState = (TabGroupState)tabGroupStates.get(i)).getNodeNumber()); ++i, ++found) {
        }
        if (found >= 9) {
            found = -1;
        }
        return found;
    }

    public static EditorsOptions getEditorsOptions() {
        ClientSetting settings;
        if (_editorsOptions == null && (_editorsOptions = (EditorsOptions)(settings = ClientSetting.findOrCreate("oracle.ide")).getData("editors-options")) == null) {
            _editorsOptions = new EditorsOptions();
            settings.putData("editors-options", _editorsOptions);
        }
        return _editorsOptions;
    }

    @Override
    public EditorPath searchEditor(Node node) {
        EditorPathImpl ret = null;
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(node))) {
            ret = editorPath;
        }
        return ret;
    }

    @Override
    public void addView(ViewId id, View view) {
        this._idsToViews.put(id, view);
        this._viewsToIds.put(view, id);
    }

    @Override
    public View getView(ViewId id) {
        return (View)this._idsToViews.get(id);
    }

    @Override
    public void removeView(View view) {
        Object id = this._viewsToIds.get(view);
        if (id != null) {
            this._idsToViews.remove(id);
            this._viewsToIds.remove(view);
        }
    }

    @Override
    public void addOpenedViews(Layout layout, List openedList) {
        Iterator iterator = this._viewsToIds.keySet().iterator();
        while (iterator.hasNext()) {
            openedList.add(iterator.next());
        }
    }

    @Override
    public void save(Layout layout) {
        if (WindowManagerStartingController.getInstance() == null) {
            this.getDesktop().saveLayout();
        }
        for (BaseLayoutListener listener : this._layoutListener.values()) {
            try {
                long startTime = System.nanoTime();
                listener.save(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.save", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    @Override
    public void init(Layout layout) {
        Assert.startTiming((String)(this.getClass().getName() + ".init"), (String)"Restoring opened editors...", (boolean)false);
        if (WindowManagerStartingController.getInstance() == null) {
            this.getDesktop().loadLayout();
        }
        for (BaseLayoutListener listener : this._layoutListener.values()) {
            try {
                long startTime = System.nanoTime();
                listener.init(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.init", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
        Assert.endTiming((String)(this.getClass().getName() + ".init"), (String)"Restored open editors", null, (boolean)false);
    }

    @Override
    public void close(Layout layout) {
    }

    @Override
    public void activeViewChanged(ActiveViewEvent e) {
        View newView;
        View oldView = e.getOldView();
        if (oldView instanceof Editor) {
            Editor editor = (Editor)oldView;
            this.fireEditorEvent(3, editor);
        }
        if ((newView = e.getNewView()) instanceof Editor) {
            Editor editor = (Editor)newView;
            this.fireEditorEvent(2, editor);
            this.ensureCurrentTabVisble();
        } else if (this.checkIfViewIsInEditor(newView.getGUI())) {
            this.ensureCurrentTabVisble();
        }
        IdeAction.get(70).setEnabled(false);
        IdeAction.get(71).setEnabled(false);
        if (newView instanceof Editor || this._lastActiveTabGroup == null || this._lastActiveTabGroup.getCurrentEditor() == null || newView == null || newView.getGUI() == null || newView.getGUI() == Ide.getMainWindow()) {
            return;
        }
        if (!EditorManagerImpl.isParent(newView.getGUI(), this._lastActiveTabGroup.getCurrentEditor().getGUI())) {
            this._lastActiveTabGroup.deactivate();
        }
    }

    private boolean checkIfViewIsInEditor(Component component) {
        if (component == null || component.getParent() == null) {
            return false;
        }
        if (component instanceof Desktop) {
            return true;
        }
        return this.checkIfViewIsInEditor(component.getParent());
    }

    private void ensureCurrentTabVisble() {
        EditorPathImpl pathImpl = new EditorPathImpl();
        this.getCurrentEditorPath(pathImpl);
        this._desktop.ensureCurrentTabVisble(pathImpl);
    }

    @Override
    public boolean handleEvent(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 48 || commandId == 70 || commandId == 71 || commandId == NEXT_PANE_CMD_ID && this.getDesktop() != null || commandId == PREV_PANE_CMD_ID && this.getDesktop() != null || commandId == 40 && this.getDesktop() != null || commandId == 41 && this.getDesktop() != null || commandId == 42 && this.getDesktop() != null || commandId == 43 && this.getDesktop() != null || this.isGoto_n(action) || this.isWindow_n(action)) {
            return this.handleWithoutFocus(action, context, false);
        }
        if (commandId == SYSTEM_MENU_CMD_ID) {
            this.whenShowSystemMenu();
        } else if (commandId == NAVIGATE_LRU_FILES_CMD_ID) {
            this.whenNavigateLRUFiles();
        } else if (commandId == SHOW_DROPDOWN_CMD_ID) {
            int currentTabGroupPos;
            Desktop desktop = this.getDesktop();
            if (desktop != null && (currentTabGroupPos = desktop.getCurrentTabGroupPos()) != -1) {
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                tabGroup.showDropDownMenu();
            }
        } else if (commandId == CLOSE_OTHERS_CMD_ID) {
            this.whenCloseOthers(context);
        } else if (commandId == 39) {
            List editorsInfo = this.getEditorsInfo();
            this.closeEditors(editorsInfo);
        } else if (commandId == MAXIMIZE_TAB_GROUP_CMD_ID) {
            this.whenMaximizeTabGroup(context);
        } else if (commandId == RESTORE_TAB_GROUPS_CMD_ID) {
            this.whenRestoreTabGroups();
        } else if (commandId == TOGGLE_MAXIMIZE_RESTORE_TAB_GROUP_CMD_ID) {
            if (this.isTabGroupMaximized(context)) {
                this.whenRestoreTabGroups();
            } else {
                this.whenMaximizeTabGroup(context);
            }
        } else if (commandId == SPLIT_DOCUMENT_CMD_ID || commandId == SPLIT_DOCUMENT_VER_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPath);
                TabGroupState tabGroupState = editorPath.getTabGroupState();
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                boolean done = false;
                for (int splitPaneStatePos = 0; !done && splitPaneStatePos < splitPaneStateCount; ++splitPaneStatePos) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(splitPaneStatePos);
                    if (!splitPaneState.isSplitable()) continue;
                    editorPath._panePos = splitPaneStatePos;
                    TabGroup tabGroup = editorPath.getTabGroup();
                    if (commandId == SPLIT_DOCUMENT_CMD_ID) {
                        tabGroup.splitPane(editorPath, 0);
                    } else {
                        tabGroup.splitPane(editorPath, 1);
                    }
                    done = true;
                }
            }
        } else if (commandId == UNSPLIT_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this.activateEditor(editorPath);
                TabGroup tabGroup = editorPath.getTabGroup();
                tabGroup.getCurrentEditorPath(editorPath);
                tabGroup.unsplitPane(editorPath);
                editorPath._panePos = 0;
                tabGroup.activateEditor(editorPath);
                this._desktop.revalidate();
            }
        } else if (commandId == DETACH_DOCUMENT_CMD_ID) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                this._desktop.detachEditor(editorPath);
            }
        } else if (commandId == REGROUP_DOCUMENTS_CMD_ID) {
            this._desktop.reattachEditors();
        } else if (commandId == 51) {
            this.whenRefresh();
        } else if (!this.handleAssign_n(action)) {
            return false;
        }
        return true;
    }

    private void updateRefresh(IdeAction action) {
        boolean isEnabled = false;
        Editor currentEditor = this.getCurrentEditor();
        if (currentEditor != null) {
            Context context = currentEditor.getContext();
            Node node = context.getNode();
            if (node != null) {
                isEnabled = true;
            }
            action.setEnabled(isEnabled);
        }
    }

    private void whenRefresh() {
        Editor currentEditor = this.getCurrentEditor();
        Context context = currentEditor.getContext();
        Node node = context.getNode();
        if (node != null) {
            NodeUtil.reloadBuffers(Collections.singletonList(node), true);
        }
    }

    private void whenNavigateLRUFiles() {
        RecentFile[] recentFiles = this._recentFilesLRU.getRecentFiles();
        IdeMainWindow mainWindow = Ide.getMainWindow();
        LastUsedFiles.runDialog((Frame)((Object)mainWindow), recentFiles);
    }

    private boolean handleWithoutFocus(IdeAction action, Context context, boolean focusEditor) {
        int commandId = action.getCommandId();
        if (commandId == 48) {
            return this.whenCloseEditor(context);
        }
        if (commandId == 70) {
            this.whenActivateLeftNode();
        } else if (commandId == 71) {
            this.whenActivateRightNode();
        } else if ((commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID) && WindowManagerStartingController.getInstance() == null) {
            Desktop desktop = this.getDesktop();
            if (desktop != null) {
                int currentTabGroupPos = desktop.getCurrentTabGroupPos();
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
                currentTabGroupState.handleEvent(commandId);
            }
        } else if ((commandId == 40 || commandId == 41) && WindowManagerStartingController.getInstance() == null) {
            Desktop desktop = this.getDesktop();
            if (desktop != null) {
                int currentTabGroupPos = desktop.getCurrentTabGroupPos();
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                TabGroupState currentTabGroupState = tabGroup.getCurrentTabGroupState();
                SplitPane currentSplitPane = currentTabGroupState.getCurrentSplitPane();
                currentSplitPane.handleEvent(commandId);
            }
        } else if (commandId == 42) {
            this.whenNextEditorFrame(context);
        } else if (commandId == 43) {
            this.whenPrevEditorFrame(context);
        } else if (this.handleGoto_n(action) || this.handleWindow_n(action)) {
            // empty if block
        }
        if (focusEditor) {
            this.focusActiveEditor();
        }
        return true;
    }

    private boolean isGoto_n(IdeAction action) {
        if (this._activateCmdId == null) {
            return false;
        }
        int commandId = action.getCommandId();
        for (int i = 0; i < this._activateCmdId.length; ++i) {
            int assignCmdId = this._activateCmdId[i];
            if (assignCmdId != commandId) continue;
            return true;
        }
        return false;
    }

    private boolean handleGoto_n(IdeAction action) {
        int commandId = action.getCommandId();
        if (this._activateCmdId == null) {
            return false;
        }
        for (int i = 0; i < this._activateCmdId.length; ++i) {
            int assignCmdId = this._activateCmdId[i];
            if (assignCmdId != commandId) continue;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(i))) {
                this.activateEditor(editorPath);
            }
            return true;
        }
        return false;
    }

    private boolean handleAssign_n(IdeAction action) {
        if (this._assignCmdId == null) {
            return false;
        }
        int commandId = action.getCommandId();
        for (int i = 0; i < this._assignCmdId.length; ++i) {
            int assignCmdId = this._assignCmdId[i];
            if (assignCmdId != commandId) continue;
            EditorPathImpl currentEditorPath = new EditorPathImpl();
            if (this.getCurrentEditorPath(currentEditorPath)) {
                TabGroupState currentTabGroupState = currentEditorPath.getTabGroupState();
                TabGroupState reassignTabGroupState = null;
                EditorPathImpl reassignEditorPath = new EditorPathImpl();
                if (this.searchEditor(reassignEditorPath, new EditorCriteriaImpl(i))) {
                    reassignTabGroupState = reassignEditorPath.getTabGroupState();
                }
                if (reassignTabGroupState == null) {
                    currentTabGroupState.setNodeNumber(i);
                } else if (reassignTabGroupState != currentTabGroupState) {
                    reassignTabGroupState.setNodeNumber(-1);
                    currentTabGroupState.setNodeNumber(i);
                    int newNumber = EditorManagerImpl.getExplicitNumber();
                    reassignTabGroupState.setNodeNumber(newNumber);
                }
            }
            return true;
        }
        return false;
    }

    private boolean isWindow_n(IdeAction action) {
        int commandId = action.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(commandId);
        return tabGroupState != null;
    }

    private boolean handleWindow_n(IdeAction action) {
        int commandId = action.getCommandId();
        TabGroupState tabGroupState = this.getTabGroupStateFromWindowMenu(commandId);
        if (tabGroupState != null) {
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState))) {
                this.activateEditor(editorPath);
            }
            return true;
        }
        return false;
    }

    private void whenMaximizeTabGroup(Context context) {
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        Desktop desktop = this.getDesktop();
        desktop.maximizeTabGroup(tabGroup);
    }

    private void whenRestoreTabGroups() {
        Desktop desktop = this.getDesktop();
        desktop.restoreTabGroups();
    }

    private boolean isTabGroupMaximized(Context context) {
        if (context == null) {
            return false;
        }
        MainWindowImpl mainWindow = (MainWindowImpl)Ide.getMainWindow();
        if (mainWindow.getMaximizedWindowType() != 2) {
            return false;
        }
        Desktop desktop = this.getDesktop();
        TabGroup tabGroup = this.getTabGroupFromContext(context);
        return desktop.isTabGroupMaximized(tabGroup);
    }

    private TabGroup getTabGroupFromContext(Context context) {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            return editorPath.getTabGroup();
        }
        Desktop desktop = this.getDesktop();
        int currentTabGroupPos = desktop.getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            return desktop.getTabGroup(currentTabGroupPos);
        }
        return null;
    }

    private void whenCloseOthers(Context context) {
        TabGroupState tabGroupStateToKeep = null;
        Desktop desktop = this.getDesktop();
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
            tabGroupStateToKeep = editorPath.getTabGroupState();
        } else {
            int currentTabGroupPos = desktop.getCurrentTabGroupPos();
            if (currentTabGroupPos != -1) {
                TabGroup tabGroup = desktop.getTabGroup(currentTabGroupPos);
                tabGroupStateToKeep = tabGroup.getCurrentTabGroupState();
            }
        }
        int tabGroupCount = desktop.getTabGroupCount();
        ArrayList<TabGroupState> tabGroupStateToClose = new ArrayList<TabGroupState>();
        for (int tabGroupPos = 0; tabGroupPos < tabGroupCount; ++tabGroupPos) {
            TabGroup tabGroup = desktop.getTabGroup(tabGroupPos);
            int tabGroupStateCount = tabGroup.getTabGroupStateCount();
            for (int i = 0; i < tabGroupStateCount; ++i) {
                TabGroupState tabGroupState = tabGroup.getTabGroupState(i);
                if (tabGroupState == tabGroupStateToKeep) continue;
                tabGroupStateToClose.add(tabGroupState);
            }
        }
        TabGroupState[] tabGroupStates = new TabGroupState[tabGroupStateToClose.size()];
        tabGroupStateToClose.toArray(tabGroupStates);
        this.closeEditors(tabGroupStates);
    }

    private void whenShowSystemMenu() {
        int currentTabGroupPos = this.getDesktop().getCurrentTabGroupPos();
        if (currentTabGroupPos != -1) {
            TabGroup tabGroup = this.getDesktop().getTabGroup(currentTabGroupPos);
            tabGroup.whenShowSystemMenu();
        }
    }

    private TabGroupState getTabGroupStateFromWindowMenu(int commandId) {
        for (int i = 0; i < this._windowListCmdID.length; ++i) {
            IdeAction act;
            WeakReference ref;
            if (this._windowListCmdID[i] != commandId || (ref = (WeakReference)(act = IdeAction.find(this._windowListCmdID[i])).getValue("UserData")) == null) continue;
            TabGroupState tabGroupState = (TabGroupState)ref.get();
            return tabGroupState;
        }
        return null;
    }

    private void whenNextEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            if (this._orderedDocumentList.size() < 2) {
                Logger.getAnonymousLogger().log(Level.WARNING, "Ordered document list contains less then 2 elements. Context: " + context + " Project: " + context.getProject());
                return;
            }
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.get(1);
            this.activateEditor(tabGroupState);
        } else if (EDITOR_SELECTOR.sizeOfDisplayables() > 1) {
            EDITOR_SELECTOR.selectNext(this._orderedDocumentList);
        }
    }

    private void whenPrevEditorFrame(Context context) {
        if (EditorManagerImpl.isMenuAction(context)) {
            TabGroupState tabGroupState = (TabGroupState)this._orderedDocumentList.getLast();
            this.activateEditor(tabGroupState);
        } else if (EDITOR_SELECTOR.sizeOfDisplayables() > 1) {
            EDITOR_SELECTOR.selectPrevious(this._orderedDocumentList);
        }
    }

    void activateEditor(TabGroupState tabGroupState) {
        EditorPathImpl editorPath = new EditorPathImpl();
        this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState));
        this.activateEditor(editorPath);
    }

    private static boolean isMenuAction(Context context) {
        EventObject event = context.getEvent();
        if (event instanceof ActionEvent) {
            ActionEvent actionEvent = (ActionEvent)event;
            Object actionEventSource = actionEvent.getSource();
            return actionEventSource instanceof MenuElement;
        }
        return false;
    }

    public void addToNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addLast(tabGroupState);
    }

    public void removeFromNodeList(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
    }

    void moveTabGroupStateSwitchToTop(TabGroupState tabGroupState) {
        this._orderedDocumentList.remove(tabGroupState);
        this._orderedDocumentList.addFirst(tabGroupState);
    }

    private void whenWindowMenuActivates(TabGroupState tabGroupState) {
        EditorPathImpl editorPath = new EditorPathImpl();
        if (this.searchEditor(editorPath, new EditorCriteriaImpl(tabGroupState))) {
            this.activateEditor(editorPath);
        }
    }

    private void whenActivateRightNode() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
        tabGroup.whenActivateRightNode();
    }

    private void whenActivateLeftNode() {
        int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
        TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
        tabGroup.whenActivateLeftNode();
    }

    private boolean whenCloseEditor(Context context) {
        EditorPathImpl contextEditorPath = new EditorPathImpl();
        EditorCriteriaImpl editorCriteria = new EditorCriteriaImpl(context);
        if (this.searchEditor(contextEditorPath, editorCriteria)) {
            this.whenCloseEditor(contextEditorPath);
            return true;
        }
        return false;
    }

    private void whenCloseEditor(EditorPathImpl editorPath) {
        TabGroupState tabGroupState = editorPath.getTabGroupState();
        this.closeEditors(new TabGroupState[]{tabGroupState});
    }

    @Override
    public boolean update(IdeAction action, Context context) {
        int commandId = action.getCommandId();
        if (commandId == 39 || commandId == SHOW_DROPDOWN_CMD_ID || commandId == SYSTEM_MENU_CMD_ID) {
            action.setEnabled(this._desktop.getTabGroupCount() != 0);
        } else if (commandId == 42 || commandId == 43 || commandId == CLOSE_OTHERS_CMD_ID) {
            int tabGroupCount = this._desktop.getTabGroupCount();
            int nodeCount = 0;
            for (int i = 0; i < tabGroupCount; ++i) {
                TabGroup tabGroup = this._desktop.getTabGroup(i);
                if (!tabGroup.isVisible()) continue;
                nodeCount += tabGroup.getTabGroupStateCount();
            }
            action.setEnabled(nodeCount > 0);
        } else if (commandId == MAXIMIZE_TAB_GROUP_CMD_ID) {
            boolean isMaximized = this.isTabGroupMaximized(context);
            action.setEnabled(!isMaximized);
        } else if (commandId == RESTORE_TAB_GROUPS_CMD_ID) {
            boolean isMaximized = this.isTabGroupMaximized(context);
            action.setEnabled(isMaximized);
        } else if (commandId == REGROUP_DOCUMENTS_CMD_ID) {
            int tabGroupCount = this._desktop.getTabGroupCount();
            boolean canDo = tabGroupCount > 1;
            action.setEnabled(canDo);
        } else if (commandId == DETACH_DOCUMENT_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                TabGroup tabGroup = editorPath.getTabGroup();
                int tabGroupStateCount = tabGroup.getTabGroupStateCount();
                canDo = tabGroupStateCount > 1;
            }
            action.setEnabled(canDo);
        } else if (commandId == SPLIT_DOCUMENT_CMD_ID || commandId == SPLIT_DOCUMENT_VER_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                TabGroupState tabGroupState = editorPath.getTabGroupState();
                int splitPaneStateCount = tabGroupState.getSplitPaneStateCount();
                for (int splitPaneStatePos = 0; !canDo && splitPaneStatePos < splitPaneStateCount; ++splitPaneStatePos) {
                    SplitPaneState splitPaneState = tabGroupState.getSplitPaneState(splitPaneStatePos);
                    if (!splitPaneState.isSplitable()) continue;
                    canDo = true;
                }
            }
            action.setEnabled(canDo);
        } else if (commandId == UNSPLIT_DOCUMENT_CMD_ID) {
            boolean canDo = false;
            EditorPathImpl editorPath = new EditorPathImpl();
            if (this.searchEditor(editorPath, new EditorCriteriaImpl(context))) {
                int splitPaneStateCount = editorPath.getTabGroupState().getSplitPaneStateCount();
                canDo = splitPaneStateCount > 1;
            }
            action.setEnabled(canDo);
        } else if (commandId != NAVIGATE_LRU_FILES_CMD_ID) {
            if (commandId == 70) {
                boolean canDo = false;
                int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
                    canDo = tabGroup.canActivateLeftNode();
                }
                action.setEnabled(canDo);
            } else if (commandId == 71) {
                boolean canDo = false;
                int currentTabGroupPos = this._desktop.getCurrentTabGroupPos();
                if (currentTabGroupPos != -1) {
                    TabGroup tabGroup = this._desktop.getTabGroup(currentTabGroupPos);
                    canDo = tabGroup.canActivateRightNode();
                }
                action.setEnabled(canDo);
            } else if (this.getDesktop() != null && (commandId == NEXT_PANE_CMD_ID || commandId == PREV_PANE_CMD_ID)) {
                TabGroup tabGroup;
                TabGroupState currentTabGroupState;
                int currentTabGroupPos;
                boolean canDo = false;
                Desktop desktop = this.getDesktop();
                if (desktop != null && (currentTabGroupPos = desktop.getCurrentTabGroupPos()) != -1 && (currentTabGroupState = (tabGroup = desktop.getTabGroup(currentTabGroupPos)).getCurrentTabGroupState()) != null) {
                    canDo = currentTabGroupState.canDo(action);
                }
                action.setEnabled(canDo);
            } else if (commandId == 40 || commandId == 41) {
                boolean canDo = false;
                Desktop desktop = this.getDesktop();
                if (desktop != null) {
                    SplitPane currentSplitPane;
                    TabGroup tabGroup;
                    TabGroupState currentTabGroupState;
                    int currentTabGroupPos = desktop.getCurrentTabGroupPos();
                    if (currentTabGroupPos != -1 && (currentTabGroupState = (tabGroup = desktop.getTabGroup(currentTabGroupPos)).getCurrentTabGroupState()) != null && (currentSplitPane = currentTabGroupState.getCurrentSplitPane()) != null) {
                        canDo = currentSplitPane.canDo(action);
                    }
                    action.setEnabled(canDo);
                }
            } else if (commandId == 51) {
                this.updateRefresh(action);
            } else if (!this.updateAssign(action, commandId) && !this.updateActivate(action, commandId)) {
                return false;
            }
        }
        return true;
    }

    private boolean updateAssign(IdeAction action, int commandId) {
        boolean ret = false;
        if (this._assignCmdId == null) {
            return false;
        }
        for (int i = 0; i < this._assignCmdId.length; ++i) {
            int cmdId = this._assignCmdId[i];
            if (cmdId != commandId) continue;
            boolean hasOneEditor = this._desktop.getTabGroupCount() != 0;
            action.setEnabled(hasOneEditor);
            ret = true;
            break;
        }
        return ret;
    }

    private boolean updateActivate(IdeAction action, int commandId) {
        if (this._activateCmdId == null) {
            return false;
        }
        boolean ret = false;
        for (int i = 0; i < this._activateCmdId.length; ++i) {
            int cmdId = this._activateCmdId[i];
            if (cmdId != commandId) continue;
            boolean found = this.searchEditor(new EditorPathImpl(), new EditorCriteriaImpl(i));
            action.setEnabled(found);
            ret = true;
            break;
        }
        return ret;
    }

    int getActivateCmdId(int cmdId) {
        return this._activateCmdId[cmdId];
    }

    public int getAssignCmdId(int cmdId) {
        return this._assignCmdId[cmdId];
    }

    public String getActivateCmdTooltip(int nodeNumber) {
        int assignCmdId = this.getActivateCmdId(nodeNumber);
        String acceleratorTooltip = KeyUtil.getAcceleratorTooltip(assignCmdId);
        return acceleratorTooltip;
    }

    public void whenCurrentEditorChanges() {
        final Layouts layouts = Layouts.getLayouts();
        if (layouts != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    EditorPathImpl editorPath = new EditorPathImpl();
                    if (EditorManagerImpl.this.getCurrentEditorPath(editorPath)) {
                        SplitPaneState splitPaneState;
                        SplitPane splitPane;
                        TabGroup tabGroup = editorPath.getTabGroup();
                        if (tabGroup != EditorManagerImpl.this._lastActiveTabGroup) {
                            if (EditorManagerImpl.this._lastActiveTabGroup != null) {
                                EditorManagerImpl.this._lastActiveTabGroup.highlight(false);
                            }
                            EditorManagerImpl.this._lastActiveTabGroup = tabGroup;
                            if (EditorManagerImpl.this._lastActiveTabGroup != null) {
                                EditorManagerImpl.this._lastActiveTabGroup.highlight(true);
                            }
                        }
                        if ((splitPane = (splitPaneState = editorPath.getSplitPaneState()).getSplitPane()) != EditorManagerImpl.this._lastActiveSplitPane) {
                            if (EditorManagerImpl.this._lastActiveSplitPane != null) {
                                EditorManagerImpl.this._lastActiveSplitPane.highlight(false);
                            }
                            EditorManagerImpl.this._lastActiveSplitPane = splitPane;
                            if (EditorManagerImpl.this._lastActiveSplitPane != null) {
                                EditorManagerImpl.this._lastActiveSplitPane.highlight(true);
                            }
                        }
                        EditorState editorState = editorPath.getEditorState();
                        Editor currentEditor = editorState.getEditor();
                        layouts.activatePreferredLayout(currentEditor);
                        Context context = currentEditor.getContext();
                        EditorAddin editorAddin = editorState.getEditorAddin();
                        EditorManagerImpl.raiseContextInLRUList(context, editorAddin);
                    } else {
                        int tabGroupCount = EditorManagerImpl.this.getDesktop().getTabGroupCount();
                        if (tabGroupCount == 0) {
                            layouts.activateDefaultDesignLayout();
                        }
                    }
                }
            });
        }
    }

    void whenEditorOpened(Editor editor) {
        this.fireEditorEvent(1, editor);
    }

    void whenEditorClosed(Editor editor) {
        this.fireEditorEvent(4, editor);
        String editorId = editor.getId();
        BaseLayoutListener listener = this._layoutListener.get(editorId);
        if (listener != null) {
            IdeProperties layout = Ide.getIdeProperties();
            try {
                long startTime = System.nanoTime();
                listener.close(layout);
                long endTime = System.nanoTime();
                PerformanceLogger.get().log("BaseLayoutListener.close", listener.getClass().getName(), endTime - startTime);
            }
            catch (Exception e) {
                FeedbackManager.reportException(e);
            }
        }
    }

    @Override
    public Controller getController() {
        return this;
    }

    static void checkThread() {
        if (!SwingUtilities.isEventDispatchThread()) {
            FeedbackManager.reportAPIException("UI operations must happen on the event thread", (Throwable)new IllegalStateException(), FM_API_NAME);
        }
    }

    @Override
    public RecentFilesLRU getRecentFilesLRU() {
        return this._recentFilesLRU;
    }

    @Override
    public Editor findEditor(EditorPath path) {
        return path instanceof EditorPathImpl ? ((EditorPathImpl)path).getTabGroupState().getCurrentEditor() : null;
    }

    @Override
    public void requestAttention(Editor editor, boolean brief) {
    }

    @Override
    public void cancelRequestAttention(Editor editor) {
    }

    @Override
    public void makeBusy(Editor editor, boolean busy) {
    }

    @Override
    public void setEditorFloating(Editor editor, boolean floating) {
        throw new IllegalStateException("This method is not implemented");
    }

    @Override
    public void refreshEditorUI(Editor editor) {
    }

    @Override
    public Collection<URL> getAllUrlEditors() {
        return Collections.emptySet();
    }

    @Override
    public Editor cloneEditor(Editor editor, boolean forceClone) {
        return null;
    }

    private void replaceEditors(final List<Editor> oldEditors, final Node newNode) {
        if (oldEditors.isEmpty()) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                EditorManagerImpl.this.closeEditors(oldEditors);
                for (Editor editor : oldEditors) {
                    Context newContext = new Context(editor.getContext());
                    newContext.setNode(newNode);
                    EditorManagerImpl.this.openEditorInFrame(editor.getClass(), newContext);
                }
            }
        });
    }

    private static boolean isParent(Component child, Component parent) {
        if (parent == null || child == null) {
            return false;
        }
        boolean isParent = EditorManagerImpl.isParent(child.getParent(), parent);
        return isParent || parent == child;
    }

    private class NodeCloseListener
    extends NodeListener {
        private NodeCloseListener() {
        }

        @Override
        public void nodeWillClose(NodeEvent e) {
            TextNode node = (TextNode)e.getNode();
            node.removeNodeListener(this);
            EditorManagerImpl.this._openBuffers.remove(node.acquireTextBuffer());
        }

        @Override
        public void nodeRenamed(NodeEvent e, URL oldURL, URL newURL) {
            EditorManagerImpl.this.LOG.trace("EditorManager: node renamed from {0} to {1}", (Object)oldURL, (Object)newURL);
            if (!SwingUtilities.isEventDispatchThread()) {
                return;
            }
            Node newNode = NodeFactory.find(newURL);
            Node oldNode = e.getNode();
            if (oldNode == null) {
                return;
            }
            boolean nodeTypeIsTheSame = oldNode.getClass() == newNode.getClass();
            EditorPath editorPath = EditorManagerImpl.this.searchEditor(oldNode);
            if (editorPath == null) {
                return;
            }
            TabGroup tabGroup = ((EditorPathImpl)editorPath).getTabGroup();
            if (tabGroup == null) {
                return;
            }
            List editors = tabGroup.getAllEditors();
            if (nodeTypeIsTheSame) {
                for (Editor editor : editors) {
                    Context context = editor.getContext();
                    if (!context.getNode().equals(oldNode)) continue;
                    editor.setContext(context);
                }
            } else {
                ArrayList<Editor> editorsToClose = new ArrayList<Editor>();
                for (Editor editor : editors) {
                    if (!oldNode.equals(editor.getContext().getNode())) continue;
                    editorsToClose.add(editor);
                }
                EditorManagerImpl.this.replaceEditors(editorsToClose, newNode);
            }
        }
    }
}

