/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.shutter;

import oracle.ideimpl.docking.shutter.MouseActivationController;
import oracle.ideimpl.docking.shutter.ShutterMargin;
import oracle.ideimpl.docking.shutter.ShutterPanel;

public final class ShutterManager {
    private static final ShutterManager INSTANCE = new ShutterManager();
    private final ShutterPanel _shutterPanel = new ShutterPanel();
    private final MouseActivationController _mouseActivationController = new MouseActivationController();

    public static ShutterManager getInstance() {
        return INSTANCE;
    }

    private ShutterManager() {
    }

    public ShutterMargin createShutterMargin(String layoutOrientation) {
        return new ShutterMargin(layoutOrientation);
    }

    public ShutterPanel getShutterPanel() {
        return this._shutterPanel;
    }

    public int getShutterPanelSize(int orientation) {
        return this._shutterPanel.getFloatingSize(orientation);
    }

    public void setShutterPanelSize(int orientation, int size) {
        this._shutterPanel.setFloatingSize(orientation, size);
    }

    public void hideShutterPanel(int flags) {
        this._shutterPanel.hidePanel(flags);
    }

    MouseActivationController getMouseActivationController() {
        return this._mouseActivationController;
    }
}

