/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking.migration;

import java.io.File;
import java.util.Collection;
import oracle.ide.IdeMainWindow;
import oracle.ide.layout.ViewId;
import oracle.ide.migration.Migrator;
import oracle.ide.model.UserPropertiesMigrator;
import oracle.ide.util.FileCopyUtil2;
import oracle.ideimpl.docking.DockableFactoryHook;

public final class WindowManagerMigrator
implements Migrator {
    public static final String WINDOW_MANAGER_NOT_MIGRATE_DOCK_STATUS_PROP = "window.manager.not.migrate.dock.status";
    public static final String WINDOW_MANAGER_MIGRATION_STARTED = "window.manager.not.migration.started";
    private String[] EMPTY_STRING_ARRAY = new String[0];

    @Override
    public int[] getMigrationCategories() {
        return new int[0];
    }

    @Override
    public String getDescription(int category) {
        return "Window Manager Migrator";
    }

    @Override
    public boolean canMigrate(int category, File sourceDir) {
        return false;
    }

    @Override
    public void setSelected(int category, boolean selected) {
    }

    @Override
    public boolean isSelected(int category) {
        return false;
    }

    @Override
    public String[] migrate(File sourceDir, File destDir) {
        System.setProperty(WINDOW_MANAGER_MIGRATION_STARTED, "true");
        if (IdeMainWindow.isWindowManagerMigrationDisabled()) {
            return this.EMPTY_STRING_ARRAY;
        }
        if (sourceDir == null || destDir == null || sourceDir.equals(destDir.getParentFile())) {
            return this.EMPTY_STRING_ARRAY;
        }
        FileCopyUtil2.copyFiles(sourceDir.getPath(), destDir.getPath());
        UserPropertiesMigrator.findAndCopy(sourceDir.getParentFile().toPath(), destDir.getParentFile().toPath(), "config", "Windows2Local", "system_cache");
        Collection<ViewId> doNotMigrateDockables = DockableFactoryHook.get().getDontMigrateDockables();
        if (doNotMigrateDockables.isEmpty()) {
            return this.EMPTY_STRING_ARRAY;
        }
        String[] doNotMigrateDockablesArray = new String[2 * doNotMigrateDockables.size()];
        int index = 0;
        for (ViewId viewId : doNotMigrateDockables) {
            String fileNameSettings = "NBDC_" + viewId.getId() + ".settings";
            String fileNameWstcref = "NBDC_" + viewId.getId() + ".wstcref";
            doNotMigrateDockablesArray[index++] = fileNameSettings;
            doNotMigrateDockablesArray[index++] = fileNameWstcref;
        }
        Collection<File> filesToRemove = FileCopyUtil2.findFilesOrDirectories(destDir.getParentFile(), doNotMigrateDockablesArray);
        for (File fileToRemove : filesToRemove) {
            boolean deleted = fileToRemove.delete();
            if (deleted) continue;
            System.out.println("Not deleted" + filesToRemove.toString());
        }
        System.setProperty(WINDOW_MANAGER_NOT_MIGRATE_DOCK_STATUS_PROP, "true");
        return this.EMPTY_STRING_ARRAY;
    }
}

