/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.docking;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ide.extension.ElementName;
import oracle.ide.ExtensionRegistry;
import oracle.ide.extension.HashStructureHook;
import oracle.ide.extension.HashStructureHookEvent;
import oracle.ide.extension.HashStructureHookListener;
import oracle.ideimpl.docking.DockableFactoryHook;
import oracle.javatools.data.HashStructure;

public final class DockableHook
extends HashStructureHook {
    private Set<String> pendingDockables = new LinkedHashSet<String>();
    private boolean addToPending = true;
    private Map<String, String> dockableExtensionIDs = new HashMap<String, String>();
    private static final ElementName NAME = new ElementName("http://xmlns.oracle.com/ide/extension", "dockable-hook");

    DockableHook() {
        this.addHashStructureHookListener(new HashStructureHookListener(){

            @Override
            public void elementVisited(HashStructureHookEvent e) {
                DockableHook.this.addDockables(e.getNewElementHashStructure());
            }

            @Override
            public void listenerAttached(HashStructureHookEvent e) {
                DockableHook.this.addDockables(e.getNewElementHashStructure());
            }
        });
    }

    public static DockableHook get() {
        return (DockableHook)ExtensionRegistry.getExtensionRegistry().getHook(NAME);
    }

    private void addDockables(HashStructure hs) {
        if (hs == null) {
            return;
        }
        List list = hs.getAsList("dockable");
        if (list == null) {
            return;
        }
        final ArrayList<String> dockablesToLoad = new ArrayList<String>();
        for (Object obj : list) {
            HashStructure factoryHash = (HashStructure)obj;
            String id = factoryHash.getString("id");
            String idExtension = factoryHash.getString("#__extension-id");
            if (id == null) {
                Logger.getLogger("global").log(Level.SEVERE, "extension " + DockableHook.getExtensionId(hs) + " is attempting to register a docakble with no id");
            }
            dockablesToLoad.add(id);
            this.dockableExtensionIDs.put(id, idExtension);
        }
        if (this.addToPending) {
            this.pendingDockables.addAll(dockablesToLoad);
        } else {
            Runnable loadDockablesRunnable = new Runnable(){

                @Override
                public void run() {
                    DockableHook.this.loadDockables(dockablesToLoad);
                }
            };
            ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
            registry.invokeAfterExtensionLoading(loadDockablesRunnable, true);
        }
    }

    private void loadDockables(Collection<String> dockableIds) {
        DockableFactoryHook dockableFactoryHook = DockableFactoryHook.get();
        for (String id : dockableIds) {
            dockableFactoryHook.ensureDockableFactoryLoaded(id);
        }
    }

    public void loadPendingDockables() {
        this.addToPending = false;
        this.loadDockables(this.pendingDockables);
    }

    String getDocakableExtensionID(String dockableFactoryID) {
        return this.dockableExtensionIDs.get(dockableFactoryID);
    }
}

