/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controls.dockLayout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JComponent;
import oracle.ide.util.StructuredPropertyAccess;
import oracle.ideimpl.controls.dockLayout.AbstractDockLayoutInfoNode;
import oracle.ideimpl.controls.dockLayout.DockDivider;
import oracle.ideimpl.controls.dockLayout.DockLayoutConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfo;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoHorzNode;
import oracle.ideimpl.controls.dockLayout.DockLayoutInfoLeaf;
import oracle.ideimpl.controls.dockLayout.DockLayoutLoadConstraint;
import oracle.ideimpl.controls.dockLayout.DockLayoutPersistence;
import oracle.ideimpl.controls.dockLayout.TreeIterator;
import oracle.ideimpl.controls.dockLayout.TreeIteratorFactory;
import oracle.ideimpl.controls.dockLayout.TreeIteratorLeaves;
import oracle.ideimpl.controls.dockLayout.XMLDockLayoutPersistence;

public final class DockLayout
implements LayoutManager2 {
    private AbstractDockLayoutInfoNode _constraints = new DockLayoutInfoHorzNode();
    private ArrayList _cacheHorzDividers;
    private ArrayList _cacheVertDividers;
    private ArrayList _cacheInsertionPoints;
    private boolean _bOptimized = true;
    private int _nOptimizeLocks = 0;
    private static final String ROOT_TAG = "window-layout";

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException("Please use specific DockLayout constraints");
    }

    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp == null) {
            throw new IllegalArgumentException("Cannot add null Components");
        }
        if (!(comp instanceof JComponent)) {
            throw new IllegalArgumentException("DockLayout only accepts JComponents");
        }
        this.addLayoutComponent((JComponent)comp, constraints);
    }

    public DockLayoutInfoLeaf getLayoutInfo(JComponent c) {
        return this._constraints.getLayoutInfo(c);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.5f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.5f;
    }

    @Override
    public void invalidateLayout(Container target) {
        this.clearCaches();
        this._constraints.invalidateLayout(target);
    }

    @Override
    public void removeLayoutComponent(Component comp) {
        this._constraints.removeLayoutComponent((JComponent)comp);
        this._bOptimized = false;
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return this._constraints.getSize(3);
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return this._constraints.getSize(2);
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this._constraints.getSize(0);
    }

    @Override
    public void layoutContainer(Container parent) {
        Dimension dimParent = parent.getSize();
        Insets insets = parent.getInsets();
        Rectangle r = new Rectangle(insets.left, insets.top, dimParent.width - (insets.left + insets.right), dimParent.height - (insets.top + insets.bottom));
        this.optimize();
        this.clearCaches();
        this._constraints.layoutContainer(r);
    }

    public DockLayoutInfo getConstraints() {
        this.optimize();
        return this._constraints;
    }

    public ArrayList getHorzDividers(Container parent) {
        if (this._cacheHorzDividers == null) {
            this.recalcDividers(parent);
        }
        return this._cacheHorzDividers;
    }

    public ArrayList getVertDividers(Container parent) {
        if (this._cacheVertDividers == null) {
            this.recalcDividers(parent);
        }
        return this._cacheVertDividers;
    }

    public DockDivider getDivider(JComponent ref, int nOrient) {
        return this._constraints.getDivider(ref, nOrient);
    }

    public ArrayList getInsertionPoints(Container parent) {
        if (this._cacheInsertionPoints == null) {
            this.recalcDividers(parent);
        }
        return this._cacheInsertionPoints;
    }

    public void saveLayout(DockLayoutPersistence p, String strParentName) {
        this.optimize();
        this._constraints.saveLayout(p, strParentName);
    }

    public void loadLayout(Container target, DockLayoutPersistence p, String strMyName) {
        DockLayoutInfo li = this._constraints.loadLayout(target, p, strMyName);
        if (li != null) {
            this._constraints = (AbstractDockLayoutInfoNode)li;
            this.runLoadedLayout(target, li);
            this._bOptimized = false;
        }
    }

    public void saveLayout(XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        this.optimize();
        this._constraints.saveLayout(layoutPersistence, parent);
    }

    public void loadLayout(Container target, XMLDockLayoutPersistence layoutPersistence, StructuredPropertyAccess parent) {
        AbstractDockLayoutInfoNode dockLayoutInfo = AbstractDockLayoutInfoNode.loadLayout(layoutPersistence, parent);
        if (dockLayoutInfo != null) {
            this._constraints = dockLayoutInfo;
            this.runLoadedLayout(target, dockLayoutInfo);
            this._bOptimized = false;
        }
    }

    private void addLayoutComponent(JComponent jComp, Object constraints) {
        if (constraints == null) {
            this._constraints.insertNode(new DockLayoutInfoLeaf(jComp, new Dimension(5, 5)), 0);
            System.err.println("DockLayout.addLayoutComponent() - Should not dock with null constraints !");
        } else if (constraints instanceof DockLayoutConstraint) {
            this.addLayoutComponent(jComp, (DockLayoutConstraint)constraints);
        } else if (!(constraints instanceof DockLayoutLoadConstraint)) {
            throw new IllegalArgumentException("Please use specific DockLayout constraints");
        }
    }

    private void addLayoutComponent(JComponent jComp, DockLayoutConstraint dlc) {
        if (!this._constraints.addLayoutComponent(jComp, dlc)) {
            throw new IllegalArgumentException("Constraint refers to an unknown object");
        }
        this._bOptimized = false;
    }

    private void recalcDividers(Container parent) {
        this.layoutContainer(parent);
        this._cacheHorzDividers = new ArrayList();
        this._cacheVertDividers = new ArrayList();
        this._constraints.getDividers(this._cacheHorzDividers, this._cacheVertDividers);
        this._cacheInsertionPoints = new ArrayList();
        this._constraints.getInsertionPoints(this._cacheInsertionPoints);
    }

    private void runLoadedLayout(Container target, DockLayoutInfo li) {
        if (li instanceof AbstractDockLayoutInfoNode) {
            AbstractDockLayoutInfoNode lin = (AbstractDockLayoutInfoNode)li;
            for (int i = 0; i < lin.getNodeCount(); ++i) {
                DockLayoutInfo liSub = lin.getNode(i);
                this.runLoadedLayout(target, liSub);
            }
        } else {
            DockLayoutInfoLeaf lil = (DockLayoutInfoLeaf)li;
            JComponent c = lil.getComponent();
            if (c != null) {
                DockLayoutLoadConstraint dllc = new DockLayoutLoadConstraint();
                target.add((Component)c, dllc);
            }
        }
    }

    private void clearCaches() {
        this._cacheHorzDividers = null;
        this._cacheVertDividers = null;
        this._cacheInsertionPoints = null;
    }

    public void lockOptimize() {
        ++this._nOptimizeLocks;
    }

    public void unlockOptimize() {
        --this._nOptimizeLocks;
        if (this._nOptimizeLocks == 0) {
            this.optimize();
        }
    }

    private void optimize() {
        if (!this._bOptimized && this._nOptimizeLocks == 0) {
            this._bOptimized = true;
            this.clearCaches();
            this._constraints.optimize();
        }
    }

    public TreeIteratorLeaves iterator(TreeIteratorFactory.Type t) {
        TreeIterator i = TreeIteratorFactory.createIterator(t, this._constraints);
        return new TreeIteratorLeaves(i);
    }
}

