/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.controller;

import oracle.ide.Context;
import oracle.ideimpl.controller.SimpleRule;
import oracle.ideimpl.controller.SimpleRuleErrorCallback;

class SimpleNotRule
extends SimpleRule {
    SimpleRule operand;
    int numOperands;

    SimpleNotRule() {
        super("not");
    }

    @Override
    public boolean evaluate(Context context) {
        if (this.operand != null) {
            return !this.operand.evaluate(context);
        }
        return false;
    }

    @Override
    public void addOperand(SimpleRule operand) {
        if (this.operand == null) {
            this.operand = operand;
        }
        ++this.numOperands;
    }

    @Override
    public void validate(SimpleRuleErrorCallback callback) {
        if (this.operand == null) {
            callback.error("No operands for <not> rule");
        } else if (this.numOperands > 1) {
            callback.error("More than one operand for <not> rule");
        }
    }

    @Override
    protected void verify(String[] ruleTypes, boolean[] verified, boolean positive, int notLevel) {
        this.operand.verify(ruleTypes, verified, positive, notLevel + 1);
    }
}

