/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.cmd;

import java.awt.Component;
import java.io.IOException;
import javax.swing.SwingUtilities;
import oracle.ide.Ide;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.config.Preferences;
import oracle.ide.controls.WaitCursor;
import oracle.ide.docking.DockStation;
import oracle.ide.layout.IdeProperties;
import oracle.ide.layout.Layouts;

public final class SaveSystemFilesUtil {
    private SaveSystemFilesUtil() {
    }

    public static void saveSystemFilesOnEDT() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SaveSystemFilesUtil.saveSystemFiles();
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void saveSystemFiles() {
        WaitCursor wc = new WaitCursor((Component)((Object)Ide.getMainWindow()));
        boolean isQuitting = Ide.isQuitting();
        if (!isQuitting) {
            wc.show();
        }
        try {
            if (isQuitting) {
                Ide.getSettings().save();
                try {
                    Preferences.getPreferences().save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            Ide.getDTCache().save();
            Layouts layouts = Layouts.getLayouts();
            if (layouts != null) {
                if (!isQuitting) {
                    DockStation.getDockStation().saveLayout(layouts.getActiveLayout());
                }
                layouts.saveAll();
            }
            FileOpenHistory.getInstance().save();
            IdeProperties props = Ide.getIdeProperties();
            if (props != null) {
                try {
                    props.save();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        finally {
            if (!isQuitting) {
                wc.hide();
            }
        }
    }
}

