/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.wizard;

import java.awt.Color;
import java.awt.Frame;
import java.awt.Image;
import java.util.ArrayList;
import java.util.Arrays;
import javax.ide.util.MetaClass;
import javax.swing.JDialog;
import javax.swing.event.EventListenerList;
import oracle.bali.ewt.wizard.WizardDialog;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.dialogs.WizardLauncher;
import oracle.ide.panels.CommitListener;
import oracle.ide.panels.CommitNotifier;
import oracle.ide.resource.WizardArb;
import oracle.ide.util.Namespace;
import oracle.ide.wizard.FSMWizard;
import oracle.ide.wizard.FinishPanel;
import oracle.ide.wizard.Step;
import oracle.javatools.util.ModelUtil;

public class GenericWizardLauncher
implements CommitNotifier {
    private ArrayList _stepList = new ArrayList();
    private boolean _showStepNumber = false;
    private String _wizardTitle = null;
    private boolean _welcomePageAdded = false;
    private boolean _finishPageAdded = false;
    private Image _wizardImage = null;
    private Color[] _gradientColors = null;
    private EventListenerList _listeners = null;
    private Namespace _namespace = new Namespace();
    public static final Color[] WIZARD_HEADER_GRADIENT = new Color[]{new Color(255, 255, 255), new Color(206, 223, 230)};
    public static final String CONTEXT_KEY = "Context";
    public static final String WIZARD_NAME_KEY = "WizardName";

    public GenericWizardLauncher(Context initContext) {
        this._namespace.put(CONTEXT_KEY, (Object)initContext);
    }

    public GenericWizardLauncher(Context initContext, String wizardTitle) {
        this(initContext);
        this._wizardTitle = wizardTitle;
    }

    public final Namespace getNamespace() {
        return this._namespace;
    }

    public void setWizardTitle(String title) {
        this._wizardTitle = title;
    }

    public String getWizardTitle() {
        return this._wizardTitle;
    }

    public void setGradientColors(Color[] gradientColors) {
        this._gradientColors = gradientColors;
    }

    public Color[] getGradientColors() {
        if (this._gradientColors == null) {
            return WIZARD_HEADER_GRADIENT;
        }
        return this._gradientColors;
    }

    public void setWizardImage(Image image) {
        this._wizardImage = image;
    }

    public Image getWizardImage() {
        return this._wizardImage;
    }

    public boolean addWelcomePage(String welcomePageClassStr, String helpID, String pageTitle) {
        return true;
    }

    public void addWelcomePage(String welcomeText, String descriptiveText, String saveKey, String helpId) {
    }

    public void addFinishPage(String helpId) {
        this.addFinishPage(WizardArb.getString(5), "", WizardArb.getString(4), helpId);
    }

    public void addFinishPage(String finishText, String descText, String title, String helpId) {
        Class[] argTypes = new Class[]{String.class, String.class};
        Object[] argVals = new Object[]{finishText, descText};
        Step step = new Step(FinishPanel.class, argTypes, argVals);
        if (!ModelUtil.hasLength((String)title)) {
            title = WizardArb.getString(4);
        }
        step.setPageTitle(title);
        this._addFinishStep(step, helpId);
    }

    @Deprecated
    public boolean addFinishPage(String finishPageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(finishPageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this._addFinishStep(step, helpID);
        return true;
    }

    public boolean addFinishPage(MetaClass finishPageMetaClass, String helpID, String pageTitle) {
        Class clazz = null;
        try {
            clazz = finishPageMetaClass.toClass();
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this._addFinishStep(step, helpID);
        return true;
    }

    @Deprecated
    public boolean addPage(String pageClass) {
        return this.addPage(pageClass, null, null);
    }

    @Deprecated
    public boolean addPage(String pageClass, String helpID) {
        return this.addPage(pageClass, helpID, null);
    }

    public boolean addPage(MetaClass pageMetaClass, String helpID) {
        return this.addPage(pageMetaClass, helpID, null);
    }

    @Deprecated
    public boolean addPage(String pageClassStr, String helpID, String pageTitle) {
        Class<?> clazz = null;
        try {
            clazz = Class.forName(pageClassStr);
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)helpID)) {
            step.setHelpID(helpID);
        }
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.addPage(step);
        return true;
    }

    public boolean addPage(MetaClass pageMetaClass, String helpID, String pageTitle) {
        Class clazz = null;
        try {
            clazz = pageMetaClass.toClass();
        }
        catch (Exception e) {
            return false;
        }
        Step step = new Step(clazz);
        if (ModelUtil.hasLength((String)helpID)) {
            step.setHelpID(helpID);
        }
        if (ModelUtil.hasLength((String)pageTitle)) {
            step.setPageTitle(pageTitle);
        }
        this.addPage(step);
        return true;
    }

    public void addPage(Step step) {
        this._stepList.add(step);
    }

    public void addPages(Step[] steps) {
        this._stepList.addAll(Arrays.asList(steps));
    }

    public boolean runGenericWizard() {
        FSMWizard fsmWiz = new FSMWizard(this._getTraversableSteps(), this._namespace);
        fsmWiz.setHeaderGradientBackground(this.getGradientColors());
        fsmWiz.setWizardTitle(this._wizardTitle);
        fsmWiz.setShowStepNumber(this._showStepNumber);
        fsmWiz.setWelcomePageAdded(this._welcomePageAdded);
        fsmWiz.setFinishPageAdded(this._finishPageAdded);
        if (this._wizardImage != null) {
            fsmWiz.setLogoImage(this._wizardImage);
        }
        if (ModelUtil.hasLength((String)this.getWizardTitle())) {
            this._namespace.put(WIZARD_NAME_KEY, (Object)this.getWizardTitle());
        }
        if (this._listeners != null) {
            CommitListener[] cListeners = (CommitListener[])this._listeners.getListeners(CommitListener.class);
            for (int i = 0; i < cListeners.length; ++i) {
                fsmWiz.addCommitListener(cListeners[i]);
            }
        }
        WizardDialog wd = fsmWiz.getDialog((Frame)((Object)Ide.getMainWindow()));
        return WizardLauncher.runDialog((JDialog)wd);
    }

    public boolean getShowStepNumber() {
        return this._showStepNumber;
    }

    public void setShowStepNumber(boolean showStepNumber) {
        this._showStepNumber = showStepNumber;
    }

    public void addCommitListener(CommitListener commitListener) {
        if (this._listeners == null) {
            this._listeners = new EventListenerList();
        }
        this._listeners.add(CommitListener.class, commitListener);
    }

    public void removeCommitListener(CommitListener commitListener) {
        if (this._listeners != null) {
            this._listeners.remove(CommitListener.class, commitListener);
        }
    }

    private void _addFinishStep(Step step, String helpId) {
        if (ModelUtil.hasLength((String)helpId)) {
            step.setHelpID(helpId);
        }
        this._stepList.add(step);
        this._finishPageAdded = true;
    }

    private Step[] _getTraversableSteps() {
        if (!this._finishPageAdded) {
            this.addFinishPage(null);
        }
        return this._stepList.toArray(new Step[this._stepList.size()]);
    }
}

