/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util.macro;

import java.util.Map;
import oracle.ide.util.Assert;
import oracle.ide.util.macro.MacroConverter;

public class StringMacroConverter
implements MacroConverter {
    private final String macroStart;
    private final String macroEnd;
    private final int macroStartLen;
    private final int macroEndLen;

    private StringMacroConverter(String mStart, String mEnd) {
        this.macroStart = mStart;
        this.macroEnd = mEnd;
        this.macroStartLen = this.macroStart.length();
        this.macroEndLen = this.macroEnd.length();
    }

    public String expandString(String s, Map macros) {
        int index = s.indexOf(this.macroStart);
        if (index == -1) {
            return s;
        }
        try {
            StringBuffer b = new StringBuffer(s.length() + 64);
            int i = 0;
            String macro = null;
            do {
                macro = s.substring(index + this.macroStartLen, s.indexOf(this.macroEnd, index + this.macroStartLen + 1));
                b.append(s.substring(i, index));
                if (macros.containsKey(macro)) {
                    Object macroValue = macros.get(macro);
                    if (macroValue == null) continue;
                    b.append(macroValue.toString());
                    continue;
                }
                b.append(this.macroStart);
                b.append(macro);
                b.append(this.macroEnd);
            } while ((index = s.indexOf(this.macroStart, i = index + this.macroStartLen + macro.length() + this.macroEndLen)) > -1);
            b.append(s.substring(i));
            return b.toString();
        }
        catch (Exception e) {
            Assert.printStackTrace((Throwable)e);
            return s;
        }
    }

    public static StringMacroConverter getConverter(int converterType) {
        switch (converterType) {
            case 1: {
                return new StringMacroConverter("@", "@");
            }
            case 2: {
                return new StringMacroConverter("$(", ")");
            }
            case 3: {
                return new StringMacroConverter("${", "}");
            }
            case 4: {
                return new StringMacroConverter("%", "%");
            }
        }
        throw new IllegalArgumentException("Unknown converterType for class MacroConverter");
    }
}

