/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import javax.swing.SwingUtilities;
import oracle.ide.util.WeakDataHolder;

public class WeakDataReference<T>
extends WeakReference<T> {
    private static ReferenceQueue QUEUE;
    private static Thread THREAD;
    private static Cleaner CLEANER;
    private WeakDataHolder<T> _holder;

    public WeakDataReference(WeakDataHolder<T> holder, T data) {
        super(data, WeakDataReference.getQueue());
        this._holder = holder;
    }

    @Override
    public synchronized void clear() {
        this._holder = null;
        super.clear();
    }

    private synchronized void expire() {
        if (this._holder != null) {
            final WeakDataHolder<T> holder = this._holder;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    holder.dataExpired(WeakDataReference.this);
                }
            });
            this._holder = null;
        }
    }

    private static final synchronized ReferenceQueue<?> getQueue() {
        if (QUEUE == null) {
            QUEUE = new ReferenceQueue();
            CLEANER = new Cleaner();
            THREAD = new Thread((Runnable)CLEANER, "WeakDataReference polling");
            THREAD.setPriority(1);
            THREAD.start();
        }
        return QUEUE;
    }

    private static final class Cleaner
    implements Runnable {
        private Cleaner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        WeakDataReference weakData;
                        if ((weakData = (WeakDataReference)QUEUE.remove()) == null) {
                            continue;
                        }
                        weakData.expire();
                    }
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
    }
}

