/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.refactoring;

import java.awt.Component;
import java.awt.EventQueue;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.HelpSystem;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.net.URLFileSystem;
import oracle.ide.panels.ActionDescriptionPanel;
import oracle.ide.refactoring.AbstractDeleteActionHandler;
import oracle.ide.refactoring.ActionHandlerConfirmationDialog;
import oracle.ide.resource.DeleteDialogArb;
import oracle.ide.resource.DialogsArb;
import oracle.ide.util.Assert;
import oracle.javatools.dialogs.MessageDialog;
import org.openide.util.RequestProcessor;

public abstract class SimpleDeleteActionHandler<T extends Element>
extends AbstractDeleteActionHandler<T> {
    private static final RequestProcessor processor = new RequestProcessor(SimpleDeleteActionHandler.class);
    private boolean executed;
    private DialogTextConfig dialogTextConfig;
    private ActionHandlerConfirmationDialog confirmationDialog;

    public SimpleDeleteActionHandler(Context context) {
        super(context);
    }

    @Override
    public final void doit() {
        this.checkOneExec();
        if (this.confirmDelete((JFrame)((Object)Ide.getMainWindow()))) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    SimpleDeleteActionHandler.this.doDelete();
                }
            };
            if (EventQueue.isDispatchThread()) {
                processor.execute(runnable);
            } else {
                runnable.run();
            }
        }
    }

    @Override
    public final boolean doItSilently() {
        this.checkOneExec();
        this.setSilentMode(true);
        return this.doDelete();
    }

    private synchronized void checkOneExec() {
        if (this.executed) {
            throw new IllegalStateException("This action handler has been already executed.");
        }
        this.executed = true;
    }

    protected abstract boolean doDelete();

    protected Component createDialogContent() {
        return this.createDefaultDialogContent();
    }

    protected final ActionDescriptionPanel createDefaultDialogContent() {
        DialogTextConfig textConfig = this.getDialogTextConfig();
        String[] options = textConfig.getOptions();
        if (options == null) {
            options = new String[]{};
        }
        ActionDescriptionPanel panel = ActionDescriptionPanel.build(textConfig.getHeader(), textConfig.getDescription(), options);
        HelpSystem.getHelpSystem().registerTopic(panel, textConfig.getHelpTopicId());
        return panel;
    }

    protected void preLaunchDialog() {
    }

    protected final DialogTextConfig getDialogTextConfig() {
        if (this.dialogTextConfig == null) {
            this.dialogTextConfig = this.createDialogTextConfig();
        }
        return this.dialogTextConfig;
    }

    protected DialogTextConfig createDialogTextConfig() {
        List nodes = this.getNodes();
        int numNodes = nodes.size();
        if (numNodes < 1) {
            throw new IllegalStateException("No nodes to delete");
        }
        DialogTextConfig textConfig = new DialogTextConfig().title(DeleteDialogArb.getString(36)).showDetails(DeleteDialogArb.getString(37)).hideDetails(DeleteDialogArb.getString(38)).helpTopicId("f1_idedconfirmdelete_html");
        if (numNodes > 1) {
            textConfig.header(DeleteDialogArb.format(45, numNodes));
        } else {
            Element node = (Element)nodes.iterator().next();
            textConfig.description(node.getLongLabel()).header(DeleteDialogArb.format(39, node.getShortLabel()));
        }
        return textConfig;
    }

    protected abstract Component createDeleteDetailsComponent();

    private boolean requireConfirm() {
        return this.getDialogTextConfig().getConfirmTitle() != null && this.getDialogTextConfig().getConfirmMessage() != null;
    }

    protected final void setStatus(String text, Icon icon) {
        this.confirmationDialog.setStatus(text, icon);
    }

    protected final void clearStatus() {
        this.setStatus("", null);
    }

    protected final void setOKButtonEnabled(boolean okButtonEnabled) {
        this.confirmationDialog.setOKButtonEnabled(okButtonEnabled);
    }

    protected final void deleteDetailsAvailable(boolean detailsAvailable) {
        this.confirmationDialog.setDetailsAvailable(detailsAvailable);
    }

    private final ActionHandlerConfirmationDialog createDeleteConfirmationDialog(JFrame dialogOwner) {
        DialogTextConfig textConfig = this.getDialogTextConfig();
        ActionHandlerConfirmationDialog detailDialog = ActionHandlerConfirmationDialog.createDialog(dialogOwner, textConfig.getTitle(), this.createDialogContent(), this.createDeleteDetailsComponent());
        detailDialog.setOKButtonText(DialogsArb.getString(2));
        detailDialog.setCancelButtonText(DialogsArb.getString(4));
        detailDialog.setOKButtonEnabled(true);
        if (textConfig.getShowDetails() != null) {
            detailDialog.setButtonTextWhenDetailsHidden(textConfig.getShowDetails(), true);
        }
        if (textConfig.getHideDetails() != null) {
            detailDialog.setButtonTextWhenDetailsShown(textConfig.getHideDetails(), false);
        }
        return detailDialog;
    }

    private boolean runDialog() {
        boolean ret = false;
        if (this.confirmationDialog.runDialog()) {
            ret = true;
        }
        this.confirmationDialog.dispose();
        return ret;
    }

    private boolean confirmDelete(final JFrame dialogOwner) {
        final AtomicBoolean result = new AtomicBoolean(false);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SimpleDeleteActionHandler.this.confirmationDialog = SimpleDeleteActionHandler.this.createDeleteConfirmationDialog(dialogOwner);
                SimpleDeleteActionHandler.this.preLaunchDialog();
                if (SimpleDeleteActionHandler.this.runDialog() && (!SimpleDeleteActionHandler.this.requireConfirm() || SimpleDeleteActionHandler.this.askToConfirm(dialogOwner))) {
                    result.set(true);
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException e) {
                Assert.printStackTrace((Throwable)e);
                result.set(false);
            }
            catch (InvocationTargetException e) {
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, "Delete handler failed", e.getCause());
                result.set(false);
            }
        }
        return result.get();
    }

    private boolean askToConfirm(Component windowParent) {
        Boolean confirmed = MessageDialog.getPersistence().getConfirmed(this.getClass().getName());
        if (confirmed != null) {
            return true;
        }
        return MessageDialog.optionalConfirm((String)this.getConfirmationDlgSkipKey(), (Component)windowParent, (Object)this.getDialogTextConfig().getConfirmMessage(), (String)this.getDialogTextConfig().getConfirmTitle(), null);
    }

    protected String getConfirmationDlgSkipKey() {
        return this.getClass().getName();
    }

    public static final boolean deleteNode(Node node) {
        if (node.isOpen()) {
            try {
                node.close();
            }
            catch (IOException e) {
                Assert.printStackTrace((Throwable)e);
            }
        }
        boolean succeeded = URLFileSystem.delete((URL)node.getURL());
        return succeeded;
    }

    public static final class DialogTextConfig {
        String m_showDetails = null;
        String m_hideDetails = null;
        String m_title = null;
        String m_header = null;
        String m_description = null;
        String[] m_options = null;
        String m_confirmTitle = null;
        String m_confirmMessage = null;
        String m_helpTopicId = null;

        public DialogTextConfig() {
        }

        DialogTextConfig(String title, String header, String description, String showDetailsText, String hideDetailsText, String confirmTitle, String confirmMessage, String helpTopicId, String ... options) {
            this.m_showDetails = showDetailsText;
            this.m_hideDetails = hideDetailsText;
            this.m_title = title;
            this.m_header = header;
            this.m_description = description;
            this.m_options = options;
            this.m_confirmTitle = confirmTitle;
            this.m_confirmMessage = confirmMessage;
            this.m_helpTopicId = helpTopicId;
        }

        public DialogTextConfig title(String title) {
            this.m_title = title;
            return this;
        }

        public DialogTextConfig header(String header) {
            this.m_header = header;
            return this;
        }

        public DialogTextConfig description(String description) {
            this.m_description = description;
            return this;
        }

        public DialogTextConfig showDetails(String showDetails) {
            this.m_showDetails = showDetails;
            return this;
        }

        public DialogTextConfig hideDetails(String hideDetails) {
            this.m_hideDetails = hideDetails;
            return this;
        }

        public DialogTextConfig options(String ... options) {
            this.m_options = options;
            return this;
        }

        public DialogTextConfig confirmTitle(String confirmTitle) {
            this.m_confirmTitle = confirmTitle;
            return this;
        }

        public DialogTextConfig confirmMessage(String confirmMessage) {
            this.m_confirmMessage = confirmMessage;
            return this;
        }

        public DialogTextConfig helpTopicId(String helpTopicId) {
            this.m_helpTopicId = helpTopicId;
            return this;
        }

        public String getTitle() {
            return this.m_title;
        }

        public String getHeader() {
            return this.m_header;
        }

        public String getDescription() {
            return this.m_description;
        }

        public String getShowDetails() {
            return this.m_showDetails;
        }

        public String getHideDetails() {
            return this.m_hideDetails;
        }

        public String[] getOptions() {
            return this.m_options;
        }

        public String getConfirmTitle() {
            return this.m_confirmTitle;
        }

        public String getConfirmMessage() {
            return this.m_confirmMessage;
        }

        public String getHelpTopicId() {
            return this.m_helpTopicId;
        }
    }
}

