/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.dialogs.DialogUtil;
import oracle.ide.net.URLChooser;
import oracle.ide.net.URLChooserInit;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import oracle.javatools.controls.FileField;
import oracle.javatools.util.ModelUtil;

public class URLTextField
extends FileField
implements ActionListener {
    public static final int OPEN_DIALOG = 0;
    public static final int SAVE_DIALOG = 1;
    private final Comparator _comparator;
    private boolean _isDir;
    private boolean _showJarsAsDirs;
    private String _lastSetText;
    private List<URL> _urls = new ArrayList<URL>();
    private URL _baseURL;
    private String _title;
    private String _helpCtx;
    private List _filterList;
    private URLChooserInit _chooserInit;
    private URLFilter _filter;
    private boolean _clearAllFilters = false;
    private URL _defaultChooserURL;
    private int _dialogType = 0;
    private String activeMacroExpression;
    private String activeMacroValue;

    public URLTextField() {
        this(null);
    }

    public URLTextField(URL url) {
        this(url, true, true);
    }

    public URLTextField(URL url, boolean isDir) {
        this(url, isDir, true);
    }

    public URLTextField(URL url, boolean isDir, boolean showJarsAsDirs) {
        this._comparator = URLFileSystem.isLocalFileSystemCaseSensitive() ? null : String.CASE_INSENSITIVE_ORDER;
        this.setURL(url);
        this.setDirectoryOnly(isDir);
        this._showJarsAsDirs = showJarsAsDirs;
    }

    public static URLTextField newForSavingFile() {
        return new URLTextField(null, false, false);
    }

    public URL getURL() {
        return this.getURLs().get(0);
    }

    public List<URL> getURLs() {
        String curText = this.getText().trim();
        if (!ModelUtil.hasLength((String)curText)) {
            ArrayList<URL> urlList = new ArrayList<URL>();
            urlList.add(this._baseURL);
            return urlList;
        }
        if (this.compare(curText, this._lastSetText) == 0) {
            return this._urls;
        }
        String[] urlStrs = curText.split(",");
        ArrayList<URL> urlList = new ArrayList<URL>();
        for (int i = 0; i < urlStrs.length; ++i) {
            URL url = URLFactory.newURL((String)urlStrs[i].trim(), (boolean)this._isDir, (boolean)false);
            if (url != null) {
                urlList.add(URLFileSystem.canonicalize((URL)url));
                continue;
            }
            if (this._baseURL == null) {
                urlList.add(null);
                continue;
            }
            URL resolvedURL = this._isDir ? URLFactory.newDirURL((URL)this._baseURL, (String)urlStrs[i].trim()) : URLFactory.newURL((URL)this._baseURL, (String)urlStrs[i].trim());
            urlList.add(URLFileSystem.canonicalize((URL)resolvedURL));
        }
        return urlList;
    }

    public URL getURL(boolean expandMacros) {
        URL realURL = this.getURL();
        if (realURL == null) {
            return null;
        }
        return expandMacros ? realURL : this.replaceValueWithMacro(realURL);
    }

    public void setURL(URL url) {
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(url);
        this.setURLs(urlList);
    }

    public void setURLs(List<URL> urlList) {
        URL url;
        int i;
        List<URL> oldURLs = this.getURLs();
        this._urls = urlList;
        if (this._urls == null) {
            this._lastSetText = "";
            this.setText("");
        } else if (this._baseURL == null) {
            this._lastSetText = "";
            for (i = 0; i < urlList.size(); ++i) {
                this._lastSetText = i == urlList.size() - 1 ? this._lastSetText + URLFileSystem.getPlatformPathName((URL)urlList.get(i)) : this._lastSetText + URLFileSystem.getPlatformPathName((URL)urlList.get(i)) + ", ";
            }
            this.setText(this._lastSetText);
        } else {
            this._lastSetText = "";
            for (i = 0; i < urlList.size(); ++i) {
                url = urlList.get(i);
                String relSpec = URLFileSystem.toRelativeSpec((URL)url, (URL)this._baseURL, (boolean)true);
                this._lastSetText = relSpec != null ? (relSpec.endsWith("/") ? relSpec.substring(0, relSpec.length() - 1) : relSpec) : URLFileSystem.getPlatformPathName((URL)url);
                if (i >= urlList.size() - 1) continue;
                this._lastSetText = this._lastSetText + ", ";
            }
            this.setText(this._lastSetText);
        }
        URL oldURL = null;
        url = null;
        if (oldURLs != null && !oldURLs.isEmpty()) {
            oldURL = oldURLs.get(0);
        }
        if (urlList != null && !urlList.isEmpty()) {
            url = urlList.get(0);
        }
        if (oldURL == null && url != null || oldURL != null && !oldURL.equals(url)) {
            this.firePropertyChange("url", oldURL, url);
        }
        if (oldURLs == null) {
            if (urlList != null) {
                this.firePropertyChange("urls", null, Collections.unmodifiableList(urlList));
            }
        } else if (urlList == null) {
            this.firePropertyChange("urls", Collections.unmodifiableList(oldURLs), null);
        } else if (!oldURLs.equals(urlList)) {
            this.firePropertyChange("urls", Collections.unmodifiableList(oldURLs), Collections.unmodifiableList(urlList));
        }
    }

    public boolean isDirectoryOnly() {
        return this._isDir;
    }

    public void setDirectoryOnly(boolean isDir) {
        this._isDir = isDir;
        this.setOnlyDirectories(isDir);
    }

    @Deprecated
    public void setClearAllFilters(boolean clearFilters) {
        this._clearAllFilters = clearFilters;
    }

    public void setDefaultChooserURL(URL url) {
        this._defaultChooserURL = url;
    }

    public void addChooseableURLFilter(URLFilter filter) {
        if (this._filterList == null) {
            this._filterList = new ArrayList();
        }
        this._filterList.add(filter);
    }

    public void clearChooseableURLFilters() {
        this._clearAllFilters = true;
        if (this._filterList != null) {
            this._filterList.clear();
            this._filterList = null;
        }
    }

    public URLFilter getFilter() {
        return this._filter;
    }

    public void setFilter(URLFilter filter) {
        this._filter = filter;
    }

    public void setDialogType(int type) {
        if (type != 0 && type != 1) {
            throw new IllegalArgumentException("type not OPEN_DIALOG or SAVE_DIALOG");
        }
        this._dialogType = type;
    }

    public int getDialogType() {
        return this._dialogType;
    }

    public URLChooserInit getChooserInit() {
        return this._chooserInit;
    }

    public void setChooserInit(URLChooserInit chooserInit) {
        this._chooserInit = chooserInit;
    }

    public void setBaseURL(URL baseURL) {
        this._baseURL = baseURL;
    }

    public void setDialogTitle(String title) {
        this._title = title;
    }

    public void setDialogHelpContext(String helpContext) {
        this._helpCtx = helpContext;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.browseForURL();
    }

    public boolean browseForURL() {
        boolean result = false;
        URL url = this.getURL() != null ? this.getURL() : this._defaultChooserURL;
        URLChooser urlChooser = this.createChooser(url);
        int response = this._dialogType == 0 ? urlChooser.showOpenDialog((Component)((Object)this), this._title) : urlChooser.showSaveDialog((Component)((Object)this), this._title);
        if (response == 0) {
            URL[] selectedURLs = urlChooser.getSelectedURLs();
            for (int i = 0; i < selectedURLs.length; ++i) {
                URL selectedURL = selectedURLs[i];
                if (this.activeMacroExpression == null) continue;
                selectedURLs[i] = this.replaceValueWithMacro(selectedURL);
            }
            this.setURLs(Arrays.asList(selectedURLs));
            result = true;
        }
        return result;
    }

    protected URLChooser createChooser(URL url) {
        return this.createChooser(null, url);
    }

    protected URLChooser createChooser(Context context, URL url) {
        URLChooser urlChooser = DialogUtil.newURLChooser(context, url);
        if (this._chooserInit != null) {
            this._chooserInit.initURLChooser(urlChooser);
        }
        if (this._baseURL != null) {
            urlChooser.setRoots(new URL[]{this._baseURL});
        }
        if (this._helpCtx != null) {
            urlChooser.setHelpID(this._helpCtx);
        }
        urlChooser.setShowJarsAsDirs(this._showJarsAsDirs);
        urlChooser.setSelectionMode(0);
        urlChooser.setSelectionScope(this._isDir ? 1 : 0);
        if (this._clearAllFilters) {
            urlChooser.clearChooseableURLFilters();
        }
        if (this._filterList != null) {
            for (URLFilter filter : this._filterList) {
                urlChooser.addChooseableURLFilter(filter);
            }
        }
        if (this._filter != null) {
            urlChooser.setURLFilter(this._filter);
        }
        return urlChooser;
    }

    private int compare(String s1, String s2) {
        if (this._comparator != null) {
            return this._comparator.compare(s1, s2);
        }
        return s1.compareTo(s2);
    }

    public void setActiveMacro(String name, String value) {
        this.activeMacroExpression = name;
        this.activeMacroValue = value;
    }

    public void clearActiveMacro() {
        this.activeMacroExpression = null;
        this.activeMacroValue = null;
    }

    private URL replaceValueWithMacro(URL url) {
        if (url == null) {
            return null;
        }
        if (this.activeMacroValue == null) {
            return url;
        }
        String path = url.getPath();
        if (path.contains(this.activeMacroValue)) {
            String pathWithMacroExpression = null;
            pathWithMacroExpression = path.startsWith("file:") ? path.replace("file:" + this.activeMacroValue, this.activeMacroExpression) : path.replace(this.activeMacroValue, this.activeMacroExpression);
            try {
                String hostname = url.getHost();
                int port = url.getPort();
                URL result = new URL("file", hostname, port, pathWithMacroExpression);
                return result;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return url;
    }
}

