/*
 * Decompiled with CFR 0.152.
 */
package oracle.ide.net;

import java.net.URL;
import java.util.Comparator;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLNode;

final class URLNodeComparator
implements Comparator<URLNode> {
    private final boolean _dirsBeforeFiles;
    private final boolean _caseSensitive;

    public URLNodeComparator(boolean dirsBeforeFiles, boolean caseSensitive) {
        this._dirsBeforeFiles = dirsBeforeFiles;
        this._caseSensitive = caseSensitive;
    }

    @Override
    public int compare(URLNode o1, URLNode o2) {
        boolean isDir2;
        boolean isDir1;
        if (o1 == o2) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        URL url1 = o1.getURL();
        URL url2 = o2.getURL();
        if (this._dirsBeforeFiles && (isDir1 = URLFileSystem.isDirectoryPath((URL)url1)) != (isDir2 = URLFileSystem.isDirectoryPath((URL)url2))) {
            return isDir1 ? -1 : 1;
        }
        String name1 = URLFileSystem.getFileName((URL)url1);
        String name2 = URLFileSystem.getFileName((URL)url2);
        if (name1.startsWith(".") && !name2.startsWith(".")) {
            return 1;
        }
        if (name2.startsWith(".") && !name1.startsWith(".")) {
            return -1;
        }
        if (this._caseSensitive) {
            return name1.compareTo(name2);
        }
        int ret = name1.compareToIgnoreCase(name2);
        if (ret == 0) {
            ret = name1.compareTo(name2);
        }
        return ret;
    }
}

